/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.client.ContractEditUI;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.IPersonCertification;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.emp.client.EmployeeContractEditUI;
import com.kingdee.eas.hr.train.TrainActivityException;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainRecordContractCollection;
import com.kingdee.eas.hr.train.TrainRecordContractFactory;
import com.kingdee.eas.hr.train.TrainRecordContractInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainContractEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityRecordEditUI;
import com.kingdee.eas.hr.train.client.TrainCourseRecordEditUI;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainContractEditUI
extends AbstractTrainContractEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainContractEditUI.class);
    private String curRecordId = null;
    private String curEmployeeContractId = null;
    private String curPersonCertifId = null;
    private boolean fromActRecordEditUI = false;
    private boolean fromCourseRecordEditUI = false;
    private TrainCourseRecordInfo courseRecordInfo;
    private PersonCertificationInfo historyCertificationInfo = new PersonCertificationInfo();
    private List contractIdList = new ArrayList();
    private Integer curIndex = null;

    public void loadFields() {
        super.loadFields();
        try {
            this.initComeFrom();
            this.loadInfo();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void initComeFrom() {
        String comeFrom = (String)this.getUIContext().get("come_from");
        if (TrainActivityRecordEditUI.class.getName().equals(comeFrom)) {
            this.fromActRecordEditUI = true;
        } else if (TrainCourseRecordEditUI.class.getName().equals(comeFrom)) {
            this.fromCourseRecordEditUI = true;
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeContractFactory.getRemoteInstance();
    }

    public void actionAddContract_actionPerformed(ActionEvent e) throws Exception {
        if (this.curIndex == null) {
            throw new TrainActivityException(TrainActivityException.NO_CONTRACT);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.contractIdList.get(this.curIndex).toString());
        uiContext.put((Object)"fromPage", (Object)TrainContractEditUI.class.getName());
        uiContext.put((Object)"contractId", (Object)this.contractIdList.get(this.curIndex).toString());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ContractEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.btnAddContract.setIcon(EASResource.getIcon((String)"imgTbtn_collateresult"));
        this.dateContractRecordDate.setValue(null);
        this.dateContractFreeDate.setValue(null);
        this.dateContractEffectDate.setValue(null);
        this.dateContractEndDate.setValue(null);
        this.dateCertifGrantTime.setValue(null);
        this.txtCertifValidity.setSupportedEmpty(true);
        super.onLoad();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.txtCertifNumber.setEditable(false);
            this.txtCertifName.setEditable(false);
            this.txtCertifName.setEnabled(false);
            this.txtCertifOrg.setEditable(false);
            this.txtCertifOrg.setEnabled(false);
            this.txtCertifValidity.setEditable(false);
            this.dateCertifGrantTime.setEditable(false);
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        LanguageInfo currentLang = null;
        int selectedIndex = 0;
        int size = langList.size();
        for (int i = 0; i < size; ++i) {
            currentLang = (LanguageInfo)langList.get(i);
            if (!currentLang.getLocale().equals(SysContext.getSysContext().getLocale())) continue;
            selectedIndex = i;
            break;
        }
        this.txtCertifName.setSelectedIndex(selectedIndex);
        this.txtCertifOrg.setSelectedIndex(selectedIndex);
    }

    private void loadInfo() throws EASBizException, BOSException {
        if (this.getUIContext().get("ID") != null) {
            this.curRecordId = this.getUIContext().get("ID").toString();
        }
        PersonCertificationInfo certificateInfo = null;
        if (this.curRecordId != null) {
            this.courseRecordInfo = TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordInfo((IObjectPK)new ObjectUuidPK(this.curRecordId), this.getRecordSelector());
            this.contractIdList = this.getContractIdsByRecord(this.courseRecordInfo);
            if (this.fromActRecordEditUI) {
                certificateInfo = this.courseRecordInfo.getActCertificate();
            } else if (this.fromCourseRecordEditUI) {
                certificateInfo = this.courseRecordInfo.getEmpCertificatio();
            }
        }
        this.loadContractInfo();
        this.loadCertificationInfo(certificateInfo);
    }

    private List getContractIdsByRecord(TrainCourseRecordInfo recordInfo) {
        String personId = recordInfo.getEmployee().getId().toString();
        HashSet billEntryIds = new HashSet();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainRecordId", (Object)recordInfo.getId().toString()));
        evi.setFilter(fi);
        try {
            if (this.fromActRecordEditUI) {
                evi.getSelector().add(new SelectorItemInfo("activityContractBillId"));
                TrainRecordContractCollection col = TrainRecordContractFactory.getRemoteInstance().getTrainRecordContractCollection(evi);
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    TrainRecordContractInfo recordContractInfo = col.get(i);
                    String activityContractBillId = recordContractInfo.getActivityContractBillId();
                    billEntryIds.addAll(this.getBillEntryIds(personId, activityContractBillId));
                }
                String actContractId = null;
                if (recordInfo.getActContract() != null) {
                    actContractId = recordInfo.getActContract().getId().toString();
                }
                return this.getContractIds(billEntryIds, actContractId);
            }
            if (this.fromCourseRecordEditUI) {
                evi.getSelector().add(new SelectorItemInfo("courseContractBillId"));
                TrainRecordContractCollection col = TrainRecordContractFactory.getRemoteInstance().getTrainRecordContractCollection(evi);
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    TrainRecordContractInfo recordContractInfo = col.get(i);
                    String courseContractBillId = recordContractInfo.getCourseContractBillId();
                    billEntryIds.addAll(this.getBillEntryIds(personId, courseContractBillId));
                }
                String courseContractId = null;
                if (recordInfo.getEmpContract() != null) {
                    courseContractId = recordInfo.getEmpContract().getId().toString();
                }
                return this.getContractIds(billEntryIds, courseContractId);
            }
        }
        catch (BOSException e) {
            logger.info((Object)"", (Throwable)e);
        }
        return null;
    }

    private Set getBillEntryIds(String personId, String billId) throws BOSException {
        HashSet<String> billEntryIds = new HashSet<String>();
        EntityViewInfo entryEvi = new EntityViewInfo();
        FilterInfo entryFi = new FilterInfo();
        entryFi.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId));
        entryFi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        entryEvi.setFilter(entryFi);
        ContractSignBizBillEntryCollection col = ContractSignBizBillEntryFactory.getRemoteInstance().getContractSignBizBillEntryCollection(entryEvi);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            billEntryIds.add(col.get(i).getId().toString());
        }
        return billEntryIds;
    }

    private List getContractIds(Set billEntryIds, String contractId) throws BOSException {
        EntityViewInfo contractEvi = new EntityViewInfo();
        FilterInfo contractFi = new FilterInfo();
        contractFi.getFilterItems().add(new FilterItemInfo("entryID", (Object)billEntryIds, CompareType.INCLUDE));
        contractFi.getFilterItems().add(new FilterItemInfo("id", (Object)contractId));
        contractFi.setMaskString("#0 or #1");
        contractEvi.setFilter(contractFi);
        SorterItemInfo sorter = new SorterItemInfo("recordDate");
        sorter.setSortType(SortType.DESCEND);
        contractEvi.getSorter().add(sorter);
        contractEvi.getSelector().add(new SelectorItemInfo("id"));
        EmployeeContractCollection contractCol = EmployeeContractFactory.getRemoteInstance().getEmployeeContractCollection(contractEvi);
        ArrayList<String> contractIds = new ArrayList<String>();
        int size = contractCol.size();
        for (int i = 0; i < size; ++i) {
            contractIds.add(contractCol.get(i).getId().toString());
        }
        return contractIds;
    }

    private void loadCertificationInfo(PersonCertificationInfo certificateInfo) throws EASBizException, BOSException {
        if (certificateInfo != null) {
            this.curPersonCertifId = certificateInfo.getId().toString();
            this.loadCertifFields(this.curPersonCertifId);
        } else {
            this.txtCertifNumber.setText(null);
            this.txtCertifValidity.setText(null);
            this.dateCertifGrantTime.setValue(null);
            this.historyCertificationInfo = this.createInitPersonCertificationInfo();
            if (this.courseRecordInfo.getTrainActivity() != null) {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtCertifName, (IObjectValue)this.courseRecordInfo.getTrainActivity(), (String)"certificateName");
                this.historyCertificationInfo.setCertificateName(this.courseRecordInfo.getTrainActivity().getCertificateName());
            }
        }
    }

    private void loadContractInfo() throws EASBizException, BOSException {
        String contractId = null;
        if (this.contractIdList.size() > 0) {
            if (this.curIndex == null) {
                this.curIndex = 0;
            }
            contractId = (String)this.contractIdList.get(this.curIndex);
        }
        if (StringUtil.isEmptyString(contractId)) {
            this.txtContractNumber.setText(null);
            this.txtContractName.setText(null);
            this.txtContractToUnit.setText(null);
            this.txtContractType.setText(null);
            this.txtContractEmp.setText(null);
            this.dateContractEffectDate.setValue(null);
            this.dateContractRecordDate.setValue(null);
            this.dateContractEndDate.setValue(null);
            this.dateContractFreeDate.setValue(null);
        } else {
            this.loadContractFileds(contractId);
        }
        this.initScrollButtons();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.curIndex = 0;
        this.loadContractInfo();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        int value = this.curIndex;
        this.curIndex = value + 1;
        this.loadContractInfo();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        int value = this.curIndex;
        this.curIndex = value - 1;
        this.loadContractInfo();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.curIndex = this.contractIdList.size() - 1;
        this.loadContractInfo();
    }

    protected void initScrollButtons() {
        if (this.curIndex == null || this.contractIdList.size() <= 1) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            return;
        }
        if (this.curIndex == 0) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(true);
            this.actionLast.setEnabled(true);
            return;
        }
        if (this.curIndex == this.contractIdList.size() - 1) {
            this.actionFirst.setEnabled(true);
            this.actionPre.setEnabled(true);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            return;
        }
        this.actionFirst.setEnabled(true);
        this.actionPre.setEnabled(true);
        this.actionNext.setEnabled(true);
        this.actionLast.setEnabled(true);
    }

    private SelectorItemCollection getRecordSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("Employee.id"));
        sic.add(new SelectorItemInfo("EmpContract.id"));
        sic.add(new SelectorItemInfo("EmpCertificatio.id"));
        sic.add(new SelectorItemInfo("actContract.id"));
        sic.add(new SelectorItemInfo("actCertificate.id"));
        sic.add(new SelectorItemInfo("TrainActivity.certificateName"));
        sic.add(new SelectorItemInfo("TrainActivity.needContract"));
        return sic;
    }

    private void loadContractFileds(String contractId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.name"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("*"));
        EmployeeContractInfo info = EmployeeContractFactory.getRemoteInstance().getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractId), selector);
        this.txtContractNumber.setText(info.getContractNo());
        this.txtContractName.setText(info.getContractTemplet().getName());
        this.txtContractToUnit.setText(info.getToUnit());
        this.txtContractType.setText(info.getContractTemplet().getContractType().getName());
        this.txtContractEmp.setText(info.getEmployee().getName());
        this.dateContractEffectDate.setValue((Object)info.getEffectDate());
        this.dateContractRecordDate.setValue((Object)info.getRecordDate());
        this.dateContractEndDate.setValue((Object)info.getEndDate());
        this.dateContractFreeDate.setValue((Object)info.getFreeDate());
    }

    private void loadCertifFields(String personCertifId) throws EASBizException, BOSException {
        PersonCertificationInfo info = PersonCertificationFactory.getRemoteInstance().getPersonCertificationInfo((IObjectPK)new ObjectUuidPK(personCertifId));
        this.historyCertificationInfo = (PersonCertificationInfo)info.clone();
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtCertifName, (IObjectValue)info, (String)"certificateName");
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtCertifOrg, (IObjectValue)info, (String)"organ");
        this.txtCertifNumber.setText(info.getCertificateNumber());
        this.txtCertifValidity.setText(Integer.valueOf(info.getPeriodValidity()).toString());
        this.dateCertifGrantTime.setValue((Object)info.getCertifyDate());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isAllCertifEmpty()) {
            this.verifyInput();
            this.submitTrainCertif(this.curRecordId, this.curPersonCertifId);
        } else if (this.curPersonCertifId != null) {
            if (this.fromActRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateActCertifyID(this.curRecordId, null);
            } else if (this.fromCourseRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateCourseCertifyID(this.curRecordId, null);
            }
            this.historyCertificationInfo = this.createInitPersonCertificationInfo();
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.Success"));
    }

    private void verifyInput() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtCertifNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtCertifName);
    }

    private void submitTrainCertif(String recordId, String perCertifId) throws BOSException, EASBizException {
        PersonCertificationInfo personCertifInfo = this.storeCertificationInfo();
        IPersonCertification iPersonCertif = PersonCertificationFactory.getRemoteInstance();
        if (perCertifId != null) {
            iPersonCertif.update((IObjectPK)new ObjectUuidPK(perCertifId), (CoreBaseInfo)personCertifInfo);
        } else {
            IObjectPK newPersonCertifPk = iPersonCertif.addnew((CoreBaseInfo)personCertifInfo);
            this.curPersonCertifId = newPersonCertifPk.toString();
            if (this.fromActRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateActCertifyID(this.curRecordId, this.curPersonCertifId);
            } else if (this.fromCourseRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateCourseCertifyID(this.curRecordId, this.curPersonCertifId);
            }
        }
        this.historyCertificationInfo = iPersonCertif.getPersonCertificationInfo((IObjectPK)new ObjectUuidPK(this.curPersonCertifId.toString()));
    }

    private PersonCertificationInfo storeCertificationInfo() throws BOSException, EASBizException {
        PersonCertificationInfo personCertifInfo = (PersonCertificationInfo)this.historyCertificationInfo.clone();
        personCertifInfo.setCertificateNumber(this.txtCertifNumber.getText());
        personCertifInfo.setCertificateName(this.txtCertifName.getSelectedItem().toString());
        personCertifInfo.setOrgan(this.txtCertifOrg.getSelectedItem().toString());
        if (this.txtCertifValidity.getNumberValue() != null) {
            personCertifInfo.setPeriodValidity(((Integer)this.txtCertifValidity.getNumberValue()).intValue());
        }
        personCertifInfo.setCertifyDate((Date)this.dateCertifGrantTime.getValue());
        return personCertifInfo;
    }

    private PersonCertificationInfo createInitPersonCertificationInfo() {
        PersonCertificationInfo personCertifInfo = new PersonCertificationInfo();
        PersonInfo personInfo = this.courseRecordInfo.getEmployee();
        personCertifInfo.setPerson(personInfo);
        return personCertifInfo;
    }

    private void submitTrainContract(IUIWindow uiWindow) throws BOSException, EASBizException {
        EmployeeContractEditUI contractEditUI = (EmployeeContractEditUI)uiWindow.getUIObject();
        String contractId = contractEditUI.getContractId();
        if (contractId != null) {
            if (this.fromActRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateActContractID(this.curRecordId, contractId);
            } else if (this.fromCourseRecordEditUI) {
                TrainCourseRecordFactory.getRemoteInstance().updateCourseContractID(this.curRecordId, contractId);
            }
        }
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        boolean bl = false;
        this.txtCertifNumber.setEnabled(bl);
        this.txtCertifName.setEnabled(bl);
        this.txtCertifOrg.setEnabled(bl);
        this.txtCertifValidity.setEnabled(bl);
        this.dateCertifGrantTime.setEnabled(bl);
    }

    protected void unLockUI() {
        super.unLockUI();
        boolean bl = true;
        this.txtCertifNumber.setEnabled(bl);
        this.txtCertifName.setEnabled(bl);
        this.txtCertifOrg.setEnabled(bl);
        this.txtCertifValidity.setEnabled(bl);
        this.dateCertifGrantTime.setEnabled(bl);
    }

    private boolean isAllCertifEmpty() {
        return !(this.txtCertifNumber.getText() != null && !this.txtCertifNumber.getText().trim().equals("") || this.txtCertifName.getSelectedItem() != null && !"".equals(this.txtCertifName.getSelectedItem().toString().trim()) || this.txtCertifOrg.getSelectedItem() != null && !"".equals(this.txtCertifOrg.getSelectedItem().toString().trim()) || this.txtCertifValidity.getNumberValue() != null && !"0".equals(this.txtCertifValidity.getNumberValue().toString().trim()) || this.dateCertifGrantTime.getValue() != null);
    }

    public boolean checkBeforeWindowClosing() {
        this.checkModify();
        return super.checkBeforeWindowClosing();
    }

    private void checkModify() {
        if (!this.getOprtState().equals(OprtState.VIEW) && this.isModified()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSave.getActionCommand());
        this.actionSubmit.actionPerformed(event);
        if (this.actionSubmit.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    private boolean isModified() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        try {
            PersonCertificationInfo info = this.storeCertificationInfo();
            if (!ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)info, (AbstractObjectValue)this.historyCertificationInfo)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        return false;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("trainRecordId", (Object)this.getUIContext().get("ID").toString());
        request.put("selector", (Object)this.getRecordSelector());
        this.initComeFrom();
        request.put("fromActRecordEditUI", (Object)this.fromActRecordEditUI);
        request.put("fromCourseRecordEditUI", (Object)this.fromCourseRecordEditUI);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        boolean empty;
        RequestContext request = super.prepareActionSubmit(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        if (!(empty = this.isAllCertifEmpty())) {
            this.verifyInput();
            PersonCertificationInfo certificationInfo = this.storeCertificationInfo();
            request.put("certificationInfo", (Object)certificationInfo);
        }
        request.put("deleteCertification", (Object)empty);
        request.put("trainRecordId", (Object)this.curRecordId);
        request.put("certificationId", (Object)this.curPersonCertifId);
        request.put("fromCourseRecordEditUI", (Object)this.fromCourseRecordEditUI);
        request.put("fromActRecordEditUI", (Object)this.fromActRecordEditUI);
        return request;
    }

    public boolean isPrepareInit() {
        return false;
    }
}

