/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ChargeItemCollection;
import com.kingdee.eas.hr.train.ChargeItemInfo;
import com.kingdee.eas.hr.train.TrainCourseCostCollection;
import com.kingdee.eas.hr.train.TrainCourseCostFactory;
import com.kingdee.eas.hr.train.TrainCourseCostInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseCostListUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainCourseCostEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainCourseCostListUI
extends AbstractTrainCourseCostListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseCostListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private int COLUMN_COUNT = 4;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initWorkButton();
        this.initTable();
        this.loadData();
        TrainUtils.setTableNumberFormat(this.tblMain, "cost", 2);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else {
            this.btnAddNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
        }
    }

    private void loadData() throws Exception {
        String trainActivityId = (String)this.getUIContext().get("TrainActivityID");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("TrainActCourse.id"));
        sic.add(new SelectorItemInfo("TrainActCourse.TrainCourse.number"));
        sic.add(new SelectorItemInfo("TrainActCourse.TrainCourse.name"));
        sic.add(new SelectorItemInfo("ChargeItem.id"));
        sic.add(new SelectorItemInfo("cost"));
        TrainCourseCostCollection coll = TrainCourseCostFactory.getRemoteInstance().getTrainCourseCostCollection(evi);
        this.fillTable(coll);
    }

    private void fillTable(TrainCourseCostCollection coll) throws Exception {
        TrainCourseCostInfo info = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            row = this.getRowFromTable(info);
            if (row != null) {
                row.getCell(info.getChargeItem().getId().toString()).setValue((Object)info.getCost());
                continue;
            }
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("trainActCourseId").setValue((Object)info.getTrainActCourse().getId().toString());
            row.getCell("number").setValue((Object)info.getTrainActCourse().getTrainCourse().getNumber());
            row.getCell("name").setValue((Object)info.getTrainActCourse().getTrainCourse().getName());
            row.getCell(info.getChargeItem().getId().toString()).setValue((Object)info.getCost());
        }
        this.calculateTotalCost();
        this.addTotalRow();
        this.calculateAllTotalCost();
    }

    private void calculateAllTotalCost() {
        if (this.tblMain.getRowCount() != 0) {
            IRow row = null;
            IColumn column = null;
            int size = this.tblMain.getColumnCount();
            for (int i = 4; i < size; ++i) {
                BigDecimal totalCost = new BigDecimal("0.00");
                column = this.tblMain.getColumn(i);
                if (column.getUserObject() == null) continue;
                for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
                    row = this.tblMain.getRow(j);
                    if (this.isTotalRow(row) || row.getCell(column.getKey()).getValue() == null) continue;
                    totalCost = totalCost.add((BigDecimal)row.getCell(column.getKey()).getValue());
                }
                row = this.getTotalRow();
                if (row == null) continue;
                row.getCell(column.getKey()).setValue((Object)this.bigDecimal2SpecialString(totalCost));
            }
        }
    }

    private String bigDecimal2SpecialString(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        decimal = decimal.setScale(2);
        String totalString = EASResource.getString((String)this.resourcePath, (String)"Yuan");
        return decimal + totalString;
    }

    private IRow getTotalRow() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (!"Total".equals((String)this.tblMain.getRow(i).getCell("id").getValue())) continue;
            return this.tblMain.getRow(i);
        }
        return null;
    }

    private boolean isTotalRow(IRow row) {
        return "Total".equals((String)row.getCell("id").getValue());
    }

    private void addTotalRow() {
        IRow row = this.tblMain.addRow();
        row.getCell("id").setValue((Object)"Total");
        row.getCell("cost").setValue((Object)this.bigDecimal2SpecialString(new BigDecimal("0")));
        row.getCell("number").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"Total"));
        row.getStyleAttributes().setBackground(TrainActivityHelper.KDTABLE_TOTAL_BG_COLOR);
    }

    private void calculateTotalCost() throws Exception {
        ChargeItemCollection coll = this.getChargeItemCollection();
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (this.isTotalRow(row)) continue;
            BigDecimal cost = new BigDecimal("0.00");
            int size = coll.size();
            for (int j = 0; j < size; ++j) {
                BigDecimal value = (BigDecimal)row.getCell(coll.get(j).getId().toString()).getValue();
                if (value == null) continue;
                cost = cost.add(value);
            }
            row.getCell("cost").setValue((Object)cost);
        }
    }

    private IRow getRowFromTable(TrainCourseCostInfo info) {
        if (info == null) {
            return null;
        }
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (!info.getTrainActCourse().getId().toString().equals((String)row.getCell("trainActCourseId").getValue())) continue;
            return row;
        }
        return null;
    }

    private void initTable() throws Exception {
        int count;
        IColumn column = null;
        for (int i = count = this.tblMain.getColumnCount() - 1; i >= 4; --i) {
            column = this.tblMain.getColumn(i);
            if (column.getUserObject() == null || column.getKey().equals("cost")) continue;
            this.tblMain.removeColumn(i);
        }
        ChargeItemCollection coll = this.getChargeItemCollection();
        ChargeItemInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            column = this.tblMain.addColumn(i + this.COLUMN_COUNT);
            column.setUserObject((Object)Boolean.TRUE);
            column.setKey(info.getId().toString());
            this.tblMain.getHeadRow(0).getCell(i + this.COLUMN_COUNT).setValue((Object)info.getName());
            TrainUtils.setTableNumberFormat(this.tblMain, info.getId().toString(), 2);
        }
        this.tblMain.getColumn("cost").setUserObject((Object)Boolean.TRUE);
    }

    private ChargeItemCollection getChargeItemCollection() throws BOSException {
        ChargeItemCollection itemColl = new ChargeItemCollection();
        String trainActivityId = (String)this.getUIContext().get("TrainActivityID");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("ChargeItem.id"));
        evi.getSelector().add(new SelectorItemInfo("ChargeItem.name"));
        TrainCourseCostCollection coll = TrainCourseCostFactory.getRemoteInstance().getTrainCourseCostCollection(evi);
        ChargeItemInfo itemInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = coll.get(i).getChargeItem();
            if (itemColl.contains(itemInfo)) continue;
            itemColl.add(itemInfo);
        }
        return itemColl;
    }

    protected String getEditUIName() {
        return TrainCourseCostEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainCourseCostFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainCourseCostInfo objectValue = new TrainCourseCostInfo();
        return objectValue;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            IRow row = this.tblMain.getRow(TrainUtils.getSelectedRow(this.tblMain));
            if (this.isTotalRow(row)) {
                return;
            }
            super.tblMain_tableClicked(e);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTable();
        this.tblMain.removeRows();
        this.loadData();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.tblMain.getRow(TrainUtils.getSelectedRow(this.tblMain));
        if (this.isTotalRow(row)) {
            return;
        }
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"TrainActivityID", this.getUIContext().get("TrainActivityID"));
        uiContext.put((Object)"TrainActCourseID", (Object)((String)row.getCell("trainActCourseId").getValue()));
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.tblMain.getRow(TrainUtils.getSelectedRow(this.tblMain));
        if (this.isTotalRow(row)) {
            return;
        }
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"TrainActivityID", this.getUIContext().get("TrainActivityID"));
        uiContext.put((Object)"TrainActCourseID", (Object)((String)row.getCell("trainActCourseId").getValue()));
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refresh();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), this.getUIContext(), null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh();
    }

    private void refresh() throws Exception {
        this.actionRefresh_actionPerformed(null);
        this.tblMain.getSelectManager().select(0, 0);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.tblMain.getRow(TrainUtils.getSelectedRow(this.tblMain));
        if (this.isTotalRow(row)) {
            return;
        }
        if (this.confirmRemove()) {
            boolean isNeedOverWrite = false;
            String trainActCourseId = row.getCell("trainActCourseId").getValue().toString();
            TrainCourseCostFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(trainActCourseId), isNeedOverWrite);
            this.refresh();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }
}

