/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.client.AbstractTrainCourseMaterialListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class TrainCourseMaterialListUI
extends AbstractTrainCourseMaterialListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainCourseMaterialListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAttachment.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                IRow row = null;
                Object boAttachId = null;
                int size = TrainCourseMaterialListUI.this.tblMain.getRowCount();
                for (int i = 0; i < size; ++i) {
                    row = TrainCourseMaterialListUI.this.tblMain.getRow(i);
                    if (TrainCourseMaterialListUI.this.isExistSameRowInTable(TrainCourseMaterialListUI.this.tblMain, "TrainMaterial.id", i)) {
                        TrainCourseMaterialListUI.this.tblMain.removeRow(i);
                        --i;
                        --size;
                        continue;
                    }
                    boAttachId = row.getCell("BoAttchAsso.id").getValue();
                    if (boAttachId == null) continue;
                    row.getCell("attachmentIcon").setValue((Object)EASResource.getIcon((String)"imgTbtn_affixmanage"));
                }
            }
        });
        if (this.getUIContext().get("courseId") != null) {
            String courseId = this.getUIContext().get("courseId").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)courseId));
            this.mainQuery.setFilter(filter);
        }
    }

    private boolean isExistSameRowInTable(KDTable tblSelect, String columnKey, int rowIndex) {
        String materialId = (String)tblSelect.getRow(rowIndex).getCell(columnKey).getValue();
        if (TrainCommonUtils.isEmpty(materialId)) {
            return false;
        }
        String strId = null;
        int size = tblSelect.getRowCount();
        for (int i = 0; i < size; ++i) {
            strId = (String)tblSelect.getRow(i).getCell(columnKey).getValue();
            if (i == rowIndex || !materialId.equals(strId)) continue;
            return true;
        }
        return false;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        Object value = this.tblMain.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell("TrainMaterial.id").getValue();
        if (value == null) {
            throw new TrainException(TrainException.TRAINCOURSE_NO_ATTACHMENT);
        }
        String materialId = value.toString();
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        am.showAttachmentListUIByBoID(materialId, (Object)this, false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.checkSelected();
        if (e.getClickCount() == 2) {
            this.actionAttachment_actionPerformed(null);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

