/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.client.HREmpFormulaFilterF7UI;
import com.kingdee.eas.hr.train.TrainFormulaFilterInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainEligibleCountFilterUI;
import java.awt.Container;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class TrainEligibleCountFilterUI
extends AbstractTrainEligibleCountFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(HREmpFormulaFilterF7UI.class);
    private CommonFilterPanel filterPanel = null;
    protected boolean isCanceled = true;
    private TrainFormulaFilterInfo formulaFilterInfo = new TrainFormulaFilterInfo();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws BaseCommonQueryClientException, ParserException, BOSException {
        TrainFormulaFilterInfo info;
        QueryInfo queryInfo = Util.getQueryInfo((String)"com.kingdee.eas.hr.train.app.TrainRecordCourseFormulaQuery");
        this.filterPanel = new CommonFilterPanel("", queryInfo, new FilterInfo(), new FilterInfo(), null, null, 486, 270);
        this.contFilter.setContentPane((Container)this.filterPanel);
        if (this.getUIContext().get("conditionParam") != null && (info = (TrainFormulaFilterInfo)((Object)this.getUIContext().get("conditionParam"))) != null && info.getFilterString() != null) {
            FilterInfo filterInfo = new FilterInfo(info.getFilterString());
            this.handleCondition(filterInfo);
            this.filterPanel.setDefalutFilterInfo(filterInfo);
            this.filterPanel.clear();
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.filterPanel.verify()) {
            FilterInfo filterInfo = this.filterPanel.getInnerFilterInfo();
            this.handleCondition(filterInfo);
            this.formulaFilterInfo.setFilterString(filterInfo.toString());
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    private void handleCondition(FilterInfo filter) {
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            FilterItemInfo filterItemInfo = null;
            FilterItemCollection items = filter.getFilterItems();
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                filterItemInfo = items.get(i);
                this.replaceCerificateCondition(filterItemInfo);
            }
        }
    }

    private void replaceCerificateCondition(FilterItemInfo filterItemInfo) {
        if ("hasCertificate".equals(filterItemInfo.getPropertyName())) {
            filterItemInfo.setPropertyName("certificateId");
            Integer value = (Integer)filterItemInfo.getCompareValue();
            if (value > 0) {
                filterItemInfo.setCompareType(CompareType.NOTEQUALS);
            } else {
                filterItemInfo.setCompareType(CompareType.EQUALS);
            }
            filterItemInfo.setCompareValue(null);
        } else if ("certificateId".equals(filterItemInfo.getPropertyName())) {
            filterItemInfo.setPropertyName("hasCertificate");
            if (CompareType.EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                filterItemInfo.setCompareValue((Object)0);
            } else {
                filterItemInfo.setCompareValue((Object)1);
                filterItemInfo.setCompareType(CompareType.EQUALS);
            }
        }
    }

    public TrainFormulaFilterInfo getFormulaFilterInfo() {
        return this.formulaFilterInfo;
    }
}

