/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.TrainConstants;
import com.kingdee.eas.hr.train.client.AbstractTrainHolidayUI;
import com.kingdee.eas.hr.train.client.TrainActCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class TrainHolidayUI
extends AbstractTrainHolidayUI {
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String trainStudent = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TrainStudent");
    private static final int COLUMN_WIDTH = 120;
    private int rowCount = 0;
    private static final String[] dayNames = new String[]{EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"SUN"), EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"MON"), EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TUE"), EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"WED"), EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"THU"), EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"FRI"), EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"SAT")};

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainCalendarQuery");
        super.onLoad();
        this.init();
        this.setComponentState();
        this.fillData();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getRowCountFromDB() {
        if (this.rowCount == -1) {
            try {
                IQueryExecutor iexec = this.getQueryExecutor((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainCalendarQuery"), this.mainQuery);
                this.rowCount = iexec.getRowCount();
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return this.rowCount;
    }

    private void init() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getStyleAttributes().setBackground(TrainConstants.disableColor);
        this.initMonthAndYear();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("trainCourseName") + 1);
    }

    private void initMonthAndYear() {
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(year, year - 1, year + 5, 1));
        this.spYear.setValue((Object)year);
        for (int i = 1; i <= 12; ++i) {
            this.comMonth.addItem((Object)String.valueOf(i));
        }
        this.comMonth.setSelectedItem((Object)String.valueOf(now.get(2) + 1));
    }

    private void fillData() throws Exception {
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = null;
        if (this.rdThisWeek.isSelected()) {
            startDate.set(7, 1);
            endDate = (Calendar)startDate.clone();
            endDate.set(7, 7);
        } else {
            int year = (Integer)this.spYear.getValue();
            startDate.set(1, year);
            int month = Integer.parseInt(this.comMonth.getSelectedItem().toString());
            startDate.set(2, month - 1);
            startDate.set(5, 1);
            endDate = (Calendar)startDate.clone();
            endDate.add(2, 1);
            endDate.add(5, -1);
        }
        this.initTableHead(startDate, endDate);
        this.fillTableBody(startDate, endDate, this.getCalendarData(startDate, endDate));
        this.tblMain.getGroupManager().group();
        this.tblMain.repaint();
    }

    private void initTableHead(Calendar startDate, Calendar endDate) {
        startDate = (Calendar)startDate.clone();
        endDate = (Calendar)endDate.clone();
        int startColumnIndex = this.tblMain.getColumnIndex("id") + 1;
        for (int i = this.tblMain.getColumnCount(); i >= startColumnIndex; --i) {
            this.tblMain.removeColumn(i);
        }
        IRow topHeadRow = this.tblMain.getHeadRow(0);
        IRow bottomHeadRow = this.tblMain.getHeadRow(1);
        endDate.add(5, 1);
        IColumn column = null;
        String value = null;
        while (!this.dateEqual(startDate, endDate)) {
            column = this.tblMain.addColumn(startColumnIndex);
            column.setWidth(120);
            value = this.rdThisWeek.isSelected() ? DateTimeUtils.format((Date)new Date(startDate.getTimeInMillis()), (String)"yyyy-MM-dd") : String.valueOf(startDate.get(5));
            topHeadRow.getCell(startColumnIndex).setValue((Object)value);
            value = dayNames[startDate.get(7) - 1];
            bottomHeadRow.getCell(startColumnIndex).setValue((Object)value);
            startDate.add(5, 1);
            ++startColumnIndex;
        }
    }

    private IRowSet getCalendarData(Calendar startDate, Calendar endDate) throws Exception {
        startDate.set(11, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        FilterInfo filterInfo = new FilterInfo();
        String personId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("personId", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)new Date(endDate.getTimeInMillis()), CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)new Date(startDate.getTimeInMillis()), CompareType.GREATER_EQUALS));
        return TrainActivityHelper.getRowSet("TrainCalendarQuery", filterInfo);
    }

    private void fillTableBody(Calendar selectStartDate, Calendar selectEndDate, IRowSet rowSet) throws Exception {
        this.tblMain.removeRows();
        String trainActCourseId = null;
        Calendar dataStartDate = Calendar.getInstance();
        Calendar dataEndDate = Calendar.getInstance();
        IRow row = null;
        while (rowSet.next()) {
            if (trainActCourseId != null && !trainActCourseId.equals(rowSet.getString("id")) || row == null) {
                row = this.tblMain.addRow();
                trainActCourseId = rowSet.getString("id");
                row.getCell("id").setValue((Object)trainActCourseId);
                row.getCell("trainActivityId").setValue((Object)rowSet.getString("trainActivityId"));
                row.getCell("trainActivityName").setValue((Object)rowSet.getString("trainActivityName"));
                row.getCell("trainCourseName").setValue((Object)rowSet.getString("trainCourseName"));
                row.getCell("trainItemName").setValue((Object)rowSet.getString("trainItemName"));
            }
            dataStartDate.setTime(rowSet.getDate("startDate"));
            dataEndDate.setTime(rowSet.getDate("endDate"));
            if (dataStartDate.before(selectStartDate)) {
                dataStartDate = (Calendar)selectStartDate.clone();
            }
            if (dataEndDate.after(selectEndDate)) {
                dataEndDate = (Calendar)selectEndDate.clone();
            }
            dataEndDate.add(5, 1);
            int day = 0;
            day = this.rdThisWeek.isSelected() ? dataStartDate.get(7) : dataStartDate.get(5);
            ICell cell = null;
            String value = null;
            String roleName = null;
            for (int columnIndex = this.tblMain.getColumnIndex("id") + day; !this.dateEqual(dataStartDate, dataEndDate) && columnIndex < this.tblMain.getColumnCount(); ++columnIndex) {
                cell = row.getCell(columnIndex);
                if (cell != null) {
                    roleName = "student".equals(rowSet.getString("roleName")) ? trainStudent : rowSet.getString("roleName");
                    value = (String)cell.getValue();
                    if (value != null) {
                        if (value.indexOf(roleName) == -1) {
                            value = value + "/" + roleName;
                        }
                    } else {
                        value = roleName;
                    }
                    cell.setValue((Object)value);
                }
                dataStartDate.add(5, 1);
            }
        }
    }

    private boolean dateEqual(Calendar one, Calendar other) {
        return one.get(1) == other.get(1) && one.get(2) == other.get(2) && one.get(5) == other.get(5);
    }

    protected void rdThisWeek_actionPerformed(ActionEvent e) throws Exception {
        this.setComponentState();
        this.fillData();
    }

    protected void rdSelectYearAndMonth_actionPerformed(ActionEvent e) throws Exception {
        this.setComponentState();
        this.fillData();
    }

    private void setComponentState() {
        boolean enable = this.rdSelectYearAndMonth.isSelected();
        this.spYear.setEnabled(enable);
        this.comMonth.setEnabled(enable);
    }

    protected void spYear_stateChanged(ChangeEvent e) throws Exception {
        this.fillData();
    }

    protected void comMonth_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    public void actionTrainActivity_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        UIContext uiContext = new UIContext((Object)"TrainActivityListUI");
        String activityId = this.tblMain.getRow(selectedRow).getCell("trainActivityId").getValue().toString();
        uiContext.put((Object)"ID", (Object)activityId);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainActivityEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.getUIObject().getUIMenuBar().setVisible(false);
        uiWindow.show();
    }

    public void actionTrainCourse_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
        UIContext uiContext = new UIContext((Object)"TrainActCourseListUI");
        String trainCourseId = this.tblMain.getRow(selectedRow).getCell("id").getValue().toString();
        uiContext.put((Object)"ID", (Object)trainCourseId);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TrainActCourseEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.getUIObject().getUIMenuBar().setVisible(false);
        uiWindow.show();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTrainActivity.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnTrainCourse.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuTrainActivity.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.menuTrainCourse.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected IObjectValue createNewData() {
        return null;
    }
}

