/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainInnerInstructorListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainInnerInstructorEditUI;
import com.kingdee.eas.hr.train.client.TrainInnerInstructorListFilterUI;
import com.kingdee.eas.hr.train.client.TrainInstructorDataProvider;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainInnerInstructorListUI
extends AbstractTrainInnerInstructorListUI {
    private static final String PRINT_TEMPLETE_PATH = "/HR/Train/TrainInnerInstructor";
    private static String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final Logger logger = CoreUIObject.getLogger(TrainInnerInstructorListUI.class);
    private boolean startOnLoad = false;
    private boolean isShare = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.actionQuery.setEnabled(true);
        this.startOnLoad = true;
        this.isShare = TrainUtils.getParamValueByNumber("hr_train_003");
        super.onLoad();
    }

    protected String getEditUIName() {
        return TrainInnerInstructorEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainInstructorFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainInstructorInfo objectValue = new TrainInstructorInfo();
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnSetDisnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnPrintInstructor.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintInstructor.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.tblMain.setColumnMoveable(true);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        try {
            filter = TrainUtils.getTrianInstructorFilter(this.isShare, false, "list");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return filter;
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainInnerInstructorListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkInnerOrgUnit(null)) {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String notRemove = "true";
        if (this.checkInnerOrgUnit(notRemove)) {
            super.actionRemove_actionPerformed(e);
        }
    }

    private boolean checkInnerOrgUnit(String notRemove) throws EASBizException, BOSException {
        List rowList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        HashSet<Object> ids = new HashSet<Object>();
        for (int i = 0; i < rowList.size(); ++i) {
            row = this.tblMain.getRow(Integer.parseInt(rowList.get(i).toString()));
            if (row.getCell("AdminOrgUnit") == null || row.getCell("AdminOrgUnit").getValue() == null) continue;
            ids.add(row.getCell("AdminOrgUnit").getValue());
        }
        if (ids != null && ids.size() > 0) {
            if (notRemove == null) {
                if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentInnerOrgUnit"));
                    return false;
                }
            } else if (!TrainFacadeFactory.getRemoteInstance().isIncludeRange_Modify(ids)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentInnerOrgUnit"));
                return false;
            }
        }
        return true;
    }

    private boolean checkCanModify() throws Exception {
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        boolean canModify = true;
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(rowNumber[i]);
            boolean IsEnabled = (Boolean)row.getCell("IsEnable").getValue();
            if (!IsEnabled) continue;
            canModify = false;
            break;
        }
        return canModify;
    }

    public void actionPrintInstructor_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set ids = TrainUtils.getSelectedValues(this.tblMain);
        TrainInstructorDataProvider dataProvider = new TrainInstructorDataProvider(ids);
        KDNoteHelper helper = new KDNoteHelper();
        helper.printPreview(PRINT_TEMPLETE_PATH, (Object)dataProvider, (Component)((Object)this));
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

