/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.ITrainInstructor;
import com.kingdee.eas.hr.train.InstructorTypeFactory;
import com.kingdee.eas.hr.train.InstructorTypeInfo;
import com.kingdee.eas.hr.train.TrainInstructorCollection;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainInstructorF7UI;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class TrainInstructorF7UI
extends AbstractTrainInstructorF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TrainInstructorF7UI.class);
    protected boolean isCanceled = true;
    protected TrainInstructorCollection instructorCol = new TrainInstructorCollection();
    private DefaultKingdeeTreeNode curTreeNode = null;
    private boolean isSingleSelect = true;
    private String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private boolean isShare = false;

    protected IObjectPK getSelectedTreeKeyValue() {
        try {
            return new ObjectUuidPK(this.getSelectedNodeKeyValue());
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return null;
        }
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "InstructorType.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return InstructorTypeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainInstructorFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.isShare = TrainUtils.getParamValueByNumber("hr_train_003");
        super.onLoad();
        this.initOperateButton();
        boolean bl = this.isSingleSelect = this.getUIContext().get("IsSingleSelect") == null ? true : (Boolean)this.getUIContext().get("IsSingleSelect");
        if (this.isSingleSelect) {
            this.contSelected.setVisible(false);
            this.splitRight.setDividerSize(0);
            this.tblMain.getSelectManager().setSelectMode(2);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            Genders sex = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                boolean isOuter = rowSet.getBoolean("IsOuter");
                if (isOuter) {
                    rowSet.updateString("kind", EASResource.getString((String)this.RES, (String)"OuterInstructor"));
                    String adminOrgUnitId = rowSet.getString("adminOrgUnit.id");
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("displayName"));
                    sic.add(new SelectorItemInfo("name"));
                    AdminOrgUnitInfo unitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitId));
                    rowSet.updateString("personAdminOrgUnit.displayName", unitInfo.getDisplayName(SysContext.getSysContext().getLocale()));
                    rowSet.updateString("personAdminOrgUnit.name", unitInfo.getName(SysContext.getSysContext().getLocale()));
                } else {
                    rowSet.updateString("kind", EASResource.getString((String)this.RES, (String)"InnerInstructor"));
                }
                sex = Genders.getEnum((int)rowSet.getInt("sex"));
                if (sex != null) {
                    rowSet.updateString("sex", sex.getAlias());
                    continue;
                }
                rowSet.updateString("sex", null);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.pnlRadio.setLayout((LayoutManager)new FlowLayout(0));
        this.rdoAll.setSelected(true);
        this.tblSelected.checkParsed();
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    private void initOperateButton() {
        this.contSelected.addButton((JButton)this.btnDown);
        this.contSelected.addButton((JButton)this.btnDel);
        this.contSelected.addButton((JButton)this.btnDownAll);
        this.contSelected.addButton((JButton)this.btnDelAll);
        this.btnDown.setText(EASResource.getString((String)this.RES, (String)"addLine"));
        this.btnDel.setText(EASResource.getString((String)this.RES, (String)"removeLine"));
        this.btnDownAll.setText(EASResource.getString((String)this.RES, (String)"addAll"));
        this.btnDelAll.setText(EASResource.getString((String)this.RES, (String)"removeAll"));
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.InstructorTypeRootName");
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.isSingleSelect) {
            int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (rowIndex < 0) {
                return;
            }
            this.instructorCol = this.getTopSelectedTrainInstructorCollection();
        } else {
            int size = this.tblSelected.getRowCount();
            if (size > 0) {
                this.instructorCol = this.getAllSelectedTrainInstructorCollection();
            }
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    private TrainInstructorCollection getTopSelectedTrainInstructorCollection() throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String strId = row.getCell("id").getValue().toString();
        TrainInstructorCollection instructorCol = new TrainInstructorCollection();
        TrainInstructorInfo instructorInfo = null;
        SelectorItemCollection sic = (SelectorItemCollection)this.getUIContext().get("selector");
        instructorInfo = sic != null ? ((ITrainInstructor)this.getBizInterface()).getTrainInstructorInfo((IObjectPK)new ObjectUuidPK(strId), sic) : ((ITrainInstructor)this.getBizInterface()).getTrainInstructorInfo((IObjectPK)new ObjectUuidPK(strId));
        instructorCol.add(instructorInfo);
        return instructorCol;
    }

    private TrainInstructorCollection getAllSelectedTrainInstructorCollection() throws Exception {
        int size = this.tblSelected.getRowCount();
        if (size <= 0) {
            return null;
        }
        TrainInstructorCollection instructorCol = new TrainInstructorCollection();
        SelectorItemCollection sic = (SelectorItemCollection)this.getUIContext().get("selector");
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblSelected.getRow(i);
            String instructorId = row.getCell("id").getValue().toString();
            TrainInstructorInfo instructorInfo = null;
            instructorInfo = sic != null ? ((ITrainInstructor)this.getBizInterface()).getTrainInstructorInfo((IObjectPK)new ObjectUuidPK(instructorId), sic) : ((ITrainInstructor)this.getBizInterface()).getTrainInstructorInfo((IObjectPK)new ObjectUuidPK(instructorId));
            instructorCol.add(instructorInfo);
        }
        return instructorCol;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            if (this.isSingleSelect) {
                this.btnSelect_actionPerformed(null);
            } else {
                this.btnDown_actionPerformed(null);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.btnDel_actionPerformed(null);
        }
    }

    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = TrainHelper.getSelectedRows(this.tblSelected);
        int size = indexs.length;
        for (int i = size - 1; i >= 0; --i) {
            this.tblSelected.removeRow(indexs[i]);
        }
    }

    protected void btnDelAll_actionPerformed(ActionEvent e) throws Exception {
        this.tblSelected.removeRows();
    }

    protected void btnDownAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow fromRow = this.tblMain.getRow(i);
            this.insertRowFromTopTable(fromRow);
        }
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = TrainHelper.getSelectedRows(this.tblMain);
        int size = indexs.length;
        for (int i = 0; i < size; ++i) {
            IRow fromRow = this.tblMain.getRow(indexs[i]);
            this.insertRowFromTopTable(fromRow);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.curTreeNode = (DefaultKingdeeTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (this.rdoInner.isSelected()) {
            this.rdoInner_actionPerformed(null);
        } else if (this.rdoOuter.isSelected()) {
            this.rdoOuter_actionPerformed(null);
        } else {
            this.rdoAll_actionPerformed(null);
        }
    }

    protected void rdoAll_actionPerformed(ActionEvent e) throws Exception {
        this.changeFilterInfo();
        this.tblMain.removeRows();
    }

    private void changeFilterInfo() throws BOSException {
        FilterInfo filter = new FilterInfo();
        Object userObj = this.getSelectedTreeNode().getUserObject();
        if (userObj != null && userObj instanceof InstructorTypeInfo) {
            HashSet idSet = new HashSet();
            this.getSelectedNodeIdSet(idSet, this.getSelectedTreeNode());
            if (idSet != null && idSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("InstructorType.id", (Object)this.getSelectedNodeKeyValue()));
                filter.getFilterItems().add(new FilterItemInfo("InstructorType.id", idSet, CompareType.INCLUDE));
                filter.setMaskString("#0 or #1");
            }
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            filter.mergeFilter(this.getDefaultFilterForQuery(), "AND");
        } else {
            filter = this.getDefaultFilterForQuery();
        }
        this.mainQuery.setFilter(filter);
    }

    private void getSelectedNodeIdSet(Set idSet, KDTreeNode node) {
        if (node.children() != null && node.getChildCount() > 0) {
            Enumeration childrenNode = node.children();
            KDTreeNode childNode = null;
            while (childrenNode.hasMoreElements()) {
                childNode = (KDTreeNode)childrenNode.nextElement();
                TreeBaseInfo info = (TreeBaseInfo)childNode.getUserObject();
                idSet.add(info.getId().toString());
                this.getSelectedNodeIdSet(idSet, childNode);
            }
        } else {
            TreeBaseInfo info = (TreeBaseInfo)node.getUserObject();
            idSet.add(info.getId().toString());
        }
    }

    protected void rdoInner_actionPerformed(ActionEvent e) throws Exception {
        this.changeFilterInfo();
        this.tblMain.removeRows();
    }

    protected void rdoOuter_actionPerformed(ActionEvent e) throws Exception {
        this.changeFilterInfo();
        this.tblMain.removeRows();
    }

    private void insertRowFromTopTable(IRow fromRow) {
        String instructorId = fromRow.getCell("id").getValue().toString();
        if (!TrainUtils.isExistSameRowInTable("id", instructorId, this.tblSelected)) {
            this.tblSelected.addRow(this.tblSelected.getRowCount(), fromRow);
        }
    }

    protected FilterInfo getDefaultFilterForTree() {
        return TrainUtils.getCurrentHRFilter("hrOrgUnit.id");
    }

    protected FilterInfo getTreeFilter() {
        return this.getDefaultFilterForQuery();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter;
        block11: {
            filter = new FilterInfo();
            boolean isOuter = false;
            if (SysContext.getSysContext().getCurrentHRUnit() == null) {
                return filter;
            }
            if (this.rdoInner.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("IsOuter", (Object)Boolean.FALSE));
            } else if (this.rdoOuter.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("IsOuter", (Object)Boolean.TRUE));
            }
            filter.getFilterItems().add(new FilterItemInfo("PositionMember.isPrimary", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)Boolean.TRUE));
            try {
                if (this.isShare) break block11;
                FilterInfo filterInfo = new FilterInfo();
                try {
                    filterInfo = TrainUtils.getTrianInstructorFilter(this.isShare, isOuter, "F7");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                filter.mergeFilter(filterInfo, "AND");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        FilterInfo customerFilter = (FilterInfo)this.getUIContext().get("filterInfo");
        if (customerFilter != null) {
            try {
                filter.mergeFilter(customerFilter, "AND");
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return filter;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void initPopmenu() {
    }
}

