/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainItemFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainItemCourseEditUI;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class TrainItemCourseEditUI
extends AbstractTrainItemCourseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainItemCourseEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";
    private ItemAction[] actions;

    public void onLoad() throws Exception {
        this.actions = TrainUtils.addButtonsToMutilTable(this.contCourse, this.kdtCourse);
        this.kdtCourse.checkParsed();
        this.initKdtCourse();
        super.onLoad();
        this.selectFirstRow();
    }

    private void selectFirstRow() {
        if (this.kdtCourse.getRow(0) != null) {
            this.kdtCourse.getSelectManager().select(0, 0);
        }
    }

    private void initKdtCourse() {
        this.initTrainCourse();
        TrainClientUtil.setDisableColor(this.kdtCourse);
        try {
            TrainUtils.setTableCellEditorByFormattedTextField(this.kdtCourse, "courseHour", 2);
            TrainUtils.setTableCellEditorByComboBox(this.kdtCourse, "courseHourUnit", "com.kingdee.eas.hr.train.CourseHourUnitEnum");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void initTrainCourse() {
        KDBizPromptBox courseBox = new KDBizPromptBox();
        TrainCoursePromptBox box = new TrainCoursePromptBox((IUIObject)this);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CourseHour"));
        selector.add(new SelectorItemInfo("CourseHourUnit"));
        selector.add(new SelectorItemInfo("treeid.id"));
        selector.add(new SelectorItemInfo("treeid.name"));
        selector.add(new SelectorItemInfo("CourseKind.name"));
        selector.add(new SelectorItemInfo("CourseKind.id"));
        selector.add(new SelectorItemInfo("orgUnit.name"));
        selector.add(new SelectorItemInfo("CourseTarget"));
        selector.add(new SelectorItemInfo("Content"));
        selector.add(new SelectorItemInfo("CourseJoinner"));
        selector.add(new SelectorItemInfo("description"));
        box.setSelector(selector);
        box.setSingleSelect(false);
        courseBox.setSelector((KDPromptSelector)box);
        courseBox.setDisplayFormat("$name$");
        courseBox.setEditFormat("$number$");
        courseBox.setCommitFormat("$number$");
        courseBox.setEditable(false);
        courseBox.setEnabledMultiSelection(true);
        this.kdtCourse.getColumn("course").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)courseBox));
        courseBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    TrainItemCourseEditUI.this.handleResult(e);
                    e.setResult(0);
                } else {
                    TrainItemCourseEditUI.this.clearRow();
                }
            }
        });
    }

    private void handleResult(PreChangeEvent e) {
        RowDataHandler handler = new RowDataHandler(){

            public boolean setRowData(IRow row, Object object) {
                boolean result = false;
                if (row != null && object != null) {
                    TrainCourseInfo courseInfo = (TrainCourseInfo)object;
                    row.getCell("course").setValue((Object)courseInfo);
                    row.getCell("courseNumber").setValue((Object)courseInfo.getNumber());
                    row.getCell("orgUnitName").setValue((Object)courseInfo.getOrgUnit().getName());
                    row.getCell("courseHour").setValue((Object)courseInfo.getCourseHour());
                    if (courseInfo.getCourseKind() != null) {
                        row.getCell("courseKind").setValue((Object)courseInfo.getCourseKind().getName());
                    } else {
                        row.getCell("courseKind").setValue(null);
                    }
                    if (courseInfo.getTreeid() != null) {
                        row.getCell("courseType").setValue((Object)courseInfo.getTreeid().getName());
                    } else {
                        row.getCell("courseType").setValue(null);
                    }
                    row.getCell("courseTarget").setValue((Object)courseInfo.getCourseTarget());
                    row.getCell("courseContent").setValue((Object)courseInfo.getContent());
                    row.getCell("courseObject").setValue((Object)courseInfo.getCourseJoinner());
                    row.getCell("courseRemark").setValue((Object)courseInfo.getDescription());
                    if (courseInfo.getCourseHourUnit() != null) {
                        row.getCell("courseHourUnit").setValue((Object)courseInfo.getCourseHourUnit());
                    } else {
                        row.getCell("courseHourUnit").setValue((Object)CourseHourUnitEnum.HOUR);
                    }
                    result = true;
                }
                return result;
            }
        };
        TrainUtils.batchAddRowWithData(this.kdtCourse, (Object[])e.getData(), "course", handler);
    }

    private void clearRow() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.kdtCourse);
        IRow row = this.kdtCourse.getRow(curIndex);
        row.getCell("course").setValue(null);
        row.getCell("courseNumber").setValue(null);
        row.getCell("orgUnitName").setValue(null);
        row.getCell("courseHour").setValue(null);
        row.getCell("courseHourUnit").setValue(null);
        row.getCell("courseKind").setValue(null);
        row.getCell("courseType").setValue(null);
        row.getCell("courseTarget").setValue(null);
        row.getCell("courseContent").setValue(null);
        row.getCell("courseObject").setValue(null);
        row.getCell("courseRemark").setValue(null);
    }

    public void loadFields() {
        super.loadFields();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
        } else {
            this.setActionState(true);
        }
    }

    private void setActionState(boolean flag) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setEnabled(flag);
        }
        this.kdtCourse.getStyleAttributes().setLocked(!flag);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.kdtCourse.getRowCount() == 0) {
            TrainClientUtil.showErrorMessage(RESOURCE, "TrainItemMustHaveCourse", (CoreUI)this);
        }
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtCourse, "course");
        if (TrainUtils.isRepeatRowInTable(this.kdtCourse, "course")) {
            TrainClientUtil.showErrorMessage(RESOURCE, "TrainItemCourseRepeat", (CoreUI)this);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnView.setEnabled(true);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        TrainClientUtil.viewEditUI((CoreUI)this, TrainCourseEditUI.class.getName(), this.kdtCourse, "course", null);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainItemFactory.getRemoteInstance();
    }

    protected void kdtCourse_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

