/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.AssessMethodInfo;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainItemFactory;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainItemTreeInfo;
import com.kingdee.eas.hr.train.TrainingMethodInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainItemEditUI;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainItemTreePromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class TrainItemEditUI
extends AbstractTrainItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainItemEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainResource";
    private ItemAction[] actions;
    private HashMap hmUIState = new HashMap();
    private String pubBtnState = null;

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
    }

    private void init() throws Exception, BOSException {
        TrainUtils.initOrgUnit(this.prmtadminOrgUnit, (IUIObject)this);
        this.setComboBox();
        TrainItemTreePromptBox itemTreePromptBox = new TrainItemTreePromptBox((IUIObject)this);
        itemTreePromptBox.setSelectLeaf(true);
        this.prmtTrainItemTree.setSelector((KDPromptSelector)itemTreePromptBox);
        this.txtcourseHour.setHorizontalAlignment(4);
        this.txtPassStand.setHorizontalAlignment(4);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtcourseHour);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtPassStand);
        this.actions = TrainUtils.addButtonsToMutilTable(this.contCourses, this.kdtCourse);
        this.initKdtCourse();
        this.pubBtnState = null;
        try {
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            this.pubBtnState = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), "hr_train_004");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddOrg = this.conRange.add((Action)((Object)this.actionAddOrg));
        JButton btnDelOrg = this.conRange.add((Action)((Object)this.actionDelOrg));
        btnAddOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnDelOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void setComboBox() throws BOSException, EASBizException {
        HashMap parameters = new HashMap();
        HashMap<String, Object> trainMethodMap = new HashMap<String, Object>();
        trainMethodMap.put("bosType", new TrainingMethodInfo().getBOSType());
        trainMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("trainMethod", trainMethodMap);
        HashMap<String, Object> assessMethodMap = new HashMap<String, Object>();
        assessMethodMap.put("bosType", new AssessMethodInfo().getBOSType());
        assessMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("assessMethod", assessMethodMap);
        Map result = TrainFacadeFactory.getRemoteInstance().batchGetCollection(parameters);
        this.cboTrainMethod.setModel((ComboBoxModel)TrainUtils.getComboBoxModel((IObjectCollection)result.get("trainMethod")));
        this.cboAssessMethod.setModel((ComboBoxModel)TrainUtils.getComboBoxModel((IObjectCollection)result.get("assessMethod")));
    }

    private void initKdtCourse() {
        this.initTrainCourse();
        KDFormattedTextField courseHour = (KDFormattedTextField)this.kdtCourse.getColumn("courseHour").getEditor().getComponent();
        courseHour.setPrecision(2);
        courseHour.setSupportedEmpty(true);
        TrainClientUtil.setDisableColor(this.kdtCourse);
    }

    private void initTrainCourse() {
        KDBizPromptBox courseBox = new KDBizPromptBox();
        TrainCoursePromptBox box = new TrainCoursePromptBox((IUIObject)this);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CourseHour"));
        selector.add(new SelectorItemInfo("CourseHourUnit"));
        selector.add(new SelectorItemInfo("treeid.id"));
        selector.add(new SelectorItemInfo("treeid.name"));
        selector.add(new SelectorItemInfo("CourseKind.name"));
        selector.add(new SelectorItemInfo("CourseKind.id"));
        selector.add(new SelectorItemInfo("orgUnit.name"));
        selector.add(new SelectorItemInfo("CourseTarget"));
        selector.add(new SelectorItemInfo("Content"));
        selector.add(new SelectorItemInfo("CourseJoinner"));
        selector.add(new SelectorItemInfo("description"));
        box.setSelector(selector);
        box.setSingleSelect(false);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        courseBox.setSelector((KDPromptSelector)box);
        courseBox.setDisplayFormat("$name$");
        courseBox.setEditFormat("$number$");
        courseBox.setCommitFormat("$number$");
        courseBox.setEditable(false);
        courseBox.setEnabledMultiSelection(true);
        this.kdtCourse.getColumn("course").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)courseBox));
        courseBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null) {
                    TrainItemEditUI.this.handleResult(e);
                    e.setResult(0);
                } else {
                    TrainItemEditUI.this.clearRow();
                }
            }
        });
    }

    private void handleResult(PreChangeEvent e) {
        RowDataHandler handler = new RowDataHandler(){

            public boolean setRowData(IRow row, Object object) {
                boolean result = false;
                if (row != null && object != null) {
                    TrainCourseInfo courseInfo = (TrainCourseInfo)object;
                    row.getCell("course").setValue((Object)courseInfo);
                    row.getCell("courseNumber").setValue((Object)courseInfo.getNumber());
                    row.getCell("courseAdminOrg").setValue((Object)courseInfo.getOrgUnit().getName());
                    row.getCell("courseHour").setValue((Object)courseInfo.getCourseHour());
                    row.getCell("courseTarget").setValue((Object)courseInfo.getCourseTarget());
                    row.getCell("courseContent").setValue((Object)courseInfo.getContent());
                    row.getCell("courseObject").setValue((Object)courseInfo.getCourseJoinner());
                    row.getCell("courseRemark").setValue((Object)courseInfo.getDescription());
                    if (courseInfo.getCourseKind() != null) {
                        row.getCell("courseKind").setValue((Object)courseInfo.getCourseKind().getName());
                    } else {
                        row.getCell("courseKind").setValue(null);
                    }
                    if (courseInfo.getTreeid() != null) {
                        row.getCell("courseType").setValue((Object)courseInfo.getTreeid().getName());
                    } else {
                        row.getCell("courseType").setValue(null);
                    }
                    if (courseInfo.getCourseHourUnit() != null) {
                        row.getCell("courseHourUnit").setValue((Object)courseInfo.getCourseHourUnit());
                    } else {
                        row.getCell("courseHourUnit").setValue((Object)CourseHourUnitEnum.HOUR);
                    }
                    result = true;
                }
                return result;
            }
        };
        TrainUtils.batchAddRowWithData(this.kdtCourse, (Object[])e.getData(), "course", handler);
    }

    private void clearRow() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.kdtCourse);
        IRow row = this.kdtCourse.getRow(curIndex);
        row.getCell("courseNumber").setValue(null);
        row.getCell("courseAdminOrg").setValue(null);
        row.getCell("courseHour").setValue(null);
        row.getCell("courseHourUnit").setValue(null);
        row.getCell("courseKind").setValue(null);
        row.getCell("courseType").setValue(null);
        row.getCell("courseTarget").setValue(null);
        row.getCell("courseContent").setValue(null);
        row.getCell("courseObject").setValue(null);
        row.getCell("courseRemark").setValue(null);
    }

    public void loadFields() {
        super.loadFields();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
            if (this.editData != null && this.editData.isIsEnable()) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            }
        } else {
            this.setActionState(true);
        }
        if (this.editData.getTrainMethod() != null) {
            TrainUtils.setComboBoxSelected(this.cboTrainMethod, this.editData.getTrainMethod().getId().toString());
        } else {
            this.cboTrainMethod.setSelectedIndex(-1);
        }
        if (this.editData.getAssessMethod() != null) {
            TrainUtils.setComboBoxSelected(this.cboAssessMethod, this.editData.getAssessMethod().getId().toString());
        }
        try {
            this.chkNeedExam_stateChanged(null);
            this.chkNeedCertificate_stateChanged(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (Boolean.TRUE.equals(this.getUIContext().get("viewOnly"))) {
            this.actionAddNew.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            TrainClientUtil.lockUI((CoreUI)this, this.hmUIState);
        }
        if (this.oprtState.equals(OprtState.EDIT) || this.oprtState.equals(OprtState.ADDNEW)) {
            this.actionDelOrg.setEnabled(true);
            this.actionAddOrg.setEnabled(true);
        }
        if (this.oprtState.equals(OprtState.VIEW) || this.pubBtnState != null && this.pubBtnState.equals("false")) {
            TrainUtils.disableTable(this.kdtRange);
            this.actionDelOrg.setEnabled(false);
            this.actionAddOrg.setEnabled(false);
        }
    }

    private void setActionState(boolean flag) {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setEnabled(flag);
        }
        this.kdtCourse.getStyleAttributes().setLocked(!flag);
    }

    protected String getEditUIName() {
        return TrainItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainItemFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainItemInfo objectValue = new TrainItemInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setHrOrgUnit(TrainUtils.getCurrentHROrgUnit());
        TrainItemTreeInfo treeInfo = (TrainItemTreeInfo)this.getUIContext().get("ParentNode");
        if (treeInfo != null && treeInfo.isIsLeaf()) {
            objectValue.setTreeid(treeInfo);
        }
        objectValue.setCourseHourUnit(CourseHourUnitEnum.HOUR);
        objectValue.setNeedExam(false);
        objectValue.setNeedCertificate(false);
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtadminOrgUnit);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainItemTree);
        TrainVerifyUtils.verifyNumberPositive((CoreUIObject)this, this.txtcourseHour);
        if (this.chkNeedCertificate.isSelected()) {
            TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtCertificateName);
        }
        if (this.kdtCourse.getRowCount() == 0) {
            TrainClientUtil.showErrorMessage(RESOURCE, "TrainItemMustHaveCourse", (CoreUI)this);
        }
        TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtCourse, "course");
        if (TrainUtils.isRepeatRowInTable(this.kdtCourse, "course")) {
            TrainClientUtil.showErrorMessage(RESOURCE, "TrainItemCourseRepeat", (CoreUI)this);
        }
    }

    public void kdtCourse_Changed(int rowIndex, int colIndex) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setActionState(true);
        AdminOrgUnitInfo adminOrgUnitInfo = this.editData.getAdminOrgUnit();
        if (adminOrgUnitInfo != null && this.pubBtnState != null && this.pubBtnState.equals("true")) {
            HashSet<String> ids = new HashSet<String>();
            ids.add(adminOrgUnitInfo.getId().toString());
            if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrg"));
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
        this.chkNeedCertificate_stateChanged(null);
        this.chkNeedExam_stateChanged(null);
        this.setAutoNumberByOrg(null);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isEnable"));
        return sic;
    }

    protected void chkNeedCertificate_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkNeedCertificate.isSelected()) {
            this.txtCertificateName.setEnabled(true);
        } else {
            this.txtCertificateName.setEnabled(false);
            this.txtCertificateName.setText(null);
        }
    }

    protected void chkNeedExam_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkNeedExam.isSelected()) {
            this.cboAssessMethod.setEnabled(true);
            this.txtPassStand.setEnabled(true);
        } else {
            this.cboAssessMethod.setEnabled(false);
            this.txtPassStand.setEnabled(false);
            this.cboAssessMethod.setSelectedIndex(-1);
            this.txtPassStand.setValue(null);
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState());
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        HashMap parameters = new HashMap();
        HashMap<String, Object> trainMethodMap = new HashMap<String, Object>();
        trainMethodMap.put("bosType", new TrainingMethodInfo().getBOSType());
        trainMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("trainMethod", trainMethodMap);
        HashMap<String, Object> assessMethodMap = new HashMap<String, Object>();
        assessMethodMap.put("bosType", new AssessMethodInfo().getBOSType());
        assessMethodMap.put("filter", TrainUtils.getCurrentHRFilter("hrOrgUnit.id"));
        parameters.put("assessMethod", assessMethodMap);
        request.put("comboParams", parameters);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOrg_actionPerformed(e);
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        f7.setIsSingleSelect(false);
        Set orgUnitIDs = this.getOrgIds();
        f7.show();
        if (f7.isCanceled()) {
            return;
        }
        Object obj = f7.getData();
        if (obj instanceof Object[]) {
            Object[] datas = (Object[])obj;
            IRow row = null;
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            for (int i = 0; i < datas.length; ++i) {
                adminOrgUnitInfo = (AdminOrgUnitInfo)datas[i];
                if (orgUnitIDs != null && orgUnitIDs.contains(adminOrgUnitInfo.getId().toString())) continue;
                row = this.kdtRange.addRow();
                row.getCell("AdminOrgUnit").setValue((Object)adminOrgUnitInfo);
                row.getCell("AdminOrgUnitNumber").setValue((Object)adminOrgUnitInfo.getNumber());
            }
        }
    }

    private Set getOrgIds() {
        HashSet<String> orgIds = new HashSet<String>();
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        for (int rowIndex = 0; rowIndex < this.kdtRange.getRowCount(); ++rowIndex) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.kdtRange.getRow(rowIndex).getCell("AdminOrgUnit").getValue();
            orgIds.add(adminOrgUnitInfo.getId().toString());
        }
        return orgIds;
    }

    public void actionDelOrg_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtRange);
    }
}

