/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.TrainMaterialFactory;
import com.kingdee.eas.hr.train.TrainMaterialInfo;
import com.kingdee.eas.hr.train.TrainMaterialTreeFactory;
import com.kingdee.eas.hr.train.TrainMaterialTreeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainMaterialListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainMaterialCourseListUI;
import com.kingdee.eas.hr.train.client.TrainMaterialEditUI;
import com.kingdee.eas.hr.train.client.TrainMaterialListFilterUI;
import com.kingdee.eas.hr.train.client.TrainMaterialTreeEditUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TreeDetailHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class TrainMaterialListUI
extends AbstractTrainMaterialListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainMaterialListUI.class);
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainResource";
    private static final String resPath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private boolean startOnLoad = false;
    private String currentHRId = null;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.menuItemGroupAddNew.setAccelerator(KeyStroke.getKeyStroke("ctrl alt N"));
        this.startOnLoad = true;
        this.currentHRId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCourse.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.treeView.getControlPane().remove((Component)this.btnGroupMoveTree);
        this.tblMain.setColumnMoveable(true);
        this.menuCourse.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseInfo obj = null;
        if (this.getSelectedTreeKeyValue() != null) {
            obj = this.getTreeInterface().getValue(this.getSelectedTreeKeyValue());
        }
        TrainMaterialTreeInfo info = null;
        info = obj != null && obj instanceof TrainMaterialTreeInfo ? (TrainMaterialTreeInfo)obj : null;
        if (info == null || !info.isIsLeaf()) {
            String msg = EASResource.getString((String)resPath, (String)"PleaseChooseLeafNode");
            MsgBox.showInfo((String)msg);
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        TreeDetailHelper.checkGroupAddNew(this, this.treeMain, this.getBizInterface());
        super.actionGroupAddNew_actionPerformed(e);
    }

    private FilterInfo getTypeFilter() {
        if (this.getSelectedTreeKeyValue() == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("treeid.id", (Object)this.getSelectedTreeKeyValue().toString());
        filter.getFilterItems().add(filterItem);
        return filter;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        KDTreeNode node = super.getSelectedTreeNode();
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (obj == null || !(obj instanceof TrainMaterialTreeInfo)) {
            return null;
        }
        String id = ((TrainMaterialTreeInfo)obj).getId().toString();
        return new ObjectUuidPK(id);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.checkGroupRemove();
        if (this.getSelectedTreeKeyValue() == null || TreeDetailHelper.treeNodeHaveItems(this.getBizInterface(), (CoreBaseInfo)node.getUserObject())) {
            MsgBox.showInfo((String)EASResource.getString((String)resPath, (String)"TypeHaveItemsRemoveDisabled"));
            SysUtil.abort();
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    private KDTreeNode checkGroupRemove() {
        KDTreeNode node = this.getSelectedTreeNode();
        if (node == null || node.isRoot()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"PleaseChooseNode"));
            SysUtil.abort();
        }
        if (node.getChildCount() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resPath, (String)"CanNotDelOnHaveChild"));
            SysUtil.abort();
        }
        return node;
    }

    public RequestContext prepareActionGroupRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionGroupRemove(itemAction);
        KDTreeNode node = this.checkGroupRemove();
        if (this.getSelectedTreeKeyValue() != null) {
            request.put("nodeData", node.getUserObject());
        }
        return request;
    }

    protected String getEditUIName() {
        return TrainMaterialEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainMaterialFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TrainMaterialTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return TrainMaterialTreeEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)resourcePath, (String)"TrainMaterial");
    }

    protected IObjectValue createNewData() {
        TrainMaterialInfo objectValue = new TrainMaterialInfo();
        return objectValue;
    }

    public void actionCourse_actionPerformed(ActionEvent e) throws Exception {
        super.actionCourse_actionPerformed(e);
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        this.getUIContext().put("TrainMaterialID", this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainMaterialCourseListUI.class.getName(), this.getUIContext(), null, OprtState.VIEW);
        uiWindow.show();
    }

    protected FilterInfo getDefaultFilterForTree() {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        FilterInfo fi = new FilterInfo();
        Set ids = TrainUtils.getHRByParamNumber("hr_train_006");
        fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        return fi;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        Set ids = TrainUtils.getHRByParamNumber("hr_train_006");
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        return filterInfo;
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainMaterialListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        TreeDetailHelper.checkMoveTreeNode(e, (CoreUI)this);
        super.moveTreeNode(e);
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        try {
            if (TreeDetailHelper.checkMoveGroupTreeNode(e, this.getBizInterface(), (CoreUI)this)) {
                super.moveGroupTreeNode(e);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), (ListUI)this, this.mainQueryPK);
    }

    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        if (this.getSelectedTreeKeyValue() != null) {
            IObjectPK pk = this.getSelectedTreeKeyValue();
            request.put("treePk", (Object)pk);
        }
        return request;
    }

    public RequestContext prepareActionGroupAddNew(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        FilterInfo fi = this.getTypeFilter();
        if (fi != null) {
            request.put("filterInfo", (Object)fi);
        }
        TreeDetailHelper.prepareCheckGroupAddNew(this, this.treeMain, request);
        return request;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionGroupAddNew() {
        return true;
    }

    public boolean isPrepareActionGroupEdit() {
        return true;
    }

    public boolean isPrepareActionGroupRemove() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String hrID = null;
        boolean isShare = false;
        if (rows != null && rows.length > 0 && rows[0] >= 0) {
            int len = rows.length;
            for (int i = 0; i < len; ++i) {
                hrID = this.tblMain.getRow(rows[i]).getCell("hrOrgUnit.id").getValue().toString();
                if (this.currentHRId.equals(hrID)) continue;
                isShare = true;
                break;
            }
        }
        if (isShare) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (this.treeMain.getSelectionPath() == null) {
            return;
        }
        KDTreeNode node = (KDTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (node.getUserObject() != null && node.getUserObject() instanceof TrainMaterialTreeInfo) {
            TrainMaterialTreeInfo treeInfo = (TrainMaterialTreeInfo)node.getUserObject();
            if (treeInfo.getHrOrgUnit() != null && !this.currentHRId.equals(treeInfo.getHrOrgUnit().getId().toString())) {
                this.actionAddNew.setEnabled(false);
                this.actionGroupAddNew.setEnabled(false);
                this.actionGroupRemove.setEnabled(false);
                this.actionGroupEdit.setEnabled(false);
            } else {
                this.actionAddNew.setEnabled(true);
                this.actionGroupAddNew.setEnabled(true);
                this.actionGroupRemove.setEnabled(true);
                this.actionGroupEdit.setEnabled(true);
            }
        } else {
            this.actionAddNew.setEnabled(true);
            this.actionGroupAddNew.setEnabled(true);
            this.actionGroupRemove.setEnabled(true);
            this.actionGroupEdit.setEnabled(true);
        }
    }
}

