/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.IBaseInnerFacade;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.PhotoPanel;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.InstructorPhotoFactory;
import com.kingdee.eas.hr.train.InstructorPhotoInfo;
import com.kingdee.eas.hr.train.TrainEvaluLevelFactory;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainOuterInstructorEditUI;
import com.kingdee.eas.hr.train.client.InstructorTypePromptBox;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseHistoryByInstructorListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainOuterInstructorEditUI
extends AbstractTrainOuterInstructorEditUI {
    protected Logger logger = Logger.getLogger((String)"com.kingdee.bos.waf.winlet.edit.EditBean");
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainChanneResource";
    private PhotoPanel pPanel = new PhotoPanel();
    private boolean pubBtnState = false;

    public void onLoad() throws Exception {
        this.pubBtnState = TrainUtils.getParamValueByNumber("hr_train_003");
        super.onLoad();
        this.initOrgUnit();
        this.pPanel.setBounds(0, 0, this.photoPanel.getWidth(), this.photoPanel.getHeight());
        this.photoPanel.add((Component)this.pPanel);
        TrainUtils.setKDTableSortable(this.kdtRange);
    }

    private void initOrgUnit() {
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        f7.setIsSingleSelect(true);
        Set hroSet = new HashSet();
        try {
            hroSet = TrainFacadeFactory.getRemoteInstance().getPersonHRRange(userID);
        }
        catch (EASBizException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        f7.setHROFilter(hroSet);
        this.prmtorgUnit.setSelector((KDPromptSelector)f7);
    }

    public void loadFields() {
        super.loadFields();
        this.initWorkButtonState();
        if (this.editData.getOuterEvaluateLevel() != null) {
            TrainUtils.setComboBoxSelected(this.cboOuterEvaluate, this.editData.getOuterEvaluateLevel().getId().toString());
        }
        if (this.oprtState.equals(OprtState.EDIT) || this.oprtState.equals(OprtState.ADDNEW)) {
            this.actionDelOrg.setEnabled(true);
            this.actionAddOrg.setEnabled(true);
        }
        if (this.oprtState.equals(OprtState.VIEW) || this.pubBtnState) {
            TrainUtils.disableTable(this.kdtRange);
            this.actionDelOrg.setEnabled(false);
            this.actionAddOrg.setEnabled(false);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.pPanel.setOprtStat(OprtState.EDIT);
        } else {
            this.pPanel.setOprtStat(null);
        }
        this.setPhotoImage();
        this.pPanel.setToolTipText(EASResource.getString((String)RESOURCE, (String)"photoToolTipText"));
    }

    private void setPhotoImage() {
        if (this.editData != null && this.editData.getPhoto() != null && this.editData.getPhoto().getImageData() != null) {
            try {
                InstructorPhotoInfo photoInfo = this.editData.getPhoto();
                byte[] data = photoInfo.getImageData();
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                BufferedImage bfg = ImageIO.read(bais);
                this.pPanel.setSelectImage(bfg);
                bais.close();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.pPanel.setSelectImage(null);
            this.pPanel.repaint();
        }
    }

    private void initWorkButtonState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnAttachment.setEnabled(false);
            this.btnPrimaryCourse.setEnabled(false);
            this.btnCourseHistory.setEnabled(false);
        } else {
            this.btnAttachment.setEnabled(true);
            this.btnPrimaryCourse.setEnabled(true);
            this.btnCourseHistory.setEnabled(true);
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            if (this.editData != null && this.editData.isIsEnable()) {
                this.actionEdit.setEnabled(false);
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
                this.actionEdit.setEnabled(true);
            }
        }
    }

    protected String getEditUIName() {
        return TrainOuterInstructorEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainInstructorFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainInstructorInfo objectValue = new TrainInstructorInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setIsOuter(true);
        objectValue.setIsEnable(true);
        objectValue.setSex(Genders.Male);
        try {
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            Set hroSet = TrainFacadeFactory.getRemoteInstance().getPersonHRRange(userID);
            IBaseInnerFacade iBIF = BaseInnerFacadeFactory.getRemoteInstance();
            objectValue.setOrgUnit(this.getOrgInRange(iBIF, null));
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
        return objectValue;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("FID")));
        adminInfo.setName(row.getString("FName_" + SysContext.getSysContext().getLocale()));
        adminInfo.setSortCode(row.getString("FSortCode"));
        adminInfo.setLongNumber(row.getString("FLongNumber"));
        adminInfo.setIsLeaf(row.getBoolean("FIsLeaf"));
        adminInfo.setLevel(row.getInt("FLevel"));
        adminInfo.setIsSealUp(row.getBoolean("FIsSealUp"));
        return adminInfo;
    }

    private AdminOrgUnitInfo getOrgInRange(IBaseInnerFacade iBIF, ArrayList nextOrgList) throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        Set hroSet = TrainFacadeFactory.getRemoteInstance().getPersonHRRange(userID);
        if (nextOrgList == null) {
            HashMap map = iBIF.getAdminOrgData(false, (HashSet)hroSet, null, false, false);
            if (map != null) {
                IRowSet adminRowSet = (IRowSet)map.get("AdminRowSet");
                HashMap adminNodeType = (HashMap)map.get("AdminNodeType");
                if (adminRowSet != null) {
                    adminRowSet.beforeFirst();
                    if (adminRowSet.next()) {
                        String adminOrgId = adminRowSet.getString("FID");
                        int nodeType = (Integer)adminNodeType.get(adminOrgId);
                        if (nodeType == 0) {
                            return null;
                        }
                        if (nodeType == 1) {
                            return TrainOuterInstructorEditUI.createAdminUnitInfo(adminRowSet);
                        }
                        if (!adminRowSet.getBoolean("FIsLeaf")) {
                            HashMap subMap = iBIF.getAdminOrgData(false, (HashSet)hroSet, adminOrgId, false, false);
                            ArrayList<HashMap> list = new ArrayList<HashMap>();
                            list.add(subMap);
                            return this.getOrgInRange(iBIF, list);
                        }
                        return null;
                    }
                }
            }
            return null;
        }
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        int size = nextOrgList.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)nextOrgList.get(i);
            IRowSet adminRowSet = (IRowSet)map.get("AdminRowSet");
            HashMap adminNodeType = (HashMap)map.get("AdminNodeType");
            adminRowSet.beforeFirst();
            if (adminRowSet == null) continue;
            while (adminRowSet.next()) {
                String adminOrgId = adminRowSet.getString("FID");
                int nodeType = (Integer)adminNodeType.get(adminOrgId);
                if (nodeType == 0) continue;
                if (nodeType == 1) {
                    return TrainOuterInstructorEditUI.createAdminUnitInfo(adminRowSet);
                }
                if (adminRowSet.getBoolean("FIsLeaf")) continue;
                HashMap subMap = iBIF.getAdminOrgData(false, (HashSet)hroSet, adminOrgId, false, false);
                list.add(subMap);
            }
        }
        if (list.size() > 0) {
            return this.getOrgInRange(iBIF, list);
        }
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setVisible(false);
        this.prmtInstructorType.setSelector((KDPromptSelector)new InstructorTypePromptBox((IUIObject)this));
        this.btnAttachment.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnPrimaryCourse.setIcon(EASResource.getIcon((String)"imgTbtn_maincourse"));
        this.btnCourseHistory.setIcon(EASResource.getIcon((String)"imgTbtn_schoolhistory"));
        try {
            this.cboDiploma.setModel((ComboBoxModel)EmployeeClientUtils.getComboModel((IBasicItem)DiplomaFactory.getRemoteInstance()));
            this.cboOuterEvaluate.setModel((ComboBoxModel)TrainUtils.getComboModel(TrainEvaluLevelFactory.getRemoteInstance(), TrainUtils.getCurrentHRFilter("hrOrgUnit.id")));
            TrainUtils.getCurrentCUFilter();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        JButton btnAddOrg = this.contRange.add((Action)((Object)this.actionAddOrg));
        JButton btnDelOrg = this.contRange.add((Action)((Object)this.actionDelOrg));
        btnAddOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnDelOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtorgUnit);
        if (!TrainClientUtil.objectIsNull(this.txtPostalcode.getText())) {
            String postCode = this.txtPostalcode.getText();
            if (postCode.trim().length() != 6) {
                this.txtPostalcode.requestFocus();
                TrainClientUtil.showErrorMessage(RES, "postCodeMustNumber", (CoreUI)this);
            }
            int n = postCode.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isDigit(postCode.charAt(i))) continue;
                this.txtPostalcode.requestFocus();
                TrainClientUtil.showErrorMessage(RES, "postCodeMustNumber", (CoreUI)this);
            }
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.OUTERINSTRUCTOR_SAVESUCCESS"));
        this.showMessage();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Diploma.*"));
        sic.add(new SelectorItemInfo("InnerLevel.*"));
        sic.add(new SelectorItemInfo("photo.*"));
        return sic;
    }

    protected void showMessageForStatus() {
    }

    public void actionPrimaryCourse_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Instructor.id", (Object)this.editData.getId().toString()));
        TrainUtils.showChanneCourseList(filter, "instructor");
    }

    public void actionCourseHistory_actionPerformed(ActionEvent e) throws Exception {
        super.actionCourseHistory_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"isOuter", (Object)"Y");
        uiContext.put((Object)"TrainInstructorID", (Object)this.editData.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainCourseHistoryByInstructorListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public IObjectPK runSubmit() throws Exception {
        this.handlePhoto();
        IObjectPK objectPk = super.runSubmit();
        return objectPk;
    }

    private void handlePhoto() throws Exception {
        this.editData.setPhotoData(null);
        InstructorPhotoInfo photo = new InstructorPhotoInfo();
        if (this.pPanel.getSelectImage() != null) {
            ObjectUuidPK oldPhoto = null;
            if (this.editData.getPhoto() != null) {
                oldPhoto = new ObjectUuidPK(this.editData.getPhoto().getId());
            }
            photo.setImageData(this.pPanel.getSelectImageBytes());
            IObjectPK pk = InstructorPhotoFactory.getRemoteInstance().addnew(photo);
            photo.setId(BOSUuid.read((String)pk.toString()));
            this.editData.setPhoto(photo);
            if (oldPhoto != null) {
                InstructorPhotoFactory.getRemoteInstance().delete((IObjectPK)oldPhoto);
            }
        } else if (this.editData.getPhoto() != null) {
            this.editData.setPhotDeleteFlag("true");
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getOrgUnit() != null) {
            HashSet<String> ids = new HashSet<String>();
            ids.add(this.editData.getOrgUnit().getId().toString());
            if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrgUnit"));
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
        this.pPanel.setOprtStat(OprtState.EDIT);
        this.txtNumber.setEnabled(false);
    }

    protected void setAutoNumberByOrg(String orgType) {
        CodingRuleHelper.setAutoNumber((EditUI)this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState(), "IsOuter");
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        super.actionAddOrg_actionPerformed(e);
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox((IUIObject)this);
        f7.setIsSingleSelect(false);
        Set orgUnitIDs = this.getOrgIds();
        f7.show();
        if (!f7.isCanceled() && (obj = f7.getData()) instanceof Object[]) {
            Object[] datas = (Object[])obj;
            IRow row = null;
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            for (int i = 0; i < datas.length; ++i) {
                adminOrgUnitInfo = (AdminOrgUnitInfo)datas[i];
                if (orgUnitIDs != null && orgUnitIDs.contains(adminOrgUnitInfo.getId().toString())) continue;
                row = this.kdtRange.addRow();
                row.getCell("AdminOrgUnit").setValue((Object)adminOrgUnitInfo);
                row.getCell("AdminOrgUnitNumber").setValue((Object)adminOrgUnitInfo.getNumber());
            }
        }
    }

    private Set getOrgIds() {
        HashSet<String> orgIds = new HashSet<String>();
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        for (int rowIndex = 0; rowIndex < this.kdtRange.getRowCount(); ++rowIndex) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.kdtRange.getRow(rowIndex).getCell("AdminOrgUnit").getValue();
            orgIds.add(adminOrgUnitInfo.getId().toString());
        }
        return orgIds;
    }

    public void actionDelOrg_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine(this.kdtRange);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getOrgUnit() != null) {
            HashSet<String> ids = new HashSet<String>();
            ids.add(this.editData.getOrgUnit().getId().toString());
            if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrgUnit"));
                return;
            }
        }
        super.actionRemove_actionPerformed(e);
    }
}

