/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.ITrainInstructor;
import com.kingdee.eas.hr.train.TrainFacadeFactory;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainOuterInstructorListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainOuterInstructorEditUI;
import com.kingdee.eas.hr.train.client.TrainOuterInstructorListFilterUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class TrainOuterInstructorListUI
extends AbstractTrainOuterInstructorListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainOuterInstructorListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private boolean isShare = false;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        try {
            this.isShare = TrainUtils.getParamValueByNumber("hr_train_003");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        super.onLoad();
        this.setButtonsState();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                TrainOuterInstructorListUI.this.setButtonsState();
            }
        });
    }

    protected String getEditUIName() {
        return TrainOuterInstructorEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainInstructorFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainInstructorInfo objectValue = new TrainInstructorInfo();
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnSetDisnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuSetEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuDisEnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnQuery.setEnabled(true);
        this.tblMain.setColumnMoveable(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkOuter(null)) {
            return;
        }
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)true));
        if (this.getBizInterface().exists(fi)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"can_not_modify_enabled_data"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String notRemove = "true";
        if (!this.checkOuter(notRemove)) {
            return;
        }
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<String> ids = new HashSet<String>();
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(rowNumber[i]);
            if (row == null || row.getCell("id").getValue() == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)true));
            if (this.getBizInterface().exists(fi)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"can_not_modify_enabled_data"));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSetDisnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setInstructorEnabled(false);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkOuter(null)) {
            return;
        }
        this.checkSelected();
        this.setInstructorEnabled(false);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkOuter(null)) {
            return;
        }
        this.checkSelected();
        this.setInstructorEnabled(true);
    }

    public void actionSetEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setInstructorEnabled(true);
    }

    private void setInstructorEnabled(boolean flag) throws EASBizException, BOSException, Exception {
        int[] indexs = TrainHelper.getSelectedRows(this.tblMain);
        ArrayList<String> instructorIdList = new ArrayList<String>();
        int size = indexs.length;
        for (int i = 0; i < size; ++i) {
            String instructorId = this.tblMain.getRow(indexs[i]).getCell("id").getValue().toString();
            instructorIdList.add(instructorId);
        }
        if (((ITrainInstructor)this.getBizInterface()).setEnabled(instructorIdList, flag)) {
            this.tblMain.removeRows();
        }
        this.selectFirstRow();
        this.setButtonsState();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        try {
            filter = TrainUtils.getTrianInstructorFilter(this.isShare, true, "list");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return filter;
    }

    public KDPanel getFilterUI() {
        try {
            return new TrainOuterInstructorListFilterUI();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.addUserPanel(this.getFilterUI());
        return queryDlg;
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setButtonsState();
    }

    private void setButtonsState() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.tblMain);
        if (curIndex < 0) {
            return;
        }
        Boolean state = (Boolean)this.tblMain.getRow(curIndex).getCell("IsEnable").getValue();
        if (Boolean.TRUE.equals(state)) {
            this.actionSetEnable.setEnabled(false);
            this.actionSetDisnable.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
            this.actionCancel.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else {
            this.actionSetEnable.setEnabled(true);
            this.actionSetDisnable.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(false);
            this.actionEdit.setEnabled(true);
        }
        if (this.canRemove()) {
            this.actionRemove.setEnabled(true);
        } else {
            this.actionRemove.setEnabled(false);
        }
    }

    private boolean canRemove() {
        int[] rowNumber = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        boolean canRemove = true;
        int j = rowNumber.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(rowNumber[i]);
            Boolean flag = (Boolean)row.getCell("IsEnable").getValue();
            if (flag == null || !flag.booleanValue()) continue;
            canRemove = false;
            break;
        }
        return canRemove;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    private boolean checkOuter(String notRemove) throws EASBizException, BOSException {
        List rowList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        HashSet<Object> ids = new HashSet<Object>();
        for (int i = 0; i < rowList.size(); ++i) {
            row = this.tblMain.getRow(Integer.parseInt(rowList.get(i).toString()));
            if (row.getCell("adminOrgUnit.id") == null || row.getCell("adminOrgUnit.id").getValue() == null) continue;
            ids.add(row.getCell("adminOrgUnit.id").getValue());
        }
        if (notRemove == null) {
            if (!TrainFacadeFactory.getRemoteInstance().isInAdminRange(ids)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrgUnit"));
                return false;
            }
        } else if (!TrainFacadeFactory.getRemoteInstance().isIncludeRange_Modify(ids)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"notCurrentOrgUnit"));
            return false;
        }
        return true;
    }
}

