/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.hr.train.SysCateFactory;
import com.kingdee.eas.hr.train.SysCateInfo;
import com.kingdee.eas.hr.train.SysCateJobEntryCollection;
import com.kingdee.eas.hr.train.SysCateJobGradeEntryCollection;
import com.kingdee.eas.hr.train.SysCatePostionEntryCollection;
import com.kingdee.eas.hr.train.SysCateTechPostEntryCollection;
import com.kingdee.eas.hr.train.client.AbstractTrainPersonF7ListUI;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TrainPersonF7ListUI
extends AbstractTrainPersonF7ListUI {
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    protected ITreeBuilder treeBuilder;
    private TreeSelectionListener treeSelectionListener;
    private HashSet selectedIDset = new HashSet();
    private static final String invalidID = "%illegal%";
    private boolean cancel = true;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblSelected.checkParsed();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        JButton btnAddLine = this.contSelected.add((Action)((Object)this.actionAddLine));
        btnAddLine.setText(EASResource.getString((String)RES, (String)"addLine"));
        JButton btnRemoveLine = this.contSelected.add((Action)((Object)this.actionRemoveLine));
        btnRemoveLine.setText(EASResource.getString((String)RES, (String)"removeLine"));
        JButton btnAddAll = this.contSelected.add((Action)((Object)this.actionAddAll));
        btnAddAll.setText(EASResource.getString((String)RES, (String)"addAll"));
        JButton btnRemoveAll = this.contSelected.add((Action)((Object)this.actionRemoveAll));
        btnRemoveAll.setText(EASResource.getString((String)RES, (String)"removeAll"));
        this.initTree();
    }

    private void initTree() throws Exception {
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        if (listeners.length >= 1) {
            this.treeSelectionListener = listeners[0];
        }
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
    }

    private void updateData() throws Exception {
        SorterItemCollection sorter = this.mainQuery.getSorter();
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        SorterItemInfo sorterInfo = null;
        int n = sorter.size();
        for (int i = 0; i < n; ++i) {
            sorterInfo = sorter.get(i);
            if ("jobGrade.name".equals(sorterInfo.getPropertyName())) {
                SorterItemInfo item = new SorterItemInfo("jobGrade.name");
                item.setSortType(sorterInfo.getSortType());
                this.mainQuery.getSorter().add(item);
                continue;
            }
            this.mainQuery.getSorter().add(sorter.get(i));
        }
        this.execQuery();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        if (this.treeMain.getLastSelectedPathComponent() == null) {
            return null;
        }
        Object obj = ((KDTreeNode)this.treeMain.getLastSelectedPathComponent()).getUserObject();
        if (obj == null || !(obj instanceof SysCateInfo)) {
            return null;
        }
        String id = ((SysCateInfo)obj).getId().toString();
        return new ObjectUuidPK(id);
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.updateData();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return SysCateFactory.getRemoteInstance();
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected int getTreeInitialLevel() {
        return 3;
    }

    protected String getRootName() {
        return EASResource.getString((String)RES, (String)"trainSysCate");
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    protected int getTreeExpandLevel() {
        return 3;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)Boolean.TRUE, CompareType.EQUALS));
        return filter;
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.removeRow(i);
            this.tblSelected.addRow(0, row);
            this.selectedIDset.add(row.getCell("id").getValue().toString());
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = TrainHelper.getSelectedRows(this.tblMain);
        if (selected.length == 0 || selected[0] == -1) {
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.removeRow(selected[i]);
            this.tblSelected.addRow(0, row);
            this.selectedIDset.add(row.getCell("id").getValue().toString());
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionAddLine_actionPerformed(null);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectedIDset.clear();
        this.tblSelected.removeRows();
        this.updateData();
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = TrainHelper.getSelectedRows(this.tblSelected);
        if (selected.length == 0 || selected[0] == -1) {
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblSelected.removeRow(selected[i]);
            this.selectedIDset.remove(row.getCell("id").getValue().toString());
        }
        this.updateData();
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionRemoveLine_actionPerformed(null);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        SysCateJobGradeEntryCollection jobGradeColl;
        SysCateTechPostEntryCollection tpColl;
        SysCatePostionEntryCollection posColl;
        FilterInfo filter = new FilterInfo();
        IObjectPK id = this.getSelectedTreeKeyValue();
        if (id == null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)invalidID));
            return filter;
        }
        boolean flag = false;
        if (this.selectedIDset.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.selectedIDset, CompareType.NOTINCLUDE));
            flag = true;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("JobEntry.id"));
        sic.add(new SelectorItemInfo("JobEntry.Job.id"));
        sic.add(new SelectorItemInfo("PostionEntry.id"));
        sic.add(new SelectorItemInfo("PostionEntry.Position.id"));
        sic.add(new SelectorItemInfo("TechPostEntry.id"));
        sic.add(new SelectorItemInfo("TechPostEntry.TechPost.id"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        sic.add(new SelectorItemInfo("jobGrade.jobGrade.id"));
        SysCateInfo info = null;
        try {
            info = (SysCateInfo)SysCateFactory.getRemoteInstance().getValue(id, sic);
        }
        catch (Exception ex) {
            super.handleException(ex);
            return filter;
        }
        SysCateJobEntryCollection jobColl = info.getJobEntry();
        if (jobColl.size() > 0) {
            HashSet<String> jobSet = new HashSet<String>();
            int n = jobColl.size();
            for (int i = 0; i < n; ++i) {
                jobSet.add(jobColl.get(i).getJob().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("Job.id", jobSet, CompareType.INCLUDE));
        }
        if ((posColl = info.getPostionEntry()).size() > 0) {
            HashSet<String> posSet = new HashSet<String>();
            int n = posColl.size();
            for (int i = 0; i < n; ++i) {
                posSet.add(posColl.get(i).getPosition().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("Position.id", posSet, CompareType.INCLUDE));
        }
        if ((tpColl = info.getTechPostEntry()).size() > 0) {
            HashSet<String> tpSet = new HashSet<String>();
            int n = tpColl.size();
            for (int i = 0; i < n; ++i) {
                tpSet.add(tpColl.get(i).getTechPost().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("TechnialPost.id", tpSet, CompareType.INCLUDE));
        }
        if ((jobGradeColl = info.getJobGrade()).size() > 0) {
            HashSet<String> jgSet = new HashSet<String>();
            int n = jobGradeColl.size();
            for (int i = 0; i < n; ++i) {
                jgSet.add(jobGradeColl.get(i).getJobGrade().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("jobGrade.id", jgSet, CompareType.INCLUDE));
        }
        int count = filter.getFilterItems().size();
        if (flag) {
            if (count == 3) {
                filter.setMaskString("#0 and (#1 or #2)");
            } else if (count == 4) {
                filter.setMaskString("#0 and (#1 or #2 or #3)");
            } else if (count == 5) {
                filter.setMaskString("#0 and (#1 or #2 or #3 or #4)");
            }
        } else if (count == 2) {
            filter.setMaskString("#0 or #1");
        } else if (count == 3) {
            filter.setMaskString("#0 or #1 or #2");
        } else if (count == 4) {
            filter.setMaskString("#0 or #1 or #2 or #3");
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)invalidID));
        } else {
            try {
                filter.mergeFilter(TrainUtils.getHROrgUnitAndOrgRangeFilter("hrOrgUnit.id", "AdminOrgUnit.id"), "AND");
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
        return filter;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void actionConfirmOP_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblSelected.getRowCount() == 0) {
            return;
        }
        this.cancel = false;
        this.actionExitCurrent_actionPerformed(null);
    }

    public Object getData() {
        int count = this.tblSelected.getRowCount();
        if (count == 0) {
            return null;
        }
        Object[] data = new Object[count];
        int idCol = this.tblSelected.getColumnIndex("id");
        int numberCol = this.tblSelected.getColumnIndex("number");
        int nameCol = this.tblSelected.getColumnIndex("name");
        Object obj = null;
        PersonInfo info = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            info = new PersonInfo();
            row = this.tblSelected.getRow(i);
            obj = row.getCell(idCol).getValue();
            info.setId(BOSUuid.read((String)obj.toString()));
            obj = row.getCell(numberCol).getValue();
            info.setNumber((String)obj);
            obj = row.getCell(nameCol).getValue();
            info.setName((String)obj);
            data[i] = info;
        }
        return data;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }
}

