/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.ITrainPlanCalendarFacade;
import com.kingdee.eas.hr.train.TrainPlanCalendarFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanActivityCarlendarListUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainPlanCourseListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class TrainPlanActivityCarlendarListUI
extends AbstractTrainPlanActivityCarlendarListUI {
    private String[] columnName = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "days", "Count"};
    private HashMap rowMap = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("orgUnitFullName").getStyleAttributes().setWrapText(false);
        Calendar calendar = Calendar.getInstance();
        int thisYear = calendar.get(1);
        SpinnerNumberModel model = new SpinnerNumberModel(thisYear, 2000, 3000, 1);
        this.spinYear.setModel((SpinnerModel)model);
        this.spinYear.setValue((Object)thisYear);
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        TrainUtils.initOrgUnit(this.prmtOrgUnit, true, (IUIObject)this);
        AdminOrgUnitInfo adminOrgUnitInfo = TrainClientUtil.getCurrentAdminOrgUnit();
        if (adminOrgUnitInfo != null) {
            this.prmtOrgUnit.setValue((Object)new Object[]{adminOrgUnitInfo});
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDMenuItem1.setEnabled(true);
        this.kDMenuItem1.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnPlanCourses.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnPlanCourses.setEnabled(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        try {
            filter = TrainUtils.getHROrgUnitFilter("hrOrgUnit.id");
            filter.getFilterItems().add(new FilterItemInfo("trainPlanCategory.category", (Object)10));
            HashSet<Integer> auditedStates = new HashSet<Integer>();
            auditedStates.add(40);
            auditedStates.add(50);
            filter.getFilterItems().add(new FilterItemInfo("trainPlan.AuditState", auditedStates, CompareType.INCLUDE));
            FilterInfo filterYear = new FilterInfo();
            filterYear.getFilterItems().add(new FilterItemInfo("trainyear", (Object)this.spinYear.getIntegerVlaue()));
            Object[] objects = (Object[])this.prmtOrgUnit.getValue();
            if (objects != null && objects.length > 0) {
                HashSet<String> ids = new HashSet<String>();
                for (int i = 0; i < objects.length; ++i) {
                    ids.add(((AdminOrgUnitInfo)objects[i]).getId().toString());
                }
                filterYear.getFilterItems().add(new FilterItemInfo("OrgUnit.id", ids, CompareType.INCLUDE));
            } else {
                filterYear.getFilterItems().add(new FilterItemInfo("OrgUnit.id", null, CompareType.EQUALS));
            }
            filter.mergeFilter(filterYear, "and");
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return filter;
    }

    protected void spinYear_stateChanged(ChangeEvent e) throws Exception {
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.execQuery();
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.execQuery();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        if (e.getClickCount() != 2 && ((colIndex = e.getColIndex()) == this.tblMain.getColumnIndex("Name") || colIndex == this.tblMain.getColumnIndex("orgUnitName")) && e.getType() == 0) {
            super.tblMain_tableClicked(e);
            this.fillData();
        }
    }

    private void fillData() {
        ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

            public void run() throws Exception {
                TrainPlanActivityCarlendarListUI.this.runFillData();
            }
        };
        ProgressManager pm = new ProgressManager((CoreUI)this);
        pm.launchProcess(process, (CoreUIObject)this);
    }

    private void runFillData() {
        HashSet<String> idSet = new HashSet<String>();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.tblMain.getRow(i).getCell("id").getValue();
            if (obj == null) continue;
            idSet.add(obj.toString());
        }
        ITrainPlanCalendarFacade facade = null;
        HashMap map = null;
        try {
            facade = TrainPlanCalendarFacadeFactory.getRemoteInstance();
            int year = this.spinYear.getIntegerVlaue();
            map = facade.getTrainPlanCalendar(idSet, year);
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        if (map == null || map.size() == 0) {
            return;
        }
        String id = null;
        HashMap subMap = null;
        int idIndex = this.tblMain.getColumnIndex("id");
        this.rowMap = new HashMap();
        int n2 = this.tblMain.getRowCount();
        for (int i = 0; i < n2; ++i) {
            this.rowMap.put(this.tblMain.getRow(i).getCell(idIndex).getValue().toString(), i);
        }
        for (Map.Entry entry : map.entrySet()) {
            id = (String)entry.getKey();
            subMap = (HashMap)map.get(id);
            if (subMap == null) continue;
            this.fillTable(id, subMap);
        }
    }

    private void fillTable(String id, HashMap map) {
        IRow row = null;
        Object value = null;
        int maxRows = 0;
        Integer index = (Integer)this.rowMap.get(id);
        if (index != null) {
            row = this.tblMain.getRow(index.intValue());
        }
        if (row == null) {
            return;
        }
        maxRows = 0;
        for (int j = 0; j < this.columnName.length; ++j) {
            StringTokenizer tk;
            value = map.get(this.columnName[j]);
            if (value != null && (tk = new StringTokenizer(value.toString(), "\n")).countTokens() > maxRows) {
                maxRows = tk.countTokens();
            }
            row.getCell(this.columnName[j]).setValue(value);
        }
        if (maxRows > 1) {
            row.setHeight(maxRows * 19);
        }
    }

    protected void execQuery() {
        super.execQuery();
        this.fillData();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.fillData();
        this.tblMain.getColumn("Name").setWidth(150);
        this.tblMain.getColumn("days").setWidth(50);
        for (int i = 0; i < this.columnName.length - 2; ++i) {
            this.tblMain.getColumn(this.columnName[i]).setWidth(140);
        }
    }

    public void actionPlanCourses_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String trainActivityId = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"trainActivity", (Object)trainActivityId);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainPlanCourseListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }
}

