/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanActivityReportListUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainPlanActivityReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainPlanCourseReportListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainPlanActivityReportListUI
extends AbstractTrainPlanActivityReportListUI {
    private static Logger logger = Logger.getLogger(TrainPlanActivityReportListUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String TO = " " + EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSysResource", (String)"to") + " ";
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.setColumnGroup();
        super.onLoad();
        this.btnTrainCourse.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
        this.menuItemTrainCourse.setEnabled(true);
        this.menuItemTrainCourse.setIcon(EASResource.getIcon((String)"imgTbtn_listfile"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainPlanTrainPlanActivityFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            return TrainUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "OrgUnit.id");
        }
        catch (Exception ex) {
            super.handleException(ex);
            return null;
        }
    }

    private KDPanel getUserPanel() {
        TrainPlanActivityReportFilterUI ret = null;
        try {
            ret = new TrainPlanActivityReportFilterUI();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return ret;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog ret = super.initCommonQueryDialog();
        KDPanel userPanel = this.getUserPanel();
        if (userPanel != null) {
            ret.addUserPanel(userPanel);
        }
        ret.setShowSorter(false);
        return ret;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String aboutDate = rowSet.getString("trainPlan.aboutDate");
                if (!StringUtils.isEmpty((String)aboutDate)) {
                    rowSet.updateString("trainPlan.description", aboutDate);
                    continue;
                }
                Date planDate = rowSet.getDate("PlanDate");
                Date endDate = rowSet.getDate("endDate");
                if (planDate == null || endDate == null) continue;
                rowSet.updateString("trainPlan.description", formater.format(planDate) + TO + formater.format(endDate));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    private void setColumnGroup() {
        this.tblMain.getColumn("trainPlan.AuditState").setGroup(true);
        this.tblMain.getColumn("trainPlan.number").setGroup(true);
        this.tblMain.getColumn("trainPlan.name").setGroup(true);
        this.tblMain.getColumn("trainPlan.TrainPlanType").setGroup(true);
        this.tblMain.getColumn("planDate").setGroup(true);
    }

    public void actionCourse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedTrainPlanID();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"hr_train_plan", (Object)id);
        uiContext.put((Object)"hide", (Object)"Y");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainPlanCourseReportListUI.class.getName(), (Map)uiContext, null, this.oprtState);
        uiWindow.show();
    }

    protected String getSelectedTrainPlanID() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("trainPlan.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        return TrainClientUtil.prepareDefaultSolutionParam(super.prepareInit(), this, this.mainQueryPK);
    }
}

