/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.client.f7.F7ParamOnRegister;
import com.kingdee.eas.base.core.hr.client.f7.IF7ParamFromUI;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.f7.DefaultF7PramFromUI;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.train.ITrainPlanParticipantScope;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainExePeriodCollection;
import com.kingdee.eas.hr.train.TrainExePeriodInfo;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.TrainPlanCourseCollection;
import com.kingdee.eas.hr.train.TrainPlanCourseInfo;
import com.kingdee.eas.hr.train.TrainPlanFactory;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.TrainPlanMessageCollection;
import com.kingdee.eas.hr.train.TrainPlanMessageFactory;
import com.kingdee.eas.hr.train.TrainPlanMessageInfo;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeCollection;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeFactory;
import com.kingdee.eas.hr.train.TrainPlanParticipantScopeInfo;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityCollection;
import com.kingdee.eas.hr.train.TrainPlanTrainPlanActivityInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanParticipantScopeListUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainActSendEmailInfoUI;
import com.kingdee.eas.hr.train.client.TrainActivityExeEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;

public class TrainPlanParticipantScopeListUI
extends AbstractTrainPlanParticipantScopeListUI {
    private static final int BLANK_LENGTH = 4;
    private SelectorItemCollection selector = null;
    private TrainPlanInfo curTrainPlanInfo = null;
    private TrainPlanMessageInfo messageInfo = null;
    private String trainPlanId;
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private final PersonInfo loginPerson = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    private static final String resource = "com.kingdee.eas.hr.train.TrainHolidayResource";
    private static final String COMMA = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"Comma");
    private static final String COLON = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"COLON");
    private static final String SPLIT = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"SPLIT");
    private static final String END = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainActivityResource", (String)"END");
    private static final String TRAINPLANMESSAGEFOR = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANMESSAGEFOR");
    private static final String TRAINPLANTRAIN = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANTRAIN");
    private static final String TRAINOWNER = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINOWNER");
    private static final String TRAINPLANMETHOD = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANMETHOD");
    private static final String TRAINPLANNEEDEXAM = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANNEEDEXAM");
    private static final String TRAINPLANEAXMMETHOD = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANEAXMMETHOD");
    private static final String TRAINPLANNOEAXM = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANNOEAXM");
    private static final String TRAINPLANPASSSCORE = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANPASSSCORE");
    private static final String TRAINPLANPASSGET = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANPASSGET");
    private static final String TRAINPLANTARGET = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANTARGET");
    private static final String TRAINPLANORG = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINPLANORG");
    private static final String TRAINADDRESS = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINADDRESS");
    private static final String TRAINEXAMDATE = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINEXAMDATE");
    private static final String TRAINCOURSEES = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINCOURSEES");
    private static final String TRAINCOURSETYPE = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINCOURSETYPE");
    private static final String TRAINCOURSEKIND = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINCOURSEKIND");
    private static final String TRAINCOURSEHOURS = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINCOURSEHOURS");
    private static final String TRAINCOURSEMETHOD = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAINCOURSEMETHOD");
    private static final String TRAININSTRUCTER = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"TRAININSTRUCTER");
    private static final String addPerson = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"ADDTRAINPUBLISHPERSON");
    private static final String delPerson = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"DELTRAINPUBLISHPERSON");
    private static final String PLANPERIOD = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"PLANPERIOD");
    private static final String PERIOD_DATE = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"PERIOD_DATE");
    private static final String PERIOD_INVIGILATOR = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"PERIOD_INVIGILATOR");
    private static final String PERIOD_EXAMADDRESS = EASResource.getString((String)"com.kingdee.eas.hr.train.TrainHolidayResource", (String)"PERIOD_EXAMADDRESS");

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.initWorkButton();
        this.initTrainPlanF7();
        this.prmtSendPerson.setText(this.loginPerson.getName());
        this.initPlanInfo();
    }

    protected void initWorkButton() {
        JButton btnAddPerson = this.contPerson.add((Action)((Object)this.actionAddPerson));
        JButton btnDelPerson = this.contPerson.add((Action)((Object)this.actionDelPerson));
        btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        btnAddPerson.setEnabled(true);
        btnDelPerson.setEnabled(true);
        this.btnPublish.setEnabled(true);
        btnAddPerson.setToolTipText(addPerson);
        btnDelPerson.setToolTipText(delPerson);
    }

    private void initTrainPlanF7() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)String.valueOf(40), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)String.valueOf(50), CompareType.EQUALS));
        filterInfo.setMaskString("(#0 or #1)");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        this.prmtTrainPlan.setEntityViewInfo(viewInfo);
        this.prmtTrainPlan.setSelectorCollection(this.getSelector());
    }

    private void initPlanInfo() throws Exception {
        String trainPlanId = (String)this.getUIContext().get("ID");
        SelectorItemCollection sic = this.getSelector();
        this.curTrainPlanInfo = TrainPlanFactory.getRemoteInstance().getTrainPlanInfo((IObjectPK)new ObjectUuidPK(trainPlanId), sic);
        if (this.curTrainPlanInfo != null) {
            this.prmtTrainPlan.setValue((Object)this.curTrainPlanInfo);
            this.prmtOrg.setValue((Object)this.curTrainPlanInfo.getOrgUnit());
        }
    }

    private SelectorItemCollection getSelector() {
        if (this.selector == null) {
            this.selector = new SelectorItemCollection();
            this.selector.add(new SelectorItemInfo("*"));
            this.selector.add(new SelectorItemInfo("OrgUnit.id"));
            this.selector.add(new SelectorItemInfo("OrgUnit.name"));
            this.selector.add(new SelectorItemInfo("OrgUnit.number"));
            this.selector.add(new SelectorItemInfo("planCategory.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.*"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.OrgUnit.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.type.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.trainMethod.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.assessMethod.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.trainItem.treeid.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.*"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.TrainCourse.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.TrainingMethod.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.TrainCourse.treeid.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.TrainCourse.CourseKind.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.chanelE1.Instructor.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.chanelE1.Instructor.IsOuter"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.TrainCourse.chanelE1.Instructor.Employee.name"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.trainExePeriods.*"));
            this.selector.add(new SelectorItemInfo("TrainPlanActivity.trainExePeriods.invigilator.name"));
        }
        return this.selector;
    }

    private void loadData() throws Exception {
        this.tblMain.removeRows();
        if (this.curTrainPlanInfo == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainPlan.id", (Object)this.curTrainPlanInfo.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString()));
        IRowSet rowSet = TrainActivityHelper.getRowSet("TrainPlanParticipantScopeQuery", fi);
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        while (rowSet.next()) {
            map = new HashMap<String, String>();
            map.put("id", rowSet.getString("id"));
            map.put("personId", rowSet.getString("person.id"));
            map.put("number", rowSet.getString("person.number"));
            map.put("name", rowSet.getString("person.name"));
            map.put("position", rowSet.getString("position.name"));
            map.put("orgUnit", rowSet.getString("orgUnit.name"));
            map.put("email", rowSet.getString("person.email"));
            list.add(map);
        }
        this.fillTable(list);
        this.initMessage();
    }

    private FilterInfo getLoadDataFilterInfo() {
        if (this.trainPlanId == null || this.trainPlanId.length() <= 0) {
            this.trainPlanId = this.getUIContext().get("ID").toString();
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainPlan.id", (Object)this.trainPlanId));
        fi.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString()));
        return fi;
    }

    private void fillTable(List list) throws Exception {
        TrainPlanParticipantScopeInfo participantScopeInfo = null;
        PersonInfo personInfo = null;
        Map map = null;
        IRow row = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (Map)list.get(i);
            if (this.checkIfRefered((String)map.get("personId"))) continue;
            row = this.tblMain.addRow();
            row.getCell("id").setValue(map.get("id"));
            row.getCell("person.id").setValue(map.get("personId"));
            row.getCell("person.number").setValue(map.get("number"));
            row.getCell("person.name").setValue(map.get("name"));
            row.getCell("position").setValue(map.get("position"));
            row.getCell("orgUnit.name").setValue(map.get("orgUnit"));
            row.getCell("person.email").setValue(map.get("email"));
            participantScopeInfo = new TrainPlanParticipantScopeInfo();
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)((String)map.get("personId"))));
            personInfo.setEmail((String)map.get("email"));
            participantScopeInfo.setPerson(personInfo);
            participantScopeInfo.setTrainPlan(this.curTrainPlanInfo);
            participantScopeInfo.setSendPerson(this.loginPerson);
            row.setUserObject((Object)participantScopeInfo);
        }
    }

    private void initMessage() throws Exception {
        if (this.curTrainPlanInfo == null) {
            this.txtTitle.setText(null);
            this.txtContent.setText(null);
            this.pkPublishDate.setValue(null);
            return;
        }
        this.messageInfo = this.getTrainPlanMessage();
        if (this.messageInfo == null) {
            this.messageInfo = this.createPlanMessageInfo();
        }
        this.txtTitle.setText(this.messageInfo.getTitle());
        this.txtContent.setText(this.messageInfo.getContent());
        this.pkPublishDate.setValue((Object)this.messageInfo.getLastUpdateTime());
    }

    private TrainPlanMessageInfo getTrainPlanMessage() throws BOSException {
        TrainPlanMessageCollection collection = TrainPlanMessageFactory.getRemoteInstance().getTrainPlanMessageCollection(this.getTrainPlanMessageEntityView());
        TrainPlanMessageInfo info = null;
        if (collection != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    private EntityViewInfo getTrainPlanMessageEntityView() {
        if (this.trainPlanId == null || this.trainPlanId.length() <= 0) {
            this.trainPlanId = this.getUIContext().get("ID").toString();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainPlan.id", (Object)this.trainPlanId));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString()));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("sendPerson.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("sendPerson.name"));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("LastUpDateTime");
        sorter.add(item);
        return viewInfo;
    }

    private TrainPlanMessageInfo createPlanMessageInfo() throws BOSException, EASBizException {
        String title = EASResource.getString((String)resourcePath, (String)"TrainPlanNotifyTitle");
        title = title.replaceAll("#0", this.curTrainPlanInfo.getName());
        TrainPlanMessageInfo trainPlanMessageInfo = new TrainPlanMessageInfo();
        trainPlanMessageInfo.setTitle(title);
        String body = EASResource.getString((String)resourcePath, (String)"TrainPlanMessageBody");
        String newLine = System.getProperty("line.separator");
        body = body.replaceAll("#00", this.curTrainPlanInfo.getName());
        body = body.replaceAll("#01", this.curTrainPlanInfo.getPlanCategory() == null ? "" : this.curTrainPlanInfo.getPlanCategory().getName());
        body = body.replaceAll("#02", DateTimeUtils.format((Date)this.curTrainPlanInfo.getPlanDate(), (String)"yyyy-MM-dd") + " ---- " + DateTimeUtils.format((Date)this.curTrainPlanInfo.getEndDate(), (String)"yyyy-MM-dd"));
        try {
            body = body.replaceAll("#03", this.getPlanActivityContent(this.curTrainPlanInfo));
        }
        catch (Exception e) {
            super.handleException(e);
        }
        body = body.replaceAll("@", newLine);
        trainPlanMessageInfo.setContent(body);
        trainPlanMessageInfo.setTrainPlan(this.curTrainPlanInfo);
        trainPlanMessageInfo.setSendPerson(this.loginPerson);
        return trainPlanMessageInfo;
    }

    private String getPlanActivityContent(TrainPlanInfo planInfo) throws Exception {
        StringBuffer result = new StringBuffer();
        TrainPlanTrainPlanActivityCollection planActivityCollection = planInfo.getTrainPlanActivity();
        if (planActivityCollection != null && planActivityCollection.size() > 0) {
            result.append("@");
            TrainPlanTrainPlanActivityInfo planActivityInfo = null;
            int size = planActivityCollection.size();
            for (int i = 0; i < size; ++i) {
                int level = 0;
                planActivityInfo = planActivityCollection.get(i);
                if (planActivityInfo.getName() == null) continue;
                this.appendBlank(result, level++);
                result.append(String.valueOf(i + 1));
                result.append(SPLIT);
                result.append(planActivityInfo.getName());
                result.append(COLON);
                if (planActivityInfo.getTrainItem() != null && planActivityInfo.getTrainItem().getTreeid() != null) {
                    result.append(TRAINPLANMESSAGEFOR);
                    result.append(planActivityInfo.getTrainItem().getTreeid().getName());
                    result.append(TRAINPLANTRAIN);
                    result.append(COMMA);
                }
                if (planActivityInfo.getType() != null) {
                    result.append(TRAINOWNER);
                    result.append(planActivityInfo.getType().getName());
                    result.append(END);
                }
                if (planActivityInfo.getTrainMethod() != null) {
                    result.append(TRAINPLANMETHOD);
                    result.append(planActivityInfo.getTrainMethod().getName());
                    result.append(COMMA);
                }
                if (planActivityInfo.isNeedExam()) {
                    result.append(TRAINPLANNEEDEXAM);
                } else {
                    result.append(TRAINPLANNOEAXM);
                }
                result.append(COMMA);
                if (planActivityInfo.getAssessMethod() != null) {
                    result.append(TRAINPLANEAXMMETHOD);
                    result.append(planActivityInfo.getAssessMethod().getName());
                    result.append(COMMA);
                }
                if (planActivityInfo.getPassStand() != null) {
                    result.append(TRAINPLANPASSSCORE);
                    result.append(planActivityInfo.getPassStand().setScale(2).toString());
                    result.append(END);
                }
                if (!TrainCommonUtils.isEmpty(planActivityInfo.getCertificateName())) {
                    result.append(TRAINPLANPASSGET);
                    result.append(planActivityInfo.getCertificateName());
                    result.append(END);
                }
                if (result.toString().endsWith(COMMA)) {
                    int index = result.toString().lastIndexOf(COMMA);
                    result = result.delete(index, result.length());
                    result.append(END);
                }
                result.append("@");
                if (!TrainCommonUtils.isEmpty(planActivityInfo.getTarget())) {
                    this.appendBlank(result, level);
                    result.append(TRAINPLANTARGET);
                    result.append(planActivityInfo.getTarget());
                    result.append("@");
                }
                if (planActivityInfo.getOrgUnit() != null) {
                    this.appendBlank(result, level);
                    result.append(TRAINPLANORG);
                    result.append(planActivityInfo.getOrgUnit().getName());
                    result.append("@");
                }
                if (!TrainCommonUtils.isEmpty(planActivityInfo.getTrainAddress())) {
                    this.appendBlank(result, level);
                    result.append(TRAINADDRESS);
                    result.append(planActivityInfo.getTrainAddress());
                    result.append("@");
                }
                if (planActivityInfo.getExamTime() != null) {
                    this.appendBlank(result, level);
                    result.append(TRAINEXAMDATE);
                    result.append(DateTimeUtils.format((Date)planActivityInfo.getExamTime(), (String)"yyyy-MM-dd"));
                    result.append("@");
                }
                this.appendCourseContent(result, planActivityInfo, level);
                this.appendExePeriodsContent(result, planActivityInfo, level);
            }
        }
        return result.toString();
    }

    private StringBuffer appendBlank(StringBuffer sb, int level) {
        for (int i = 0; i < level; ++i) {
            for (int j = 0; j < 4; ++j) {
                sb.append(" ");
            }
        }
        return sb;
    }

    private void appendCourseContent(StringBuffer result, TrainPlanTrainPlanActivityInfo planActivityInfo, int level) {
        TrainPlanCourseCollection planCourseCollection = planActivityInfo.getTrainCourse();
        if (planCourseCollection != null && planCourseCollection.size() > 0) {
            this.appendBlank(result, level++);
            result.append(TRAINCOURSEES);
            DecimalFormat formater = new DecimalFormat("0.##");
            TrainInstructorInfo instructorInfo = null;
            TrainPlanCourseInfo planCourseInfo = null;
            int size = planCourseCollection.size();
            for (int i = 0; i < size; ++i) {
                planCourseInfo = planCourseCollection.get(i);
                if (planCourseInfo.getTrainCourse() == null) continue;
                this.appendBlank(result, level);
                result.append(planCourseInfo.getTrainCourse().getName());
                if (planCourseInfo.getTrainCourse().getTreeid() != null) {
                    result.append(COMMA);
                    result.append(TRAINCOURSETYPE);
                    result.append(planCourseInfo.getTrainCourse().getTreeid().getName());
                }
                if (planCourseInfo.getTrainCourse().getCourseKind() != null) {
                    result.append(COMMA);
                    result.append(TRAINCOURSEKIND);
                    result.append(planCourseInfo.getTrainCourse().getCourseKind().getName());
                }
                if (planCourseInfo.getLessonHour() != null) {
                    result.append(COMMA);
                    result.append(TRAINCOURSEHOURS);
                    result.append(formater.format(planCourseInfo.getLessonHour()));
                    if (planCourseInfo.getTimeUnit() != null) {
                        result.append(planCourseInfo.getTimeUnit().getAlias());
                    }
                }
                if (planCourseInfo.getTrainingMethod() != null) {
                    result.append(COMMA);
                    result.append(TRAINCOURSEMETHOD);
                    result.append(planCourseInfo.getTrainingMethod().getName());
                }
                if (planCourseInfo.getChanelE1() != null && planCourseInfo.getChanelE1().getInstructor() != null) {
                    result.append(COMMA);
                    result.append(TRAININSTRUCTER);
                    instructorInfo = planCourseInfo.getChanelE1().getInstructor();
                    if (instructorInfo.isIsOuter()) {
                        result.append(instructorInfo.getName());
                    } else if (instructorInfo.getEmployee() != null) {
                        result.append(instructorInfo.getEmployee().getName());
                    }
                }
                result.append("@");
            }
        }
    }

    private void appendExePeriodsContent(StringBuffer result, TrainPlanTrainPlanActivityInfo planActivityInfo, int level) {
        TrainExePeriodCollection periodCollection = planActivityInfo.getTrainExePeriods();
        if (periodCollection != null && periodCollection.size() > 0) {
            TrainActivityExeEditUI.sortByStartDate(periodCollection);
            this.appendBlank(result, level++);
            result.append(PLANPERIOD);
            result.append("@");
            String startDate = null;
            String endDate = null;
            TrainExePeriodInfo periodInfo = null;
            int size = periodCollection.size();
            for (int i = 0; i < size; ++i) {
                periodInfo = periodCollection.get(i);
                if (TrainCommonUtils.isEmpty(periodInfo.getName())) continue;
                this.appendBlank(result, level);
                result.append(periodInfo.getName());
                if (periodInfo.getStartDate() != null && periodInfo.getEndDate() != null) {
                    result.append(COMMA);
                    startDate = DateTimeUtils.format((Date)periodInfo.getStartDate(), (String)"yyyy-MM-dd");
                    endDate = DateTimeUtils.format((Date)periodInfo.getEndDate(), (String)"yyyy-MM-dd");
                    result.append(MessageFormat.format(PERIOD_DATE, startDate, endDate));
                }
                if (periodInfo.getInvigilator() != null) {
                    result.append(COMMA);
                    result.append(PERIOD_INVIGILATOR);
                    result.append(periodInfo.getInvigilator().getName());
                }
                if (!TrainCommonUtils.isEmpty(periodInfo.getTrainAddress())) {
                    result.append(COMMA);
                    result.append(TRAINADDRESS);
                    result.append(periodInfo.getTrainAddress());
                }
                if (periodInfo.getExamTime() != null) {
                    result.append(COMMA);
                    result.append(TRAINEXAMDATE);
                    result.append(DateTimeUtils.format((Date)periodInfo.getExamTime(), (String)"yyyy-MM-dd"));
                }
                if (!TrainCommonUtils.isEmpty(periodInfo.getExamAddress())) {
                    result.append(COMMA);
                    result.append(PERIOD_EXAMADDRESS);
                    result.append(periodInfo.getExamAddress());
                }
                result.append("@");
            }
        }
    }

    private void verifyInput() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainPlan);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtTitle);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtContent);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.bindFields();
        IObjectPK pk = TrainPlanMessageFactory.getRemoteInstance().submit((CoreBaseInfo)this.messageInfo);
        this.messageInfo.setId(BOSUuid.read((String)pk.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Success"));
    }

    private void bindFields() throws EASBizException, BOSException {
        this.messageInfo.setTitle(this.txtTitle.getText());
        this.messageInfo.setContent(this.txtContent.getText());
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoPerson"));
            SysUtil.abort();
        }
        this.verifyInput();
        this.bindFields();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActSendEmailInfoUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        TrainActSendEmailInfoUI trainActSendEmailInfoUI = (TrainActSendEmailInfoUI)uiWindow.getUIObject();
        if (trainActSendEmailInfoUI.isSendMessage()) {
            boolean sendMail = trainActSendEmailInfoUI.isSendMail();
            if (sendMail) {
                this.verifyPersonMail();
            }
            this.executePublish(this.getScopeCollection(), sendMail);
        }
    }

    private void verifyPersonMail() {
        int badEmailCount = 0;
        StringBuffer badEmailName = new StringBuffer();
        HashSet<String> nameBuffer = new HashSet<String>();
        String email = null;
        IRow row = null;
        int rowSize = this.tblMain.getRowCount();
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("person.name").getValue() == null) {
                nameBuffer.add(String.valueOf(i + 1));
            }
            if (!StringUtils.isEmpty((String)(email = (String)row.getCell("person.email").getValue())) && email.indexOf("@") >= 0) continue;
            if (badEmailCount++ != 0) {
                badEmailName.append(",");
            }
            badEmailName.append(row.getCell("person.name").getValue().toString());
        }
        if (nameBuffer.size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resource, (String)"NAMEISUNLL"));
            SysUtil.abort();
        }
        if (badEmailCount > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(badEmailName);
            sb.append(EASResource.getString((String)resource, (String)"etc"));
            sb.append(badEmailCount);
            sb.append(EASResource.getString((String)resource, (String)"sendMailConfirm"));
            if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
                SysUtil.abort();
            }
        }
    }

    private TrainPlanParticipantScopeCollection getScopeCollection() {
        TrainPlanParticipantScopeCollection collection = new TrainPlanParticipantScopeCollection();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            collection.add((TrainPlanParticipantScopeInfo)this.tblMain.getRow(i).getUserObject());
        }
        return collection;
    }

    private void executePublish(final TrainPlanParticipantScopeCollection collection, final boolean sendMail) {
        TrainClientUtil.executeWithProcess((CoreUI)this, new IProgTask(){

            public Object exec() throws Exception {
                TrainPlanParticipantScopeListUI.this.runPublish(collection, sendMail);
                return "";
            }

            public void afterExec(Object result) throws Exception {
                TrainPlanParticipantScopeListUI.this.showSuccessMessage();
                TrainPlanParticipantScopeListUI.this.loadData();
            }
        });
    }

    private void runPublish(TrainPlanParticipantScopeCollection collection, boolean sendMail) throws BOSException, EASBizException {
        IObjectPK messagePK = TrainPlanFactory.getRemoteInstance().publish(this.messageInfo, collection, sendMail);
        this.messageInfo.setId(BOSUuid.read((String)messagePK.toString()));
    }

    private void showSuccessMessage() {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PublishSuccess"));
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        this.setF7Filter(pmt);
        pmt.setModal(true);
        pmt.showNoPositionPerson(true);
        pmt.setUserOrgRangeFilter(true);
        pmt.setReturnPositionAndUnit(false);
        F7ParamOnRegister regParam = new F7ParamOnRegister();
        regParam.setF7Name(EmployeeMultiF7PromptBox.class.getName());
        regParam.setSeq(0);
        pmt.setF7ParamOnRegister(regParam);
        pmt.setF7ParamFromUI((IF7ParamFromUI)new DefaultF7PramFromUI((CoreUIObject)this, this.getMainOrgContext(), OrgType.HRO, false));
        new F7ConfigManager().apply((IF7Support)pmt);
        pmt.setIsSingleSelect(false);
        this.handlePromptBox((KDCommonPromptDialog)pmt);
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    private void handlePromptBox(KDCommonPromptDialog pmt) throws Exception {
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 10) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        TrainPlanParticipantScopeListUI.this.dealAddPerson(obj);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(obj);
            }
        }
    }

    private void dealAddPerson(Object[] obj) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        PersonInfo personInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            personInfo = (PersonInfo)obj[i];
            idSet.add(personInfo.getId().toString());
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            IRowSet rowSet = TrainActivityHelper.getRowSet("TrainActParticipantAboutQuery", fi);
            ArrayList list = new ArrayList();
            HashMap<String, String> map = null;
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("personId", rowSet.getString("id"));
                map.put("number", rowSet.getString("number"));
                map.put("name", rowSet.getString("name"));
                map.put("position", rowSet.getString("position.name"));
                map.put("orgUnit", rowSet.getString("orgUnit.name"));
                map.put("email", rowSet.getString("email"));
                list.add(map);
            }
            this.fillTable(list);
            this.submit();
        }
    }

    public void submit() throws Exception {
        if (this.curTrainPlanInfo == null) {
            return;
        }
        ITrainPlanParticipantScope participantScope = TrainPlanParticipantScopeFactory.getRemoteInstance();
        TrainPlanParticipantScopeCollection participantScopeCollection = new TrainPlanParticipantScopeCollection();
        TrainPlanParticipantScopeInfo participantScopeInfo = null;
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            participantScopeInfo = (TrainPlanParticipantScopeInfo)row.getUserObject();
            participantScopeCollection.add(participantScopeInfo);
        }
        if (participantScopeCollection.size() != 0) {
            Map idMap = participantScope.batchSubmit(participantScopeCollection);
            int size2 = this.tblMain.getRowCount();
            for (int i = 0; i < size2; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell("id").getValue() != null) continue;
                row.getCell("id").setValue(idMap.get((String)row.getCell("person.id").getValue()));
            }
        }
    }

    private boolean checkIfRefered(String personId) {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            String personIdInTable = (String)row.getCell("person.id").getValue();
            if (personIdInTable == null || !personIdInTable.equals(personId)) continue;
            return true;
        }
        return false;
    }

    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        ITrainPlanParticipantScope participantScope = TrainPlanParticipantScopeFactory.getRemoteInstance();
        TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.confirmRemove()) {
            List selectRowList = TrainUtils.getSelectedRows(this.tblMain);
            Arrays.sort(selectRowList.toArray());
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = selectRowList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)selectRowList.get(i);
                row = this.tblMain.getRow(rowIndex);
                String id = (String)row.getCell("id").getValue();
                if (id != null) {
                    idSet.add(id);
                }
                this.tblMain.removeRow(rowIndex);
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            participantScope.delete(idSet);
        }
    }

    protected void prmtTrainPlan_dataChanged(DataChangeEvent e) throws Exception {
        this.curTrainPlanInfo = (TrainPlanInfo)this.prmtTrainPlan.getData();
        if (this.curTrainPlanInfo != null) {
            this.prmtOrg.setValue((Object)this.curTrainPlanInfo.getOrgUnit());
        } else {
            this.prmtOrg.setValue(null);
        }
        this.loadData();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public IUIActionPostman prepareInit() {
        SelectorItemCollection sic;
        TrainClientUtil.checkValidPerson((CoreUI)this);
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        FilterInfo fi = this.getLoadDataFilterInfo();
        if (fi != null) {
            request.put("filterInfo", (Object)fi);
        }
        request.put("query", (Object)"com.kingdee.eas.hr.train.app.TrainPlanParticipantScopeQuery");
        request.put("trainPlanId", this.getUIContext().get("ID"));
        EntityViewInfo evi = this.getTrainPlanMessageEntityView();
        if (evi != null) {
            request.put("messageEVI", (Object)evi);
        }
        if ((sic = this.getSelector()) != null) {
            request.put("planInfoSelector", (Object)sic);
        }
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    protected void initUserConfig() {
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

