/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainPlanCategoryInfo;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanReportFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

public class TrainPlanReportFilterUI
extends AbstractTrainPlanReportFilterUI {
    private static final long serialVersionUID = 8812107855971689994L;

    public TrainPlanReportFilterUI() throws Exception {
        this.clear();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)40));
        filterInfo.setMaskString("#0 or #1");
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"OrgUnit.id"), "AND");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        this.prmptTrainPlan.setEntityViewInfo(viewInfo);
        TrainUtils.initOrgUnit(this.prmptOrgUnit, true, (IUIObject)this);
        this.prmptOrgUnit.setEditable(false);
        TrainActivityHelper.initTrainPlanCategory(this.comboPlanType);
        TrainUtils.addComboBoxEmptyItem(this.comboPlanType);
        this.comboPlanType.setSelectedIndex(-1);
        this.prmptTrainPlan.setEditable(false);
    }

    public FilterInfo getFilterInfo() {
        Set adminOrgUnitIds;
        Object categoryInfo;
        FilterInfo filter = new FilterInfo();
        TrainPlanInfo trainPlanInfo = (TrainPlanInfo)this.prmptTrainPlan.getValue();
        if (trainPlanInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)trainPlanInfo.getId().toString()));
        }
        if ((categoryInfo = this.comboPlanType.getSelectedItem()) != null && categoryInfo instanceof TrainPlanCategoryInfo) {
            filter.getFilterItems().add(new FilterItemInfo("planCategory.id", (Object)((TrainPlanCategoryInfo)categoryInfo).getId().toString()));
        }
        if ((adminOrgUnitIds = TrainCommonUtils.assembleSetByArray((Object[])this.prmptOrgUnit.getValue())) != null && adminOrgUnitIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)adminOrgUnitIds, CompareType.INCLUDE));
        }
        if (this.pkDateStart.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)((Date)this.pkDateStart.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.pkDateEnd.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("PlanDate", (Object)((Date)this.pkDateEnd.getValue()), CompareType.LESS_EQUALS));
        }
        return filter;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmptTrainPlan);
        CustomerQueryUtil.storeToCustomerParams(cp, this.comboPlanType);
        CustomerQueryUtil.storeToCustomerParams(cp, this.prmptOrgUnit);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkDateStart);
        CustomerQueryUtil.storeToCustomerParams(cp, this.pkDateEnd);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmptTrainPlan, TrainPlanInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prmptOrgUnit, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.comboPlanType);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkDateStart);
        CustomerQueryUtil.loadFromCustomerParams(cp, this.pkDateEnd);
    }

    public boolean verify() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkDateStart);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.pkDateEnd);
        TrainVerifyUtils.verifyDateBigOrSmallOrEqual((CoreUIObject)this, this.pkDateStart, this.pkDateEnd, null);
        return true;
    }

    public void clear() {
        super.clear();
        this.prmptTrainPlan.setValue(null);
        this.comboPlanType.setSelectedIndex(-1);
        this.prmptOrgUnit.setValue(null);
        Calendar now = Calendar.getInstance();
        this.pkDateEnd.setValue((Object)new Date(now.getTimeInMillis()));
        now.set(5, 1);
        this.pkDateStart.setValue((Object)new Date(now.getTimeInMillis()));
    }
}

