/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainConstants;
import com.kingdee.eas.hr.train.client.AbstractTrainPlanReportUI;
import com.kingdee.eas.hr.train.client.TrainActManagerUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainPlanReportFilterUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainPlanReportUI
extends AbstractTrainPlanReportUI {
    private static final long serialVersionUID = 5720526419361991605L;
    private static final Logger logger = Logger.getLogger((String)TrainPlanReportUI.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private Set trainActivityIds = new HashSet();
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        super.onLoad();
        this.btnView.setVisible(false);
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            this.trainActivityIds.clear();
            String trainActivityId = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                trainActivityId = rowSet.getString("trainActivity.id");
                if (TrainCommonUtils.isEmpty(trainActivityId)) continue;
                this.trainActivityIds.add(trainActivityId);
            }
            Map studentCounts = null;
            if (this.trainActivityIds.size() > 0) {
                studentCounts = TrainActivityFacadeFactory.getRemoteInstance().getActStudentCount(this.trainActivityIds);
            }
            Map mainUnits = TrainUtils.getMainUnitMap();
            CourseHourUnitEnum mainUnitType = null;
            if (mainUnits != null) {
                mainUnitType = TrainUtils.getMainUnitType(mainUnits);
            }
            DecimalFormat df = TrainConstants.NUMBER_FORMAT;
            String split = " " + EASResource.getString((String)RESOURCE, (String)"to") + " ";
            BigDecimal rate = null;
            String dateString = null;
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (studentCounts != null) {
                    String activityId = rowSet.getString("trainActivity.id");
                    rowSet.updateString("studentCount", (String)studentCounts.get(activityId));
                }
                dateString = TrainClientUtil.assembleDate(rowSet.getDate("planDate"), rowSet.getDate("endDate"), "yyyy-MM-dd", split);
                rowSet.updateString("trainPlanDate", dateString);
                dateString = TrainClientUtil.assembleDate(rowSet.getDate("actBeginDate"), rowSet.getDate("actEndDate"), "yyyy-MM-dd", split);
                rowSet.updateString("trainDate", dateString);
                BigDecimal hour = rowSet.getBigDecimal("actHour");
                int hourUnit = rowSet.getInt("actHourUnit");
                if (hour != null && hourUnit > 0) {
                    if (mainUnitType != null) {
                        rate = (BigDecimal)mainUnits.get((Object)CourseHourUnitEnum.getEnum(hourUnit));
                        rowSet.updateString("trainHour", df.format(hour.multiply(rate)) + mainUnitType.toString());
                        continue;
                    }
                    rowSet.updateString("trainHour", df.format(hour) + CourseHourUnitEnum.getEnum(hourUnit).toString());
                    continue;
                }
                rowSet.updateString("trainHour", null);
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.onGetRowSet(rowSet);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getGroupManager().setGroup(true);
        super.actionQuery_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (TrainCommonUtils.isEmpty(this.getSelectedKeyValue())) {
            return;
        }
        super.actionView_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)50));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)40));
        filterInfo.setMaskString("#0 or #1");
        try {
            filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"OrgUnit.id"), "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return filterInfo;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            dialog.addUserPanel((KDPanel)new TrainPlanReportFilterUI());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dialog;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int index;
        if (e.getType() == 0 && ((index = e.getColIndex()) == this.tblMain.getColumnIndex("trainPlanDate") || index == this.tblMain.getColumnIndex("trainDate") || index == this.tblMain.getColumnIndex("trainHour") || index == this.tblMain.getColumnIndex("studentCount"))) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected String getKeyFieldName() {
        return "trainActivity.id";
    }

    protected String getEditUIName() {
        return TrainActManagerUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainActivityFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"HRO");
    }
}

