/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainMainUnitCollection;
import com.kingdee.eas.hr.train.TrainMainUnitFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainRecordCourseHourReportUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainRecordCourseHourFilterUI;
import com.kingdee.eas.hr.train.client.TrainRecordHourDetailUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainRecordCourseHourReportUI
extends AbstractTrainRecordCourseHourReportUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainRecordCourseHourReportUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private static final String TOTAL_RECORD_TEXT = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainReportResource", (String)"listUIMessageBarText");
    private CourseHourUnitEnum mainUnit;
    private String hourHeadTitle = null;
    private Map parameters = new HashMap();
    private boolean isTrainActivity = true;
    private boolean startOnLoad = false;
    private Boolean defaultFilterFlag = null;

    public void onLoad() throws Exception {
        this.startOnLoad = true;
        if (!this.isTrainMainUnitEnabled()) {
            TrainClientUtil.showMessage(RESOURCE, "setEnableTrainMainUnit", (CoreUI)this);
            return;
        }
        this.tblMain.checkParsed();
        super.onLoad();
        this.setTableHeadTitle();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public boolean isHasQyeryPK() {
        return false;
    }

    private boolean isTrainMainUnitEnabled() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("mainUnitType"));
        FilterInfo filterInfo = TrainUtils.getCurrentHRFilter("hrOrgUnit.id");
        filterInfo.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        viewInfo.setFilter(filterInfo);
        TrainMainUnitCollection collection = TrainMainUnitFactory.getRemoteInstance().getTrainMainUnitCollection(viewInfo);
        this.mainUnit = collection != null && collection.size() > 0 ? collection.get(0).getMainUnitType() : null;
        return this.mainUnit != null;
    }

    private void setTableHeadTitle() {
        ICell cell = this.tblMain.getHeadRow(0).getCell("totalHour");
        if (this.hourHeadTitle == null) {
            this.hourHeadTitle = cell.getValue().toString();
        }
        cell.setValue((Object)this.hourHeadTitle.replaceFirst("#0", this.mainUnit.getAlias()));
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainUnit == null) {
            return;
        }
        this.handleQuery();
        super.tblMain_doRequestRowSet(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isTrainMainUnitEnabled()) {
            this.tblMain.removeRows();
            TrainClientUtil.showErrorMessage(RESOURCE, "setEnableTrainMainUnit", (CoreUI)this);
        } else {
            this.setTableHeadTitle();
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
            super.actionQuery_actionPerformed(e);
        }
    }

    private void handleQuery() {
        this.parameters.clear();
        FilterItemCollection filters = this.mainQuery.getFilter().getFilterItems();
        FilterItemInfo filterItemInfo = null;
        int size = filters.size();
        for (int i = 0; i < size; ++i) {
            filterItemInfo = filters.get(i);
            if ("isTrainActivity".equals(filterItemInfo.getPropertyName())) {
                Object value = filterItemInfo.getCompareValue();
                if (value instanceof Boolean) {
                    this.isTrainActivity = (Boolean)value;
                } else if (value instanceof Integer) {
                    this.isTrainActivity = (Integer)value > 0;
                }
                filterItemInfo.setPropertyName("hrOrgUnitId");
                filterItemInfo.setCompareValue((Object)TrainUtils.getCurrentHROrgUnit().getId().toString());
                continue;
            }
            if ("startDate".equals(filterItemInfo.getPropertyName())) {
                this.parameters.put("endDate", (Date)filterItemInfo.getCompareValue());
                continue;
            }
            if ("endDate".equals(filterItemInfo.getPropertyName())) {
                this.parameters.put("startDate", (Date)filterItemInfo.getCompareValue());
                continue;
            }
            if ("trainActivityId".equals(filterItemInfo.getPropertyName())) {
                this.parameters.put("trainActivityId", (String)filterItemInfo.getCompareValue());
                continue;
            }
            if (!"trainType".equals(filterItemInfo.getPropertyName())) continue;
            this.parameters.put("trainType", (String)filterItemInfo.getCompareValue());
        }
        this.parameters.put("isTrainActivity", this.isTrainActivity);
        this.setBindingQuery(this.isTrainActivity);
        this.setDateRangText();
    }

    private void setBindingQuery(boolean isTrainActivity) {
        if (isTrainActivity) {
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordActHourQuery");
            this.lbTableTitle.setText(EASResource.getString((String)RESOURCE, (String)"trainRecordActHourTitle"));
        } else {
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordCourseHourQuery");
            this.lbTableTitle.setText(EASResource.getString((String)RESOURCE, (String)"trainRecordCourseHourTitle"));
        }
    }

    private void setDateRangText() {
        Date startDate = (Date)this.parameters.get("startDate");
        Date endDate = (Date)this.parameters.get("endDate");
        String text = null;
        if (startDate != null && endDate != null) {
            String str = EASResource.getString((String)RESOURCE, (String)"dateRang");
            String startDateString = DateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
            String endDateString = DateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            text = MessageFormat.format(str, startDateString, endDateString);
        }
        this.lbDateRang.setText(text);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isTrainMainUnitEnabled()) {
            this.tblMain.removeRows();
            TrainClientUtil.showErrorMessage(RESOURCE, "setEnableTrainMainUnit", (CoreUI)this);
        } else {
            this.setTableHeadTitle();
            super.actionRefresh_actionPerformed(e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        try {
            FilterInfo filterInfo = null;
            filterInfo = TrainUtils.getHRAndAdminRangePersonFilterInfo_All("hrOrgUnitId", "employeeId");
            return filterInfo;
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
            return super.getDefaultFilterForQuery();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordCourseHourQuery"));
        try {
            dialog.addUserPanel((KDPanel)new TrainRecordCourseHourFilterUI());
            dialog.setDisShowRowCount(true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dialog;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        this.setMessageBarText(MessageFormat.format(TOTAL_RECORD_TEXT, rowSet.size()));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        int selectedIndex = TrainUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedIndex);
        this.parameters.put("employeeId", row.getCell("employeeId").getValue().toString());
        this.parameters.put("employeeName", row.getCell("employeeName").getValue().toString());
        uiContext.put((Object)"trainRecordParameters", (Object)this.parameters);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainRecordHourDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean initDefaultFilter() {
        if (!this.startOnLoad) {
            return super.initDefaultFilter();
        }
        try {
            if (this.defaultFilterFlag == null) {
                this.defaultFilterFlag = TrainUtils.hasDefaultSolution(this.mainQueryPK, this.getMetaDataPK().getFullName());
            }
            return this.defaultFilterFlag == false;
        }
        catch (Exception e) {
            logger.info((Object)"error message", (Throwable)e);
            return super.initDefaultFilter();
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"employeeNumber", "employeeName"};
        return locateNames;
    }

    protected String getKeyFieldName() {
        return "employeeId";
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

