/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordExtendsInfo;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainRecordIsPassedEnum;
import com.kingdee.eas.hr.train.TrainTypeEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainScoreRecordBatchMgrUI;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainScoreRecordBatchMgrUI
extends AbstractTrainScoreRecordBatchMgrUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainScoreRecordBatchMgrUI.class);
    String RES = "com.kingdee.eas.hr.train.client.TrainRecordResource";
    JButton btnAddRuleNew;
    JButton btnDelRuleNew;
    HashMap recordMap;
    boolean isActivity = false;
    HashMap currentMap;
    boolean courseFlag = false;
    boolean activityFlag = false;
    private String certificateName;
    private TrainCourseRecordInfo backRecordInfo = null;
    private LocateAssistant locateAssistant;
    private Set canNotAuditSet = new HashSet();
    private String userID = null;

    public void storeFields() {
        if (this.recordMap == null) {
            this.currentMap = null;
            return;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        this.currentMap = new HashMap();
        for (Map.Entry entry : this.recordMap.entrySet()) {
            this.currentMap.put(entry.getKey(), ((TrainCourseRecordInfo)entry.getValue()).clone());
        }
        String key = null;
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TrainCourseRecordExtendsInfo eInfo;
            PersonInfo personInfo;
            TrainCourseRecordInfo courseRecordInfo;
            IRow row = this.recordTable.getRow(i);
            if (this.isActivity) {
                key = row.getCell("person.id").getValue().toString() + row.getCell("trainActivity.id").getValue().toString();
                courseRecordInfo = (TrainCourseRecordInfo)this.currentMap.get(key);
                if (((Boolean)row.getCell("isCheck").getValue()).booleanValue()) {
                    courseRecordInfo.setActNeedExam(true);
                    if (row.getCell("checkScore").getValue() != null) {
                        courseRecordInfo.setActAssessScore((BigDecimal)row.getCell("checkScore").getValue());
                    } else {
                        courseRecordInfo.setActAssessScore(null);
                    }
                    if (row.getCell("checkValue").getValue() != null) {
                        if (courseRecordInfo.getRecordExtends() == null) {
                            TrainCourseRecordExtendsInfo eInfo2 = new TrainCourseRecordExtendsInfo();
                            courseRecordInfo.put("recordExtends", eInfo2);
                        }
                        courseRecordInfo.getRecordExtends().setActAssessValue(row.getCell("checkValue").getValue().toString());
                    }
                } else {
                    courseRecordInfo.setActNeedExam(false);
                    courseRecordInfo.setActAssessScore(null);
                    if (courseRecordInfo.getRecordExtends() != null) {
                        courseRecordInfo.getRecordExtends().setActAssessValue(null);
                    }
                }
                if (row.getCell("isPass").getValue() != null) {
                    courseRecordInfo.setActIsPassed((TrainRecordIsPassedEnum)((Object)row.getCell("isPass").getValue()));
                } else {
                    courseRecordInfo.put("actIsPassed", null);
                }
                if (((Boolean)row.getCell("hasCertificate").getValue()).booleanValue() && this.checkCeritify.isSelected()) {
                    if (courseRecordInfo.getActCertificate() == null) {
                        courseRecordInfo.setActCertificate(new PersonCertificationInfo());
                        courseRecordInfo.getActCertificate().setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
                        personInfo = new PersonInfo();
                        personInfo.setId(BOSUuid.read((String)row.getCell("person.id").getValue().toString()));
                        courseRecordInfo.getActCertificate().setPerson(personInfo);
                    }
                    if (row.getCell("certificateName").getValue() != null) {
                        courseRecordInfo.getActCertificate().setCertificateName(row.getCell("certificateName").getValue().toString());
                    } else {
                        courseRecordInfo.getActCertificate().setCertificateName(null);
                    }
                    if (row.getCell("certificateNumber").getValue() != null) {
                        courseRecordInfo.getActCertificate().setCertificateNumber(row.getCell("certificateNumber").getValue().toString());
                    } else {
                        courseRecordInfo.getActCertificate().setCertificateNumber(null);
                    }
                    if (row.getCell("grantOrg").getValue() != null) {
                        courseRecordInfo.getActCertificate().setOrgan(row.getCell("grantOrg").getValue().toString());
                    } else {
                        courseRecordInfo.getActCertificate().setOrgan(null);
                    }
                    if (row.getCell("effect").getValue() != null) {
                        courseRecordInfo.getActCertificate().setPeriodValidity(Integer.parseInt(row.getCell("effect").getValue().toString()));
                    } else {
                        courseRecordInfo.getActCertificate().setPeriodValidity(0);
                    }
                    if (row.getCell("grantDate").getValue() != null) {
                        courseRecordInfo.getActCertificate().setCertifyDate((Date)row.getCell("grantDate").getValue());
                        continue;
                    }
                    courseRecordInfo.getActCertificate().setCertifyDate(null);
                    continue;
                }
                courseRecordInfo.setActCertificate(null);
                continue;
            }
            boolean isCourse = false;
            if (this.promptTrainCourse.getValue() != null && this.promptTrainActivity.getValue() == null) {
                isCourse = true;
            }
            if (row.getCell("trainActivity.id").getValue() != null && !isCourse) {
                key = row.getCell("person.id").getValue().toString() + row.getCell("trainActivity.id").getValue().toString() + row.getCell("trainCourse.id").getValue().toString();
            } else {
                key = row.getCell("person.id").getValue().toString() + row.getCell("trainCourse.id").getValue().toString();
                if (row.getCell("trainDate").getValue() != null) {
                    key = key + (String)row.getCell("trainDate").getValue();
                }
            }
            courseRecordInfo = (TrainCourseRecordInfo)this.currentMap.get(key);
            if (courseRecordInfo == null) continue;
            if (((Boolean)row.getCell("isCheck").getValue()).booleanValue()) {
                courseRecordInfo.setNeedExam(true);
                if (courseRecordInfo.getRecordExtends() == null) {
                    eInfo = new TrainCourseRecordExtendsInfo();
                    courseRecordInfo.put("recordExtends", eInfo);
                }
                if (row.getCell("checkScore").getValue() != null) {
                    courseRecordInfo.setAssessScore((BigDecimal)row.getCell("checkScore").getValue());
                } else {
                    courseRecordInfo.setAssessScore(null);
                }
                if (row.getCell("checkValue").getValue() != null) {
                    courseRecordInfo.getRecordExtends().setAssessValue(row.getCell("checkValue").getValue().toString());
                }
            } else {
                courseRecordInfo.setNeedExam(false);
                courseRecordInfo.setAssessScore(null);
                if (courseRecordInfo.getRecordExtends() == null) {
                    eInfo = new TrainCourseRecordExtendsInfo();
                    courseRecordInfo.put("recordExtends", eInfo);
                }
                courseRecordInfo.getRecordExtends().setAssessValue(null);
            }
            if (row.getCell("isPass").getValue() != null) {
                courseRecordInfo.setIsPassed((TrainRecordIsPassedEnum)((Object)row.getCell("isPass").getValue()));
            } else {
                courseRecordInfo.put("isPassed", null);
            }
            if (((Boolean)row.getCell("hasCertificate").getValue()).booleanValue() && this.checkCeritify.isSelected()) {
                if (courseRecordInfo.getEmpCertificatio() == null) {
                    courseRecordInfo.setEmpCertificatio(new PersonCertificationInfo());
                    courseRecordInfo.getEmpCertificatio().setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
                    personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)row.getCell("person.id").getValue().toString()));
                    courseRecordInfo.getEmpCertificatio().setPerson(personInfo);
                }
                if (row.getCell("certificateName").getValue() != null) {
                    courseRecordInfo.getEmpCertificatio().setCertificateName(row.getCell("certificateName").getValue().toString());
                } else {
                    courseRecordInfo.getEmpCertificatio().setCertificateName(null);
                }
                if (row.getCell("certificateNumber").getValue() != null) {
                    courseRecordInfo.getEmpCertificatio().setCertificateNumber(row.getCell("certificateNumber").getValue().toString());
                } else {
                    courseRecordInfo.getEmpCertificatio().setCertificateNumber(null);
                }
                if (row.getCell("grantOrg").getValue() != null) {
                    courseRecordInfo.getEmpCertificatio().setOrgan(row.getCell("grantOrg").getValue().toString());
                } else {
                    courseRecordInfo.getEmpCertificatio().setOrgan(null);
                }
                if (row.getCell("effect").getValue() != null) {
                    courseRecordInfo.getEmpCertificatio().setPeriodValidity(Integer.parseInt(row.getCell("effect").getValue().toString()));
                } else {
                    courseRecordInfo.getEmpCertificatio().setPeriodValidity(0);
                }
                if (row.getCell("grantDate").getValue() != null) {
                    courseRecordInfo.getEmpCertificatio().setCertifyDate((Date)row.getCell("grantDate").getValue());
                } else {
                    courseRecordInfo.getEmpCertificatio().setCertifyDate(null);
                }
            } else {
                courseRecordInfo.setEmpCertificatio(null);
            }
            if (courseRecordInfo.getActHourUnit() == null) {
                courseRecordInfo.put("actHourUnit", null);
            }
            if (courseRecordInfo.getActAbsentType() == null) {
                courseRecordInfo.put("actAbsentType", null);
            }
            if (courseRecordInfo.getActAbsHourUnit() != null) continue;
            courseRecordInfo.put("actAbsHourUnit", null);
        }
    }

    private boolean isModify() {
        this.storeFields();
        if (this.currentMap == null || this.recordMap == null) {
            return false;
        }
        for (Map.Entry entry : this.currentMap.entrySet()) {
            TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            if (courseRecordInfo.getId() != null) continue;
            return true;
        }
        if (!this.isActivity) {
            TrainCourseRecordInfo info = null;
            for (Map.Entry entry : this.recordMap.entrySet()) {
                info = (TrainCourseRecordInfo)entry.getValue();
                if (info.getActHourUnit() == null) {
                    info.put("actHourUnit", null);
                }
                if (info.getActAbsentType() == null) {
                    info.put("actAbsentType", null);
                }
                if (info.getActAbsHourUnit() != null) continue;
                info.put("actAbsHourUnit", null);
            }
        }
        for (Map.Entry entry : this.currentMap.entrySet()) {
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)((AbstractObjectValue)entry.getValue()), (AbstractObjectValue)((AbstractObjectValue)this.recordMap.get(entry.getKey())))) continue;
            return true;
        }
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.actionLocate.setEnabled(true);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSelectedCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    public void onLoad() throws Exception {
        this.recordTable.checkParsed();
        TrainClientUtil.setDisableColor(this.recordTable);
        TrainActivityHelper.initTrainActivity_By_End_Star(this.promptTrainActivity, TrainActivityHelper.getActSelectors());
        TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
        this.txtAttendAll.setRemoveingZeroInDispaly(false);
        super.onLoad();
        this.initEntryButton();
        this.initTableEditor();
        this.initTableView();
        TrainUtils.setKDTableSortable(this.recordTable);
        this.recordTable.getViewManager().setFreezeView(0, this.recordTable.getColumnIndex("name") + 1);
        this.userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }

    private void initTableView() {
        this.recordTable.checkParsed();
        this.recordTable.getColumn("name").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("number").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("orgUnit").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("position").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("jobGrade").getStyleAttributes().setLocked(true);
        this.recordTable.getColumn("isPass").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
    }

    private void initTableEditor() throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(formattedTextField);
        TrainUtils.setTableCellEditorByFormattedTextField(this.recordTable, formattedTextField, "checkScore", 2);
        TrainUtils.setTableCellEditorByComboBox(this.recordTable, "isPass", "com.kingdee.eas.hr.train.TrainRecordIsPassedEnum");
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(60);
        TrainUtils.setTableCellEditorByTextField(this.recordTable, txtField, "certificateName");
        TrainUtils.setTableCellEditorByTextField(this.recordTable, "checkValue", 400);
        TrainUtils.setTableCellEditorByTextField(this.recordTable, txtField, "certificateNumber");
        TrainUtils.setTableCellEditorByTextField(this.recordTable, txtField, "grantOrg");
        KDFormattedTextField formattedTextField2 = new KDFormattedTextField();
        formattedTextField2.setDataType(1);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(formattedTextField2);
        TrainUtils.setTableCellEditorByFormattedTextField(this.recordTable, formattedTextField2, "effect", 0);
        KDDatePicker dp = new KDDatePicker();
        this.recordTable.getColumn("grantDate").setEditor((ICellEditor)new KDTDefaultCellEditor(dp));
    }

    private void loadData() throws Exception {
        this.clearTable();
        this.txtAttendAll.setValue(null);
        this.txtCertificateName.setText(null);
        this.txtPassScore.setText(null);
        this.operateNeddCertificate();
        this.recordMap = new HashMap();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection courseRecordCollection = this.getRecordCollection(filterInfo, null);
        this.backRecordInfo = courseRecordCollection != null && courseRecordCollection.size() > 0 ? courseRecordCollection.get(0) : new TrainCourseRecordInfo();
        HashMap newRecord = this.filterRecord(courseRecordCollection, this.isActivity, false);
        HashSet set = this.getPersonSet(newRecord);
        HashMap personMap = this.getPersonProperty(set);
        this.countAttend_tmp(courseRecordCollection);
        this.putDataToTable(newRecord, personMap);
        this.operateIsAttendAll();
    }

    private void operateNeddCertificate() throws Exception {
        this.certificateName = null;
        if (this.promptTrainActivity.getValue() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("needCertifcate"));
            sic.add(new SelectorItemInfo("certificateName"));
            sic.add(new SelectorItemInfo("passStand"));
            ObjectUuidPK id = new ObjectUuidPK(((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString());
            TrainActivityInfo trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)id, sic);
            if (trainActivityInfo != null && trainActivityInfo.isNeedCertifcate()) {
                this.checkCeritify.setSelected(true);
                this.setCertificateColumnLock(false);
                this.certificateName = trainActivityInfo.getCertificateName();
            } else {
                this.checkCeritify.setSelected(false);
                this.setCertificateColumnLock(true);
            }
            if (trainActivityInfo != null) {
                if (trainActivityInfo.getPassStand() != null) {
                    this.txtPassScore.setText(trainActivityInfo.getPassStand().setScale(TrainClientUtil.PRECISION).toString());
                }
                if (trainActivityInfo.getCertificateName() != null) {
                    this.txtCertificateName.setText(trainActivityInfo.getCertificateName());
                }
            }
        } else {
            this.checkCeritify.setSelected(false);
            this.setCertificateColumnLock(true);
        }
    }

    private void setCertificateColumnLock(boolean flag) {
        this.recordTable.getColumn("hasCertificate").getStyleAttributes().setLocked(flag);
    }

    private void clearTable() {
        this.recordTable.checkParsed();
        this.recordTable.removeRows();
    }

    private void putDataToTable(HashMap record, HashMap personMap2) {
        if (record == null || record.size() == 0) {
            return;
        }
        Set recordIDSet = this.getTableID(this.recordTable);
        boolean noTrainActivity = true;
        if (this.promptTrainActivity.getValue() != null) {
            noTrainActivity = false;
        }
        this.recordTable.getColumn("trainDate").getStyleAttributes().setHided(!noTrainActivity);
        Iterator iterator = record.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap personRef = null;
            Map.Entry entry = iterator.next();
            TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null ? recordIDSet.contains(courseRecordInfo.getEmployee().getId().toString()) : recordIDSet.contains(courseRecordInfo.getId().toString())) continue;
            IRow row = this.recordTable.addRow();
            if (courseRecordInfo.getId() != null) {
                row.getCell("id").setValue((Object)courseRecordInfo.getId().toString());
            }
            if (courseRecordInfo.getTrainActivity() != null && courseRecordInfo.getTrainActivity().getId() != null) {
                row.getCell("trainActivity.id").setValue((Object)courseRecordInfo.getTrainActivity().getId().toString());
            }
            if (courseRecordInfo.getTrainCourse() != null && courseRecordInfo.getTrainCourse().getId() != null) {
                row.getCell("trainCourse.id").setValue((Object)courseRecordInfo.getTrainCourse().getId().toString());
            }
            if (courseRecordInfo.getEmployee().getId() != null) {
                row.getCell("person.id").setValue((Object)courseRecordInfo.getEmployee().getId().toString());
                personRef = (HashMap)personMap2.get(courseRecordInfo.getEmployee().getId().toString());
            }
            if (personRef != null) {
                row.getCell("name").setValue(personRef.get("name"));
                row.getCell("number").setValue(personRef.get("number"));
                if (courseRecordInfo.getRecordExtends() != null) {
                    if (courseRecordInfo.getRecordExtends().getOrgStudent().getName() != null) {
                        row.getCell("orgUnit").setValue((Object)courseRecordInfo.getRecordExtends().getOrgStudent().getName());
                    } else {
                        row.getCell("orgUnit").setValue(personRef.get("orgUnit"));
                    }
                    if (courseRecordInfo.getRecordExtends().getPosiStudent().getName() != null) {
                        row.getCell("position").setValue((Object)courseRecordInfo.getRecordExtends().getPosiStudent().getName());
                    } else {
                        row.getCell("position").setValue(personRef.get("position"));
                    }
                } else {
                    row.getCell("orgUnit").setValue(personRef.get("orgUnit"));
                    row.getCell("position").setValue(personRef.get("position"));
                }
                row.getCell("jobGrade").setValue(personRef.get("jobGrade"));
            }
            if (this.isActivity) {
                if (courseRecordInfo.isActNeedExam()) {
                    row.getCell("isCheck").setValue((Object)Boolean.TRUE);
                    row.getCell("checkScore").setValue((Object)courseRecordInfo.getActAssessScore());
                    if (courseRecordInfo.getRecordExtends() != null && courseRecordInfo.getRecordExtends().size() > 0) {
                        if (courseRecordInfo.getRecordExtends().getActAssessValue() != null) {
                            row.getCell("checkValue").setValue((Object)courseRecordInfo.getRecordExtends().getActAssessValue());
                        }
                    } else {
                        courseRecordInfo.put("checkValue", null);
                    }
                } else {
                    row.getCell("isCheck").setValue((Object)Boolean.FALSE);
                }
                row.getCell("isPass").setValue((Object)courseRecordInfo.getActIsPassed());
                if (courseRecordInfo.getActIsPassed() == null) {
                    courseRecordInfo.put("actIsPassed", null);
                }
                if (courseRecordInfo.getActCertificate() != null && this.checkCeritify.isSelected()) {
                    row.getCell("hasCertificate").setValue((Object)Boolean.TRUE);
                    row.getCell("certificateName").setValue((Object)courseRecordInfo.getActCertificate().getCertificateName());
                    row.getCell("certificateNumber").setValue((Object)courseRecordInfo.getActCertificate().getCertificateNumber());
                    row.getCell("grantOrg").setValue((Object)courseRecordInfo.getActCertificate().getOrgan());
                    row.getCell("effect").setValue((Object)courseRecordInfo.getActCertificate().getPeriodValidity());
                    row.getCell("grantDate").setValue((Object)courseRecordInfo.getActCertificate().getCertifyDate());
                    continue;
                }
                if (this.txtCertificateName.getText() != null) {
                    row.getCell("certificateName").setValue((Object)this.txtCertificateName.getText());
                }
                row.getCell("hasCertificate").setValue((Object)Boolean.FALSE);
                continue;
            }
            if (courseRecordInfo.isNeedExam()) {
                row.getCell("isCheck").setValue((Object)Boolean.TRUE);
                row.getCell("checkScore").setValue((Object)courseRecordInfo.getAssessScore());
                if (courseRecordInfo.getRecordExtends() != null) {
                    if (courseRecordInfo.getRecordExtends() != null) {
                        row.getCell("checkValue").setValue((Object)courseRecordInfo.getRecordExtends().getAssessValue());
                    }
                } else {
                    courseRecordInfo.put("checkValue", null);
                }
            } else {
                row.getCell("isCheck").setValue((Object)Boolean.FALSE);
            }
            row.getCell("trainDate").setValue((Object)courseRecordInfo.getString("trainDate"));
            Object checkSore = row.getCell("checkScore").getValue();
            if (!TrainClientUtil.objectIsNull(checkSore) && !TrainClientUtil.objectIsNull(this.txtPassScore.getText())) {
                if (new BigDecimal(checkSore.toString()).compareTo(new BigDecimal(this.txtPassScore.getText())) == -1) {
                    row.getCell("isPass").setValue((Object)TrainRecordIsPassedEnum.NOT_PASSED);
                } else {
                    row.getCell("isPass").setValue((Object)TrainRecordIsPassedEnum.PASSED);
                }
            } else {
                row.getCell("isPass").setValue((Object)courseRecordInfo.getIsPassed());
            }
            if (courseRecordInfo.getIsPassed() == null) {
                courseRecordInfo.put("isPassed", null);
            }
            if (courseRecordInfo.getEmpCertificatio() != null && this.checkCeritify.isSelected()) {
                row.getCell("hasCertificate").setValue((Object)Boolean.TRUE);
                row.getCell("certificateName").setValue((Object)courseRecordInfo.getEmpCertificatio().getCertificateName());
                row.getCell("certificateNumber").setValue((Object)courseRecordInfo.getEmpCertificatio().getCertificateNumber());
                row.getCell("grantOrg").setValue((Object)courseRecordInfo.getEmpCertificatio().getOrgan());
                row.getCell("effect").setValue((Object)courseRecordInfo.getEmpCertificatio().getPeriodValidity());
                row.getCell("grantDate").setValue((Object)courseRecordInfo.getEmpCertificatio().getCertifyDate());
                continue;
            }
            if (this.txtCertificateName.getText() != null) {
                row.getCell("certificateName").setValue((Object)this.txtCertificateName.getText());
            }
            row.getCell("hasCertificate").setValue((Object)Boolean.FALSE);
        }
    }

    private HashMap getPersonProperty(HashSet set) throws Exception {
        HashMap personMap = new HashMap();
        if (set == null || set.size() == 0) {
            return personMap;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "PersonToPositionGradeLevelQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        while (rowSet.next()) {
            HashMap<String, String> personRef = new HashMap<String, String>();
            personRef.put("name", rowSet.getString("name"));
            personRef.put("number", rowSet.getString("number"));
            personRef.put("orgUnit", rowSet.getString("orgUnit.name"));
            personRef.put("jobGrade", rowSet.getString("jobGrade.name"));
            personRef.put("position", rowSet.getString("position.name"));
            personMap.put(rowSet.getString("id"), personRef);
        }
        return personMap;
    }

    private HashSet getPersonSet(HashMap record) {
        HashSet<String> set = new HashSet<String>();
        if (record == null || record.size() == 0) {
            return set;
        }
        for (Map.Entry entry : record.entrySet()) {
            TrainCourseRecordInfo courseRecordInfo = (TrainCourseRecordInfo)entry.getValue();
            set.add(courseRecordInfo.getEmployee().getId().toString());
        }
        return set;
    }

    private HashMap filterRecord(TrainCourseRecordCollection courseRecordCollection, boolean isActivity, boolean isLoadPerson) {
        this.canNotAuditSet.clear();
        TrainCourseRecordCollection col_new = new TrainCourseRecordCollection();
        TrainCourseRecordInfo info = null;
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            return new HashMap();
        }
        for (int i = 0; i < courseRecordCollection.size(); ++i) {
            info = courseRecordCollection.get(i);
            if (isActivity) {
                if (!info.getRecordExtends().isActIsApproved()) {
                    col_new.add(info);
                }
                if (!info.getRecordExtends().isActIsApproved()) continue;
                this.canNotAuditSet.add(info.getEmployee().getId().toString());
                continue;
            }
            if (!info.getRecordExtends().isIsApproved()) {
                col_new.add(info);
            }
            if (!info.getRecordExtends().isIsApproved()) continue;
            this.canNotAuditSet.add(info.getEmployee().getId().toString());
        }
        if (col_new == null || col_new.size() == 0) {
            return new HashMap();
        }
        HashMap<String, TrainCourseRecordInfo> fillMap = new HashMap<String, TrainCourseRecordInfo>();
        HashMap<String, TrainCourseRecordInfo> addMap = new HashMap<String, TrainCourseRecordInfo>();
        if (isActivity) {
            int n = col_new.size();
            for (int i = 0; i < n; ++i) {
                String key = col_new.get(i).getEmployee().getId().toString() + col_new.get(i).getTrainActivity().getId().toString();
                fillMap.put(key, col_new.get(i));
                if (this.recordMap.containsKey(key)) continue;
                this.recordMap.put(key, col_new.get(i));
                addMap.put(key, col_new.get(i));
            }
        } else if (this.promptTrainActivity.getValue() != null) {
            int n = col_new.size();
            for (int i = 0; i < n; ++i) {
                String key = col_new.get(i).getEmployee().getId().toString() + col_new.get(i).getTrainActivity().getId().toString() + col_new.get(i).getTrainCourse().getId().toString();
                fillMap.put(key, col_new.get(i));
                if (this.recordMap.containsKey(key)) continue;
                this.recordMap.put(key, col_new.get(i));
                addMap.put(key, col_new.get(i));
            }
        } else {
            StringBuffer sb = new StringBuffer();
            TrainCourseRecordInfo trainCourseRecordInfo = null;
            String trainDate = null;
            int n = col_new.size();
            for (int i = 0; i < n; ++i) {
                trainCourseRecordInfo = col_new.get(i);
                sb.delete(0, sb.length());
                sb.append(trainCourseRecordInfo.getEmployee().getId().toString());
                sb.append(trainCourseRecordInfo.getTrainCourse().getId().toString());
                trainDate = TrainClientUtil.assembleDate(trainCourseRecordInfo.getBeginDateTime(), trainCourseRecordInfo.getEndDateTime(), "yyyy-MM-dd HH:mm:ss");
                sb.append(trainDate);
                trainCourseRecordInfo.put("trainDate", trainDate);
                fillMap.put(sb.toString(), trainCourseRecordInfo);
                if (this.recordMap.containsKey(sb.toString())) continue;
                this.recordMap.put(sb.toString(), trainCourseRecordInfo);
                addMap.put(sb.toString(), trainCourseRecordInfo);
            }
        }
        if (isLoadPerson) {
            return fillMap;
        }
        return this.recordMap;
    }

    private TrainCourseRecordCollection getRecordCollection(FilterInfo filterInfo, SelectorItemCollection itemCollection) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("Employee.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("NeedExam"));
        viewInfo.getSelector().add(new SelectorItemInfo("AssessScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPassed"));
        viewInfo.getSelector().add(new SelectorItemInfo("actNeedExam"));
        viewInfo.getSelector().add(new SelectorItemInfo("actAssessScore"));
        viewInfo.getSelector().add(new SelectorItemInfo("actIsPassed"));
        viewInfo.getSelector().add(new SelectorItemInfo("beginDateTime"));
        viewInfo.getSelector().add(new SelectorItemInfo("endDateTime"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.certificateNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.certificateName"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.certifyDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.PeriodValidity"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.organ"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.level"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.hrOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.AssessValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.ActAssessValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.certificateNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.certificateName"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.certifyDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.PeriodValidity"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.organ"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.level"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.hrOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("CourseCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.PosiStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.OrgStudent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainChannel.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.isApproved"));
        viewInfo.getSelector().add(new SelectorItemInfo("recordExtends.actIsApproved"));
        if (itemCollection != null && itemCollection.size() > 0) {
            int n = itemCollection.size();
            for (int i = 0; i < n; ++i) {
                viewInfo.getSelector().add(itemCollection.get(i));
            }
        }
        return TrainCourseRecordFactory.getRemoteInstance().getTrainCourseRecordCollection(viewInfo);
    }

    private boolean getIsCheck() throws Exception {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() == null) {
            return false;
        }
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("needExam", (Object)1));
            return TrainActivityFactory.getRemoteInstance().exists(filterInfo);
        }
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("NeedExam", (Object)1));
            return TrainActCourseFactory.getRemoteInstance().exists(filterInfo);
        }
        return false;
    }

    private FilterInfo getFilterInfo() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.promptTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)((TrainCourseInfo)this.promptTrainCourse.getValue()).getId().toString()));
        }
        if (this.promptTrainActivity.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString()));
        } else if (this.promptTrainCourse.getValue() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", null));
        }
        if (filterInfo.getFilterItems().size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)BOSUuid.create((BOSObjectType)new TrainCourseRecordInfo().getBOSType()).toString()));
        }
        filterInfo.getFilterItems().add(TrainCommonUtils.getAdminRangeFilterItemInfo(this.userID, "recordExtends.OrgStudent.id"));
        return filterInfo;
    }

    private void initEntryButton() {
        this.btnAddRuleNew = this.recordContainer.add((Action)((Object)this.actionAddPerson));
        this.btnAddRuleNew.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAddPerson), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnDelRuleNew = this.recordContainer.add((Action)((Object)this.actionDelLine));
        this.btnDelRuleNew.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionDelLine), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnAddRuleNew.setToolTipText(TrainClientUtil.getResource(this.RES, "addPerson"));
        this.btnAddRuleNew.setText(null);
        this.btnAddRuleNew.setSize(19, 19);
        this.btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnDelRuleNew.setToolTipText(TrainClientUtil.getResource(this.RES, "delPerson"));
        this.btnDelRuleNew.setText(null);
        this.btnDelRuleNew.setSize(19, 19);
    }

    protected void promptTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainActivity_dataChanged(e);
        if (this.activityFlag) {
            this.activityFlag = false;
            return;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                this.activityFlag = true;
                this.promptTrainActivity.setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.isActivity = e.getNewValue() != null ? this.promptTrainActivity.getValue() != null : false;
        if (this.promptTrainActivity.getValue() != null) {
            if (this.promptTrainCourse.getValue() != null) {
                this.courseFlag = true;
                this.promptTrainCourse.setValue(null);
            }
            TrainActivityHelper.initTrainCourseByActivity_END_AND_STAR(this.promptTrainCourse, ((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString());
            this.isActivity = true;
        } else {
            TrainActivityHelper.initTrainCourse(this.promptTrainCourse, false, (IUIObject)this);
            this.courseFlag = true;
            this.promptTrainCourse.setValue(null);
        }
        this.loadData();
        this.operateUIStatus();
        this.setAddAndEndPersonState();
        this.setEntryButton();
    }

    private void operateUIStatus() {
        if (this.promptTrainActivity.getValue() != null || this.promptTrainCourse.getValue() != null) {
            this.setButtonStatus(true);
        } else {
            this.setButtonStatus(false);
        }
    }

    private void setButtonStatus(boolean flag) {
        this.btnAddNew.setEnabled(flag);
        this.btnSave.setEnabled(flag);
        this.btnSelectedCopy.setEnabled(flag);
        if (this.btnAddRuleNew != null) {
            this.btnAddRuleNew.setEnabled(flag && this.promptTrainActivity.getValue() != null);
        }
        if (this.btnDelRuleNew != null) {
            this.btnDelRuleNew.setEnabled(flag);
        }
    }

    private void checkModifyed() throws Exception {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    private void operateYes() {
        ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
        this.actionSave.actionPerformed(event);
        if (this.actionSave.isInvokeFailed()) {
            SysUtil.abort();
        }
    }

    protected void promptTrainCourse_dataChanged(DataChangeEvent e) throws Exception {
        super.promptTrainCourse_dataChanged(e);
        if (this.courseFlag) {
            this.courseFlag = false;
            return;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.operateYes();
            } else if (result == 2) {
                this.courseFlag = true;
                this.promptTrainCourse.setValue(e.getOldValue());
                SysUtil.abort();
            }
        }
        this.isActivity = e.getNewValue() == null;
        this.loadData();
        this.operateUIStatus();
        this.setAddAndEndPersonState();
        this.setEntryButton();
    }

    protected boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.checkModifyed();
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkModifyed();
        super.actionAddNew_actionPerformed(e);
        this.activityFlag = true;
        this.courseFlag = true;
        this.clearTable();
        this.recordMap = new HashMap();
        this.promptTrainActivity.setValue(null);
        this.promptTrainCourse.setValue(null);
        this.txtAttendAll.setValue(null);
        this.txtCertificateName.setText(null);
        this.txtPassScore.setText(null);
        this.operateUIStatus();
    }

    public void actionSelectedCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectedCopy_actionPerformed(e);
        IRow row2 = TrainClientUtil.getSelectedRow(this.recordTable);
        if (row2 == null) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.recordTable.getSelectManager().size();
        if (size > 0) {
            sb = this.recordTable.getSelectManager().get(0);
            int column = sb.getLeft();
            if (column != this.recordTable.getColumn("isCheck").getColumnIndex() && column != this.recordTable.getColumn("checkScore").getColumnIndex() && column != this.recordTable.getColumn("checkValue").getColumnIndex() && column != this.recordTable.getColumn("isPass").getColumnIndex() && column != this.recordTable.getColumn("hasCertificate").getColumnIndex() && column != this.recordTable.getColumn("certificateName").getColumnIndex() && column != this.recordTable.getColumn("certificateNumber").getColumnIndex() && column != this.recordTable.getColumn("grantOrg").getColumnIndex() && column != this.recordTable.getColumn("effect").getColumnIndex() && column != this.recordTable.getColumn("grantDate").getColumnIndex()) {
                return;
            }
            TrainUtils.selectedCopy(this.recordTable);
        }
        this.operateIsAttendAll();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.checkValidate();
        this.storeFields();
        if (this.currentMap == null || this.currentMap.size() == 0) {
            TrainClientUtil.showErrorMessage(this.RES, "recordNotNull", this);
        }
        IObjectPK[] pks = TrainCourseRecordFactory.getRemoteInstance().submitScoreRecordBatch(this.recordMap, this.currentMap, this.isActivity);
        TrainClientUtil.showMessage(this.RES, "batchSaveSuccess", this);
        TrainCourseRecordCollection courseRecordCollection = this.getRecordCollection(pks);
        this.recordMap = new HashMap();
        this.filterRecord(courseRecordCollection, this.isActivity, false);
        this.operateUIStatus();
        this.operateIsAttendAll();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection col = this.getRecordCollection(filterInfo, null);
        this.countAttend_tmp(col);
    }

    private void checkValidate() {
        this.recordTable.checkParsed();
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            KDTEditManager kdtManager;
            IRow row = this.recordTable.getRow(i);
            if (row.getCell("isPass").getValue() == null) {
                kdtManager = this.recordTable.getEditManager();
                kdtManager.editCellAt(i, this.recordTable.getColumnIndex("isPass"));
                TrainClientUtil.showErrorMessage(this.RES, "isPassNotNull", this);
            }
            if (!this.checkCeritify.isSelected() || !((Boolean)row.getCell("hasCertificate").getValue()).booleanValue()) continue;
            if (row.getCell("certificateName").getValue() == null) {
                kdtManager = this.recordTable.getEditManager();
                kdtManager.editCellAt(i, this.recordTable.getColumnIndex("certificateName"));
                TrainClientUtil.showErrorMessage(this.RES, "certificateNameNotNull", this);
                continue;
            }
            if (row.getCell("certificateNumber").getValue() != null) continue;
            kdtManager = this.recordTable.getEditManager();
            kdtManager.editCellAt(i, this.recordTable.getColumnIndex("certificateNumber"));
            TrainClientUtil.showErrorMessage(this.RES, "certificateNumberNotNull", this);
        }
    }

    private TrainCourseRecordCollection getRecordCollection(IObjectPK[] pks) throws Exception {
        if (pks == null || pks.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            set.add(pks[i].toString());
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        return this.getRecordCollection(filterInfo, null);
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        MetaDataPK pk = this.isActivity ? new MetaDataPK("com.kingdee.eas.hr.train.app", this.getActivityRecordQuery()) : new MetaDataPK("com.kingdee.eas.hr.train.app", this.getCourseRecordQuery());
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        dlg.setQueryInfo(queryInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (this.isActivity && this.promptTrainActivity.getValue() != null) {
            Set personIDSet = this.getPersonID();
            if (personIDSet == null || personIDSet.size() == 0) {
                TrainClientUtil.showMessage(this.RES, "noExistEmployeeForAct", this);
                SysUtil.abort();
            }
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)personIDSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)((TrainActivityInfo)this.promptTrainActivity.getValue()).getId().toString(), CompareType.INCLUDE));
        } else {
            Set recordID = this.getTrainCourseRecordID();
            if (recordID == null || recordID.size() == 0) {
                TrainClientUtil.showMessage(this.RES, "noExistEmployeeForCourse", this);
                SysUtil.abort();
            }
            fi.getFilterItems().add(new FilterItemInfo("trainCourseRecord.id", (Object)this.getTrainCourseRecordID(), CompareType.INCLUDE));
        }
        evi.setFilter(fi);
        dlg.setEntityViewInfo(evi);
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        if (dlg.isCanceled()) {
            return;
        }
        Object[] obj = (Object[])dlg.getData();
        this.dealAddPerson(obj);
    }

    private void dealAddPerson(Object[] obj) throws Exception {
        if (obj == null || obj.length == 0) {
            return;
        }
        HashMap<String, Object> ids = new HashMap<String, Object>();
        int n = obj.length;
        for (int i = 0; i < n; ++i) {
            if (this.canNotAuditSet.contains(((PersonInfo)obj[i]).getId().toString())) continue;
            ids.put(((PersonInfo)obj[i]).getId().toString(), obj[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", new HashSet(ids.keySet()), CompareType.INCLUDE));
        filterInfo.mergeFilter(this.getFilterInfo(), "AND");
        TrainCourseRecordCollection courseRecordCollection = this.getRecordCollection(filterInfo, null);
        HashMap filterMap = this.filterRecord(courseRecordCollection, this.isActivity, true);
        HashSet personSet = this.getPersonSet(filterMap);
        HashMap personMap = this.getPersonProperty(personSet);
        this.putDataToTable(filterMap, personMap);
        this.operateIsAttendAll();
    }

    private void handleDefaultValue(TrainCourseRecordInfo info) {
        if (this.backRecordInfo != null) {
            if (info.getActBeginDate() == null) {
                info.setActBeginDate(this.backRecordInfo.getActBeginDate());
            }
            if (info.getActEndDate() == null) {
                info.setActEndDate(this.backRecordInfo.getActEndDate());
            }
            if (info.getBeginDateTime() == null) {
                info.setBeginDateTime(this.backRecordInfo.getBeginDateTime());
            }
            if (info.getEndDateTime() == null) {
                info.setEndDateTime(this.backRecordInfo.getEndDateTime());
            }
            if (info.getActTrainType() == null) {
                if (this.backRecordInfo.getActTrainType() != null) {
                    info.setActTrainType(this.backRecordInfo.getActTrainType());
                } else {
                    info.setActTrainType(TrainTypeEnum.INNERTRAINTYPE);
                }
            }
            if (info.getTrainType() == null) {
                if (this.backRecordInfo.getTrainType() != null) {
                    info.setTrainType(this.backRecordInfo.getTrainType());
                } else {
                    info.setTrainType(TrainTypeEnum.INNERTRAINTYPE);
                }
            }
            if (info.getActIsPassed() == null) {
                info.setActIsPassed(TrainRecordIsPassedEnum.PASSED);
            }
            if (info.getIsPassed() == null) {
                info.setIsPassed(TrainRecordIsPassedEnum.PASSED);
            }
        }
    }

    private HashSet getPersonIds(TrainCourseRecordCollection courseRecordCollection) {
        HashSet<String> set = new HashSet<String>();
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            return set;
        }
        int n = courseRecordCollection.size();
        for (int i = 0; i < n; ++i) {
            set.add(courseRecordCollection.get(i).getEmployee().getId().toString());
        }
        return set;
    }

    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        TrainActivityHelper.deleteRows(this.recordTable);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private void operateIsAttendAll() {
        this.recordTable.checkParsed();
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.recordTable.getRow(i);
            this.operateRowAttendAll(row);
        }
    }

    private void operateRowAttendAll(IRow row) {
        if (((Boolean)row.getCell("isCheck").getValue()).booleanValue()) {
            row.getCell("checkScore").getStyleAttributes().setLocked(false);
            row.getCell("checkValue").getStyleAttributes().setLocked(false);
        } else {
            row.getCell("checkScore").getStyleAttributes().setLocked(true);
            row.getCell("checkScore").setValue(null);
            row.getCell("checkValue").getStyleAttributes().setLocked(true);
            row.getCell("checkValue").setValue(null);
        }
        if (((Boolean)row.getCell("hasCertificate").getValue()).booleanValue()) {
            row.getCell("certificateName").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
            row.getCell("certificateNumber").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
            row.getCell("certificateName").getStyleAttributes().setLocked(false);
            row.getCell("certificateNumber").getStyleAttributes().setLocked(false);
            row.getCell("grantOrg").getStyleAttributes().setLocked(false);
            row.getCell("effect").getStyleAttributes().setLocked(false);
            row.getCell("grantDate").getStyleAttributes().setLocked(false);
            if (row.getCell("certificateName").getValue() == null) {
                row.getCell("certificateName").setValue((Object)this.certificateName);
            }
        } else {
            row.getCell("certificateName").getStyleAttributes().setBackground(TrainClientUtil.normalColor);
            row.getCell("certificateNumber").getStyleAttributes().setBackground(TrainClientUtil.normalColor);
            row.getCell("certificateName").getStyleAttributes().setLocked(true);
            row.getCell("certificateName").setValue(null);
            row.getCell("certificateNumber").getStyleAttributes().setLocked(true);
            row.getCell("certificateNumber").setValue(null);
            row.getCell("grantOrg").getStyleAttributes().setLocked(true);
            row.getCell("grantOrg").setValue(null);
            row.getCell("effect").getStyleAttributes().setLocked(true);
            row.getCell("effect").setValue(null);
            row.getCell("grantDate").getStyleAttributes().setLocked(true);
            row.getCell("grantDate").setValue(null);
        }
    }

    protected void recordTable_editStopped(KDTEditEvent e) throws Exception {
        if (e.getRowIndex() >= 0) {
            if (e.getColIndex() == this.recordTable.getColumnIndex("isCheck")) {
                this.operateRowAttendAll(this.recordTable.getRow(e.getRowIndex()));
            } else if (e.getColIndex() == this.recordTable.getColumnIndex("hasCertificate")) {
                this.operateRowAttendAll(this.recordTable.getRow(e.getRowIndex()));
            } else if (e.getColIndex() == this.recordTable.getColumnIndex("isPass")) {
                this.operateRowAttendAll(this.recordTable.getRow(e.getRowIndex()));
            } else if (e.getColIndex() == this.recordTable.getColumnIndex("checkScore")) {
                this.operateRowAttendAll(this.recordTable.getRow(e.getRowIndex()));
                if (this.recordTable.getRow(e.getRowIndex()).getCell("checkScore").getValue() != null && this.txtPassScore.getText() != null && this.txtPassScore.getText() != null && this.txtPassScore.getText().length() > 0) {
                    if (new BigDecimal(this.recordTable.getRow(e.getRowIndex()).getCell("checkScore").getValue().toString()).compareTo(new BigDecimal(this.txtPassScore.getText())) == -1) {
                        this.recordTable.getRow(e.getRowIndex()).getCell("isPass").setValue((Object)TrainRecordIsPassedEnum.NOT_PASSED);
                    } else {
                        this.recordTable.getRow(e.getRowIndex()).getCell("isPass").setValue((Object)TrainRecordIsPassedEnum.PASSED);
                    }
                }
            }
        }
    }

    protected void txtShouldAttend_dataChanged(DataChangeEvent e) throws Exception {
        int value = this.getMaxActualAttend();
        if (Integer.parseInt(e.getNewValue().toString()) < value) {
            this.txtAttendAll.requestFocus();
            TrainClientUtil.showErrorMessage(this.RES, "actualAttendNotMoreShouldAttend", this);
        } else {
            this.operateIsAttendAll();
        }
    }

    private int getMaxActualAttend() {
        this.recordTable.checkParsed();
        int value = 0;
        int temp = 0;
        int n = this.recordTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.recordTable.getRow(i);
            temp = TrainClientUtil.getIntValue(row.getCell("actAttend").getValue());
            if (temp <= value) continue;
            value = temp;
        }
        return value;
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        if (this.locateAssistant == null) {
            this.locateAssistant = new LocateAssistant((CoreUIObject)this, this.recordTable, this.getLocateNames());
        }
        this.locateAssistant.actionLocate();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name"};
        return locateNames;
    }

    private void setAddAndEndPersonState() {
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
            TrainActivityInfo info = (TrainActivityInfo)this.promptTrainActivity.getValue();
            if (!TrainActStateEnum.CLOSED.equals((Object)info.getTrainActState())) {
                this.btnAddRuleNew.setEnabled(false);
                this.btnDelRuleNew.setEnabled(false);
                this.clearTable();
            }
        } else {
            this.btnAddRuleNew.setEnabled(true);
            this.btnDelRuleNew.setEnabled(true);
        }
    }

    private Set getTableID(KDTable recordTable) {
        HashSet<String> idSet = new HashSet<String>();
        if (this.recordTable.getRowCount() > 0) {
            for (int i = 0; i < this.recordTable.getRowCount(); ++i) {
                IRow row = this.recordTable.getRow(i);
                if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
                    idSet.add(row.getCell("person.id").getValue().toString());
                    continue;
                }
                idSet.add(row.getCell("id").getValue().toString());
            }
        }
        return idSet;
    }

    private String getActivityRecordQuery() {
        return "TrainActivityRecordForBatchQuery";
    }

    private String getCourseRecordQuery() {
        return "TrainCourseRecordForBatchQuery";
    }

    private void countAttend_tmp(TrainCourseRecordCollection courseRecordCollection) {
        if (courseRecordCollection == null || courseRecordCollection.size() == 0) {
            this.txtAttendAll.setValue(null);
            return;
        }
        boolean isAct = false;
        HashSet<String> empSet = new HashSet<String>();
        if (this.promptTrainActivity.getValue() != null && this.promptTrainCourse.getValue() == null) {
            isAct = true;
        }
        int count = 0;
        int recordSize = 0;
        for (int i = 0; i < courseRecordCollection.size(); ++i) {
            TrainCourseRecordInfo info = courseRecordCollection.get(i);
            if (isAct) {
                if (empSet.contains(info.getEmployee().getId().toString())) continue;
                empSet.add(info.getEmployee().getId().toString());
                if (TrainRecordIsPassedEnum.PASSED.equals((Object)info.getActIsPassed())) {
                    ++count;
                }
            } else if (TrainRecordIsPassedEnum.PASSED.equals((Object)info.getIsPassed())) {
                ++count;
            }
            ++recordSize;
        }
        BigDecimal percent = new BigDecimal("" + count).setScale(6).divide(new BigDecimal("" + recordSize).setScale(6), 0);
        this.txtAttendAll.setValue((Object)percent.multiply(new BigDecimal("100")));
    }

    private void setEntryButton() {
        if (this.promptTrainActivity.getValue() == null && this.promptTrainCourse.getValue() == null) {
            this.btnAddRuleNew.setEnabled(false);
            this.btnDelRuleNew.setEnabled(false);
        }
    }

    private Set getPersonID() throws Exception {
        Set personIdSet = null;
        personIdSet = TrainActivityHelper.getPersonIdSet(this.promptTrainActivity, this.promptTrainCourse);
        return personIdSet;
    }

    private Set getTrainCourseRecordID() throws Exception {
        HashSet<String> recordIDSet = new HashSet<String>();
        FilterInfo filterInfo = this.getFilterInfo();
        TrainCourseRecordCollection col = TrainActivityHelper.getRecordCollection(filterInfo, null);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                TrainCourseRecordInfo info = col.get(i);
                recordIDSet.add(info.getId().toString());
            }
        }
        return recordIDSet;
    }
}

