/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainSignupParam;
import com.kingdee.eas.hr.train.client.AbstractTrainSignupFilterUI;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TrainSignupFilterUI
extends AbstractTrainSignupFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSignupFilterUI.class);

    public void onLoad() throws Exception {
        TrainSignupFilterUI.initOrgUnit(this.prtTrainActivityOrg, true);
        this.combTrainActivityState.removeItem((Object)TrainActStateEnum.NOT_EFFECTIVE);
        this.combTrainActivityState.setSelectedItem((Object)TrainActStateEnum.APPROVED);
        TrainUtils.addComboBoxEmptyItem(this.combTrainActivityState);
        this.initTrainActivity();
        super.onLoad();
        this.prtTrainActivityName.setEditable(false);
        this.prtTrainActivityNumber.setEditable(false);
        this.prtTrainActivityOrg.setEditable(false);
    }

    private void initTrainActivity() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("magroupPerson.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)30));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        filterInfo.setMaskString(" (#0 or #1) AND ( #2 OR #3 OR #4)");
        evi.setFilter(filterInfo);
        this.prtTrainActivityName.setEntityViewInfo(evi);
        this.prtTrainActivityNumber.setEntityViewInfo(evi);
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit, boolean isMultiSelected) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(isMultiSelected);
        prmtOrgUnit.setSelector((KDPromptSelector)adminF7);
    }

    public FilterInfo getFilterInfo() {
        Object[] objs;
        FilterInfo fi = new FilterInfo();
        if (this.prtTrainActivityName.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainActivityInfo)this.prtTrainActivityName.getData()).getId().toString()));
        }
        if (this.prtTrainActivityNumber.getData() != null) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)((TrainActivityInfo)this.prtTrainActivityNumber.getData()).getId().toString()));
        }
        if (this.combTrainActivityState.getSelectedIndex() != -1) {
            Object type = this.combTrainActivityState.getSelectedItem();
            if (type.equals((Object)TrainActStateEnum.NOT_EFFECTIVE)) {
                String notEffective = String.valueOf(10);
                fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)notEffective, CompareType.EQUALS));
            } else if (type.equals((Object)TrainActStateEnum.APPROVED)) {
                String approved = String.valueOf(30);
                fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)approved, CompareType.EQUALS));
            } else if (type.equals((Object)TrainActStateEnum.RUNNING)) {
                String running = String.valueOf(40);
                fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)running, CompareType.EQUALS));
            } else if (type.equals((Object)TrainActStateEnum.CLOSED)) {
                String closed = String.valueOf(50);
                fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)closed, CompareType.EQUALS));
            }
        }
        if (this.prtTrainActivityOrg.getData() != null && (objs = (Object[])this.prtTrainActivityOrg.getData()).length != 0 && objs[0] != null) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < objs.length; ++i) {
                idSet.add(((AdminOrgUnitInfo)objs[i]).getId().toString());
            }
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", idSet, CompareType.INCLUDE));
        }
        return fi;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prtTrainActivityName.getData() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.prtTrainActivityName);
        }
        if (this.prtTrainActivityNumber.getData() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.prtTrainActivityNumber);
        }
        if (this.prtTrainActivityOrg.getData() != null) {
            CustomerQueryUtil.storeToCustomerParams(cp, this.prtTrainActivityOrg);
        }
        CustomerQueryUtil.storeToCustomerParams(cp, this.combTrainActivityState);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prtTrainActivityName, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prtTrainActivityNumber, TrainActivityInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.prtTrainActivityOrg, AdminOrgUnitInfo.class.getName());
        CustomerQueryUtil.loadFromCustomerParams(cp, this.combTrainActivityState);
    }

    public Object getParam() {
        TrainSignupParam param = new TrainSignupParam();
        if (this.prtTrainActivityName.getData() != null) {
            param.setTrainActivityName(((TrainActivityInfo)this.prtTrainActivityName.getData()).getId().toString());
        }
        if (this.prtTrainActivityNumber.getData() != null) {
            String number = ((TrainActivityInfo)this.prtTrainActivityNumber.getData()).getId().toString();
            param.setTrainActivityId(number);
        }
        if (!PFUtils.isEmpty((Object)this.prtTrainActivityOrg.getData())) {
            Object[] objs = (Object[])this.prtTrainActivityOrg.getData();
            String[] orgUnitIds = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                orgUnitIds[i] = ((AdminOrgUnitInfo)objs[i]).getId().toString();
            }
            param.setOrgUnitIds(orgUnitIds);
        }
        if (this.combTrainActivityState.getSelectedItem() != null) {
            param.setTrainActivityState(this.combTrainActivityState.getSelectedItem().toString());
        }
        return param;
    }

    public void setParam(Object arg0) {
        if (!(arg0 instanceof TrainSignupParam)) {
            return;
        }
        TrainSignupParam param = (TrainSignupParam)arg0;
        try {
            TrainActivityInfo trainActivityInfo;
            if (param.getTrainActivityName() != null) {
                trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(param.getTrainActivityName()));
                this.prtTrainActivityName.setData((Object)trainActivityInfo);
            }
            if (param.getTrainActivityId() != null) {
                trainActivityInfo = TrainActivityFactory.getRemoteInstance().getTrainActivityInfo((IObjectPK)new ObjectUuidPK(param.getTrainActivityId()));
                this.prtTrainActivityNumber.setData((Object)trainActivityInfo);
            }
            if (param.getTrainActivityState() != null) {
                String state = param.getTrainActivityState();
                if (state.equals(TrainActStateEnum.NOT_EFFECTIVE.toString())) {
                    this.combTrainActivityState.setSelectedItem((Object)TrainActStateEnum.NOT_EFFECTIVE);
                } else if (state.equals(TrainActStateEnum.APPROVED.toString())) {
                    this.combTrainActivityState.setSelectedItem((Object)TrainActStateEnum.APPROVED);
                } else if (state.equals(TrainActStateEnum.RUNNING.toString())) {
                    this.combTrainActivityState.setSelectedItem((Object)TrainActStateEnum.RUNNING);
                } else if (state.equals(TrainActStateEnum.CLOSED.toString())) {
                    this.combTrainActivityState.setSelectedItem((Object)TrainActStateEnum.CLOSED);
                } else {
                    this.combTrainActivityState.setSelectedItem(null);
                }
            } else {
                this.combTrainActivityState.setSelectedIndex(-1);
            }
            String[] orgUnitIds = param.getOrgUnitIds();
            if (orgUnitIds != null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                HashSet<String> idSet = new HashSet<String>();
                for (int i = 0; i < orgUnitIds.length; ++i) {
                    idSet.add(orgUnitIds[i]);
                }
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                evi.setFilter(fi);
                AdminOrgUnitCollection orgUnitColl = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(evi);
                this.prtTrainActivityOrg.setData((Object)orgUnitColl.toArray());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.prtTrainActivityName.setData(null);
        this.prtTrainActivityNumber.setData(null);
        this.prtTrainActivityOrg.setData(null);
        this.combTrainActivityState.setSelectedIndex(-1);
    }
}

