/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.workflow.WorkflowUtils;
import com.kingdee.eas.hr.train.CodingRuleHelper;
import com.kingdee.eas.hr.train.ITrainSignupForm;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainSignupFormEntryCollection;
import com.kingdee.eas.hr.train.TrainSignupFormEntryInfo;
import com.kingdee.eas.hr.train.TrainSignupFormFactory;
import com.kingdee.eas.hr.train.TrainSignupFormInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSignupSingleEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainSignupBatchEditUI;
import com.kingdee.eas.hr.train.client.TrainSignupPersonalListUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class TrainSignupSingleEditUI
extends AbstractTrainSignupSingleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSignupSingleEditUI.class);
    static String RES = "com.kingdee.eas.hr.train.client.TrainSignResource";
    KDCheckBox checkBox;
    String ID = "id";
    String SELECTED = "selected";
    String COURSENAME = "courseName";
    String COURSENUMBER = "courseNumber";
    String TRAINSTARTENDDATE = "trainStartEndDate";
    String SIGNUPSTARTENDDATE = "signupStartEndDate";
    String COURSEHOUR = "courseHour";
    String COURSEKIND = "courseKind";
    String COURSETYPE = "courseType";
    String INSTRUCTOR = "instructor";
    String ORGUNIT = "orgUnit";
    String TRAINADDRESS = "trainAddress";
    String COURSEID = "courseID";
    HashMap oldValue;
    HashMap newValue;
    boolean selectAllCourse = false;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSignupCourse.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        this.oldValue = new HashMap();
        if (this.editData != null && this.editData.getEntrys() != null) {
            int n = this.editData.getEntrys().size();
            for (int i = 0; i < n; ++i) {
                this.oldValue.put(this.editData.getEntrys().get(i).getCourse().getId().toString(), this.editData.getEntrys().get(i));
            }
        }
    }

    public void loadFields() {
        CodingRuleHelper.setAutoNumber(this, (CoreBaseInfo)this.editData, this.txtNumber, this.getOprtState(), "IsBatch", (OrgUnitInfo)TrainClientUtil.getGroupOrg());
        super.loadFields();
        this.loadCourseEntry();
        if (!TrainClientUtil.objectIsNull(this.editData) && !TrainClientUtil.objectIsNull(this.editData.getApplier())) {
            this.loadPositionAndAdmin();
        }
        this.disposeOprtState();
        if (!TrainClientUtil.objectIsNull(this.editData) && !TrainClientUtil.objectIsNull(this.editData.getTrainAct())) {
            this.disposeSelectAllCourse();
        }
        Boolean isSelectedAll = true;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            if (isSelectedAll.equals(row.getCell(this.SELECTED).getValue())) continue;
            isSelectedAll = false;
            break;
        }
        this.kdtEntrys.getHeadRow(0).getCell(this.SELECTED).setValue((Object)isSelectedAll);
    }

    private void disposeSelectAllCourse() {
        this.checkSelectedAllCourse();
        if (this.selectAllCourse) {
            this.disableSelectedCourse();
        }
    }

    private void disableSelectedCourse() {
        this.contTrainCourse.setTitle(TrainClientUtil.getResource(RES, "selectedAllCourse"));
        this.kdtEntrys.setEditable(false);
    }

    private void checkSelectedAllCourse() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getTrainAct().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("needDivide", (Object)1, CompareType.EQUALS));
        try {
            this.selectAllCourse = TrainActivityFactory.getRemoteInstance().exists(filterInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void disposeOprtState() {
        if (OprtState.VIEW.equalsIgnoreCase(this.getOprtState()) || "FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            this.lockUIForViewStatus();
            this.setOprtState(OprtState.VIEW);
        }
    }

    private void loadPositionAndAdmin() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.editData.getApplier().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.number"));
        try {
            PositionMemberCollection collection = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                PositionMemberInfo info = collection.get(0);
                this.prmtPosition.setValue((Object)info.getPosition());
                this.prmtOrgUnit.setValue((Object)info.getPosition().getAdminOrgUnit());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("TrainAct.id"));
        sic.add(new SelectorItemInfo("AuditState"));
        sic.add(new SelectorItemInfo("IsBatch"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.Attendee.id"));
        sic.add(new SelectorItemInfo("entrys.Course.id"));
        return sic;
    }

    private void loadCourseEntry() {
        if (TrainClientUtil.objectIsNull(this.editData.getTrainAct())) {
            TrainClientUtil.showErrorMessage(RES, "trainActivityNotNull", (CoreUI)this);
        }
        IRowSet rowSet = this.getTrainActivityCourseByActivityID(this.editData.getTrainAct().getId().toString());
        this.setDefaultSelectedCourse(rowSet);
        this.mergeRowSet(rowSet);
        this.fillRowSetValueToTable(rowSet, this.kdtEntrys);
    }

    private void setDefaultSelectedCourse(IRowSet rowSet) {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            TrainSignupFormEntryCollection collection = new TrainSignupFormEntryCollection();
            PersonInfo info = SysContext.getSysContext().getCurrentUserInfo().getPerson();
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    TrainSignupFormEntryInfo formInfo = new TrainSignupFormEntryInfo();
                    formInfo.setAttendee(info);
                    TrainCourseInfo courseInfo = new TrainCourseInfo();
                    courseInfo.setId(BOSUuid.read((String)rowSet.getString(this.COURSEID)));
                    formInfo.setCourse(courseInfo);
                    collection.add(formInfo);
                }
                rowSet.beforeFirst();
            }
            catch (Exception ex) {
                this.abort(ex);
            }
            this.editData.put("entrys", (Object)collection);
            this.setDataObject((IObjectValue)this.editData);
        }
    }

    private void fillRowSetValueToTable(IRowSet rowSet, KDTable kdtEntrys) {
        kdtEntrys.checkParsed();
        kdtEntrys.removeRows();
        try {
            rowSet.beforeFirst();
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    IRow row = this.kdtEntrys.addRow(0);
                    if (this.oldValue != null && this.oldValue.containsKey(rowSet.getString(this.COURSEID))) {
                        row.getCell(this.SELECTED).setValue((Object)Boolean.TRUE);
                    } else {
                        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
                    }
                    row.getCell(this.COURSENAME).setValue((Object)rowSet.getString(this.COURSENAME));
                    row.getCell(this.COURSENUMBER).setValue((Object)rowSet.getString(this.COURSENUMBER));
                    row.getCell(this.TRAINSTARTENDDATE).setValue((Object)rowSet.getString(this.TRAINSTARTENDDATE));
                    row.getCell(this.SIGNUPSTARTENDDATE).setValue((Object)rowSet.getString(this.SIGNUPSTARTENDDATE));
                    row.getCell(this.COURSEHOUR).setValue((Object)rowSet.getString(this.COURSEHOUR));
                    row.getCell(this.COURSEKIND).setValue((Object)rowSet.getString(this.COURSEKIND));
                    row.getCell(this.COURSETYPE).setValue((Object)rowSet.getString(this.COURSETYPE));
                    row.getCell(this.INSTRUCTOR).setValue((Object)rowSet.getString(this.INSTRUCTOR));
                    row.getCell(this.ORGUNIT).setValue((Object)rowSet.getString(this.ORGUNIT));
                    row.getCell(this.TRAINADDRESS).setValue((Object)rowSet.getString(this.TRAINADDRESS));
                    row.getCell(this.COURSEID).setValue((Object)rowSet.getString(this.COURSEID));
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void mergeRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateString(this.SIGNUPSTARTENDDATE, TrainClientUtil.getStartDate2EndDateString(rowSet.getDate("signStartDate"), rowSet.getDate("signEndDate"), TrainClientUtil.getResource(RES, "startEndDateSeperate")));
                rowSet.updateString(this.TRAINSTARTENDDATE, TrainClientUtil.getStartDate2EndDateString(rowSet.getDate("trainActCourse.StartDate"), rowSet.getDate("trainActCourse.EndDate"), TrainClientUtil.getResource(RES, "startEndDateSeperate")));
                rowSet.updateString(this.COURSEHOUR, TrainClientUtil.getHourUnitString(rowSet.getObject("trainActCourse.CourseHour"), rowSet.getObject("trainActCourse.CourseHourUnit")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    private IRowSet getTrainActivityCourseByActivityID(String id) {
        if (id == null) {
            return null;
        }
        IRowSet rowSet = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActivityForSignupFormEditUIQuery"));
        iqec.setObjectView(viewInfo);
        try {
            rowSet = iqec.executeQuery();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return rowSet;
    }

    public void storeFields() {
        super.storeFields();
        this.storeCourseEntry();
    }

    private void storeCourseEntry() {
        this.newValue = new HashMap();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            if (!((Boolean)row.getCell(this.SELECTED).getValue()).booleanValue()) continue;
            if (this.oldValue.containsKey(row.getCell(this.COURSEID).getValue().toString())) {
                this.newValue.put(row.getCell(this.COURSEID).getValue().toString(), this.oldValue.get(row.getCell(this.COURSEID).getValue().toString()));
                continue;
            }
            TrainSignupFormEntryInfo info = new TrainSignupFormEntryInfo();
            TrainCourseInfo courseInfo = new TrainCourseInfo();
            courseInfo.setId(BOSUuid.read((String)row.getCell(this.COURSEID).getValue().toString()));
            info.setCourse(courseInfo);
            info.setAttendee(SysContext.getSysContext().getCurrentUserInfo().getPerson());
            this.newValue.put(row.getCell(this.COURSEID).getValue().toString(), info);
        }
        Iterator iterator = this.newValue.entrySet().iterator();
        TrainSignupFormEntryCollection collection = new TrainSignupFormEntryCollection();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            collection.add((TrainSignupFormEntryInfo)entry.getValue());
        }
        for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
            this.editData.getEntrys().removeObject(i);
        }
        this.editData.put("entrys", (Object)collection);
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.txtName.setEditable(false);
        this.txtNumber.setEditable(false);
        this.kdtEntrys.setEnabled(false);
        this.btnSubmit.setEnabled(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.btnSignupCourse.setEnabled(true);
        this.txtName.setEditable(true);
        this.txtNumber.setEditable(true);
        this.kdtEntrys.setEnabled(true);
        this.btnSubmit.setEnabled(true);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
    }

    public IObjectPK runSave() throws Exception {
        IObjectPK objectPK = super.runSave();
        return objectPK;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = ((ITrainSignupForm)this.getBizInterface()).submit3(this.editData);
        this.updateState();
        return objectPK;
    }

    private void updateState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.VIEW);
        }
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        super.afterSubmitEdit(pk);
        this.setOprtState(OprtState.VIEW);
    }

    protected IObjectValue createNewData() {
        TrainSignupFormInfo objectValue = new TrainSignupFormInfo();
        if (!TrainClientUtil.objectIsNull(SysContext.getSysContext().getCurrentUserInfo().getPerson())) {
            objectValue.setApplier(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        }
        objectValue.setName(TrainClientUtil.getResource(RES, "trainSignupSingleName"));
        objectValue.setAuditState(TrainAuditStateEnum.AUDITING);
        objectValue.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        objectValue.setIsBatch(false);
        objectValue.setTrainAct(this.fetchTrainActivityFromUIContext());
        if (TrainUtils.getCurrentUser().getPerson() != null) {
            objectValue.setOrgUnit(TrainActivityHelper.getAdminOrgUnit(TrainUtils.getCurrentUser().getPerson().getId().toString()));
        }
        return objectValue;
    }

    private TrainActivityInfo fetchTrainActivityFromUIContext() {
        String id = (String)this.getUIContext().get("trainActivity");
        TrainActivityInfo info = new TrainActivityInfo();
        if (!TrainClientUtil.objectIsNull(id)) {
            info.setId(BOSUuid.read((String)id));
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSignupFormFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidHRO((CoreUI)this);
        TrainClientUtil.checkValidPerson((CoreUI)this);
        Object billId = this.getUIContext().get("ID");
        if (billId != null) {
            TrainSignupFormInfo info = TrainSignupFormFactory.getRemoteInstance().getTrainSignupFormInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
            if (info.isIsBatch()) {
                IUIWindow uiWindow = UIFactory.createUIFactory().create(TrainSignupBatchEditUI.class.getName(), this.getUIContext(), null, this.getOprtState());
                uiWindow.show();
                SysUtil.abort();
            } else {
                this.initTableSelectedRow();
                super.onLoad();
                this.setTableDisEnabled();
            }
        } else {
            this.initTableSelectedRow();
            super.onLoad();
            this.setTableDisEnabled();
        }
    }

    private void setTableDisEnabled() {
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.getColumn(this.COURSENAME).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.COURSENUMBER).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.TRAINSTARTENDDATE).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.SIGNUPSTARTENDDATE).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.COURSEHOUR).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.COURSEKIND).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.COURSETYPE).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.INSTRUCTOR).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.ORGUNIT).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.TRAINADDRESS).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
        this.kdtEntrys.getColumn(this.COURSEID).getStyleAttributes().setBackground(TrainClientUtil.disableColor);
    }

    private void initTableSelectedRow() {
        this.kdtEntrys.checkParsed();
        this.checkBox = new KDCheckBox();
        KDTDefaultCellEditor checkBoxEditor = new KDTDefaultCellEditor((JCheckBox)this.checkBox);
        this.kdtEntrys.getInputMap().remove(KeyStroke.getKeyStroke(127, 0));
        this.kdtEntrys.getInputMap().remove(KeyStroke.getKeyStroke(8, 0));
        this.kdtEntrys.getHeadRow(0).getCell(this.SELECTED).setEditor((ICellEditor)checkBoxEditor);
        this.kdtEntrys.getHeadRow(0).getCell(this.SELECTED).getStyleAttributes().setLocked(false);
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TrainSignupSingleEditUI.this.checkBox_actionPerformed(e);
                }
                catch (Exception e1) {
                    TrainSignupSingleEditUI.this.handUIException(e1);
                }
            }
        });
    }

    private void checkBox_actionPerformed(ActionEvent e) {
        if (((Boolean)this.kdtEntrys.getHeadRow(0).getCell(this.SELECTED).getValue()).booleanValue()) {
            this.kdtEntrys.getHeadRow(0).getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
            this.setSelectedValue(this.kdtEntrys, Boolean.FALSE);
        } else {
            this.kdtEntrys.getHeadRow(0).getCell(this.SELECTED).setValue((Object)Boolean.TRUE);
            this.setSelectedValue(this.kdtEntrys, Boolean.TRUE);
        }
    }

    private void setSelectedValue(KDTable table, Boolean flag) {
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            row.getCell(this.SELECTED).setValue((Object)flag);
        }
    }

    public void actionSignupCourse_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignupCourse_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"trainActivity", (Object)this.editData.getTrainAct().getId().toString());
        uiContext.put((Object)"person", (Object)this.editData.getApplier().getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainSignupPersonalListUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData != null && (this.editData.getEntrys() == null || this.editData.getEntrys().size() == 0)) {
            TrainClientUtil.showErrorMessage(RES, "selectedCourseNotNull", (CoreUI)this);
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Submit_OK"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent arg0) throws Exception {
        WorkflowUtils.viewWorkFlowGraph((CoreBaseInfo)this.editData, (CoreUIObject)this, (String)"com.kingdee.eas.hr.train.app.TrainSignupFunction", (String)"ActionSubmit");
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return super.isModify();
        }
        return false;
    }

    public IUIActionPostman prepareInit() {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        PersonInfo pInfo = SysContext.getSysContext().getCurrentUserInfo().getPerson();
        if (pInfo != null) {
            request.put("personId", (Object)pInfo.getId().toString());
        }
        if (this.getUIContext().get("trainActivity") != null) {
            request.put("activityId", this.getUIContext().get("trainActivity"));
        }
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

