/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.train.StudentTypeEnum;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainStudentF7UI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainStudentF7UI
extends AbstractTrainStudentF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TrainStudentF7UI.class);
    private PersonCollection personCollection = new PersonCollection();
    protected boolean isCanceled = true;
    private static final String resourcePath = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private EntityViewInfo currentViewInfo;
    private CommonQueryDialog dialog = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblSelected.checkParsed();
        this.initComboTrainActivityStatus();
        this.initWorkButton();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblSelected.getSelectManager().setSelectMode(10);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        JButton btnAddOne = this.contSelectedStudent.add((Action)((Object)this.actionAddOne));
        JButton btnDelOne = this.contSelectedStudent.add((Action)((Object)this.actionDelOne));
        JButton btnAddAll = this.contSelectedStudent.add((Action)((Object)this.actionAddAll));
        JButton btnDelAll = this.contSelectedStudent.add((Action)((Object)this.actionDelAll));
        btnAddOne.setText(EASResource.getString((String)resourcePath, (String)"addLine"));
        btnDelOne.setText(EASResource.getString((String)resourcePath, (String)"removeLine"));
        btnAddAll.setText(EASResource.getString((String)resourcePath, (String)"addAll"));
        btnDelAll.setText(EASResource.getString((String)resourcePath, (String)"removeAll"));
    }

    public PersonCollection getPersonCollection() {
        return this.personCollection;
    }

    public void setPersonCollection(PersonCollection personCollection) {
        this.personCollection = personCollection;
    }

    private void initComboTrainActivityStatus() {
        TrainUtils.addComboBoxEmptyItem(this.comboTrainActivityStatus);
        this.comboTrainActivityStatus.setActionCommand("INIT");
        this.comboTrainActivityStatus.addItems(TrainActStateEnum.getEnumList().toArray());
        this.comboTrainActivityStatus.setActionCommand(null);
        this.comboTrainActivityStatus.setSelectedIndex(0);
    }

    protected void comboTrainActivityStatus_actionPerformed(ActionEvent e) throws Exception {
        super.comboTrainActivityStatus_actionPerformed(e);
        if (this.comboTrainActivityStatus.getActionCommand() != null) {
            return;
        }
        TrainActStateEnum status = (TrainActStateEnum)((Object)this.comboTrainActivityStatus.getSelectedItem());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)((String)this.getUIContext().get("TrainActivityID")), CompareType.NOTEQUALS));
        if (status != null) {
            fi.getFilterItems().add(new FilterItemInfo("trainActState", (Object)status.getValue()));
        }
        fi.mergeFilter(TrainUtils.getHROrgUnitFilter("HrOrgUnit.id"), "AND");
        evi.setFilter(fi);
        this.prmtTrainActivity.setEntityViewInfo(evi);
    }

    protected void comboTrainActivityStatus_itemStateChanged(ItemEvent e) throws Exception {
        this.tblMain.removeRows(false);
        this.prmtTrainActivity.setValue(null);
    }

    protected void comboType_actionPerformed(ActionEvent e) throws Exception {
        super.comboType_actionPerformed(e);
        this.executeQueryStudent();
    }

    protected void prmtTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTrainActivity_dataChanged(e);
        this.executeQueryStudent();
    }

    private void executeQueryStudent() {
        TrainActivityInfo info = (TrainActivityInfo)this.prmtTrainActivity.getData();
        if (info != null) {
            StudentTypeEnum type = (StudentTypeEnum)((Object)this.comboType.getSelectedItem());
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)info.getId().toString()));
            if (!type.equals((Object)StudentTypeEnum.ALL)) {
                fi.getFilterItems().add(new FilterItemInfo("trainSC.Type", (Object)type.getValue()));
            }
            evi.setFilter(fi);
            this.setDataObject((IObjectValue)evi);
            this.currentViewInfo = evi;
            this.execQuery();
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (this.currentViewInfo != null && this.currentViewInfo.getFilter() != null) {
            return this.currentViewInfo.getFilter();
        }
        return super.getDefaultFilterForQuery();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionAddOne_actionPerformed(null);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionDelOne_actionPerformed(null);
        } else {
            super.tblSelected_tableClicked(e);
        }
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        int size = this.tblSelected.getRowCount();
        if (size > 0) {
            IRow row = null;
            for (int i = 0; i < size; ++i) {
                row = this.tblSelected.getRow(i);
                PersonInfo info = new PersonInfo();
                info.setId(BOSUuid.read((String)row.getCell("Person.id").getValue().toString()));
                this.personCollection.add(info);
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            if (!this.existInSelectedPerson(row.getCell("Person.id").getValue().toString())) {
                this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            }
            this.tblMain.removeRow(i);
        }
    }

    private boolean existInSelectedPerson(String personId) {
        IRow row = null;
        int count = this.tblSelected.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblSelected.getRow(i);
            if (!personId.equals(row.getCell("Person.id").getValue().toString())) continue;
            return true;
        }
        return false;
    }

    public void actionAddOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblMain.getRow(rowIndex);
            if (!this.existInSelectedPerson(row.getCell("Person.id").getValue().toString())) {
                this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            }
            this.tblMain.removeRow(rowIndex);
        }
    }

    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelAll_actionPerformed(e);
        IRow row = null;
        for (int i = this.tblSelected.getRowCount() - 1; i >= 0; --i) {
            row = this.tblSelected.getRow(i);
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(i);
        }
    }

    public void actionDelOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelOne_actionPerformed(e);
        List rowIndexList = TrainUtils.getSelectedRows(this.tblSelected);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblSelected.getRow(rowIndex);
            this.tblMain.addRow(this.tblMain.getRowCount(), row);
            this.tblSelected.removeRow(rowIndex);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery;
        if (TrainClientUtil.objectIsNull(this.prmtTrainActivity.getValue())) {
            this.prmtTrainActivity.requestFocus();
            TrainClientUtil.showErrorMessage(resourcePath, "prmtTrainActivityNotNull", (CoreUI)this);
        }
        if (!this.isPerformDefaultQuery(iQuery = QuerySolutionFacadeFactory.getRemoteInstance(), queryName = TrainStudentF7UI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.dialog == null) {
                this.dialog = this.initCommonQueryDialog();
            }
            this.dialog.setShowSorter(false);
            if (this.dialog.show()) {
                this.mainQuery = this.getEntityViewInfo(this.dialog.getEntityViewInfoResult());
                this.refreshList();
            } else {
                SysUtil.abort();
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }
}

