/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainStudentInfoF7UI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainStudentInfoF7UI
extends AbstractTrainStudentInfoF7UI {
    private static final Logger logger = CoreUIObject.getLogger(TrainStudentInfoF7UI.class);
    private Collection selectedCollection;
    private boolean cancel = true;
    private EntityViewInfo customViewInfo = new EntityViewInfo();
    private String source;
    private static final String resourcePath = "com.kingdee.eas.hr.train.client.TrainSysResource";

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.tblSelected.checkParsed();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.all.setSelected(true);
        this.all_actionPerformed(null);
    }

    protected void initWorkButton() {
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        JButton btnAddOne = this.contSelectedStudent.add((Action)((Object)this.actionAddOne));
        JButton btnDelOne = this.contSelectedStudent.add((Action)((Object)this.actionDelOne));
        JButton btnAddAll = this.contSelectedStudent.add((Action)((Object)this.actionAddAll));
        JButton btnDelAll = this.contSelectedStudent.add((Action)((Object)this.actionDelAll));
        btnAddOne.setText(EASResource.getString((String)resourcePath, (String)"addLine"));
        btnDelOne.setText(EASResource.getString((String)resourcePath, (String)"removeLine"));
        btnAddAll.setText(EASResource.getString((String)resourcePath, (String)"addAll"));
        btnDelAll.setText(EASResource.getString((String)resourcePath, (String)"removeAll"));
        this.btnQueryScheme.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionAddOne_actionPerformed(null);
        }
    }

    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.actionDelOne_actionPerformed(null);
        }
    }

    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            if (this.existInSelectedPerson(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
        }
    }

    private boolean existInSelectedPerson(String personId) {
        IRow row = null;
        int count = this.tblSelected.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblSelected.getRow(i);
            if (!personId.equals(row.getCell("id").getValue().toString())) continue;
            return true;
        }
        return false;
    }

    public void actionAddOne_actionPerformed(ActionEvent e) throws Exception {
        List rowIndexList = TrainUtils.getSelectedRows(this.tblMain);
        IRow row = null;
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            row = this.tblMain.getRow(rowIndex);
            if (this.existInSelectedPerson(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
        }
    }

    public void actionDelAll_actionPerformed(ActionEvent e) throws Exception {
        this.tblSelected.removeRows();
    }

    public void actionDelOne_actionPerformed(ActionEvent e) throws Exception {
        List rowIndexList = TrainUtils.getSelectedRows(this.tblSelected);
        for (int i = rowIndexList.size() - 1; i >= 0; --i) {
            int rowIndex = (Integer)rowIndexList.get(i);
            this.tblSelected.removeRow(rowIndex);
        }
    }

    public Object getData() {
        Object[] objs = null;
        if (this.selectedCollection != null && this.selectedCollection.size() > 0) {
            objs = this.selectedCollection.toArray();
        }
        return objs;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblSelected.getRowCount();
        if (size > 0) {
            this.selectedCollection = new ArrayList();
            IRow row = null;
            for (int i = 0; i < size; ++i) {
                row = this.tblSelected.getRow(i);
                PersonInfo info = new PersonInfo();
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                this.selectedCollection.add(info);
            }
            this.cancel = false;
            this.getUIWindow().close();
        }
    }

    protected void btnCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = true;
        this.getUIWindow().close();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = TrainStudentInfoF7UI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && !this.isFirstDefaultQuery()) {
            CommonQueryDialog dialog = this.initCommonQueryDialog();
            dialog.setShowSorter(false);
            if (dialog.show()) {
                if (this.mainQuery.getSorter() != null) {
                    this.mainQuery.getSorter().clear();
                }
                this.customViewInfo = dialog.getEntityViewInfoResult();
                this.executePersonQuery();
            } else {
                SysUtil.abort();
            }
        }
    }

    protected void all_actionPerformed(ActionEvent e) throws Exception {
        this.executePersonQuery();
    }

    protected void mustSelect_actionPerformed(ActionEvent e) throws Exception {
        this.executePersonQuery();
    }

    protected void noMustSelect_actionPerformed(ActionEvent e) throws Exception {
        this.executePersonQuery();
    }

    private void executePersonQuery() throws Exception {
        ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

            public void run() throws Exception {
                TrainStudentInfoF7UI.this.executeQuery();
            }
        };
        new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
    }

    private void executeQuery() throws BOSException, Exception {
        EntityViewInfo viewInfo = (EntityViewInfo)this.customViewInfo.clone();
        FilterInfo filterInfo = this.getQueryFilter();
        if (FilterUtility.hasFilterItem((FilterInfo)this.customViewInfo.getFilter())) {
            viewInfo.getFilter().mergeFilter(filterInfo, "AND");
        } else {
            viewInfo.setFilter(filterInfo);
        }
        IRowSet rowSet = TrainActivityHelper.getRowSet("TrainPersonQuery", viewInfo);
        this.fillTable(rowSet);
    }

    private void fillTable(IRowSet rowSet) throws SQLException {
        this.tblMain.removeRows();
        while (rowSet.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("name").setValue((Object)rowSet.getString("name"));
            row.getCell("number").setValue((Object)rowSet.getString("number"));
            row.getCell("gender").setValue((Object)rowSet.getString("gender"));
            row.getCell("positionName").setValue((Object)rowSet.getString("Position.name"));
            row.getCell("jobName").setValue((Object)rowSet.getString("Job.name"));
            row.getCell("technicalPostName").setValue((Object)rowSet.getString("TechnialPost.name"));
            row.getCell("jobGradeName").setValue((Object)rowSet.getString("jobGrade.name"));
            row.getCell("orgUnitName").setValue((Object)rowSet.getString("AdminOrgUnit.name"));
            row.getCell("degreeName").setValue((Object)rowSet.getString("diploma.name"));
            row.getCell("email").setValue((Object)rowSet.getString("email"));
            row.getCell("officePhone").setValue((Object)rowSet.getString("officePhone"));
            row.getCell("cell").setValue((Object)rowSet.getString("cell"));
            row.getCell("id").setValue((Object)rowSet.getString("id"));
        }
    }

    private FilterInfo getQueryFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            Set personIds = null;
            List courseIds = (List)this.getUIContext().get("trainCourseList");
            if (courseIds != null && courseIds.size() > 0) {
                String isRequired = null;
                if (this.mustSelect.isSelected()) {
                    isRequired = "true";
                } else if (this.noMustSelect.isSelected()) {
                    isRequired = "false";
                } else {
                    this.all.setSelected(true);
                }
                if ("StudentAssign".equals(this.getSource())) {
                    personIds = TrainActivityFacadeFactory.getRemoteInstance().getCoursePerson(courseIds, isRequired);
                } else if ("MessagePublish".equals(this.getSource())) {
                    personIds = TrainActivityFacadeFactory.getRemoteInstance().getAllCoursePerson(courseIds, isRequired);
                }
            }
            if (personIds != null && personIds.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(personIds), CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", null));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filterInfo;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected String getSource() {
        return this.source;
    }

    protected void setSource(String source) {
        this.source = source;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }
}

