/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainActCostSummaryCollection;
import com.kingdee.eas.hr.train.TrainActCostSummaryFactory;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryCollection;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryInfo;
import com.kingdee.eas.hr.train.TrainAuditStatusEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainEvaluLevelCollection;
import com.kingdee.eas.hr.train.TrainEvaluLevelFactory;
import com.kingdee.eas.hr.train.TrainEvaluLevelInfo;
import com.kingdee.eas.hr.train.TrainSummaryCollection;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSummaryEditUI;
import com.kingdee.eas.hr.train.client.ComBoxInfo;
import com.kingdee.eas.hr.train.client.TrainActivityCostSummaryUI;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseSummaryUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainSummaryEditUI
extends AbstractTrainSummaryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSummaryEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSummaryResource";
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";
    private boolean isLoadField = false;

    public void loadFields() {
        this.isLoadField = true;
        super.loadFields();
        this.loadTrainEvaluLevel();
        this.clearInitValue();
        this.initWorkButtonState();
        this.changeTrainActivityView();
        this.setActRelativePerson();
        this.isLoadField = false;
    }

    private void setActRelativePerson() {
        if (this.kdtActRelativer.getRowCount() > 0) {
            HashSet<String> personIds = new HashSet<String>();
            PersonInfo personInfo = null;
            int count = this.kdtActRelativer.getRowCount();
            for (int i = 0; i < count; ++i) {
                personInfo = (PersonInfo)this.kdtActRelativer.getRow(i).getCell("person").getValue();
                if (TrainCommonUtils.isEmpty((CoreBaseInfo)personInfo)) continue;
                personIds.add(personInfo.getId().toString());
            }
            if (personIds.size() > 0) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
                try {
                    IRowSet rowSet = TrainActivityHelper.getRowSet("PersonPositionAdminQuery", filterInfo);
                    this.setActRelativePerson(rowSet);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }

    private void setActRelativePerson(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return;
        }
        Map personInfos = this.rowSetToMap(rowSet);
        IRow row = null;
        PersonInfo personInfo = null;
        Map personMap = null;
        int size = this.kdtActRelativer.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtActRelativer.getRow(i);
            personInfo = (PersonInfo)row.getCell("person").getValue();
            if (TrainCommonUtils.isEmpty((CoreBaseInfo)personInfo) || (personMap = (Map)personInfos.get(personInfo.getId().toString())) == null) continue;
            row.getCell("adminOrgUnit").setValue(personMap.get("orgUnit"));
            row.getCell("position").setValue(personMap.get("positionName"));
        }
    }

    private Map rowSetToMap(IRowSet rowSet) throws SQLException {
        HashMap map = null;
        if (rowSet != null) {
            map = new HashMap();
            rowSet.beforeFirst();
            HashMap<String, String> row = null;
            while (rowSet.next()) {
                row = new HashMap<String, String>();
                row.put("positionName", rowSet.getString("positionName"));
                row.put("orgUnit", rowSet.getString("orgUnit"));
                map.put(rowSet.getString("id"), row);
            }
            rowSet.beforeFirst();
        }
        return map;
    }

    private void initWorkButtonState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnAttach.setEnabled(false);
            this.btnCourseSummary.setEnabled(false);
            this.btnChargelist.setEnabled(false);
            this.menuAttach.setEnabled(false);
            this.menuCourse.setEnabled(false);
        } else {
            this.btnAttach.setEnabled(true);
            this.btnCourseSummary.setEnabled(true);
            this.btnChargelist.setEnabled(true);
            this.menuAttach.setEnabled(true);
            this.menuCourse.setEnabled(true);
        }
        this.btnAttachment.setVisible(false);
        String state = this.getOprtState();
        this.actionEdit.setEnabled(true);
        if (OprtState.ADDNEW.equals(state) || OprtState.EDIT.equals(state)) {
            this.actionEdit.setEnabled(false);
        } else if (OprtState.VIEW.equals(state) && TrainAuditStatusEnum.AUDITED.equals((Object)this.editData.getAuditState())) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
        }
    }

    private void clearInitValue() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.pkTrainAStartDate.setValue(null);
            this.pkTrainAEndDate.setValue(null);
        }
    }

    private void loadTrainEvaluLevel() {
        if (!TrainClientUtil.objectIsNull(this.editData.getTrainActEvalu())) {
            String id = this.editData.getTrainActEvalu().getId().toString();
            for (int j = this.comboActEvalu.getItemCount() - 1; j > -1; --j) {
                TrainEvaluLevelInfo trainEvaluLevelinfo = (TrainEvaluLevelInfo)((ComBoxInfo)this.comboActEvalu.getItemAt(j)).getobjInfo();
                if (!id.equals(trainEvaluLevelinfo.getId().toString())) continue;
                this.comboActEvalu.setSelectedIndex(j);
            }
        } else {
            this.comboActEvalu.setSelectedItem(null);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttach.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnCourseSummary.setIcon(EASResource.getIcon((String)"imgTbtn_coursesummarize"));
        this.menuAttach.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.menuCourse.setIcon(EASResource.getIcon((String)"imgTbtn_coursesummarize"));
        this.setButtonDefaultStyl(this.btnAttach);
        this.btnChargelist.setEnabled(true);
    }

    public void storeFields() {
        super.storeFields();
        this.storeTrainEvaluLevel();
    }

    private void storeTrainEvaluLevel() {
        if (!TrainClientUtil.objectIsNull(this.comboActEvalu.getSelectedItem())) {
            this.editData.setTrainActEvalu((TrainEvaluLevelInfo)((ComBoxInfo)this.comboActEvalu.getSelectedItem()).getobjInfo());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.activityChanged()) {
            if (TrainClientUtil.showConfirmMessge(RES, "activityChange", (CoreUI)this)) {
                if (this.isPrepareActionSubmit()) {
                    RequestContext request = new RequestContext();
                    request.put("realSubmit", (Object)Boolean.TRUE);
                    IUIActionPostman handler = this.prepareAction((IItemAction)this.actionSubmit);
                    handler.setRequestContext((Serializable)request);
                    handler.callHandler();
                }
                super.actionSubmit_actionPerformed(e);
            }
        } else {
            super.actionSubmit_actionPerformed(e);
        }
    }

    private boolean activityChanged() throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            return false;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)this.editData.getTrainActivity().getId().toString(), CompareType.EQUALS));
        return !TrainSummaryFactory.getRemoteInstance().exists(filterInfo);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
        this.kdtActRelativer.getStyleAttributes().setLocked(false);
    }

    private void checkCanEdit() throws Exception {
        if (this.editData == null || TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "dataNotExist", (CoreUI)this);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)60));
            if (!TrainSummaryFactory.getRemoteInstance().exists(filterInfo)) {
                TrainClientUtil.showErrorMessage(RES, "alreadyAudit", (CoreUI)this);
            }
        }
    }

    protected String getEditUIName() {
        return TrainSummaryEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSummaryFactory.getRemoteInstance();
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.pkStartDate.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.txtSummary.setEditable(false);
        this.kdtActRelativer.getStyleAttributes().setLocked(false);
    }

    protected void unLockUI() {
        super.unLockUI();
        this.pkStartDate.setEnabled(true);
        this.pkEndDate.setEnabled(true);
        this.txtSummary.setEditable(true);
        this.kdtActRelativer.getStyleAttributes().setLocked(true);
    }

    protected IObjectValue createNewData() {
        TrainSummaryInfo objectValue = new TrainSummaryInfo();
        objectValue.setAuditState(TrainAuditStatusEnum.UNAUDITED);
        objectValue.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return objectValue;
    }

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidHRO((CoreUI)this);
        this.initTrainEvaluLevel();
        super.onLoad();
        this.prmtTrainActivity.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                TrainSummaryEditUI.this.changeTrainActivityView();
            }
        });
        this.initTrainActivityF7();
        this.initFormattedTextDisplayFormatter();
        this.initFormattedTextRange();
        this.initKdtActRelativer();
    }

    private void initKdtActRelativer() throws Exception {
        KDFormattedTextField txtEvalu = new KDFormattedTextField();
        txtEvalu.setHorizontalAlignment(4);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtActRelativer, txtEvalu, "evalu", TrainClientUtil.PRECISION);
        KDFormattedTextField txtEvaluRate = new KDFormattedTextField();
        txtEvaluRate.setHorizontalAlignment(4);
        TrainUtils.setTableCellEditorByFormattedTextField(this.kdtActRelativer, txtEvaluRate, "evaluRate", TrainClientUtil.PRECISION);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtEvalu);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(txtEvaluRate);
        TrainUtils.setTableCellEditorByTextField(this.kdtActRelativer, "comment", 400);
        TrainClientUtil.setDisableColor(this.kdtActRelativer);
    }

    private void initFormattedTextRange() {
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.kdFormattedTextBudget);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtRealCost);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtActScore);
        TrainClientUtil.setFormattedTextFieldMaxMinValue(this.txtDeptScore);
    }

    private void changeTrainActivityView() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("HrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        TrainSummaryCollection collection = null;
        try {
            collection = TrainSummaryFactory.getRemoteInstance().getTrainSummaryCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        HashSet<String> set = new HashSet<String>();
        if (collection != null && collection.size() > 0) {
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                set.add(collection.get(i).getTrainActivity().getId().toString());
            }
        }
        viewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        try {
            filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HrOrgUnit.id", (String)"belongOrgUnit.id"), "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.NOTINCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtTrainActivity.setEntityViewInfo(viewInfo);
    }

    private void initFormattedTextDisplayFormatter() {
        this.txtRealCost.setSupportedEmpty(true);
        TrainClientUtil.setBigDecimalDisplayFormatter(this.kdFormattedTextBudget, TrainClientUtil.PRECISION);
        TrainClientUtil.setBigDecimalDisplayFormatter(this.txtRealCost, TrainClientUtil.PRECISION);
    }

    private void initTrainActivityF7() {
        this.prmtTrainActivity.setQueryInfo("com.kingdee.eas.hr.train.app.TrainActivityForTrainSummaryQuery");
    }

    private void initTrainEvaluLevel() {
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        try {
            TrainEvaluLevelCollection collection = TrainEvaluLevelFactory.getRemoteInstance().getTrainEvaluLevelCollection(evi);
            Object[] comboxInfos = new ComBoxInfo[collection.size()];
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                comboxInfos[i] = new ComBoxInfo((IObjectValue)collection.get(i));
            }
            this.comboActEvalu.setActionCommand("INIT");
            this.comboActEvalu.removeAllItems();
            this.comboActEvalu.addItems(comboxInfos);
            this.comboActEvalu.setActionCommand(null);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private EntityViewInfo getTrainEvaluLevelEntityViewInfo() {
        EntityViewInfo evi = TrainUtils.getCurrentHREntityViewInfo();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        return evi;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("TrainActEvalu.id"));
        sic.add(new SelectorItemInfo("AuditState"));
        sic.add(new SelectorItemInfo("HrOrgUnit.id"));
        sic.add(new SelectorItemInfo("trainActCostSummary.id"));
        return sic;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Date endDate;
        Date startDate;
        super.beforeStoreFields(e);
        if (TrainClientUtil.objectIsNull(this.prmtTrainActivity.getValue())) {
            this.prmtTrainActivity.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "trainActivityNotNull", (CoreUI)this);
        }
        if (!TrainClientUtil.objectIsNull(this.pkStartDate.getValue()) && !TrainClientUtil.objectIsNull(this.pkEndDate.getValue()) && (startDate = (Date)this.pkStartDate.getValue()).after(endDate = (Date)this.pkEndDate.getValue())) {
            this.pkStartDate.requestFocus();
            TrainClientUtil.showErrorMessage(RES, "startDateMustBeforeEndDate", (CoreUI)this);
        }
    }

    public IObjectPK runSave() throws Exception {
        IObjectPK objectPK = super.runSave();
        return objectPK;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        this.updateState();
        return objectPK;
    }

    private void updateState() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    public void prmtTrainActivity_Changed() throws Exception {
        if (this.isLoadField) {
            return;
        }
        super.prmtTrainActivity_Changed();
        this.txtTrainAOrgUnit.setText(UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.prmtTrainActivity.getData()), (String)"orgUnit.name")));
        this.kdFormattedTextBudget.setValue((Object)UIRuleUtil.getBigDecimal((Object)UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.prmtTrainActivity.getData()), (String)"BudgetCost")));
        this.setSummaryScoreAndEval((TrainActivityInfo)this.prmtTrainActivity.getData());
    }

    private void setSummaryScoreAndEval(TrainActivityInfo trainActivity) {
        TrainUtils.removeRows(this.kdtActRelativer);
        try {
            if (trainActivity != null) {
                Map map = TrainSummaryFactory.getRemoteInstance().getSummaryRelativeInfo(trainActivity.getId().toString());
                this.txtActScore.setValue((Object)((BigDecimal)map.get("activityAverageActScore")));
                this.txtDeptScore.setValue((Object)((BigDecimal)map.get("activityAverageDeptScore")));
                this.comboResponserEval.setSelectedItem(map.get("activityResponserEval"));
                TrainActivityOrganigerEntryCollection collection = (TrainActivityOrganigerEntryCollection)((Object)map.get("activityOrgeniger"));
                if (collection != null && collection.size() > 0) {
                    TrainActivityOrganigerEntryInfo info = null;
                    IRow row = null;
                    int size = collection.size();
                    for (int i = 0; i < size; ++i) {
                        row = this.kdtActRelativer.addRow();
                        info = collection.get(i);
                        row.getCell("actRelativer").setValue((Object)info);
                        row.getCell("role").setValue((Object)info.getRole());
                        row.getCell("person").setValue((Object)info.getOrganiger());
                        if (info.getOrganiger() == null) continue;
                        row.getCell("personNumber").setValue((Object)info.getOrganiger().getNumber());
                    }
                }
                this.setActRelativePerson((IRowSet)map.get("person"));
                this.txtBelongUnit.setText(trainActivity.getBelongOrgUnit().getName());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void actionAttach_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttach_actionPerformed(e);
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanAttachment", (CoreUI)this);
        }
        if (TrainAuditStatusEnum.AUDITED.equals((Object)this.editData.getAuditState())) {
            AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, false);
        } else {
            AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this);
        }
    }

    public void actionTrainActCostSum_actionPerformed(ActionEvent e) throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            if (OprtState.VIEW.equals(this.getOprtState())) {
                TrainClientUtil.showErrorMessage(RES, "noTrainActivityCostSummaryUI", (CoreUI)this);
            } else {
                TrainClientUtil.showErrorMessage(RES, "mustSave", (CoreUI)this);
            }
        }
        String total = null;
        total = UIRuleUtil.isNotNull((BigDecimal)this.editData.getTrainActivity().getBudgetCost()) ? this.editData.getTrainActivity().getBudgetCost().toString() : "0.00";
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.editData.getId());
        uiContext.put((Object)"trainActivity", (Object)this.editData.getTrainActivity().getId().toString());
        uiContext.put((Object)"costTotal", (Object)total);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainActivityCostSummaryUI.class.getName(), (Map)uiContext, null, this.oprtState);
        uiWindow.show();
        if (uiWindow.getUIObject().getUIContext().get("needReback") != null && ((Boolean)uiWindow.getUIObject().getUIContext().get("needReback")).booleanValue()) {
            this.txtRealCost.setValue(uiWindow.getUIObject().getUIContext().get("newValue"));
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainSummaryID", (Object)this.editData.getId().toString()));
        evi.setFilter(fi);
        TrainActCostSummaryCollection costCol = TrainActCostSummaryFactory.getRemoteInstance().getTrainActCostSummaryCollection(evi);
        this.editData.put("trainActCostSummary", (Object)costCol);
    }

    public void actionCourseSummary_actionPerformed(ActionEvent e) throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanCourseSummary", (CoreUI)this);
        }
        if (this.editData.getTrainActivity() != null) {
            String trainActivityId = this.editData.getTrainActivity().getId().toString();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity", (Object)trainActivityId));
            if (!TrainActCourseFactory.getRemoteInstance().exists(fi)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NotExistTrainActCourse"));
                SysUtil.abort();
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        if (TrainAuditStatusEnum.AUDITED.equals((Object)this.editData.getAuditState())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)this.editData.getTrainActivity().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("TrainSummary.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            if (!TrainCourseSummaryFactory.getRemoteInstance().exists(filter)) {
                TrainClientUtil.showErrorMessage(RES, "noResponseTrainCourseSummary", (CoreUI)this);
            }
            uiContext.put((Object)"onlyView", (Object)"true");
        }
        uiContext.put((Object)"trainActivity", (Object)this.editData.getTrainActivity());
        uiContext.put((Object)"trainSummary", (Object)this.editData.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainCourseSummaryUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        EntityViewInfo evi = this.getTrainEvaluLevelEntityViewInfo();
        request.put("eviEvaluLevel", (Object)evi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("HrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActivity.id"));
        request.put("eviActivity", (Object)viewInfo);
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public RequestContext prepareActionCourseSummary(IItemAction itemAction) throws Exception {
        if (TrainClientUtil.objectIsNull(this.editData.getId())) {
            TrainClientUtil.showErrorMessage(RES, "mustSaveCanCourseSummary", (CoreUI)this);
        }
        RequestContext request = super.prepareActionCourseSummary(itemAction);
        if (this.editData.getTrainActivity() != null) {
            String trainActivityId = this.editData.getTrainActivity().getId().toString();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("TrainActivity", (Object)trainActivityId));
            request.put("trainActivityFI", (Object)fi);
        }
        if (TrainAuditStatusEnum.AUDITED.equals((Object)this.editData.getAuditState())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.TrainActivity.id", (Object)this.editData.getTrainActivity().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("TrainSummary.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            request.put("trainCourseFI", (Object)filter);
        }
        return request;
    }

    public boolean isPrepareActionCourseSummary() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionSave() {
        return true;
    }

    public boolean isPrepareActionSubmit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }
}

