/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.train.ITrainSummaryPublishScope;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainSummaryCollection;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryInfo;
import com.kingdee.eas.hr.train.TrainSummaryMessageCollection;
import com.kingdee.eas.hr.train.TrainSummaryMessageFactory;
import com.kingdee.eas.hr.train.TrainSummaryMessageInfo;
import com.kingdee.eas.hr.train.TrainSummaryPublishScopeCollection;
import com.kingdee.eas.hr.train.TrainSummaryPublishScopeFactory;
import com.kingdee.eas.hr.train.TrainSummaryPublishScopeInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSummaryPublishScopeListUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainSummaryPublishScopeListUI
extends AbstractTrainSummaryPublishScopeListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSummaryPublishScopeListUI.class);
    private final PersonInfo loginPerson = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    private static final String STRRES = "com.kingdee.eas.hr.train.client.TrainSummaryResource";
    private static final String addPerson = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSummaryResource", (String)"17_AddPublishPerson");
    private static final String delPerson = EASResource.getString((String)"com.kingdee.eas.hr.train.client.TrainSummaryResource", (String)"18_DelPublishPerson");
    private String trainSummaryId = null;
    private TrainSummaryInfo trainSummaryInfo = null;
    private TrainSummaryMessageInfo messageInfo = null;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private TrainActivityInfo trainActivityInfo = null;
    private TrainActivityInfo newTrainActivityInfo = null;
    private EmployeeMultiF7PromptBox empF7 = null;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.initWorkButton();
        this.initEmpF7();
        this.initTrainActivityF7();
        this.prmtSendPerson.setText(this.loginPerson.getName());
        this.initTrainSummaryInfo();
        this.loadData();
    }

    private void initEmpF7() {
        this.empF7 = new EmployeeMultiF7PromptBox();
        this.empF7.showNoPositionPerson(true);
        this.empF7.setUserOrgRangeFilter(true);
        this.empF7.setIsSingleSelect(false);
    }

    protected void initWorkButton() {
        JButton btnAddPerson = this.contPerson.add((Action)((Object)this.actionAddPerson));
        JButton btnDelPerson = this.contPerson.add((Action)((Object)this.actionDelPerson));
        btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        btnDelPerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        btnAddPerson.setToolTipText(addPerson);
        btnDelPerson.setToolTipText(delPerson);
    }

    private void initTrainActivityF7() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = TrainUtils.getHRAndAdminRangeFilterInfo("belongOrgUnit.id");
        view.setFilter(filterInfo);
        this.prmtTrainActivity.setEntityViewInfo(view);
    }

    protected void prmtTrainActivity_dataChanged(DataChangeEvent e) throws Exception {
        this.newTrainActivityInfo = (TrainActivityInfo)this.prmtTrainActivity.getData();
        if (this.newTrainActivityInfo == null && this.trainActivityInfo == null) {
            return;
        }
        if (this.newTrainActivityInfo != null && this.trainActivityInfo != null && this.newTrainActivityInfo.getId().toString().equals(this.trainActivityInfo.getId().toString())) {
            return;
        }
        this.trainActivityInfo = this.newTrainActivityInfo;
        if (this.trainActivityInfo instanceof TrainActivityInfo) {
            String trainActivityId = this.trainActivityInfo.getId().toString();
            FilterInfo filterInfo = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId, CompareType.EQUALS));
            view.setFilter(filterInfo);
            SelectorItemCollection sic = this.getSelector();
            view.setSelector(sic);
            TrainSummaryCollection coll = TrainSummaryFactory.getRemoteInstance().getTrainSummaryCollection(view);
            if (coll != null && coll.size() > 0) {
                this.trainSummaryInfo = coll.get(0);
                this.trainSummaryId = this.trainSummaryInfo.getId().toString();
            } else {
                this.trainSummaryInfo = null;
                this.trainSummaryId = null;
            }
        } else {
            this.trainSummaryInfo = null;
            this.trainSummaryId = null;
        }
        this.loadData();
    }

    private void initTrainSummaryInfo() throws Exception {
        this.trainSummaryId = (String)this.getUIContext().get("TRAINSUMMARYID");
        SelectorItemCollection sic = this.getSelector();
        this.trainSummaryInfo = TrainSummaryFactory.getRemoteInstance().getTrainSummaryInfo((IObjectPK)new ObjectUuidPK(this.trainSummaryId), sic);
        if (this.trainSummaryInfo != null) {
            this.trainActivityInfo = this.trainSummaryInfo.getTrainActivity();
            this.prmtTrainActivity.setValue((Object)this.trainActivityInfo);
            this.prmtAdminOrgUnit.setValue((Object)this.trainActivityInfo.getOrgUnit());
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("StartDate"));
        selector.add(new SelectorItemInfo("EndDate"));
        selector.add(new SelectorItemInfo("Summary"));
        selector.add(new SelectorItemInfo("TrainActivity.id"));
        selector.add(new SelectorItemInfo("TrainActivity.name"));
        selector.add(new SelectorItemInfo("TrainActivity.number"));
        selector.add(new SelectorItemInfo("TrainActivity.orgUnit.id"));
        selector.add(new SelectorItemInfo("TrainActivity.orgUnit.name"));
        return selector;
    }

    private void loadData() throws Exception {
        this.tblMain.removeRows();
        if (this.trainSummaryInfo == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("trainSummary.id", (Object)this.trainSummaryId, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString(), CompareType.EQUALS));
        IRowSet rowSet = TrainActivityHelper.getRowSet("TrainSummaryPublishScopeQuery", fi);
        ArrayList list = new ArrayList();
        HashMap<String, String> map = null;
        while (rowSet.next()) {
            map = new HashMap<String, String>();
            map.put("id", rowSet.getString("id"));
            map.put("personId", rowSet.getString("person.id"));
            map.put("number", rowSet.getString("person.number"));
            map.put("name", rowSet.getString("person.name"));
            map.put("email", rowSet.getString("person.email"));
            map.put("position", rowSet.getString("position.name"));
            map.put("adminOrg", rowSet.getString("adminOrgUnit.name"));
            list.add(map);
        }
        this.fillTable(list);
        this.initMessage();
    }

    private void fillTable(List list) {
        TrainSummaryPublishScopeInfo TSPSInfo = null;
        PersonInfo personInfo = null;
        Map map = null;
        IRow row = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (Map)list.get(i);
            if (this.isRefered((String)map.get("personId"))) continue;
            row = this.tblMain.addRow();
            row.getCell("id").setValue(map.get("id"));
            row.getCell("person.id").setValue(map.get("personId"));
            row.getCell("person.name").setValue(map.get("name"));
            row.getCell("person.number").setValue(map.get("number"));
            row.getCell("position.name").setValue(map.get("position"));
            row.getCell("adminOrgUnit.name").setValue(map.get("adminOrg"));
            row.getCell("person.email").setValue(map.get("email"));
            TSPSInfo = new TrainSummaryPublishScopeInfo();
            personInfo = new PersonInfo();
            if (map.get("email") != null) {
                personInfo.setEmail(map.get("email").toString());
            }
            personInfo.setId(BOSUuid.read((String)((String)map.get("personId"))));
            TSPSInfo.setPerson(personInfo);
            TSPSInfo.setTrainSummary(this.trainSummaryInfo);
            TSPSInfo.setSendPerson(this.loginPerson);
            row.setUserObject((Object)TSPSInfo);
        }
    }

    private boolean isRefered(String personId) {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            String personIdInTable = (String)row.getCell("person.id").getValue();
            if (personIdInTable == null || !personIdInTable.equals(personId)) continue;
            return true;
        }
        return false;
    }

    private void initMessage() throws Exception {
        if (this.trainSummaryInfo == null) {
            this.txtTitle.setText(null);
            this.txtContent.setText(null);
            this.pkPublishDate.setValue(null);
            this.prmtAdminOrgUnit.setValue(null);
            return;
        }
        this.messageInfo = this.getTrainSummaryMessageInfo();
        if (this.messageInfo == null) {
            this.messageInfo = this.createTrainSummaryMessageInfo();
        }
        this.txtTitle.setText(this.messageInfo.getTitle());
        this.txtContent.setText(this.messageInfo.getContent());
        this.pkPublishDate.setValue((Object)this.messageInfo.getPublishDate());
        this.prmtSendPerson.setValue((Object)this.messageInfo.getSendPerson());
        this.prmtAdminOrgUnit.setValue((Object)this.messageInfo.getTrainSummary().getTrainActivity().getOrgUnit());
    }

    private TrainSummaryMessageInfo getTrainSummaryMessageInfo() throws Exception {
        TrainSummaryMessageCollection coll = TrainSummaryMessageFactory.getRemoteInstance().getTrainSummaryMessageCollection(this.getTrainSummaryMessageEntityView());
        TrainSummaryMessageInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    private EntityViewInfo getTrainSummaryMessageEntityView() {
        if (this.trainSummaryId == null || this.trainSummaryId.length() < 1) {
            this.trainSummaryId = (String)this.getUIContext().get("TRAINSUMMARYID");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainSummary.id", (Object)this.trainSummaryId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendPerson.id", (Object)this.loginPerson.getId().toString(), CompareType.EQUALS));
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("sendPerson.id"));
        view.getSelector().add(new SelectorItemInfo("sendPerson.name"));
        view.getSelector().add(new SelectorItemInfo("trainSummary.id"));
        view.getSelector().add(new SelectorItemInfo("trainSummary.TrainActivity.id"));
        view.getSelector().add(new SelectorItemInfo("trainSummary.TrainActivity.orgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("trainSummary.TrainActivity.orgUnit.name"));
        view.setFilter(filterInfo);
        return view;
    }

    private TrainSummaryMessageInfo createTrainSummaryMessageInfo() {
        String title = EASResource.getString((String)STRRES, (String)"19_Title");
        title = title.replaceAll("#0", this.trainSummaryInfo.getTrainActivity().getName());
        TrainSummaryMessageInfo trainSummaryMessageInfo = new TrainSummaryMessageInfo();
        trainSummaryMessageInfo.setTitle(title);
        String body = EASResource.getString((String)STRRES, (String)"20_content");
        String newLine = System.getProperty("line.separator");
        body = this.trainSummaryInfo.getTrainActivity().getName() != null ? body.replaceAll("#00", this.trainSummaryInfo.getTrainActivity().getName()) : body.replaceAll("#00", "");
        body = this.trainSummaryInfo.getStartDate() != null && this.trainSummaryInfo.getEndDate() != null ? body.replaceAll("#01", DateTimeUtils.format((Date)this.trainSummaryInfo.getStartDate(), (String)DATE_FORMAT) + "----" + DateTimeUtils.format((Date)this.trainSummaryInfo.getEndDate(), (String)DATE_FORMAT)) : body.replaceAll("#01", "");
        body = this.trainSummaryInfo.getSummary() != null ? body.replaceAll("#02", this.trainSummaryInfo.getSummary()) : body.replaceAll("#02", "");
        body = body.replaceAll("@", newLine);
        trainSummaryMessageInfo.setContent(body);
        trainSummaryMessageInfo.setTrainSummary(this.trainSummaryInfo);
        trainSummaryMessageInfo.setSendPerson(this.loginPerson);
        return trainSummaryMessageInfo;
    }

    private void verifyInput() {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtTrainActivity);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtTitle);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, STRRES, this.txtContent, "25_Content_Can_Not_Null");
    }

    private void bindFields() {
        this.messageInfo.setTitle(this.txtTitle.getText());
        this.messageInfo.setContent(this.txtContent.getText());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.bindFields();
        IObjectPK pk = TrainSummaryMessageFactory.getRemoteInstance().submit(this.messageInfo);
        this.messageInfo.setId(BOSUuid.read((String)pk.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"21_Success"));
    }

    private boolean confirmPublish() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)STRRES, (String)"23_Confirm_Publish")));
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"22_NoPerson"));
            SysUtil.abort();
        }
        this.verifyInput();
        this.bindFields();
        if (this.confirmPublish()) {
            this.executePublish(this.getPublishPersonCollection());
        }
    }

    private void executePublish(final TrainSummaryPublishScopeCollection collection) {
        TrainClientUtil.executeWithProcess((CoreUI)this, new IProgTask(){

            public void afterExec(Object result) throws Exception {
                TrainSummaryPublishScopeListUI.this.showSuccessMessage();
                TrainSummaryPublishScopeListUI.this.loadData();
            }

            public Object exec() throws Exception {
                TrainSummaryPublishScopeListUI.this.runPublish(collection);
                return "";
            }
        });
    }

    private void showSuccessMessage() {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)STRRES, (String)"24_PublishSuccess"));
    }

    private void runPublish(TrainSummaryPublishScopeCollection collection) throws EASBizException, BOSException {
        this.messageInfo.setPublishDate(new Date());
        IObjectPK messagePK = TrainSummaryMessageFactory.getRemoteInstance().publish(this.messageInfo, collection);
        this.messageInfo.setId(BOSUuid.read((String)messagePK.toString()));
    }

    private TrainSummaryPublishScopeCollection getPublishPersonCollection() {
        TrainSummaryPublishScopeCollection collection = new TrainSummaryPublishScopeCollection();
        TrainSummaryPublishScopeInfo info = null;
        String id = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            info = (TrainSummaryPublishScopeInfo)this.tblMain.getRow(i).getUserObject();
            id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            info.setId(BOSUuid.read((String)id));
            collection.add(info);
        }
        return collection;
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        if (this.empF7 != null) {
            this.handlePromptBox((KDCommonPromptDialog)this.empF7);
        }
    }

    private void handlePromptBox(KDCommonPromptDialog pmt) throws Exception {
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 50) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        TrainSummaryPublishScopeListUI.this.dealAddPerson(obj);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(obj);
            }
        }
    }

    private void dealAddPerson(Object[] obj) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        PersonInfo personInfo = null;
        int len = obj.length;
        for (int i = 0; i < len; ++i) {
            personInfo = (PersonInfo)obj[i];
            idSet.add(personInfo.getId().toString());
        }
        if (idSet.size() != 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            IRowSet rowSet = TrainActivityHelper.getRowSet("TrainActParticipantAboutQuery", fi);
            ArrayList list = new ArrayList();
            HashMap<String, String> map = null;
            while (rowSet.next()) {
                map = new HashMap<String, String>();
                map.put("personId", rowSet.getString("id"));
                map.put("number", rowSet.getString("number"));
                map.put("name", rowSet.getString("name"));
                map.put("position", rowSet.getString("position.name"));
                map.put("adminOrg", rowSet.getString("orgUnit.name"));
                map.put("email", rowSet.getString("email"));
                list.add(map);
            }
            this.fillTable(list);
            this.submit();
        }
    }

    private void submit() throws Exception {
        if (this.trainSummaryInfo == null) {
            return;
        }
        ITrainSummaryPublishScope iTrainSummaryPublishScope = TrainSummaryPublishScopeFactory.getRemoteInstance();
        TrainSummaryPublishScopeCollection TSPScoll = new TrainSummaryPublishScopeCollection();
        TrainSummaryPublishScopeInfo TSPSInfo = null;
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() != null) continue;
            TSPSInfo = (TrainSummaryPublishScopeInfo)row.getUserObject();
            TSPScoll.add(TSPSInfo);
        }
        if (TSPScoll.size() > 0) {
            Map idMap = iTrainSummaryPublishScope.batchSumit(TSPScoll);
            int size2 = this.tblMain.getRowCount();
            for (int i = 0; i < size2; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell("id").getValue() != null) continue;
                row.getCell("id").setValue(idMap.get((String)row.getCell("person.id").getValue()));
            }
        }
    }

    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        ITrainSummaryPublishScope iTrainSummaryPublishScope = TrainSummaryPublishScopeFactory.getRemoteInstance();
        this.checkSelected();
        if (this.confirmRemove()) {
            IRow row = null;
            HashSet<String> idSet = new HashSet<String>();
            List selectRowList = TrainUtils.getSelectedRows(this.tblMain);
            Arrays.sort(selectRowList.toArray());
            String id = null;
            for (int i = selectRowList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)selectRowList.get(i);
                row = this.tblMain.getRow(rowIndex);
                if (row.getCell("id").getValue() != null) {
                    id = row.getCell("id").getValue().toString();
                    idSet.add(id);
                }
                this.tblMain.removeRow(rowIndex);
            }
            FilterInfo fi = new FilterInfo();
            if (idSet.size() > 0) {
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                iTrainSummaryPublishScope.deletes(idSet);
            }
        }
    }
}

