/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.TrainSurveyFacadeFactory;
import com.kingdee.eas.hr.train.client.AbstractTrainSurveyDetailReportUI;
import com.kingdee.eas.hr.train.client.TrainSurveyDetailReportFilterUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainSurveyDetailReportUI
extends AbstractTrainSurveyDetailReportUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSurveyDetailReportUI.class);
    private int rowCount = 0;
    private TrainSurveyDetailReportFilterUI filterUI = null;

    public void onLoad() throws Exception {
        this.mergeTable();
        super.onLoad();
        this.rowCount = this.tblMain.getRowCount();
    }

    protected void mergeTable() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("name").setGroup(true);
        this.tblMain.getColumn("inquiry.title").setGroup(true);
        this.tblMain.getColumn("options.question").setGroup(true);
        this.tblMain.getColumn("contentOption.optionSymbol").setGroup(true);
        this.tblMain.getColumn("contentOption.optDescrip").setGroup(true);
        this.tblMain.getColumn("personCount").setGroup(true);
        this.tblMain.getColumn("totalCount").setGroup(true);
        this.tblMain.getColumn("rate").setGroup(true);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().group();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)10, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("options.questionType", (Object)30, CompareType.NOTEQUALS));
        try {
            filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo((String)"HROrgUnit.id", (String)"adminOrgUnit.id"), "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return filterInfo;
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            HashSet<String> trainSurveyIds = new HashSet<String>();
            HashSet<String> questionInquiryIds = new HashSet<String>();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                trainSurveyIds.add(rowSet.getString("id"));
                questionInquiryIds.add(rowSet.getString("questionInquiry.id"));
            }
            rowSet.beforeFirst();
            if (!trainSurveyIds.isEmpty()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("trainSurveyId", trainSurveyIds);
                params.put("questionInquiryId", questionInquiryIds);
                TrainSurveyDetailReportFilterUI reportFilterUI = this.getReportFilterUI();
                if (reportFilterUI != null) {
                    params.put("responseOrgValue", reportFilterUI.txtResponseOrgName.getText());
                    params.put("lookup", reportFilterUI.ckLookup.isSelected());
                }
                Map datas = TrainSurveyFacadeFactory.getRemoteInstance().getResponseCount(params);
                this.updateRowSetCount(rowSet, datas);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private TrainSurveyDetailReportFilterUI getReportFilterUI() throws BOSException, EASBizException, Exception {
        TrainSurveyDetailReportFilterUI reportFilterUI = this.filterUI;
        if (reportFilterUI == null) {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            QuerySolutionInfo querySolution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), this.mainQueryPK.getFullName());
            if (querySolution == null) {
                return null;
            }
            QueryPanelCollection panels = querySolution.getQueryPanelInfo();
            if (panels != null && panels.size() > 0) {
                int size = panels.size();
                for (int i = 0; i < size; ++i) {
                    QueryPanelInfo panelInfo = panels.get(i);
                    if (!TrainSurveyDetailReportFilterUI.class.getName().equalsIgnoreCase(panelInfo.getPanelClassName())) continue;
                    reportFilterUI = new TrainSurveyDetailReportFilterUI();
                    reportFilterUI.setCustomerParams(CustomerParams.getCustomerParams2((String)panelInfo.getCustomerParams()));
                    break;
                }
            }
        }
        return reportFilterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dlg = super.initCommonQueryDialog();
        try {
            this.filterUI = new TrainSurveyDetailReportFilterUI();
            dlg.addUserPanel((KDPanel)this.filterUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return dlg;
    }

    private void updateRowSetCount(IRowSet rowSet, Map datas) throws SQLException {
        String surveyId = null;
        String questionInquiryId = null;
        String questionId = null;
        String optionTypeId = null;
        String optionId = null;
        Map questionInquiryMap = null;
        Map questionMap = null;
        Map optionTypeMap = null;
        Map optionMap = null;
        rowSet.beforeFirst();
        while (rowSet.next()) {
            Integer totalCount;
            surveyId = rowSet.getString("id");
            questionInquiryId = rowSet.getString("questionInquiry.id");
            questionId = rowSet.getString("options.id");
            optionTypeId = rowSet.getString("quesnaireOption.id");
            optionId = rowSet.getString("contentOption.id");
            questionInquiryMap = (Map)datas.get(surveyId);
            if (questionInquiryMap == null || (questionMap = (Map)questionInquiryMap.get(questionInquiryId)) == null || (optionTypeMap = (Map)questionMap.get(questionId)) == null || (optionMap = (Map)optionTypeMap.get(optionTypeId)) == null || (totalCount = (Integer)optionMap.get("totalCount")) == null || totalCount == 0) continue;
            rowSet.updateInt("totalCount", totalCount.intValue());
            Integer personCount = (Integer)optionMap.get(optionId);
            if (personCount == null) continue;
            rowSet.updateInt("personCount", personCount.intValue());
            rowSet.updateString("rate", String.valueOf(personCount.doubleValue() / (double)totalCount.intValue() * 100.0));
        }
        rowSet.beforeFirst();
    }

    protected String[] getLocateNames() {
        String[] names = new String[]{"name", "inquiry.title", "options.question", "contentOption.optionSymbol", "contentOption.optDescrip"};
        return names;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

