/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.QuestionInquiryInfo;
import com.kingdee.eas.hr.train.TrainSurveyFactory;
import com.kingdee.eas.hr.train.TrainSurveyInfo;
import com.kingdee.eas.hr.train.TrainSurveyStateEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainSurveyEditUI;
import com.kingdee.eas.hr.train.client.QuestionInquiryF7UI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.hr.train.client.TreeBasePromptBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class TrainSurveyEditUI
extends AbstractTrainSurveyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSurveyEditUI.class);
    private ItemAction[] actions;

    public void onLoad() throws Exception {
        this.kdtInquiry.checkParsed();
        this.init();
        super.onLoad();
    }

    private void init() throws Exception {
        this.actions = TrainUtils.addButtonsToMutilTable(this.contInquiry, this.kdtInquiry, null);
        TrainUtils.initOrgUnit(this.prmtBelongOrgUnit, (IUIObject)this);
        this.prmtBelongOrgUnit.setRequired(true);
        this.prmtBelongOrgUnit.setEditable(false);
        TreeBasePromptBox inquiryF7 = new TreeBasePromptBox((IUIObject)this, QuestionInquiryF7UI.class.getName());
        TrainUtils.setTableCellEditorByF7Selector(this.kdtInquiry, (KDPromptSelector)inquiryF7, "inquiry");
        this.txtDescription.setMaxLength(255);
    }

    protected void kdtInquiry_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        IRow row = this.kdtInquiry.getRow(e.getRowIndex());
        if (colIndex == this.kdtInquiry.getColumn("inquiry").getColumnIndex() && e.getValue() != null) {
            QuestionInquiryInfo inquiryInfo = (QuestionInquiryInfo)e.getValue();
            this.setRowInfoByTrainInquiry(row, inquiryInfo);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtBelongOrgUnit);
        if (this.kdtInquiry.getRowCount() != 0) {
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtInquiry, "inquiry");
            TrainVerifyUtils.verifyInput((CoreUIObject)this, this.kdtInquiry, "title");
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        TrainVerifyUtils.verifyDateTimeBigOrSmall((CoreUIObject)this, this.pkBeginDateTime, this.pkEndDateTime);
    }

    private void setRowInfoByTrainInquiry(IRow row, QuestionInquiryInfo inquiryInfo) {
        row.getCell("title").setValue((Object)inquiryInfo.getTitle());
    }

    protected IObjectValue createNewData() {
        TrainSurveyInfo objectValue = new TrainSurveyInfo();
        objectValue.setHrOrgUnit(TrainUtils.getCurrentHROrgUnit());
        objectValue.setState(TrainSurveyStateEnum.NOT_SURVEY);
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSurveyFactory.getRemoteInstance();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("inquiry.*"));
        sic.add(new SelectorItemInfo("inquiry.inquiry.*"));
        return sic;
    }

    public void loadFields() {
        super.loadFields();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.setActionState(false);
        } else {
            this.setActionState(true);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setActionState(true);
        super.actionEdit_actionPerformed(e);
    }

    private void setActionState(boolean flag) {
        if (this.actions != null) {
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i].setEnabled(flag);
            }
        }
        this.kdtInquiry.getStyleAttributes().setLocked(!flag);
        if (flag) {
            this.kdtInquiry.getColumn("inquiry").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
            this.kdtInquiry.getColumn("title").getStyleAttributes().setBackground(TrainClientUtil.requiredColor);
        } else {
            this.kdtInquiry.getColumn("inquiry").getStyleAttributes().setBackground(Color.WHITE);
            this.kdtInquiry.getColumn("title").getStyleAttributes().setBackground(Color.WHITE);
        }
    }
}

