/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.train.SurveyInquiryCollection;
import com.kingdee.eas.hr.train.SurveyInquiryFactory;
import com.kingdee.eas.hr.train.SurveyInquiryInfo;
import com.kingdee.eas.hr.train.SurveyResponseCollection;
import com.kingdee.eas.hr.train.SurveyResponseFactory;
import com.kingdee.eas.hr.train.SurveyResponseInfo;
import com.kingdee.eas.hr.train.TrainSurveyFactory;
import com.kingdee.eas.hr.train.TrainSurveyInfo;
import com.kingdee.eas.hr.train.TrainSurveyStateEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainSurveyListUI;
import com.kingdee.eas.hr.train.client.RequirementClientUtil;
import com.kingdee.eas.hr.train.client.SurveyResponseEditUI;
import com.kingdee.eas.hr.train.client.SurveyResponseViewUI;
import com.kingdee.eas.hr.train.client.TrainSurveyEditUI;
import com.kingdee.eas.hr.train.client.TrainSurveyPublishUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainSurveyListUI
extends AbstractTrainSurveyListUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSurveyListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.btnEnd.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
        this.btnPreview.setIcon(EASResource.getIcon((String)"imgTbtn_seechecklist"));
        this.btnMonitoring.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.btnShowList.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        this.menuItemEnd.setIcon(EASResource.getIcon((String)"imgTbtn_allfinishinitialize"));
        this.menuItemPreview.setIcon(EASResource.getIcon((String)"imgTbtn_seechecklist"));
        this.menuItemMonitoring.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.menuItemShowList.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        this.setActionsState();
    }

    private void setActionsState() {
        int curIndex = TrainUtils.getCurrentRowIndex(this.tblMain);
        if (curIndex < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(curIndex);
        String state = row.getCell("state").getValue().toString();
        if (TrainSurveyStateEnum.NOT_SURVEY.getAlias().equals(state)) {
            this.btnShowList.setEnabled(false);
            this.btnEnd.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnPublish.setEnabled(true);
            this.menuItemShowList.setEnabled(false);
            this.menuItemEnd.setEnabled(false);
            this.menuItemEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
            this.menuItemPublish.setEnabled(true);
            this.actionShowList.setEnabled(false);
        } else if (TrainSurveyStateEnum.CLOSE.getAlias().equals(state)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnPublish.setEnabled(true);
            this.btnEnd.setEnabled(false);
            this.btnShowList.setEnabled(true);
            this.menuItemShowList.setEnabled(true);
            this.menuItemEnd.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.menuItemPublish.setEnabled(false);
            this.actionShowList.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnPublish.setEnabled(true);
            this.btnEnd.setEnabled(true);
            this.btnShowList.setEnabled(true);
            this.menuItemShowList.setEnabled(true);
            this.menuItemEnd.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.menuItemPublish.setEnabled(true);
            this.actionShowList.setEnabled(true);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = null;
        try {
            filterInfo = PFUtils.getHRAndAdminRangeFilterInfo((String)"hrOrgUnit.id", (String)"belongOrgUnit.id");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return filterInfo;
    }

    protected String getEditUIName() {
        return TrainSurveyEditUI.class.getName();
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int curIndex = TrainUtils.getCurrentRowIndex(this.tblMain);
        TrainSurveyInfo trainSurveyInfo = new TrainSurveyInfo();
        IRow row = this.tblMain.getRow(curIndex);
        String id = row.getCell("id").getValue().toString();
        BizEnumValueInfo surveyState = (BizEnumValueInfo)row.getCell("state").getValue();
        trainSurveyInfo.setId(BOSUuid.read((String)id));
        trainSurveyInfo.setName((String)row.getCell("name").getValue());
        trainSurveyInfo.setState(TrainSurveyStateEnum.getEnum(surveyState.getInt()));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent.id", (Object)trainSurveyInfo.getId().toString()));
        evi.setFilter(fi);
        SurveyInquiryCollection col = SurveyInquiryFactory.getRemoteInstance().getSurveyInquiryCollection(evi);
        if (col.size() != 0) {
            SurveyInquiryInfo inquiryInfo = null;
            int j = col.size();
            for (int i = 0; i < j; ++i) {
                inquiryInfo = col.get(i);
                trainSurveyInfo.getInquiry().add(inquiryInfo);
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        String surveyPublishId = RequirementClientUtil.getSurveyId(id);
        String state = null;
        if (30 == surveyState.getInt()) {
            state = OprtState.VIEW;
            uiContext.put((Object)"ID", (Object)surveyPublishId);
        } else if (surveyPublishId == null) {
            state = OprtState.ADDNEW;
            uiContext.put((Object)"parent", (Object)trainSurveyInfo);
        } else {
            state = OprtState.EDIT;
            uiContext.put((Object)"ID", (Object)surveyPublishId);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainSurveyPublishUI.class.getName(), (Map)uiContext, null, state);
        uiWindow.show();
        TrainSurveyPublishUI publishUI = (TrainSurveyPublishUI)uiWindow.getUIObject();
        if (publishUI.isModifiedData() && 10 == surveyState.getInt()) {
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            this.refreshList();
        }
    }

    public void actionEnd_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnd_actionPerformed(e);
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"isEnd"));
        if (result == 0) {
            TrainUtils.checkSelected((Component)((Object)this), this.tblMain);
            int selectedRow = TrainUtils.getSelectedRow(this.tblMain);
            String id = this.getSelectedKeyValue();
            TrainSurveyFactory.getRemoteInstance().close((IObjectPK)new ObjectUuidPK(id));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"FinishSuccess"));
            this.refreshTable(selectedRow);
            this.setWorkButtonStatus();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSurveyFactory.getRemoteInstance();
    }

    private void refreshTable(int selectedRow) {
        this.tblMain.refresh();
        this.tblMain.getSelectManager().select(selectedRow, 0);
    }

    private void setWorkButtonStatus() {
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnEnd.setEnabled(false);
        this.btnShowList.setEnabled(true);
        this.menuItemShowList.setEnabled(true);
        this.menuItemEnd.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
        this.menuItemPublish.setEnabled(false);
    }

    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SurveyResponseInfo info = SurveyResponseFactory.getRemoteInstance().createSurveyResponse(id);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isPreview", (Object)id);
        uiContext.put((Object)"InitDataObject", (Object)info);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SurveyResponseEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionShowList_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        RealModeIDList idList = new RealModeIDList();
        Set ids = this.getSurveyResponseIds();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            idList.add(it.next().toString());
        }
        uiContext.put((Object)"IDList", (Object)idList);
        uiContext.put((Object)"ID", (Object)idList.getFirstID());
        uiContext.put((Object)"showResponses", (Object)Boolean.TRUE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(SurveyResponseViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private Set getSurveyResponseIds() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("survey.id", (Object)this.getSelectedKeyValue()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        SurveyResponseCollection collection = SurveyResponseFactory.getRemoteInstance().getSurveyResponseCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.train.TRAINAutoGenerateResource", (String)"5_TrainSurveyListUI"));
            SysUtil.abort();
        }
        HashSet<String> ids = new HashSet<String>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            ids.add(collection.get(i).getId().toString());
        }
        return ids;
    }
}

