/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.F7ConfigDetailCollection;
import com.kingdee.eas.hr.base.F7ConfigDetailFactory;
import com.kingdee.eas.hr.base.F7ConfigInfo;
import com.kingdee.eas.hr.base.client.f7.F7ConfigManager;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.train.TrainSurveyInfo;
import com.kingdee.eas.hr.train.TrainSurveyPublishFactory;
import com.kingdee.eas.hr.train.TrainSurveyPublishInfo;
import com.kingdee.eas.hr.train.TrainSurveyStateEnum;
import com.kingdee.eas.hr.train.client.AbstractTrainSurveyPublishUI;
import com.kingdee.eas.hr.train.client.ProgressManager;
import com.kingdee.eas.hr.train.client.TrainActivityHelper;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainStudentPromptBox;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TrainSurveyPublishUI
extends AbstractTrainSurveyPublishUI {
    private static final Logger logger = CoreUIObject.getLogger(TrainSurveyPublishUI.class);
    private static final String ACT_RESOURCE = "com.kingdee.eas.hr.train.TrainActivityResource";
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainResource";
    private boolean modifiedData = false;
    private static final int MAX_PERSON_COUNT = 80;

    public TrainSurveyPublishUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.kdtEntry.getStyleAttributes().setLocked(true);
        this.kdtEntry.checkParsed();
        this.kdtEntry.getSelectManager().setSelectMode(10);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPublish.setIcon(EASResource.getIcon((String)"imgTbtn_issuance"));
        JButton btnAddTrainAcitivityPerson = this.contPublishScope.add((Action)((Object)this.actionAddTrainAcitivityPerson));
        btnAddTrainAcitivityPerson.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"AddTrainAcitivityPerson"));
        btnAddTrainAcitivityPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        JButton btnAddPerson = this.contPublishScope.add((Action)((Object)this.actionAddPerson));
        JButton btnDeletePerson = this.contPublishScope.add((Action)((Object)this.actionDelPerson));
        btnAddPerson.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        btnAddPerson.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"ADD_PERSON"));
        btnDeletePerson.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        btnDeletePerson.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"DELETE_PERSON"));
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    public void loadFields() {
        super.loadFields();
        this.loadKdtEntryData();
        boolean enabled = !OprtState.VIEW.equals(this.getOprtState());
        this.actionSubmit.setEnabled(enabled);
        this.actionPublish.setEnabled(enabled);
        this.actionAddPerson.setEnabled(enabled);
        this.actionDelPerson.setEnabled(enabled);
        this.actionAddTrainAcitivityPerson.setEnabled(enabled);
    }

    private void loadKdtEntryData() {
        if (this.kdtEntry.getRowCount() == 0) {
            return;
        }
        HashSet<String> personIds = new HashSet<String>();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            PersonInfo info = (PersonInfo)this.kdtEntry.getRow(i).getCell("person").getValue();
            personIds.add(info.getId().toString());
        }
        try {
            IRowSet rowSet = this.getPersonInfos(personIds);
            Map persons = this.assembleMap(rowSet);
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                IRow row = this.kdtEntry.getRow(i);
                PersonInfo info = (PersonInfo)row.getCell("person").getValue();
                String personId = info.getId().toString();
                Map person = (Map)persons.get(personId);
                if (person == null) continue;
                row.getCell("position").setValue(person.get("position"));
                row.getCell("orgUnit").setValue(person.get("orgUnitName"));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private IRowSet getPersonInfos(Set personIds) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)personIds, CompareType.INCLUDE));
        IRowSet rowSet = TrainActivityHelper.getRowSet("RequirementPersonQuery", filterInfo);
        return rowSet;
    }

    private Map assembleMap(IRowSet rowSet) throws SQLException {
        HashMap persons = new HashMap();
        while (rowSet.next()) {
            HashMap<String, String> person = new HashMap<String, String>();
            person.put("position", rowSet.getString("Position.name"));
            person.put("orgUnitName", rowSet.getString("AdminOrgUnit.displayName"));
            persons.put(rowSet.getString("id"), person);
        }
        return persons;
    }

    public boolean isModify() {
        return false;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("trainSurvey.id"));
        sic.add(new SelectorItemInfo("trainSurvey.name"));
        sic.add(new SelectorItemInfo("trainSurvey.state"));
        sic.add(new SelectorItemInfo("isRoot"));
        sic.add(new SelectorItemInfo("entry.state"));
        return sic;
    }

    protected IObjectValue createNewData() {
        TrainSurveyPublishInfo publishInfo = new TrainSurveyPublishInfo();
        publishInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        publishInfo.setTrainSurvey((TrainSurveyInfo)this.getUIContext().get("parent"));
        if (TrainSurveyStateEnum.NOT_SURVEY.equals((Object)publishInfo.getTrainSurvey().getState())) {
            publishInfo.setIsRoot(true);
        } else {
            publishInfo.setIsRoot(false);
        }
        return publishInfo;
    }

    public void actionPublish_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(null);
        this.storeFields();
        if (this.editData.getEntry().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACT_RESOURCE, (String)"NoPerson"));
            SysUtil.abort();
        }
        IObjectPK pk = TrainSurveyPublishFactory.getRemoteInstance().publish((IObjectValue)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACT_RESOURCE, (String)"PublishSuccess"));
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        this.loadFields();
        this.modifiedData = true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainSurveyPublishFactory.getRemoteInstance();
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK objectPK = super.runSubmit();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
        this.modifiedData = true;
        return objectPK;
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setIsSingleSelect(false);
        pmt.setModal(true);
        F7ConfigManager f7ConfigManager = new F7ConfigManager();
        F7ConfigInfo f7ConfigInfo = f7ConfigManager.getConfig("com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox", "com.kingdee.eas.hr.train.client.TrainSurveyPublishUI", 0);
        String value = this.getF7ConfigValue("com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox", "com.kingdee.eas.hr.train.client.TrainSurveyPublishUI", 0, "SCOPE");
        if ("0".equals(value)) {
            pmt.setIsShowAllAdmin(true);
        } else if ("2".equals(value)) {
            HROrgUnitInfo hr = SysContext.getSysContext().getCurrentHRUnit();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(hr.getId().toString());
            pmt.setHROFilter(idSet);
        } else {
            pmt.setUserOrgRangeFilter(true);
        }
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            Object[] obj = (Object[])pmt.getData();
            if (obj == null || obj.length == 0) {
                return;
            }
            final HashSet<String> personIds = new HashSet<String>();
            for (int i = 0; i < obj.length; ++i) {
                personIds.add(((PersonInfo)obj[i]).getId().toString());
            }
            if (obj.length > 80) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        TrainSurveyPublishUI.this.dealAddPerson(personIds);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(personIds);
            }
        }
    }

    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        HashSet<String> personIdSet = new HashSet<String>();
        HashSet<String> notDeleteIdSet = new HashSet<String>();
        PersonInfo personInfo = null;
        int count = 0;
        Iterator it = null;
        StringBuffer personName_buffer = new StringBuffer();
        String surveyId = this.editData.getTrainSurvey().getId().toString();
        int[] index = TrainHelper.getSelectedRows(this.kdtEntry);
        if (index.length == 0) {
            return;
        }
        for (int i = 0; i < index.length; ++i) {
            row = this.kdtEntry.getRow(index[i]);
            personInfo = (PersonInfo)row.getCell("person").getValue();
            personIdSet.add(personInfo.getId().toString());
        }
        Set personInfoSet = TrainSurveyPublishFactory.getRemoteInstance().deletePerson(personIdSet, surveyId);
        if (personInfoSet.size() > 0) {
            it = personInfoSet.iterator();
            while (it.hasNext()) {
                if (count != 0) {
                    personName_buffer.append(",");
                }
                personInfo = (PersonInfo)it.next();
                personName_buffer.append(personInfo.getName().toString());
                notDeleteIdSet.add(personInfo.getId().toString());
                ++count;
            }
            MessageFormat format = new MessageFormat(EASResource.getString((String)RES, (String)"notDelPublishPerson"));
            String message = format.format(new Object[]{personName_buffer.toString()});
            MsgBox.showWarning((String)message);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)ACT_RESOURCE, (String)"sucessDelete"));
        }
        for (int i = index.length - 1; i >= 0; --i) {
            row = this.kdtEntry.getRow(index[i]);
            if (row == null) continue;
            personInfo = (PersonInfo)row.getCell("person").getValue();
            if (notDeleteIdSet != null && notDeleteIdSet.size() > 0) {
                if (notDeleteIdSet.contains(personInfo.getId().toString())) continue;
                TrainUtils.removeRow(this.kdtEntry, index[i]);
                continue;
            }
            TrainUtils.removeRow(this.kdtEntry, index[i]);
        }
    }

    private void dealAddPerson(Set personIds) throws Exception {
        if (personIds == null || personIds.size() == 0) {
            return;
        }
        IRowSet rowSet = this.getPersonInfos(personIds);
        while (rowSet.next()) {
            String personId = rowSet.getString("id");
            PersonInfo info = new PersonInfo();
            info.setId(BOSUuid.read((String)personId));
            if (TrainUtils.isRepeatRowInTable(this.kdtEntry, info, "person")) continue;
            IRow row = this.kdtEntry.addRow();
            row.getCell("person").setValue((Object)info);
            row.getCell("personID").setValue((Object)rowSet.getString("id"));
            row.getCell("personName").setValue((Object)rowSet.getString("name"));
            row.getCell("personNumber").setValue((Object)rowSet.getString("number"));
            row.getCell("position").setValue((Object)rowSet.getString("Position.name"));
            row.getCell("orgUnit").setValue((Object)rowSet.getString("AdminOrgUnit.displayName"));
        }
    }

    protected boolean isModifiedData() {
        return this.modifiedData;
    }

    public void actionAddTrainAcitivityPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddTrainAcitivityPerson_actionPerformed(e);
        TrainStudentPromptBox pmt = new TrainStudentPromptBox((IUIObject)this);
        pmt.setModal(true);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            Object[] obj = (Object[])pmt.getData();
            if (obj == null || obj.length == 0) {
                return;
            }
            final HashSet<String> personIds = new HashSet<String>();
            for (int i = 0; i < obj.length; ++i) {
                personIds.add(((PersonInfo)obj[i]).getId().toString());
            }
            if (obj.length > 80) {
                ProgressManager.DaemonTask process = new ProgressManager.DaemonTask(){

                    public void run() throws Exception {
                        TrainSurveyPublishUI.this.dealAddPerson(personIds);
                    }
                };
                new ProgressManager((CoreUI)this).launchProcess(process, (CoreUIObject)this);
            } else {
                this.dealAddPerson(personIds);
            }
        }
    }

    private String getF7ConfigValue(String f7, String ui, int seq, String property) {
        String value = null;
        F7ConfigDetailCollection cc = null;
        if (StringUtils.isEmpty((String)f7) || StringUtils.isEmpty((String)ui)) {
            return value;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("config.f7.number", (Object)f7));
        filterInfo.getFilterItems().add(new FilterItemInfo("config.ui.name", (Object)ui));
        filterInfo.getFilterItems().add(new FilterItemInfo("config.seq", (Object)new Integer(seq)));
        filterInfo.getFilterItems().add(new FilterItemInfo("property", (Object)property));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("value"));
        view.setFilter(filterInfo);
        view.setSelector(selectors);
        try {
            cc = F7ConfigDetailFactory.getRemoteInstance().getF7ConfigDetailCollection(view);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (cc != null && cc.size() > 0) {
            value = cc.get(0).getValue();
        }
        return value;
    }
}

