/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.train.ISysCate;
import com.kingdee.eas.hr.train.ISysCateCourseEntry;
import com.kingdee.eas.hr.train.SysCateCourseEntryCollection;
import com.kingdee.eas.hr.train.SysCateCourseEntryFactory;
import com.kingdee.eas.hr.train.SysCateCourseEntryInfo;
import com.kingdee.eas.hr.train.SysCateFactory;
import com.kingdee.eas.hr.train.SysCateInfo;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainSysTreeDetailListUI;
import com.kingdee.eas.hr.train.client.SysCateConfigEditUI;
import com.kingdee.eas.hr.train.client.SysCateSimpleEditUI;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.hr.train.client.TrainCourseEditUI;
import com.kingdee.eas.hr.train.client.TrainCoursePromptBox;
import com.kingdee.eas.hr.train.client.TrainItemF7UI;
import com.kingdee.eas.hr.train.client.TrainSysFilterUI;
import com.kingdee.eas.hr.train.client.TreeDetailHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class TrainSysTreeDetailListUI
extends AbstractTrainSysTreeDetailListUI {
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainSysResource";
    private static final String RESOURCE = "com.kingdee.eas.hr.train.TrainResource";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.menuItemGroupMoveTree.setEnabled(true);
        this.mergeTable();
        super.onLoad();
        this.tblMain.getColumn("IsRequired").getStyleAttributes().setLocked(false);
        this.treeView.getControlPane().remove((Component)this.btnGroupMoveTree);
        this.btnGroupDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.treeView.getControlPane().add((Component)this.btnGroupDisable);
        this.btnAddTrainItem.setIcon(EASResource.getIcon((String)"imgTbtn_additem"));
        this.btnAddCourse.setIcon(EASResource.getIcon((String)"imgTbtn_addcourse"));
        this.btnReferConfig.setIcon(EASResource.getIcon((String)"imgTbtn_settingrelating"));
        this.btnRefConfigView.setIcon(EASResource.getIcon((String)"imgTbtn_seerelating"));
        this.actionAddTrainItem.setEnabled(true);
        this.menuAddItem.setIcon(EASResource.getIcon((String)"imgTbtn_additem"));
        this.menuItemAddCourse.setIcon(EASResource.getIcon((String)"imgTbtn_addcourse"));
        this.menuItemReferConfig.setIcon(EASResource.getIcon((String)"imgTbtn_settingrelating"));
        this.menuItemRefConfigView.setIcon(EASResource.getIcon((String)"imgTbtn_seerelating"));
    }

    private void mergeTable() {
        this.tblMain.getColumn("trainSysCate").setGroup(true);
        this.tblMain.getColumn("trainItem").setGroup(true);
    }

    protected void initTree() throws Exception {
        super.initTree();
        this.setNodeColor((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
    }

    protected String getGroupEditUIName() {
        return SysCateSimpleEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "parent.id";
    }

    protected String getSelectDetailTreeName() {
        return "parent";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return SysCateFactory.getRemoteInstance();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SysCateCourseEntryFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return SysCateSimpleEditUI.class.getName();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        Object obj;
        if (super.getSelectedTreeNode() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"selectSysCate"));
            SysUtil.abort();
        }
        if ((obj = super.getSelectedTreeNode().getUserObject()) == null || !(obj instanceof SysCateInfo)) {
            return null;
        }
        String id = ((SysCateInfo)obj).getId().toString();
        return new ObjectUuidPK(id);
    }

    private boolean isSelectedLeaf() {
        Object obj = super.getSelectedTreeNode().getUserObject();
        if (obj == null || !(obj instanceof SysCateInfo)) {
            return false;
        }
        SysCateInfo info = (SysCateInfo)obj;
        return info.isIsLeaf();
    }

    protected String getRootName() {
        return EASResource.getString((String)RES, (String)"trainSysCate");
    }

    public void actionAddCourse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSysCate();
        if (!this.isSelectedNodeEnabled()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"disabledAddCourse"));
            SysUtil.abort();
        }
        if (!this.isSelectedLeaf()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"canNotAddNew"));
            return;
        }
        HashSet<String> courses = new HashSet<String>();
        IRow row = null;
        ICell cell = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            cell = row.getCell("trainItem");
            if (cell.getValue() != null) continue;
            courses.add(row.getCell("TrainCourse.id").getValue().toString());
        }
        TrainCoursePromptBox courseBox = new TrainCoursePromptBox((IUIObject)this);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("IsEnable", (Object)1));
        Set courseIds = this.getCourseIDs(this.getEntrys());
        if (courseIds != null && courseIds.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)courseIds, CompareType.NOTINCLUDE));
        }
        courseBox.setSingleSelect(false);
        courseBox.show();
        if (courseBox.isCanceled()) {
            return;
        }
        Object[] values = (Object[])courseBox.getData();
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        TrainCourseInfo info = null;
        for (int i = 0; i < values.length; ++i) {
            info = (TrainCourseInfo)values[i];
            if (courses.contains(info.getId().toString())) continue;
            list.add(info.getId());
        }
        this.preAddCourse(list, this.getSelectedTreeKeyValue()).callHandler();
        ISysCateCourseEntry iEntry = SysCateCourseEntryFactory.getRemoteInstance();
        iEntry.addCourse(list, this.getSelectedTreeKeyValue());
        this.execQuery();
    }

    private Set getCourseIDs(SysCateCourseEntryCollection coll) throws BOSException, EASBizException {
        HashSet<String> set = null;
        if (coll != null && coll.size() > 0) {
            set = new HashSet<String>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                SysCateCourseEntryInfo entryInfo = coll.get(i);
                if (entryInfo.getTrainItem() != null || entryInfo.getTrainCourse() == null) continue;
                set.add(entryInfo.getTrainCourse().getId().toString());
            }
        }
        return set;
    }

    private SysCateCourseEntryCollection getEntrys() throws BOSException, EASBizException {
        IObjectPK pk = this.getSelectedTreeKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CourseEntry.id"));
        sic.add(new SelectorItemInfo("CourseEntry.trainItem.id"));
        sic.add(new SelectorItemInfo("CourseEntry.trainItem.name"));
        sic.add(new SelectorItemInfo("CourseEntry.trainItem.Course.course.id"));
        sic.add(new SelectorItemInfo("CourseEntry.TrainCourse.id"));
        SysCateInfo sysCateInfo = (SysCateInfo)SysCateFactory.getRemoteInstance().getValue(pk, sic);
        SysCateCourseEntryCollection coll = sysCateInfo.getCourseEntry();
        return coll;
    }

    private SelectorItemCollection getSysCateCourseEntrySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CourseEntry.id"));
        sic.add(new SelectorItemInfo("CourseEntry.trainItem.id"));
        sic.add(new SelectorItemInfo("CourseEntry.trainItem.name"));
        sic.add(new SelectorItemInfo("CourseEntry.trainItem.Course.course.id"));
        sic.add(new SelectorItemInfo("CourseEntry.TrainCourse.id"));
        return sic;
    }

    public void actionAddTrainItem_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isSelectedNodeEnabled()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"disabledAddTrainItem"));
            return;
        }
        if (!this.isSelectedLeaf()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"cannotAddTrainItem"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1));
        Set itemIds = this.getTrainItemIDs(this.getEntrys());
        if (itemIds != null && itemIds.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(itemIds), CompareType.NOTINCLUDE));
        }
        uiContext.put((Object)"filterInfo", (Object)filterInfo);
        uiContext.put((Object)"singleSelect", (Object)false);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainItemF7UI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        TrainItemF7UI trainItemF7UI = (TrainItemF7UI)uiWindow.getUIObject();
        Collection result = trainItemF7UI.getSelectedCollection();
        if (trainItemF7UI.isCanceled() || result == null || result.size() == 0) {
            return;
        }
        this.preAddTrainItem(result, this.getSelectedTreeKeyValue()).callHandler();
        ISysCateCourseEntry iEntry = SysCateCourseEntryFactory.getRemoteInstance();
        iEntry.addTrainItem(this.getSelectedTreeKeyValue(), result);
        this.execQuery();
    }

    private Set getTrainItemIDs(SysCateCourseEntryCollection coll) throws BOSException, EASBizException {
        TreeSet<String> itemIds = null;
        if (coll != null && coll.size() > 0) {
            itemIds = new TreeSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                SysCateCourseEntryInfo entryInfo = coll.get(i);
                if (entryInfo.getTrainItem() == null) continue;
                itemIds.add(entryInfo.getTrainItem().getId().toString());
            }
        }
        return itemIds;
    }

    public void actionReferConfig_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSysCate();
        if (!this.isSelectedNodeEnabled()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"disabledRefConfig"));
            SysUtil.abort();
        }
        if (!this.isSelectedLeaf()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"selectSysCate"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedTreeKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SysCateConfigEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void actionRefConfigView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSysCate();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedTreeKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SysCateConfigEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void checkSelectedSysCate() throws Exception {
        IObjectPK pk = this.getSelectedTreeKeyValue();
        if (pk == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"selectSysCate"));
            SysUtil.abort();
        }
    }

    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        int colIndex = this.tblMain.getColumnIndex("IsRequired");
        if (e.getColIndex() == colIndex) {
            Boolean value = (Boolean)this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getValue();
            value = value == null || value.equals(Boolean.FALSE) ? Boolean.TRUE : Boolean.FALSE;
            Object obj = this.tblMain.getRow(e.getRowIndex()).getCell("id").getValue();
            if (obj != null) {
                ISysCateCourseEntry iEntry = SysCateCourseEntryFactory.getRemoteInstance();
                iEntry.setRequired((IObjectPK)new ObjectUuidPK(obj.toString()), value);
            }
        }
    }

    public void actionGroupDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSysCate();
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"disableSysCate")) == 2) {
            return;
        }
        ISysCate iSysCate = SysCateFactory.getRemoteInstance();
        iSysCate.disableCurrentNode(this.getSelectedTreeObjectValue());
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actRefresh = this.getActionFromActionEvent(evt);
        actRefresh.actionPerformed(evt);
    }

    protected SysCateInfo getSelectedTreeObjectValue() {
        Object obj = super.getSelectedTreeNode().getUserObject();
        if (obj == null || !(obj instanceof SysCateInfo)) {
            return null;
        }
        return (SysCateInfo)obj;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setNodeColor((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
    }

    protected void chkShowDisabled_itemStateChanged(ItemEvent e) throws Exception {
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actRefresh = this.getActionFromActionEvent(evt);
        actRefresh.actionPerformed(evt);
    }

    protected FilterInfo getDefaultFilterForTree() {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        if (this.chkShowDisabled.isSelected()) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)Boolean.TRUE, CompareType.EQUALS));
        return filter;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext viewContext = new UIContext((Object)this);
        String id = this.getSelectedCourseKeyValue();
        viewContext.put((Object)"ID", (Object)id);
        RealModeIDList courseIDList = new RealModeIDList();
        Object obj = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            obj = this.tblMain.getRow(i).getCell("TrainCourse.id").getValue();
            if (obj == null) continue;
            courseIDList.add(obj.toString());
        }
        courseIDList.setCurrentID(id);
        viewContext.put((Object)"IDList", (Object)courseIDList);
        viewContext.put((Object)"viewOnly", (Object)Boolean.TRUE);
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            viewContext.put((Object)"ParentNode", treeNode.getUserObject());
        } else {
            viewContext.put((Object)"ParentNode", null);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TrainCourseEditUI.class.getName(), (Map)viewContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedCourseKeyValue() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("TrainCourse.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    private boolean isSelectedNodeEnabled() {
        if (super.getSelectedTreeNode() == null) {
            return true;
        }
        Object obj = super.getSelectedTreeNode().getUserObject();
        if (obj == null || !(obj instanceof SysCateInfo)) {
            return true;
        }
        boolean status = ((SysCateInfo)obj).isIsEnabled();
        return status;
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK treeKey;
        if (!this.isSelectedNodeEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"disableGroupAddNew"));
            SysUtil.abort();
        }
        if ((treeKey = this.getSelectedTreeKeyValue()) != null && this.haveCourse(treeKey.toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"canNotAddSubType"));
            SysUtil.abort();
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSysCate();
        if (!this.isSelectedLeaf()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"typeHaveSubType"));
            SysUtil.abort();
        }
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"sysCateIsReferedNotAllowRemove"));
            SysUtil.abort();
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelectedSysCate();
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"isReferedGroupDisable"));
            SysUtil.abort();
        }
        if (!this.isSelectedNodeEnabled()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"disableGroupEdit"));
            SysUtil.abort();
        }
        super.actionGroupEdit_actionPerformed(e);
    }

    private boolean haveCourse(String id) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id, CompareType.EQUALS));
        try {
            return SysCateCourseEntryFactory.getRemoteInstance().exists(filter);
        }
        catch (Exception e) {
            this.handleException(e);
            return true;
        }
    }

    private boolean isRefered() throws EASBizException, BOSException, Exception {
        SysCateInfo sysCateInfo = (SysCateInfo)this.getSelectedTreeNode().getUserObject();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sysCateInfo.getId().toString()));
        return this.getBizInterface().exists(filterInfo);
    }

    private void setNodeColor(DefaultKingdeeTreeNode root) {
        if (root != null) {
            SysCateInfo info;
            Object obj = root.getUserObject();
            if (obj != null && obj instanceof SysCateInfo && !(info = (SysCateInfo)obj).isIsEnabled()) {
                root.setTextColor(Color.LIGHT_GRAY);
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.setNodeColor(node);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actRefresh = this.getActionFromActionEvent(evt);
        actRefresh.actionPerformed(evt);
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        uiContext.put((Object)"group_enabled", (Object)this.isSelectedNodeEnabled());
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        TreePath path = null;
        if (e == null || (path = e.getNewLeadSelectionPath()) == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == root) {
            this.tblMain.getColumn("trainSysCate").getStyleAttributes().setHided(false);
        } else if (node.getChildCount() > 0) {
            this.tblMain.getColumn("trainSysCate").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("trainSysCate").getStyleAttributes().setHided(true);
        }
        boolean enabled = this.isSelectedNodeEnabled();
        this.tblMain.getColumn("IsRequired").getStyleAttributes().setLocked(!enabled);
        this.actionGroupDisable.setEnabled(enabled);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.TRAIN_MANAGEMENT;
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        TreeDetailHelper.checkMoveTreeNode(e, (CoreUI)this);
        super.moveTreeNode(e);
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        TreeBaseInfo treeBaseInfo = e.getTargetTreeBaseInfo();
        if (treeBaseInfo != null && this.haveCourse(treeBaseInfo.getId().toString())) {
            Object[] objs = new Object[]{TrainClientUtil.getResource(RESOURCE, "TrainCourseQueryF7WindowTitle")};
            TrainClientUtil.showErrorMessage("com.kingdee.eas.hr.train.client.TrainResource", "TreeNodeMoveError", objs, (CoreUI)this);
        }
        super.moveGroupTreeNode(e);
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isEnabled"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("displayName"));
        sic.add(new SelectorItemInfo("parent.id"));
        return sic;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"TrainCourse.name", "TrainCourse.number", "trainItem"};
        return locateNames;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        TrainSysFilterUI userPanel = null;
        try {
            userPanel = new TrainSysFilterUI();
        }
        catch (Exception e) {
            super.handleException(e);
        }
        if (userPanel != null) {
            queryDlg.addUserPanel((KDPanel)userPanel);
        }
        return queryDlg;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"HRO");
    }

    public RequestContext prepareActionGroupAddNew(IItemAction itemAction) throws Exception {
        IObjectPK pk = this.getSelectedTreeKeyValue();
        RequestContext request = super.prepareActionGroupAddNew(itemAction);
        if (pk != null) {
            request.put("treeId", (Object)pk.toString());
        }
        return request;
    }

    public RequestContext prepareActionAddCourse(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddCourse(itemAction);
        SelectorItemCollection sic = this.getSysCateCourseEntrySelector();
        request.put("selector", (Object)sic);
        IObjectPK pk = this.getSelectedTreeKeyValue();
        if (pk != null) {
            request.put("pk", (Object)pk.toString());
        }
        return request;
    }

    public IUIActionPostman preAddCourse(List list, IObjectPK selectPK) {
        IUIActionPostman postman = this.prepareQuery(null);
        RequestContext request = new RequestContext();
        if (list != null) {
            request.put("list", (Object)list);
        }
        if (selectPK != null) {
            request.put("selectPK", (Object)selectPK);
        }
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("preAddCourse");
        postman.setRequestContext((Serializable)request);
        return postman;
    }

    public RequestContext prepareActionAddTrainItem(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddTrainItem(itemAction);
        SelectorItemCollection sic = this.getSysCateCourseEntrySelector();
        request.put("selector", (Object)sic);
        IObjectPK pk = this.getSelectedTreeKeyValue();
        if (pk != null) {
            request.put("pk", (Object)pk.toString());
        }
        return request;
    }

    public IUIActionPostman preAddTrainItem(Collection result, IObjectPK selectPK) {
        IUIActionPostman postman = this.prepareQuery(null);
        RequestContext request = new RequestContext();
        if (result != null) {
            request.put("result", (Object)result);
        }
        if (selectPK != null) {
            request.put("selectPK", (Object)selectPK);
        }
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("preAddTrainItem");
        postman.setRequestContext((Serializable)request);
        return postman;
    }

    public boolean isPrepareActionAddCourse() {
        return true;
    }

    public boolean isPrepareActionAddTrainItem() {
        return true;
    }

    public boolean isPrepareActionGroupAddNew() {
        return true;
    }

    public boolean isPrepareActionReferConfig() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRemove() {
        return true;
    }
}

