/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.TrainThoughtCollection;
import com.kingdee.eas.hr.train.TrainThoughtFactory;
import com.kingdee.eas.hr.train.TrainThoughtInfo;
import com.kingdee.eas.hr.train.client.AbstractTrainThoughtEditUI;
import com.kingdee.eas.hr.train.client.TrainActivityRecordEditUI;
import com.kingdee.eas.hr.train.client.TrainCourseRecordEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;

public class TrainThoughtEditUI
extends AbstractTrainThoughtEditUI {
    private String recordId = null;
    private boolean fromActRecordEditUI = false;
    private boolean fromCourseRecordEditUI = false;

    public void onLoad() throws Exception {
        this.initComeFrom();
        this.loadRecordId();
        super.onLoad();
    }

    public void loadFields() {
        super.loadFields();
        if (this.editData.getId() == null) {
            this.btnAttachment.setEnabled(false);
        } else {
            this.btnAttachment.setEnabled(true);
        }
    }

    private void initComeFrom() {
        String comeFrom = (String)this.getUIContext().get("come_from");
        if (TrainActivityRecordEditUI.class.getName().equals(comeFrom)) {
            this.fromActRecordEditUI = true;
        } else if (TrainCourseRecordEditUI.class.getName().equals(comeFrom)) {
            this.fromCourseRecordEditUI = true;
        }
    }

    protected String getEditUIName() {
        return TrainThoughtEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TrainThoughtFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        TrainThoughtInfo objectValue = new TrainThoughtInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setInputDate(DateTimeUtils.truncateDate((Date)new Date()));
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        TrainThoughtInfo thoughtInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String recordColumnName = null;
        if (this.fromActRecordEditUI) {
            recordColumnName = "trainActRecord.id";
        } else if (this.fromCourseRecordEditUI) {
            recordColumnName = "trainCouRecord.id";
        }
        filter.getFilterItems().add(new FilterItemInfo(recordColumnName, (Object)this.recordId));
        view.setFilter(filter);
        TrainThoughtCollection thoughtCol = TrainThoughtFactory.getRemoteInstance().getTrainThoughtCollection(view);
        if (thoughtCol.size() <= 0) {
            thoughtInfo = (TrainThoughtInfo)this.createNewData();
            TrainCourseRecordInfo recordInfo = new TrainCourseRecordInfo();
            recordInfo.setId(BOSUuid.read((String)this.recordId));
            if (this.fromActRecordEditUI) {
                thoughtInfo.setTrainActRecord(recordInfo);
            } else if (this.fromCourseRecordEditUI) {
                thoughtInfo.setTrainCouRecord(recordInfo);
            }
        } else {
            thoughtInfo = thoughtCol.get(0);
        }
        return thoughtInfo;
    }

    private void loadRecordId() {
        if (this.getUIContext().get("ID") != null) {
            this.recordId = this.getUIContext().get("ID").toString();
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this, false);
        } else {
            am.showAttachmentListUIByBoID(this.editData.getId().toString(), (Object)this);
        }
    }

    public boolean isPrepareInit() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        this.initComeFrom();
        this.loadRecordId();
        request.put("fromActRecordEditUI", (Object)this.fromActRecordEditUI);
        request.put("fromCourseRecordEditUI", (Object)this.fromCourseRecordEditUI);
        request.put("trainRecordId", (Object)this.recordId);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

