/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import org.apache.log4j.Logger;

public class TrainTreeTable {
    private static final Logger logger = Logger.getLogger(TrainTreeTable.class);

    public static void setHRTreeTable(final KDTable table1, final String colName) {
        table1.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                int row = e.getRowIndex();
                int column = e.getColIndex();
                TrainTreeTable.cellClicked(table1, colName, row, column, e.getX(), e.getY());
            }
        });
    }

    private static void cellClicked(KDTable table, String colName, int rowIndex, int columnIndex, int x, int y) {
        if (rowIndex > -1 && columnIndex == table.getColumnIndex(colName)) {
            if (table.getRow(rowIndex) == null || table.getRow(rowIndex).getCell(columnIndex).getValue() == null) {
                return;
            }
            HRCellUserObject cellUserObject = (HRCellUserObject)table.getRow(rowIndex).getCell(columnIndex).getValue();
            HRCellTreeRenderer virtureCompanyRender = (HRCellTreeRenderer)table.getRow(rowIndex).getCell(columnIndex).getRenderer();
            if (virtureCompanyRender.inRect(cellUserObject, x, y)) {
                try {
                    TrainTreeTable.handle(table, colName, rowIndex);
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
            }
        }
    }

    private static void handle(KDTable table, String columnName, int rowIndex) throws Exception {
        HRCellUserObject cellObj = (HRCellUserObject)table.getRow(rowIndex).getCell(columnName).getValue();
        if (cellObj.isLeaf()) {
            return;
        }
        table.setRefresh(false);
        if (cellObj.isExpanded()) {
            TrainTreeTable.hideRows(table, columnName, rowIndex);
        } else {
            TrainTreeTable.expandRow(table, columnName, rowIndex);
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    private static void hideRows(KDTable table, String columnName, int rowIndex) {
        HRCellUserObject rootCellObj = (HRCellUserObject)table.getRow(rowIndex).getCell(columnName).getValue();
        rootCellObj.setExpanded(false);
        int rowCount = table.getRowCount();
        while (++rowIndex < rowCount) {
            IRow curRow = table.getRow(rowIndex);
            HRCellUserObject curCellObj = (HRCellUserObject)curRow.getCell(columnName).getValue();
            if (rootCellObj.getLongNumber().equals(curCellObj.getLongNumber())) {
                curCellObj.setExpanded(rootCellObj.isExpanded());
                continue;
            }
            if (curCellObj.getLevel() <= rootCellObj.getLevel()) break;
            curRow.getStyleAttributes().setHided(true);
        }
    }

    private static int expandRow(KDTable table, String columnName, int rowIndex) {
        HRCellUserObject rootCellObj = (HRCellUserObject)table.getRow(rowIndex).getCell(columnName).getValue();
        rootCellObj.setExpanded(true);
        int rowCount = table.getRowCount();
        while (++rowIndex < rowCount) {
            IRow curRow = table.getRow(rowIndex);
            HRCellUserObject curCellObj = (HRCellUserObject)curRow.getCell(columnName).getValue();
            if (rootCellObj.getLongNumber().equals(curCellObj.getLongNumber())) {
                curCellObj.setExpanded(rootCellObj.isExpanded());
                continue;
            }
            if (curCellObj.getLevel() <= rootCellObj.getLevel()) break;
            curRow.getStyleAttributes().setHided(false);
            if (curCellObj.isExpanded() || curCellObj.isLeaf()) continue;
            rowIndex = TrainTreeTable.expandSkipChildren(table, columnName, rowIndex);
        }
        return rowIndex;
    }

    private static int expandSkipChildren(KDTable table, String columnName, int rowIndex) {
        IRow preRow = table.getRow(rowIndex);
        HRCellUserObject rootCellObj = (HRCellUserObject)preRow.getCell(columnName).getValue();
        String longNumber = rootCellObj.getLongNumber();
        int rowCount = table.getRowCount();
        while (++rowIndex < rowCount) {
            IRow curRow = table.getRow(rowIndex);
            HRCellUserObject curCellObj = (HRCellUserObject)curRow.getCell(columnName).getValue();
            if (curCellObj.getLongNumber().equals(longNumber)) {
                curRow.getStyleAttributes().setHided(false);
                continue;
            }
            if (curCellObj.getLongNumber().indexOf(longNumber) >= 0) continue;
            break;
        }
        return rowIndex - 1;
    }

    public static void hideLevelRow(KDTable table, int level, String columnName) {
        IRow row = null;
        int hideLevel = level;
        HRCellUserObject curCellObj = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            curCellObj = (HRCellUserObject)row.getCell(columnName).getValue();
            if (i == 0) {
                hideLevel = curCellObj.getLevel() + level;
            }
            if (curCellObj.getLevel() > hideLevel) {
                row.getStyleAttributes().setHided(true);
                if (curCellObj.isLeaf()) continue;
                curCellObj.setExpanded(false);
                continue;
            }
            if (curCellObj.getLevel() == hideLevel) {
                curCellObj.setExpanded(false);
                continue;
            }
            curCellObj.setExpanded(true);
        }
    }
}

