/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainUnitTransferCollection;
import com.kingdee.eas.hr.train.TrainUnitTransferFactory;
import com.kingdee.eas.hr.train.TrainUnitTransferInfo;
import com.kingdee.eas.hr.train.client.RowDataHandler;
import com.kingdee.eas.hr.train.client.TableActionHandler;
import com.kingdee.eas.hr.train.client.TrainCourseTreePromptBox;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.hr.train.client.TrainInstructorDisplayFormatter;
import com.kingdee.eas.hr.train.client.TrainInstructorPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.tree.TreeModel;

public class TrainUtils {
    public static final String strResource = "com.kingdee.eas.hr.train.TrainResource.";
    public static final int TEXT_MAX_LENGTH = 40;
    public static final int DESCRIPTION_MAX_LENGTH = 200;
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public static FilterInfo getCurrentCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static DefaultComboBoxModel getComboModel(IDataBase iDb) throws BOSException {
        return TrainUtils.getComboBoxModel(iDb.getDataBaseCollection());
    }

    public static DefaultComboBoxModel getComboModel(IDataBase iDb, FilterInfo filterInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        SorterItemInfo itemInfo = new SorterItemInfo("number");
        itemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(itemInfo);
        return TrainUtils.getComboBoxModel(iDb.getDataBaseCollection(viewInfo));
    }

    public static DefaultComboBoxModel getComboBoxModel(DataBaseCollection col) throws BOSException {
        DefaultComboBoxModel<DataBaseInfo> model = new DefaultComboBoxModel<DataBaseInfo>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(col.get(i));
        }
        if (size != 0) {
            model.setSelectedItem(col.get(0));
        }
        return model;
    }

    public static DefaultComboBoxModel getComboBoxModel(IObjectCollection col) throws BOSException {
        DefaultComboBoxModel<IObjectValue> model = new DefaultComboBoxModel<IObjectValue>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(col.getObject(i));
        }
        if (size != 0) {
            model.setSelectedItem(col.getObject(0));
        }
        return model;
    }

    public static void checkSelected(Component ui, KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public static int getSelectedRow(KDTable table) {
        IBlock selectBlock = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get());
        return selectBlock.getTop();
    }

    public static List getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] selectRowsIndex = TrainHelper.getSelectedRows(table);
        Arrays.sort(selectRowsIndex);
        for (int i = 0; i < selectRowsIndex.length; ++i) {
            if (list.contains(selectRowsIndex[i])) continue;
            list.add(selectRowsIndex[i]);
        }
        return list;
    }

    public static UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public static CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        return companyOrgUnitInfo;
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    public static AdminOrgUnitInfo getCurrentAdminOrgUnit() {
        AdminOrgUnitInfo info = SysContext.getSysContext().getCurrentAdminUnit();
        return info;
    }

    private static void setTableCellEditorByComboBox(KDTable tblMain, KDComboBox comboBox, IObjectCollection coll, String property) throws Exception {
        if (comboBox == null) {
            comboBox = new KDComboBox();
        }
        if (coll != null) {
            DefaultComboBoxModel<IObjectValue> model = new DefaultComboBoxModel<IObjectValue>();
            for (int j = 0; j < coll.size(); ++j) {
                model.addElement(coll.getObject(j));
            }
            comboBox.setModel(model);
        }
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, IObjectCollection coll, String property) throws Exception {
        TrainUtils.setTableCellEditorByComboBox(tblMain, null, coll, property);
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, KDComboBox comboBox, String property) throws Exception {
        TrainUtils.setTableCellEditorByComboBox(tblMain, comboBox, null, property);
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, String property, String enumString) throws Exception {
        KDComboBox box = new KDComboBox();
        box.setVisible(true);
        box.addItems(EnumUtils.getEnumList((String)enumString).toArray());
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
    }

    public static KDCheckBox setTableCellEditorByCheckBox(KDTable tblMain, String property) throws Exception {
        KDCheckBox chkBox = new KDCheckBox();
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkBox));
        return chkBox;
    }

    public static KDFormattedTextField setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setSupportedEmpty(true);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        return formattedTextField;
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, KDFormattedTextField formattedTextField, String property, int precision) throws Exception {
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setSupportedEmpty(true);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByTextField(KDTable tblMain, String property) throws Exception {
        KDTextField textField = new KDTextField();
        textField.setMaxLength(40);
        TrainUtils.setTableCellEditorByTextField(tblMain, textField, property);
    }

    public static void setTableCellEditorByTextField(KDTable tblMain, KDTextField textField, String property) throws Exception {
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
    }

    public static void setTableCellEditorByTextField(KDTable tblMain, String property, int length) throws Exception {
        KDTextField textField = new KDTextField();
        textField.setMaxLength(length);
        TrainUtils.setTableCellEditorByTextField(tblMain, textField, property);
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setSupportedEmpty(true);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByF7Query(KDTable tblMain, String f7Query, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setQueryInfo(f7Query);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static void setTableCellEditorByF7Query(KDTable tblMain, String f7Query, String property, EntityViewInfo evi) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$name$");
        promptBox.setCommitFormat("$number$");
        promptBox.setEditable(true);
        promptBox.setQueryInfo(f7Query);
        promptBox.setEntityViewInfo(evi);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static void setTableCellEditorByF7Selector(KDTable tblMain, KDPromptSelector selector, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setEditable(true);
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$name$");
        promptBox.setCommitFormat("$number$");
        promptBox.setSelector(selector);
        promptBox.setEditable(false);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static void setTableCellEditorByDatePicker(KDTable tblMain, String property) throws Exception {
        TrainUtils.setTableCellEditorByDatePicker(tblMain, property, false);
    }

    public static void setTableCellEditorByDatePicker(KDTable tblMain, String property, boolean enableTime) throws Exception {
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setTimeEnabled(enableTime);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
    }

    public static void setTableCellEditorByEnum(KDTable tblMain, String enumClassName, String property) throws Exception {
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator it = (Iterator)Class.forName(enumClassName).getMethod("iterator", null).invoke(null, null);
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        comboBox.setModel(model);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    public static void setTableNumberFormat(KDTable tblMain, String columnKey, int precision) {
        String numberFormat = TrainUtils.getNumberFormat(precision);
        StyleAttributes styleAttributes = tblMain.getColumn(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
    }

    public static String getNumberFormat(int precision) {
        StringBuffer sb = new StringBuffer("0");
        if (precision > 0) {
            sb.append(".");
            for (int i = 0; i < precision; ++i) {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public static FilterInfo getCUFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static IRow[] getSelectedFullRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return null;
        }
        int count = TrainHelper.getSelectedRowCount(table);
        IRow[] rows = new IRow[count];
        int[] rowsIndex = TrainHelper.getSelectedRows(table);
        for (int i = 0; i < rowsIndex.length; ++i) {
            rows[i] = table.getRow(rowsIndex[i]);
        }
        return rows;
    }

    public static boolean isExistSameRowInTable(String columnKey, String keyValue, KDTable tblSelect) {
        int size = tblSelect.getRowCount();
        for (int i = 0; i < size; ++i) {
            String strId = tblSelect.getRow(i).getCell(columnKey).getValue().toString();
            if (!strId.equals(keyValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistDupRowInTable(KDTable tblSelect, String columnKey) {
        int size = tblSelect.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object keyValue = tblSelect.getRow(i).getCell(columnKey).getValue();
            if (keyValue == null) continue;
            for (int j = 0; j < size; ++j) {
                Object compareValue;
                if (j == i || (compareValue = tblSelect.getRow(j).getCell(columnKey).getValue()) == null || !compareValue.equals(keyValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static void showAttachmentList(String strBosId, Object owner) throws UIException {
        AttachmentClientManager am = AttachmentManagerFactory.getClientManager();
        am.showAttachmentListUIByBoID(strBosId, owner);
    }

    public static void showChanneCourseList(FilterInfo filter, String flag) throws UIException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", filter);
        map.put("flag", flag);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.hr.train.client.ChannelCourseListUI", map);
        uiWindow.show();
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit) throws Exception {
        TrainUtils.initOrgUnit(prmtOrgUnit, false);
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit, IUIObject owner) throws Exception {
        TrainUtils.initOrgUnit(prmtOrgUnit, false, owner);
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit, boolean isMultiSelected) throws Exception {
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(isMultiSelected);
        prmtOrgUnit.setSelector((KDPromptSelector)adminF7);
    }

    public static void initOrgUnit(KDBizPromptBox prmtOrgUnit, boolean isMultiSelected, IUIObject owner) throws Exception {
        NewAdminByHROF7 adminF7 = new NewAdminByHROF7();
        adminF7.setMultiSelect(isMultiSelected);
        prmtOrgUnit.setEditable(false);
        prmtOrgUnit.setQueryInfo(null);
        prmtOrgUnit.setSelector((KDPromptSelector)adminF7);
    }

    public static void initTrainCourseTree(KDBizPromptBox prmtTrainCourseTree, IUIObject owner) throws Exception {
        TrainCourseTreePromptBox f7UI = new TrainCourseTreePromptBox(owner);
        prmtTrainCourseTree.setSelector((KDPromptSelector)f7UI);
    }

    public static void initPerson(KDBizPromptBox prmtPerson, boolean isMultiSelected) throws Exception {
        EmployeeMultiF7PromptBox personF7 = new EmployeeMultiF7PromptBox();
        prmtPerson.setSelector((KDPromptSelector)personF7);
        prmtPerson.setEnabledMultiSelection(isMultiSelected);
    }

    public static void initPerson(KDBizPromptBox prmtPerson, boolean isMultiSelected, IUIObject owner) throws Exception {
        EmployeeMultiF7PromptBox personF7 = new EmployeeMultiF7PromptBox(owner);
        prmtPerson.setSelector((KDPromptSelector)personF7);
        prmtPerson.setEnabledMultiSelection(isMultiSelected);
        prmtPerson.setEditable(false);
    }

    public static void initTrainInstructor(KDBizPromptBox prmtInstructor, IUIObject owner) {
        TrainInstructorPromptBox instructorF7 = new TrainInstructorPromptBox(owner);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isOuter"));
        sic.add(new SelectorItemInfo("Employee.name"));
        sic.add(new SelectorItemInfo("Employee.number"));
        instructorF7.setSelector(sic);
        instructorF7.setSingleSelect(true);
        prmtInstructor.setVisible(true);
        prmtInstructor.setEditable(false);
        prmtInstructor.setDisplayFormatter((IFormatter)new TrainInstructorDisplayFormatter());
        prmtInstructor.setSelector((KDPromptSelector)instructorF7);
    }

    public static FilterInfo getHROrgUnitAndOrgRangeFilter(String hrOrgUnit, String adminOrgUnit) throws Exception {
        FilterInfo filterInfo = TrainUtils.buildHROFilter(adminOrgUnit);
        FilterInfo fi = new FilterInfo();
        if (filterInfo != null && filterInfo.getFilterItems().size() == 0) {
            fi.getFilterItems().add(new FilterItemInfo(adminOrgUnit, (Object)BOSUuid.create((BOSObjectType)new AdminOrgUnitInfo().getBOSType()).toString()));
        }
        fi.getFilterItems().add(new FilterItemInfo(hrOrgUnit, (Object)TrainUtils.getCurrentHROrgUnit().getId().toString()));
        if (filterInfo != null) {
            filterInfo.mergeFilter(fi, "AND");
        }
        return filterInfo;
    }

    public static FilterInfo getHROrgUnitFilter(String columnName) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)TrainUtils.getCurrentHROrgUnit().getId().toString()));
        return filterInfo;
    }

    public static FilterInfo buildHROFilter(String columnName) throws Exception {
        HROrgUnitInfo hroInfo;
        FilterInfo filterInfo = new FilterInfo();
        IHROrgUnit iHRO = HROrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollectionWithOrgRangeFilter((hroInfo = SysContext.getSysContext().getCurrentHRUnit()).getId().toString());
        if (adminColl != null && adminColl.size() > 0) {
            HashSet<String> ids = new HashSet<String>();
            int size = adminColl.size();
            for (int i = 0; i < size; ++i) {
                ids.add(adminColl.get(i).getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, ids, CompareType.INCLUDE));
        } else {
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)BOSUuid.create((BOSObjectType)adminInfo.getBOSType())));
        }
        return filterInfo;
    }

    public static DefaultKingdeeTreeNode goLeaf(KDTree tree) {
        TreeModel model = tree.getModel();
        if (model == null) {
            return null;
        }
        Object objNode = model.getRoot();
        while (tree.getModel().getChildCount(objNode) > 0) {
            objNode = tree.getModel().getChild(objNode, 0);
        }
        tree.setSelectionNode((DefaultKingdeeTreeNode)objNode);
        return (DefaultKingdeeTreeNode)objNode;
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (value == null) {
            return "";
        }
        String str = ZERO.compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static FilterInfo customMergeFilter(FilterInfo filter1, FilterInfo filter2, String mergeType) throws BOSException {
        FilterInfo filterResult = new FilterInfo();
        if (filter1 == null || filter1.getFilterItems().size() <= 0) {
            if (filter2 != null && filter2.getFilterItems().size() > 0) {
                filterResult = filter2;
            }
        } else if (filter2 == null || filter2.getFilterItems().size() <= 0) {
            filterResult = filter1;
        } else {
            filter1.mergeFilter(filter2, mergeType);
            filterResult = filter1;
        }
        return filterResult;
    }

    public static void disableTable(KDTable table) {
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    public static Date turncate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = f.parse(f.format(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static void setComboBoxSelected(KDComboBox comboBox, String id) {
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object item = comboBox.getItemAt(i);
            String value = null;
            if (item instanceof CoreBaseInfo) {
                value = ((CoreBaseInfo)item).getId().toString();
            } else if (item != null) {
                value = item.toString();
            }
            if (!id.equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public static void setComboBoxSelected(KDTEditEvent e) {
        KDTable table = (KDTable)e.getSource();
        Component component = table.getEditManager().getEditor().getComponent();
        if (component != null && component instanceof KDComboBox) {
            int colIndex = e.getColIndex();
            int rowIndex = e.getRowIndex();
            TrainUtils.setComboBoxSelected((KDComboBox)component, table, rowIndex, colIndex);
        }
    }

    public static void setComboBoxSelected(KDComboBox comboBox, KDTable table, int rowIndex, int colIndex) {
        DataBaseInfo info;
        IRow row = table.getRow(rowIndex);
        Object obj = row.getCell(colIndex).getValue();
        if (obj instanceof DataBaseInfo && (info = (DataBaseInfo)obj) != null && info.getId() != null) {
            TrainUtils.setComboBoxSelected(comboBox, info.getId().toString());
        }
    }

    public static void setEnumComboBoxSelected(KDComboBox comboBox, String id) {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object item = comboBox.getItemAt(i);
            String value = null;
            if (item == null) continue;
            if (item instanceof StringEnum) {
                value = ((StringEnum)item).getValue();
            } else if (item instanceof IntEnum) {
                value = String.valueOf(((IntEnum)item).getValue());
            } else if (item != null) {
                value = item.toString();
            }
            if (!id.equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public static Object[] batchAddRowWithData(KDTable kdTable, Object[] objs, String columnName) {
        Object[] oldObjs = new Object[kdTable.getRowCount() + objs.length];
        int curRowIndex = TrainUtils.getCurrentRowIndex(kdTable);
        for (int i = 0; i < objs.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)objs[i];
            if (info == null) continue;
            IRow row = kdTable.getRow(curRowIndex);
            Object oldObj = null;
            if (row != null && (oldObj = row.getCell(columnName).getValue()) != null && TrainUtils.isArrayContains(objs, oldObj)) {
                ++curRowIndex;
                --i;
                continue;
            }
            if (TrainUtils.isRepeatRowInTable(kdTable, info, columnName)) {
                objs[i] = null;
                continue;
            }
            if (curRowIndex + 1 > kdTable.getRowCount()) {
                kdTable.addRow();
            }
            if (row == null) {
                row = kdTable.getRow(curRowIndex);
            }
            oldObjs[curRowIndex] = oldObj;
            row.getCell(columnName).setValue((Object)info);
            ++curRowIndex;
            objs[i] = null;
        }
        return oldObjs;
    }

    public static void batchAddRowWithData(KDTable kdTable, Object[] objs, String columnName, RowDataHandler handler) {
        int curRowIndex = TrainUtils.getCurrentRowIndex(kdTable);
        for (int i = 0; i < objs.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)objs[i];
            if (info == null) continue;
            IRow row = null;
            if (curRowIndex + 1 > kdTable.getRowCount()) {
                row = kdTable.addRow();
            } else {
                Object oldObj;
                row = kdTable.getRow(curRowIndex);
                if (i != 0 && (oldObj = row.getCell(columnName).getValue()) != null) {
                    row = kdTable.addRow(curRowIndex);
                }
            }
            if (handler != null) {
                if (!handler.setRowData(row, info)) continue;
                ++curRowIndex;
                continue;
            }
            row.getCell(columnName).setValue((Object)info);
            ++curRowIndex;
        }
    }

    private static boolean isArrayContains(Object[] objs, Object obj) {
        boolean returnValue = false;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)obj;
        if (obj != null) {
            for (int i = 0; i < objs.length; ++i) {
                DataBaseInfo info = (DataBaseInfo)objs[i];
                if (info == null || !info.getId().equals((Object)dataBaseInfo.getId())) continue;
                returnValue = true;
                objs[i] = null;
                break;
            }
        }
        return returnValue;
    }

    public static boolean isRepeatRowInTable(KDTable kdTable, Object object, String columnName) {
        boolean returnValue = false;
        if (object != null) {
            for (int i = 0; i < kdTable.getRowCount(); ++i) {
                IRow row = kdTable.getRow(i);
                if (object instanceof CoreBaseInfo) {
                    CoreBaseInfo info = (CoreBaseInfo)row.getCell(columnName).getValue();
                    if (info == null || !info.getId().equals((Object)((CoreBaseInfo)object).getId())) continue;
                    returnValue = true;
                    break;
                }
                Object obj = row.getCell(columnName).getValue();
                if (obj == null || !obj.toString().equals(object.toString())) continue;
                returnValue = true;
                break;
            }
        }
        return returnValue;
    }

    public static int getCurrentRowIndex(KDTable kdTable) {
        int rowIndex = -1;
        KDTSelectBlock selectBlock = kdTable.getSelectManager().get();
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
        }
        return rowIndex;
    }

    public static void setMutilTableFromBIM(KDContainer container, KDTable table) {
        container.getContentPane().removeAll();
        container.getContentPane().add((Component)table);
    }

    public static IRow addLine(KDTable table) {
        if (table == null) {
            return null;
        }
        return table.addRow();
    }

    public static IRow insertLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = TrainUtils.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        return row;
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || TrainUtils.isTableColumnSelected(table)) {
            return;
        }
        int[] selectRowsIndex = TrainHelper.getSelectedRows(table);
        if (selectRowsIndex.length > 0) {
            int[] selectedColumnIndexs = TrainHelper.getSelectedColumns(table);
            Arrays.sort(selectRowsIndex);
            for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
                TrainUtils.removeRow(table, selectRowsIndex[i]);
            }
            if (table.getRowCount() > 0) {
                Arrays.sort(selectedColumnIndexs);
                int columnIndex = 0;
                if (selectedColumnIndexs.length > 0) {
                    columnIndex = selectedColumnIndexs[0];
                }
                table.getSelectManager().select(selectRowsIndex[0], columnIndex);
            }
        }
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = TrainUtils.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    public static void removeRows(KDTable table) {
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            TrainUtils.removeRow(table, i);
        }
    }

    private static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static void initMutilTableFromBIM(KDContainer container, Action actionAddLine, Action actionInsertLine, Action actionRemoveLine) {
        JButton btnAddLine = container.add(actionAddLine);
        btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.AddLine"));
        btnAddLine.setText(null);
        JButton btnInsertLine = container.add(actionInsertLine);
        btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        btnInsertLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.InsertLine"));
        btnInsertLine.setText(null);
        JButton btnRemoveLine = container.add(actionRemoveLine);
        btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnRemoveLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.train.TrainResource.RemoveLine"));
        btnRemoveLine.setText(null);
    }

    public static double numberMustPositive(JTextField textField) {
        double age = 0.0;
        if (!"".equals(textField.getText())) {
            try {
                age = 0.0;
                age = Double.parseDouble(textField.getText());
                if (age < 0.0) {
                    age = 0.0 - age;
                    textField.setText(String.valueOf(age));
                }
                return age;
            }
            catch (NumberFormatException exception) {
                return -1.0;
            }
        }
        return age;
    }

    public static Set getSelectedValues(KDTable tblMain) {
        HashSet<String> ids = new HashSet<String>();
        List selectedRows = TrainUtils.getSelectedRows(tblMain);
        IRow row = null;
        Iterator it = selectedRows.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            row = tblMain.getRow(index);
            if (row.getCell("id") == null || row.getCell("id").getValue() == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        return ids;
    }

    public static ItemAction[] addButtonsToMutilTable(KDContainer container, KDTable table) {
        return TrainUtils.addButtonsToMutilTable(container, table, null);
    }

    public static ItemAction[] addButtonsToMutilTable(KDContainer container, KDTable table, TableActionHandler handler) {
        TrainUtils.setMutilTableFromBIM(container, table);
        class ActionRow
        extends ItemAction {
            private String name;
            private KDTable table;
            private TableActionHandler handler;

            ActionRow(KDTable table, String name, TableActionHandler handler) {
                this.table = table;
                this.name = name;
                this.handler = handler;
            }

            public void actionPerformed(ActionEvent e) {
                if ("ActionAddLine".equals(this.name)) {
                    IRow row = TrainUtils.addLine(this.table);
                    if (this.handler != null) {
                        this.handler.afterAddLine(row);
                    }
                } else if ("ActionInsertLine".equals(this.name)) {
                    IRow row = TrainUtils.insertLine(this.table);
                    if (this.handler != null) {
                        this.handler.afterInsertLine(row);
                    }
                } else if ("ActionRemoveLine".equals(this.name)) {
                    TrainUtils.removeLine(this.table);
                }
            }
        }
        ActionRow actionAddLine = new ActionRow(table, "ActionAddLine", handler);
        ActionRow actionInsertLine = new ActionRow(table, "ActionInsertLine", handler);
        ActionRow actionRemoveLine = new ActionRow(table, "ActionRemoveLine", handler);
        TrainUtils.initMutilTableFromBIM(container, (Action)((Object)actionAddLine), (Action)((Object)actionInsertLine), (Action)((Object)actionRemoveLine));
        ItemAction[] actions = new ItemAction[]{actionAddLine, actionInsertLine, actionRemoveLine};
        return actions;
    }

    public static void setNumberMaximumValue(KDFormattedTextField field) {
        field.setMaximumValue((Comparable)new BigDecimal("999999999999.99"));
        field.setMinimumValue((Comparable)new BigDecimal("-999999999999.99"));
    }

    public static void setPositiveNumberValue(KDFormattedTextField field) {
        field.setMaximumValue((Comparable)new BigDecimal("999999999999.99"));
        field.setMinimumValue((Comparable)new BigDecimal("0.00"));
    }

    public static boolean isRepeatRowInTable(KDTable tblSelect, String columnKey) {
        int size = tblSelect.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object keyValue = tblSelect.getRow(i).getCell(columnKey).getValue();
            if (keyValue == null) continue;
            String keyValueId = keyValue instanceof CoreBaseInfo ? ((CoreBaseInfo)keyValue).getId().toString() : keyValue.toString();
            for (int j = i + 1; j < size; ++j) {
                String compareValueId;
                Object compareValue = tblSelect.getRow(j).getCell(columnKey).getValue();
                if (compareValue == null) continue;
                String string = compareValueId = compareValue instanceof CoreBaseInfo ? ((CoreBaseInfo)compareValue).getId().toString() : compareValue.toString();
                if (!keyValueId.equals(compareValueId)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeatRowInTableWithName(KDTable tblSelect, String columnKey) {
        int size = tblSelect.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object keyValue = tblSelect.getRow(i).getCell(columnKey).getValue();
            if (keyValue == null) continue;
            String name = ((DataBaseInfo)keyValue).getName();
            for (int j = 0; j < size; ++j) {
                String compareName;
                Object compareValue;
                if (j == i || (compareValue = tblSelect.getRow(j).getCell(columnKey).getValue()) == null || !name.equals(compareName = ((DataBaseInfo)compareValue).getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static FilterInfo getCurrentHRFilter(String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (TrainUtils.getCurrentHROrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitId, (Object)TrainUtils.getCurrentHROrgUnit().getId().toString()));
        }
        return filter;
    }

    public static FilterInfo getHRFilter(String hrOrgUnitColumn, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitColumn, (Object)hrOrgUnitId));
        return filter;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            for (int i = 0; i < objs.length; ++i) {
                Object o = objs[i];
                if (o != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isManager(String userId) throws Exception {
        OrgType ot = OrgType.Admin;
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)ot));
        IPermission ip = PermissionFactory.getRemoteInstance();
        HashMap hm = (HashMap)ip.getAuthorizedOrgs((IObjectPK)userPK, ot, (IObjectPK)treePK, null, null);
        return hm != null && hm.size() > 0;
    }

    public static String getPersonJobGrade(String personId) throws Exception {
        JobGradeInfo jobGradeInfo;
        if (personId == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("jobGrade.id"));
        evi.getSelector().add(new SelectorItemInfo("jobGrade.name"));
        PersonPositionCollection personPositionColl = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(evi);
        if (personPositionColl != null && personPositionColl.size() != 0 && (jobGradeInfo = personPositionColl.get(0).getJobGrade()) != null) {
            return jobGradeInfo.getName();
        }
        return null;
    }

    public static void selectFirstRow(KDTable table) {
        if (table.getRow(0) != null) {
            table.getSelectManager().select(0, 0);
        }
    }

    public static Date getDateMaxTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 23, 59, 59);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static EntityViewInfo getCurrentCUEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(TrainUtils.getCurrentCUFilter());
        return viewInfo;
    }

    public static EntityViewInfo getCurrentHREntityViewInfo(String hrOrgUnit) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(TrainUtils.getCurrentHRFilter(hrOrgUnit));
        return viewInfo;
    }

    public static EntityViewInfo getCurrentHREntityViewInfo() {
        return TrainUtils.getCurrentHREntityViewInfo("hrOrgUnit.id");
    }

    public static EntityViewInfo getHRAndAdminRangeEntityViewInfo(String hrOrgUnitId, String adminOrgUnitId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(TrainUtils.getHRAndAdminRangeFilterInfo(hrOrgUnitId, adminOrgUnitId));
        return viewInfo;
    }

    public static HashMap getPersonProperty(Set persons) throws Exception {
        HashMap personMap = new HashMap();
        if (persons == null || persons.size() == 0) {
            return personMap;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)persons, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "PersonToPositionGradeLevelQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        while (rowSet.next()) {
            HashMap<String, String> personRef = new HashMap<String, String>();
            personRef.put("name", rowSet.getString("name"));
            personRef.put("number", rowSet.getString("number"));
            personRef.put("orgUnit", rowSet.getString("orgUnit.name"));
            personRef.put("jobGrade", rowSet.getString("jobGrade.name"));
            personRef.put("position", rowSet.getString("position.name"));
            personRef.put("id", rowSet.getString("id"));
            personMap.put(rowSet.getString("id"), personRef);
        }
        return personMap;
    }

    public static boolean confirmRemove(Component component) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)component, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public static void selectedCopy(KDTable table) {
        if (table.getRowCount() == 0) {
            return;
        }
        int size = table.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = table.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = table.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked() || table.getCell(row, column).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = table.getCell(row, column).getValue();
            for (int i = 0; i < size; ++i) {
                sb = table.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    if (table.getCell(j, column).getStyleAttributes().isLocked()) continue;
                    table.getCell(j, column).setValue(value);
                }
            }
        }
    }

    public static BigDecimal transferUnit(String from, Map map) throws BOSException {
        BigDecimal format = null;
        if (CourseHourUnitEnum.DAY.toString().equals(from)) {
            format = new BigDecimal(map.get(new BigDecimal(String.valueOf(1))).toString());
        }
        if (CourseHourUnitEnum.HOUR.toString().equals(from)) {
            format = new BigDecimal(map.get(new BigDecimal(String.valueOf(2))).toString());
        }
        if (CourseHourUnitEnum.SECTOR.toString().equals(from)) {
            format = new BigDecimal(map.get(new BigDecimal(String.valueOf(3))).toString());
        }
        return format;
    }

    public static void setKDTableSortable(KDTable table) {
        KDTSortManager sm = new KDTSortManager(table);
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    public static Map getMainUnitMap() throws BOSException {
        HashMap<CourseHourUnitEnum, BigDecimal> result = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("parent.mainUnitType"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainTransferType"));
        viewInfo.getSelector().add(new SelectorItemInfo("TransferFormat"));
        FilterInfo filterInfo = TrainUtils.getCurrentHRFilter("parent.hrOrgUnit.id");
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.IsEnable", (Object)1));
        viewInfo.setFilter(filterInfo);
        TrainUnitTransferCollection collection = TrainUnitTransferFactory.getRemoteInstance().getTrainUnitTransferCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            result = new HashMap<CourseHourUnitEnum, BigDecimal>();
            TrainUnitTransferInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                if (i == 0) {
                    result.put(info.getParent().getMainUnitType(), new BigDecimal("1"));
                }
                result.put(info.getTrainTransferType(), info.getTransferFormat());
            }
        }
        return result;
    }

    public static CourseHourUnitEnum getMainUnitType(Map mainUnitMap) {
        CourseHourUnitEnum mainUnitType = null;
        if (mainUnitMap != null) {
            Object key = null;
            for (Map.Entry entry : mainUnitMap.entrySet()) {
                key = entry.getKey();
                if (!"1".equals(mainUnitMap.get(key).toString())) continue;
                mainUnitType = key;
                break;
            }
        }
        return mainUnitType;
    }

    public static boolean hasDefaultSolution(IMetaDataPK mainQueryPK, String className) throws BOSException, EASBizException {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        return iQuery.hasDefaultSolution(className, mainQueryPK.getFullName());
    }

    public static void addComboBoxEmptyItem(KDComboBox comboBox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
        model.insertElementAt(null, 0);
    }

    public static String getCurrentPersonId() {
        String currentPersonId = null;
        if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
            currentPersonId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        }
        return currentPersonId;
    }

    public static AdminOrgUnitInfo getUserOrgInfo(String personId) throws EASBizException, BOSException, UuidException {
        AdminOrgUnitInfo orgUnitInfo = null;
        if (!TrainCommonUtils.isEmpty(personId)) {
            orgUnitInfo = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
        }
        return orgUnitInfo;
    }

    public static SelectorItemCollection mergeSelectorItemCollection(SelectorItemCollection first, SelectorItemCollection second) {
        SelectorItemCollection sic = null;
        if (first != null) {
            sic = first;
            if (second != null) {
                for (int i = 0; i < second.size(); ++i) {
                    sic.add(second.get(i));
                }
            }
        } else {
            sic = second;
        }
        return sic;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return TrainUtils.getHRAndAdminRangeFilterInfo(hrColumnName, orgUnitColumnName, hrOrgUnitID);
    }

    public static FilterInfo getRangeFilterInfo(String hrColumnName) {
        SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(hrColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static String getAdminRangeSql() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        return sql.toString();
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName, String hrOrgUnitId) {
        FilterInfo filter = TrainUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitId);
        FilterItemInfo item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitId);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String orgUnitColumnName) {
        String hrOrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return TrainUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitId);
    }

    public static FilterInfo getAdminRangeFilterInfo(String orgUnitColumnName, String hrOrgUnitId) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String sql = TrainUtils.getAdminRangeSQL(hrOrgUnitId, userID);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql, CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static String getAdminRangeSQL(String hrOrgUnitId, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static FilterInfo getAdminRangeFilterInfo(String orgUnitColumnName) {
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return TrainUtils.getAdminRangeFilterInfo(orgUnitColumnName, hrOrgUnitID);
    }

    public static String getHRAndAdminRangePersonSQL(String hrOrgUnitID, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_HR_PERSONPOSITION AS PP ON PP.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = PP.FPERSONDEP");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static FilterInfo getHRAndAdminRangePersonFilterInfo(String hrColumnName, String personColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        String sql = TrainUtils.getHRAndAdminRangePersonSQL(hrOrgUnitID, userID);
        filterInfo.getFilterItems().add(new FilterItemInfo(personColumnName, (Object)sql, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID));
        return filterInfo;
    }

    public static String getHRAndAdminRangePersonSQL_All(String hrOrgUnitID, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_ORG_POSITIONMEMBER AS PM ON PM.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_POSITION AS Position ON PM.FPOSITIONID = Position.FID");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = Position.FAdminOrgUnitID");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID in (");
        sql.append(hrOrgUnitID);
        sql.append(") ");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static FilterInfo getHRAndAdminRangePersonFilterInfo_All(String hrColumnName, String personColumnName) throws EASBizException, BOSException {
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID));
        filterInfo.mergeFilter(TrainUtils.getHRAndAdminRangePersonFilterInfo_All(personColumnName), "AND");
        return filterInfo;
    }

    public static FilterInfo getHRAndAdminRangePersonFilterInfo_All(String personColumnName) throws EASBizException, BOSException {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String str_hrid = null;
        HashSet col = TrainUtils.getHRRangeID();
        str_hrid = TrainCommonUtils.collectionToStrings(col);
        FilterInfo filterInfo = new FilterInfo();
        String sql = TrainUtils.getHRAndAdminRangePersonSQL_All(str_hrid, userID);
        filterInfo.getFilterItems().add(new FilterItemInfo(personColumnName, (Object)sql, CompareType.INNER));
        return filterInfo;
    }

    public static String getHRAndAdminRangePersonSQL() {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer hrOrgUnitID_buf = new StringBuffer();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        hrOrgUnitID_buf.append("'").append(hrOrgUnitID).append("'");
        String sql = TrainUtils.getHRAndAdminRangePersonSQL_All(hrOrgUnitID_buf.toString(), userID);
        return sql;
    }

    public static HashSet getHRRangeID() throws EASBizException, BOSException {
        return TrainActivityFacadeFactory.getRemoteInstance().getHRRange();
    }

    public static void removeLintMenu(KDTable table, KDTMenuManager tm) {
        Component[] obj = tm.getMenu().getComponents();
        Component comp3 = null;
        Component comp2 = null;
        for (Component comp3 : obj) {
            if (comp3.getName() == null || !comp3.getName().equals("menuPublishReport")) continue;
            Component[] menus = ((KDMenu)comp3).getMenuComponents();
            for (int t = 0; t < menus.length; ++t) {
                comp2 = menus[t];
                if (comp3.getName() == null) continue;
                if (comp2.getName().equals("separatorRpt")) {
                    ((JPopupMenu.Separator)comp2).setVisible(false);
                }
                if (!comp2.getName().equals("menuItemToLinkForRpt")) continue;
                ((KDMenuItem)comp2).setVisible(false);
            }
        }
    }

    public static String setSetToString(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        boolean flag = false;
        while (it.hasNext()) {
            if (flag) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(it.next());
            sb.append("'");
            flag = true;
        }
        String str = sb.toString();
        return str;
    }

    public static boolean getParamValueByNumber(String number) throws Exception {
        String HRO_ID;
        String isShare = null;
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        isShare = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), number);
        return "true".equals(isShare);
    }

    public static FilterItemInfo getAdminRangeFilterItemInfo(Context ctx, String orgID) {
        String sql = TrainUtils.getAdminRangeSql(ctx);
        FilterItemInfo item = new FilterItemInfo(orgID, (Object)sql, CompareType.INNER);
        return item;
    }

    public static String getAdminRangeSql(Context ctx) {
        String userID = TrainUtils.getCurrentUserId(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID in (");
        sql.append(TrainUtils.getHRRangeByUserId(userID));
        sql.append(") AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    private static String getCurrentUserId(Context ctx) {
        String userID = null;
        userID = ctx != null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        return userID;
    }

    public static String getHRRangeByUserId(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRange.forgId as forgId from T_PM_OrgRange orgRange ");
        sql.append("where orgRange.ftype = ");
        sql.append(10);
        sql.append(" and fuserid = '");
        sql.append(userID);
        sql.append("' ");
        return sql.toString();
    }

    public static Set getHRByParamNumber(String number) {
        HashSet<String> ids = new HashSet<String>();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        IParamItem iParamItem = null;
        try {
            iParamItem = ParamItemFactory.getRemoteInstance();
            ParamItemCollection col = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            SorterItemCollection sorters = new SorterItemCollection();
            filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)number));
            sorters.add(new SorterItemInfo("id"));
            sorters.add(new SorterItemInfo("Value"));
            sorters.add(new SorterItemInfo("orgUnitID.id"));
            view.setFilter(filterInfo);
            view.setSorter(sorters);
            col = iParamItem.getParamItemCollection(view);
            ids.add(hrOrgUnitID);
            if (col != null && col.size() > 0) {
                String id = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    id = col.get(i).getOrgUnitID().getId().toString();
                    if (!"true".equals(col.get(i).getValue()) || ids.contains(id)) continue;
                    ids.add(id);
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return ids;
    }

    public static FilterItemInfo getUserAdminRangeFilter(String queryColumn) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        FilterItemInfo item = new FilterItemInfo(queryColumn, (Object)sql.toString(), CompareType.INNER);
        return item;
    }

    public static FilterInfo getTrianInstructorFilter(boolean isShare, boolean isOuter, String source) throws Exception {
        FilterInfo returnFilter = new FilterInfo();
        if (isShare) {
            return null;
        }
        returnFilter.getFilterItems().add(new FilterItemInfo("Range.AdminOrgUnit.id", (Object)TrainUtils.getAdminRangeSql(), CompareType.INNER));
        if ("list".equals(source)) {
            returnFilter.getFilterItems().add(new FilterItemInfo("IsOuter", (Object)isOuter));
        }
        returnFilter.mergeFilter(TrainUtils.getAdminRangeFilterInfo("AdminOrgUnit.id"), "OR");
        return returnFilter;
    }

    public static FilterInfo getTrianItemTreeFilter(Set hrOrgUintIdSet) throws Exception {
        FilterInfo returnFilter = new FilterInfo();
        StringBuffer innerSql = new StringBuffer();
        innerSql.append("select tree.Fid from T_HR_TrainItemTREE tree ");
        innerSql.append("left join T_HR_TrainItem item on tree.Fid = item.FTreeID ");
        innerSql.append("left join T_HR_TrainItemRange range on range.FParentID = item.Fid ");
        innerSql.append("where ( range.FAdminOrgUnitID in ( ");
        innerSql.append(TrainUtils.getAdminRangeSql());
        innerSql.append(" ) and  item.FHROrgUnitID in( ");
        innerSql.append(TrainUtils.convertSetToString(hrOrgUintIdSet));
        innerSql.append(" ))");
        innerSql.append(" or tree.FHROrgUnitID  ='");
        innerSql.append(TrainUtils.getCurrentHROrgUnit().getId().toString());
        innerSql.append("' ");
        returnFilter.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql.toString(), CompareType.INNER));
        return returnFilter;
    }

    public static FilterInfo getRangeOutCourseFilter() {
        FilterInfo fiOut = new FilterInfo();
        StringBuffer innerSql = new StringBuffer();
        innerSql.append("select course.Fid from T_HR_TrainCourse course ");
        innerSql.append("left join T_HR_TrainCourseRange range on range.FTrainCourseID = course.Fid ");
        innerSql.append("inner join (" + TrainUtils.getAdminRangeSql() + ") as temp ");
        innerSql.append("on range.FAdminOrgUnitID =temp.FOrgID ");
        innerSql.append("where course.FHROrgUnitID <> '");
        innerSql.append(TrainUtils.getCurrentHROrgUnit().getId().toString());
        innerSql.append("'");
        fiOut.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql.toString(), CompareType.INNER));
        return fiOut;
    }

    public static FilterInfo getRangeOutTreeCourseFilter() {
        FilterInfo fiOut = new FilterInfo();
        StringBuffer innerSql = new StringBuffer();
        innerSql.append("select tree.Fid from T_HR_TrainCourseTree tree ");
        innerSql.append("left join T_HR_TrainCourse course on tree.Fid = course.FTreeID ");
        innerSql.append("left join T_HR_TrainCourseRange range on range.FTrainCourseID = course.Fid ");
        innerSql.append("inner join (" + TrainUtils.getAdminRangeSql() + ") as temp ");
        innerSql.append("on range.FAdminOrgUnitID =temp.FOrgID ");
        innerSql.append("where course.FHROrgUnitID <> '");
        innerSql.append(TrainUtils.getCurrentHROrgUnit().getId().toString());
        innerSql.append("'");
        fiOut.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql.toString(), CompareType.INNER));
        return fiOut;
    }

    public static String convertSetToString(Set set) {
        if (set == null || set.size() <= 0) {
            return "''";
        }
        Iterator iter = set.iterator();
        StringBuffer sql = new StringBuffer();
        while (iter.hasNext()) {
            sql.append("'");
            sql.append(iter.next());
            sql.append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        return sql.toString();
    }
}

