/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;

public class TrainVerifyUtils {
    private static String path = "com.kingdee.eas.hr.train.TrainVerifyResource";

    public static void verifyInput(CoreUIObject ui, String resourcePath, KDTable kdtEntries, IRow row, int i, String msg) {
        if (TrainVerifyUtils.isEmpty(row.getCell(i).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), i);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            TrainVerifyUtils.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInputByContainer(KDContainer cont, KDTable kdTable) {
        if (kdTable.getRowCount() == 0 && cont.getTitle() != null) {
            MsgBox.showInfo((String)(cont.getTitle().toString() + EASResource.getString((String)path, (String)"CanNotBeNull")));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (TrainVerifyUtils.isEmpty(row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)path, (String)"CanNotBeNull");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showInfo((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyDateGreaterThan(CoreUIObject ui, KDTable kdtTable, String key1, String key2) {
        IRow row = null;
        for (int i = 0; i < kdtTable.getRowCount(); ++i) {
            row = kdtTable.getRow(i);
            TrainVerifyUtils.verifyDateGreaterThan(ui, kdtTable, row, key1, key2);
        }
    }

    public static void verifyDateGreaterThan(CoreUIObject ui, KDTable kdtTable, IRow row, String key1, String key2) {
        Object obj1 = row.getCell(key1).getValue();
        Object obj2 = row.getCell(key2).getValue();
        Date date1 = null;
        Date date2 = null;
        if (obj1 instanceof Date) {
            date1 = DateTimeUtils.truncateDate((Date)((Date)obj1));
        }
        if (obj2 instanceof Date) {
            date2 = DateTimeUtils.truncateDate((Date)((Date)obj2));
        }
        if (date1 != null && date2 != null && date2.before(date1)) {
            int colIndex = kdtTable.getColumnIndex(key1);
            kdtTable.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            StringBuffer message = new StringBuffer();
            message.append(kdtTable.getHeadRow(0).getCell(key2).getValue());
            message.append(EASResource.getString((String)path, (String)"BigThanOrEqual"));
            message.append(kdtTable.getHeadRow(0).getCell(key1).getValue());
            message.append(EASResource.getString((String)path, (String)"!"));
            MsgBox.showWarning((Component)ui, (String)message.toString());
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        if (!txtNumber.isEnabled()) {
            return;
        }
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        TrainVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextArea txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextArea txtNumber) {
        TrainVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static String getMessage(Component component) {
        String text = TrainVerifyUtils.getBoundLabelText(component);
        text = text.replaceFirst(":", "").trim();
        return text + EASResource.getString((String)path, (String)"CanNotBeNull");
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        TrainVerifyUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(msg == null ? TrainVerifyUtils.getMessage((Component)bizBox) : msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        Object content = comboBox.getSelectedItem();
        if (content == null) {
            comboBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)comboBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        TrainVerifyUtils.verifyEmpty(ui, null, comboBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)datePicker) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        TrainVerifyUtils.verifyEmpty(ui, null, datePicker, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizMultiLangBox txtNumber, String msg) {
        Object txt = txtNumber.getSelectedItem();
        if (txt == null || txt.toString().trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizMultiLangBox txtNumber) {
        TrainVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? TrainVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        TrainVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void checkStringLength(Component ui, String resourcePath, IRow row, String colName, int length) {
        String name = (String)row.getCell(colName).getValue();
        if (name != null && name.length() > length) {
            MsgBox.showWarning((Component)ui, (String)(EASResource.getString((String)resourcePath, (String)"StringLengthGreaterthan") + length + ":" + "\n\n" + name));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).equals(new BigDecimal("0"))) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyDateBigOrSmall(CoreUIObject ui, KDDatePicker pkStartDate, KDDatePicker pkEndDate) {
        TrainVerifyUtils.verifyDateBigOrSmall(ui, pkStartDate, pkEndDate, null);
    }

    public static void verifyDateBigOrSmall(CoreUIObject ui, KDDatePicker pkStartDate, KDDatePicker pkEndDate, String message) {
        Date smallDate;
        if (pkStartDate.getValue() == null || pkEndDate.getValue() == null) {
            return;
        }
        Date bigDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        if (!bigDate.after(smallDate = DateTimeUtils.truncateDate((Date)((Date)pkStartDate.getValue())))) {
            pkEndDate.requestFocus(true);
            if (message == null) {
                message = TrainVerifyUtils.getBoundLabelText((Component)pkEndDate) + EASResource.getString((String)path, (String)"BigThan") + TrainVerifyUtils.getBoundLabelText((Component)pkStartDate) + EASResource.getString((String)path, (String)"!");
            }
            MsgBox.showInfo((Component)ui, (String)message);
            SysUtil.abort();
        }
    }

    public static void verifyDateBigOrSmallOrEqual(CoreUIObject ui, KDDatePicker pkStartDate, KDDatePicker pkEndDate, String message) {
        if (pkStartDate.getValue() == null || pkEndDate.getValue() == null) {
            return;
        }
        Date bigDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        Date smallDate = DateTimeUtils.truncateDate((Date)((Date)pkStartDate.getValue()));
        if (smallDate.after(bigDate)) {
            pkEndDate.requestFocus(true);
            if (message == null) {
                message = TrainVerifyUtils.getBoundLabelText((Component)pkEndDate) + EASResource.getString((String)path, (String)"BigThanOrEqual") + TrainVerifyUtils.getBoundLabelText((Component)pkStartDate) + EASResource.getString((String)path, (String)"Period");
            }
            MsgBox.showInfo((Component)ui, (String)message);
            SysUtil.abort();
        }
    }

    public static void verifyDateTimeBigOrSmall(CoreUIObject ui, KDDatePicker pkStartDate, KDDatePicker pkEndDate) {
        Date smallDate;
        if (pkStartDate.getValue() == null || pkEndDate.getValue() == null) {
            return;
        }
        Date bigDate = (Date)pkEndDate.getValue();
        if (!bigDate.after(smallDate = (Date)pkStartDate.getValue())) {
            pkEndDate.requestFocus(true);
            String msg = TrainVerifyUtils.getBoundLabelText((Component)pkEndDate) + EASResource.getString((String)path, (String)"BigThan") + TrainVerifyUtils.getBoundLabelText((Component)pkStartDate) + EASResource.getString((String)path, (String)"Period");
            MsgBox.showInfo((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyNumberPositive(CoreUIObject ui, KDFormattedTextField field) {
        Number number = field.getNumberValue();
        if (number == null) {
            return;
        }
        if (number.doubleValue() <= 0.0) {
            field.requestFocus();
            String msg = TrainVerifyUtils.getBoundLabelText((Component)field) + EASResource.getString((String)path, (String)"MustBePositive");
            MsgBox.showInfo((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyNumberPositive(CoreUIObject ui, KDTable table, String columnName) {
        if (table != null && table.getRowCount() > 0) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow row = table.getRow(i);
                Number number = (Number)row.getCell(columnName).getValue();
                if (number == null || !(number.doubleValue() <= 0.0)) continue;
                table.getEditManager().editCellAt(i, table.getColumnIndex(columnName));
                String headName = table.getHeadRow(0).getCell(columnName).getValue().toString();
                String msg = headName + EASResource.getString((String)path, (String)"MustBePositive");
                MsgBox.showInfo((Component)ui, (String)msg);
                SysUtil.abort();
            }
        }
    }

    public static void verifyNumberBig(CoreUIObject ui, KDFormattedTextField firstNumber, KDFormattedTextField secondNumber) {
        Number first = firstNumber.getNumberValue();
        Number second = secondNumber.getNumberValue();
        if (first == null || second == null) {
            return;
        }
        if (second.doubleValue() > first.doubleValue()) {
            firstNumber.requestFocus();
            StringBuffer msg = new StringBuffer();
            msg.append(TrainVerifyUtils.getBoundLabelText((Component)secondNumber));
            msg.append(" ");
            msg.append(EASResource.getString((String)path, (String)"CanNotBig"));
            msg.append(" ");
            msg.append(TrainVerifyUtils.getBoundLabelText((Component)firstNumber));
            MsgBox.showInfo((Component)ui, (String)msg.toString());
            SysUtil.abort();
        }
    }

    public static boolean isEmpty(Object o) {
        return o == null || o.toString().trim().length() == 0;
    }

    public static boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (TrainVerifyUtils.objectIsNull(value)) {
            return "";
        }
        String str = value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static BigDecimal objToBigDecimal(Object obj) {
        if (TrainVerifyUtils.objectIsNull(obj)) {
            return new BigDecimal("0.0");
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        try {
            return new BigDecimal(obj.toString().trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean bigDecimalBetween(BigDecimal value, BigDecimal from, BigDecimal to) {
        if (TrainVerifyUtils.objectIsNull(value) || TrainVerifyUtils.objectIsNull(from) || TrainVerifyUtils.objectIsNull(to)) {
            return false;
        }
        BigDecimal zeroDecimal = new BigDecimal("0.0");
        return value.subtract(from).compareTo(zeroDecimal) >= 0 && to.subtract(value).compareTo(zeroDecimal) >= 0;
    }

    public static boolean isNumberString(String str) {
        if (TrainVerifyUtils.objectIsNull(str)) {
            return false;
        }
        str = str.trim();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static RankInfo getRankInfoInEvaluFlow(String solutionPeriodId, String evaluObjectId) throws Exception {
        if (solutionPeriodId == null || evaluObjectId == null) {
            return null;
        }
        return EvalWorkFlowFacadeFactory.getRemoteInstance().getNodeProcesserRankInfo(solutionPeriodId, evaluObjectId);
    }

    public static void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public static void verifyEntrys(CoreUIObject ui, KDTable table, String displayName) {
        if (table.getRowCount() == 0) {
            MessageFormat format = new MessageFormat(EASResource.getString((String)path, (String)"MustHaveOneEntry"));
            String msg = format.format(new Object[]{displayName});
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyRepeatRow(CoreUIObject ui, KDTable table, String columnName, String displayName) {
        if (TrainUtils.isRepeatRowInTable(table, columnName)) {
            MessageFormat format = new MessageFormat(EASResource.getString((String)path, (String)"CannotRepeated"));
            if (displayName == null) {
                displayName = table.getHeadRow(0).getCell(columnName).getValue().toString();
            }
            String msg = format.format(new Object[]{displayName});
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static boolean verifyDateEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        String content = datePicker.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showWarning((Component)ui, (String)TrainVerifyUtils.getMessage((Component)datePicker));
            datePicker.requestFocus(true);
            return true;
        }
        return false;
    }
}

