/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.client.tree.NewOrgTreeHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.train.ITrainExpenseReportFacade;
import com.kingdee.eas.hr.train.TrainExpenseReportFacadeFactory;
import com.kingdee.eas.hr.train.TrainExpenseReportHelper;
import com.kingdee.eas.hr.train.client.AbstractTrianExpenseReportUI;
import com.kingdee.eas.hr.train.client.TrainExpenseFilterUI;
import com.kingdee.eas.hr.train.client.TrainTreeTable;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TrianExpenseReportUI
extends AbstractTrianExpenseReportUI {
    private static final Logger logger = CoreUIObject.getLogger(TrianExpenseReportUI.class);
    private static final String RES = "com.kingdee.eas.hr.train.client.TrainReportResource";
    private boolean isFirstDefaultQuery = true;
    private CustomerParams params = null;
    private CommonQueryDialog commonQueryDialog = null;
    private TrainExpenseFilterUI customerPanel;
    private DefaultKingdeeTreeNode childNode = null;
    private AdminOrgUnitInfo selectOrgUnitInfo = null;
    private boolean isActivity = false;
    private boolean isCourse = false;

    public void onLoad() throws Exception {
        this.checkLicense();
        this.handlePermissionForItemAction((ItemAction)this.actionOnLoad);
        this.initTable();
        this.btnExport.setEnabled(true);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        TrainTreeTable.setHRTreeTable(this.tblMain, "colOrg");
        this.enableExportExcel(this.tblMain);
        this.tblMain.getViewManager().setFreezeView(0, 1);
        this.initToolbar();
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
        this.enableOAMenu(this.tblMain);
        TrainUtils.removeLintMenu(this.tblMain, this.getMenuManager(this.tblMain));
        this.actionQuery_actionPerformed(null);
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemOutput.setEnabled(true);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.INVITE_MANAGEMENT;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void initTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getHeadMergeManager().setMergeMode(3);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = TrianExpenseReportUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getQueryPanelInfo().size() <= 0 || solution.getQueryPanelInfo().get(0).getCustomerParams() == null) {
                this.showFilterUI();
            } else if (solution.getQueryPanelInfo().size() > 0 && solution.getQueryPanelInfo().get(0).getCustomerParams() != null) {
                this.params = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                this.buildFilterFromParam();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterUI();
        }
        this.refresh();
    }

    private void showFilterUI() throws Exception {
        if (this.customerPanel == null) {
            this.customerPanel = new TrainExpenseFilterUI();
        }
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(355);
            this.commonQueryDialog.setWidth(442);
            this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
            this.commonQueryDialog.setTitle(EASResource.getString((String)RES, (String)"trainExpenseFilter"));
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setDisShowRowCount(true);
        }
        if (this.commonQueryDialog.show()) {
            this.params = this.customerPanel.getCustomerParams();
            this.buildFilterFromParam();
        } else {
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        TrainExpenseFilterUI userPanel = null;
        try {
            userPanel = new TrainExpenseFilterUI();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            super.handleException(e);
        }
        if (userPanel != null) {
            queryDlg.addUserPanel((KDPanel)userPanel);
        }
        queryDlg.setShowSorter(true);
        queryDlg.setDisShowRowCount(true);
        queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        queryDlg.setQueryObjectPK(this.mainQueryPK);
        queryDlg.setUiObject((IUIObject)this);
        return queryDlg;
    }

    private void refresh() throws Exception {
        this.removeAllColumn();
        this.initTableColumn();
        this.setTableData();
        TrainTreeTable.hideLevelRow(this.tblMain, 1, "colOrg");
    }

    private void buildFilterFromParam() throws Exception {
        if (this.params == null) {
            return;
        }
        if (this.customerPanel != null) {
            AdminOrgUnitInfo orgUnitInfo = (AdminOrgUnitInfo)this.customerPanel.promOrg.getValue();
            if (orgUnitInfo != null) {
                this.selectOrgUnitInfo = orgUnitInfo;
            }
        } else {
            String orgId = this.params.getCustomerParam("orgInfo");
            if (orgId != null) {
                this.selectOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        this.isActivity = this.params.getBoolean("isActivity");
        this.isCourse = this.params.getBoolean("isCourse");
    }

    private void removeAllColumn() {
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        IColumn col = this.tblMain.addColumn();
        col.setWidth(150);
        col.setKey("colOrg");
        IRow headerRow = this.tblMain.addHeadRow();
        headerRow.getCell("colOrg").setValue((Object)EASResource.getString((String)RES, (String)"unit"));
    }

    private void setTableData() throws Exception {
        Vector<AdminOrgUnitInfo> vec = new Vector<AdminOrgUnitInfo>();
        DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode();
        if (rootNode == null) {
            return;
        }
        AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
        if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
            rootInfo.put("isEnable", (Object)false);
        } else {
            rootInfo.put("isEnable", (Object)true);
        }
        rootInfo.setLevel(rootNode.getLevel());
        if (rootNode.getChildCount() == 0) {
            rootInfo.setIsStart(true);
        } else {
            rootInfo.setIsStart(false);
        }
        vec.add(rootInfo);
        this.getCellUserObjects(rootNode, vec);
        if (vec.size() == 0) {
            return;
        }
        ITrainExpenseReportFacade facade = TrainExpenseReportFacadeFactory.getRemoteInstance();
        Map result = null;
        Vector<AdminOrgUnitInfo> rootUnit = new Vector<AdminOrgUnitInfo>();
        rootUnit.add(rootInfo);
        this.preGetData(rootUnit).callHandler();
        result = facade.queryTrainExpense(rootUnit, this.params.getDate("startDate"), this.params.getDate("endDate"), this.isActivity, this.isCourse, this.params.getCustomerParam("activityId"), this.params.getCustomerParam("courseId"));
        if (result == null) {
            return;
        }
        AdminOrgUnitInfo orgNodeInfo = null;
        HRCellUserObject hrObj = null;
        IRow curRow = null;
        int baseLevel = 0;
        KDTMergeManager mm = this.tblMain.getMergeManager();
        HRCellTreeRenderer render = new HRCellTreeRenderer();
        String benbu = EASResource.getString((String)RES, (String)"baseDept");
        List hasData = null;
        int newRowNum = 0;
        int rowCount = 0;
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            TrainExpenseReportHelper helper;
            List list;
            orgNodeInfo = (AdminOrgUnitInfo)vec.get(i);
            hasData = (List)result.get(orgNodeInfo.getId().toString());
            if (hasData == null) {
                ++rowCount;
                continue;
            }
            curRow = this.tblMain.addRow();
            if (i == 0) {
                baseLevel = orgNodeInfo.getLevel();
            }
            orgNodeInfo.setLevel(orgNodeInfo.getLevel() - baseLevel + 1);
            hrObj = new HRCellUserObject();
            hrObj.setCompanyId(orgNodeInfo.getId().toString());
            if (orgNodeInfo.getName() == null) {
                hrObj.setName("");
            } else {
                hrObj.setName(orgNodeInfo.getName());
            }
            hrObj.setIsLeaf(orgNodeInfo.isIsLeaf());
            hrObj.setLevel(orgNodeInfo.getLevel());
            hrObj.setLongNumber(orgNodeInfo.getLongNumber());
            hrObj.setExpanded(!hrObj.isLeaf());
            curRow.getCell("colOrg").setValue((Object)hrObj);
            curRow.getCell("colOrg").setRenderer((IBasicRender)render);
            if (!Boolean.valueOf(orgNodeInfo.get("isEnable").toString()).booleanValue()) {
                this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            }
            if (!this.isActivity && !this.isCourse) {
                list = (List)result.get(orgNodeInfo.getId().toString());
                if (list != null && list.size() > 0) {
                    TrainExpenseReportHelper helper2 = (TrainExpenseReportHelper)list.get(0);
                    curRow.getCell("trainExpense").setValue((Object)new Double(helper2.getExpense()));
                }
            } else {
                list = (List)result.get(orgNodeInfo.getId().toString());
                if (list != null && list.size() > 0) {
                    int n = list.size();
                    for (int k = 0; k < n; ++k) {
                        helper = (TrainExpenseReportHelper)list.get(k);
                        if (k == 0) {
                            curRow.getCell("trainExpense").setValue((Object)new Double(helper.getExpense()));
                            if (this.isActivity && this.isCourse) {
                                curRow.getCell("activity").setValue((Object)helper.getActivityInfo().getName());
                                curRow.getCell("course").setValue((Object)helper.getCourseInfo().getName());
                                continue;
                            }
                            if (this.isActivity && !this.isCourse) {
                                curRow.getCell("activity").setValue((Object)helper.getActivityInfo().getName());
                                continue;
                            }
                            if (!this.isCourse || this.isActivity) continue;
                            curRow.getCell("course").setValue((Object)helper.getCourseInfo().getName());
                            continue;
                        }
                        IRow tempRow = this.tblMain.addRow();
                        HRCellUserObject obj = new HRCellUserObject();
                        obj.setName(" ");
                        obj.setCompanyId("test");
                        obj.setIsLeaf(orgNodeInfo.isIsLeaf());
                        obj.setLevel(orgNodeInfo.getLevel());
                        obj.setLongNumber(orgNodeInfo.getLongNumber());
                        obj.setExpanded(!obj.isLeaf());
                        tempRow.getCell("colOrg").setValue((Object)obj);
                        tempRow.getCell("colOrg").setRenderer((IBasicRender)render);
                        tempRow.getCell("trainExpense").setValue((Object)new Double(helper.getExpense()));
                        if (this.isActivity && this.isCourse) {
                            tempRow.getCell("activity").setValue((Object)helper.getActivityInfo().getName());
                            tempRow.getCell("course").setValue((Object)helper.getCourseInfo().getName());
                            continue;
                        }
                        if (this.isActivity && !this.isCourse) {
                            tempRow.getCell("activity").setValue((Object)helper.getActivityInfo().getName());
                            continue;
                        }
                        if (!this.isCourse || this.isActivity) continue;
                        tempRow.getCell("course").setValue((Object)helper.getCourseInfo().getName());
                    }
                    if (list != null && list.size() > 1) {
                        int startRow = i + newRowNum - rowCount;
                        int endRow = startRow + list.size() - 1;
                        mm.mergeBlock(startRow, 0, endRow, 0);
                        newRowNum = newRowNum + list.size() - 1;
                    }
                }
            }
            List benbuList = (List)result.get(orgNodeInfo.getId().toString() + "#");
            if (orgNodeInfo.isIsStart() || benbuList == null || benbuList.size() <= 0) continue;
            IRow row2 = this.tblMain.addRow();
            ++newRowNum;
            HRCellUserObject obj = new HRCellUserObject();
            obj.setName(orgNodeInfo.getName() + benbu);
            obj.setCompanyId(orgNodeInfo.getId().toString() + "#");
            obj.setLongNumber(orgNodeInfo.getLongNumber() + "!-1");
            obj.setIsLeaf(true);
            obj.setLevel(orgNodeInfo.getLevel() + 1);
            obj.setExpanded(true);
            row2.getCell("colOrg").setValue((Object)obj);
            row2.getCell("colOrg").setRenderer((IBasicRender)render);
            if (!this.isActivity && !this.isCourse) {
                helper = (TrainExpenseReportHelper)benbuList.get(0);
                row2.getCell("trainExpense").setValue((Object)new Double(helper.getExpense2()));
                continue;
            }
            if (benbuList == null || benbuList.size() <= 0) continue;
            int n = benbuList.size();
            for (int k = 0; k < n; ++k) {
                TrainExpenseReportHelper helper3 = (TrainExpenseReportHelper)benbuList.get(k);
                if (k == 0) {
                    row2.getCell("trainExpense").setValue((Object)new Double(helper3.getExpense2()));
                    if (this.isActivity && this.isCourse) {
                        row2.getCell("activity").setValue((Object)helper3.getActivityInfo().getName());
                        row2.getCell("course").setValue((Object)helper3.getCourseInfo().getName());
                        continue;
                    }
                    if (this.isActivity && !this.isCourse) {
                        row2.getCell("activity").setValue((Object)helper3.getActivityInfo().getName());
                        continue;
                    }
                    if (!this.isCourse || this.isActivity) continue;
                    row2.getCell("course").setValue((Object)helper3.getCourseInfo().getName());
                    continue;
                }
                IRow tempRow = this.tblMain.addRow();
                HRCellUserObject tempObject = new HRCellUserObject();
                tempObject.setName(" ");
                tempObject.setCompanyId("test");
                tempObject.setLongNumber(obj.getLongNumber());
                tempObject.setIsLeaf(obj.isLeaf());
                tempObject.setLevel(obj.getLevel());
                tempObject.setExpanded(obj.isExpanded());
                tempRow.getCell("colOrg").setValue((Object)tempObject);
                tempRow.getCell("colOrg").setRenderer((IBasicRender)render);
                tempRow.getCell("trainExpense").setValue((Object)new Double(helper3.getExpense2()));
                if (this.isActivity && this.isCourse) {
                    tempRow.getCell("activity").setValue((Object)helper3.getActivityInfo().getName());
                    tempRow.getCell("course").setValue((Object)helper3.getCourseInfo().getName());
                    continue;
                }
                if (this.isActivity && !this.isCourse) {
                    tempRow.getCell("activity").setValue((Object)helper3.getActivityInfo().getName());
                    continue;
                }
                if (!this.isCourse || this.isActivity) continue;
                tempRow.getCell("course").setValue((Object)helper3.getCourseInfo().getName());
            }
            if (benbuList == null || benbuList.size() <= 1) continue;
            int startRow = i + newRowNum - rowCount;
            int endRow = startRow + benbuList.size() - 1;
            mm.mergeBlock(startRow, 0, endRow, 0);
            newRowNum = newRowNum + benbuList.size() - 1;
        }
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec) {
        AdminOrgUnitInfo adminInfo = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                adminInfo = (AdminOrgUnitInfo)this.childNode.getUserObject();
                adminInfo.setLevel(this.childNode.getLevel());
                if (this.childNode.isLeaf()) {
                    adminInfo.setIsStart(this.childNode.isLeaf());
                } else {
                    adminInfo.setIsStart(false);
                }
                adminInfo.setIsLeaf(false);
                if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)this.childNode)) {
                    adminInfo.put("isEnable", (Object)false);
                } else {
                    adminInfo.put("isEnable", (Object)true);
                }
                vec.add(adminInfo);
                if (this.childNode.getChildCount() <= 0) continue;
                this.getCellUserObjects(this.childNode, vec);
            }
        }
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode() throws Exception {
        DefaultKingdeeTreeNode orgRoot = NewOrgTreeHelper.createAdminTreeNodeByHRO();
        if (orgRoot == null) {
            return null;
        }
        if (this.selectOrgUnitInfo != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(orgRoot), orgRoot);
            this.overTreeNodeSimple(orgRoot, map);
            orgRoot = (DefaultKingdeeTreeNode)map.get(this.selectOrgUnitInfo.getId().toString());
        } else {
            this.selectOrgUnitInfo = (AdminOrgUnitInfo)orgRoot.getUserObject();
        }
        return orgRoot;
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private void initTableColumn() {
        IColumn column = null;
        if (this.isActivity) {
            column = this.tblMain.addColumn();
            column.setWidth(300);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.setKey("activity");
            this.tblMain.getHeadRow(0).getCell("activity").setValue((Object)EASResource.getString((String)RES, (String)"trainActivity"));
        }
        if (this.isCourse) {
            column = this.tblMain.addColumn();
            column.setWidth(300);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column.setKey("course");
            this.tblMain.getHeadRow(0).getCell("course").setValue((Object)EASResource.getString((String)RES, (String)"trainCourse"));
        }
        column = this.tblMain.addColumn();
        column.setWidth(200);
        column.getStyleAttributes().setNumberFormat("0.00");
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column.setKey("trainExpense");
        this.tblMain.getHeadRow(0).getCell("trainExpense").setValue((Object)EASResource.getString((String)RES, (String)"trainExpense"));
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    private void initToolbar() {
        this.btnAttachment.setVisible(false);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnAddNew);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        if (this.mainQueryPK != null) {
            request.put("querypk", (Object)this.mainQueryPK);
        }
        request.put("className", (Object)this.getMetaDataPK().getFullName());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman preGetData(Vector vec) {
        IUIActionPostman clientHanlder = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        if (this.params != null) {
            String orgId = this.params.getCustomerParam("orgInfo");
            if (orgId != null) {
                request.put("orgId", (Object)orgId);
            }
            if (this.params.getDate("startDate") != null) {
                request.put("startDate", (Object)this.params.getDate("startDate"));
            }
            if (this.params.getDate("endDate") != null) {
                request.put("endDate", (Object)this.params.getDate("endDate"));
            }
            if (this.params.getCustomerParam("activityId") != null) {
                request.put("activityId", (Object)this.params.getCustomerParam("activityId"));
            }
            if (this.params.getCustomerParam("courseId") != null) {
                request.put("courseId", (Object)this.params.getCustomerParam("courseId"));
            }
            request.put("isActivity", (Object)this.params.getBoolean("isActivity"));
            request.put("isCourse", (Object)this.params.getBoolean("isCourse"));
        }
        if (vec != null) {
            request.put("vector", (Object)vec);
        }
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("preGetData");
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman preGetUnit() {
        IUIActionPostman clientHanlder = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("preGetUnit");
        CustomerParams customerParams = this.params;
        if (customerParams.getCustomerParam("orgInfo") != null) {
            request.put("orgUnitId", (Object)customerParams.getCustomerParam("orgInfo").toString());
        }
        if (customerParams.getCustomerParam("activityId") != null) {
            request.put("activityId", (Object)customerParams.getCustomerParam("activityId").toString());
        }
        if (customerParams.getCustomerParam("courseId") != null) {
            request.put("courseId", (Object)customerParams.getCustomerParam("courseId").toString());
        }
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

