/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.web.TrainWebUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TrainInstructorUtil {
    private static Logger logger = Logger.getLogger(TrainInstructorUtil.class);

    public static TrainInstructorInfo getInnerInstructor(Context ctx, String id) throws Exception {
        TrainInstructorInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("InstructorType.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Employee.*"));
        sic.add(new SelectorItemInfo("Employee.officePhone"));
        sic.add(new SelectorItemInfo("Employee.cell"));
        sic.add(new SelectorItemInfo("Employee.email"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("InnerLevel.*"));
        sic.add(new SelectorItemInfo("IsEnable"));
        sic.add(new SelectorItemInfo("IsOuter"));
        sic.add(new SelectorItemInfo("hireDate"));
        sic.add(new SelectorItemInfo("fireDate"));
        sic.add(new SelectorItemInfo("hireYears"));
        info = TrainInstructorFactory.getLocalInstance(ctx).getTrainInstructorInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return info;
    }

    public static TrainInstructorInfo getOuterInstructor(Context ctx, String id) throws Exception {
        TrainInstructorInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("InstructorType.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Name"));
        sic.add(new SelectorItemInfo("Diploma.*"));
        sic.add(new SelectorItemInfo("Special"));
        sic.add(new SelectorItemInfo("Email"));
        sic.add(new SelectorItemInfo("Sex"));
        sic.add(new SelectorItemInfo("photo.id"));
        sic.add(new SelectorItemInfo("OfficePhone"));
        sic.add(new SelectorItemInfo("MobilePhone"));
        sic.add(new SelectorItemInfo("OtherContact"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("outerEvaluateLevel.*"));
        info = TrainInstructorFactory.getLocalInstance(ctx).getTrainInstructorInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return info;
    }

    public static String getTrainActCourseInstructorDataXml(Context ctx, String trainActCourseID) {
        int COLS = 8;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)trainActCourseID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Participators.isTeacher", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        String xmlData = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActCourseInstructorQuery"));
            iqec.setObjectView(viewInfo);
            IRowSet rowSet = iqec.executeQuery();
            list.add("" + rowSet.size());
            while (rowSet.next()) {
                String[] array = new String[COLS];
                boolean isOuter = true;
                if (!rowSet.getString("Instructor.IsOuter").equals("true")) {
                    isOuter = false;
                }
                array[0] = rowSet.getString("role.name");
                if (isOuter) {
                    array[1] = rowSet.getString("Instructor.number");
                    array[2] = rowSet.getString("Instructor.name");
                    array[6] = rowSet.getString("Instructor.id");
                } else {
                    array[1] = rowSet.getString("Employee.number");
                    array[2] = rowSet.getString("Employee.name");
                    array[6] = rowSet.getString("Instructor.id");
                    array[4] = rowSet.getString("AdminOrgUnit.name");
                    array[5] = rowSet.getString("Position.name") != null ? rowSet.getString("Position.name") : "";
                }
                array[3] = rowSet.getString("Trainchannel.name");
                array[7] = rowSet.getString("Instructor.IsOuter");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        return xmlData;
    }
}

