/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionManager;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;

public class BgEliminationHelper {
    public static OrgTreeCollection getOrgTreeCollection() throws EASBizException, BOSException {
        OrgTreeCollection ocn = null;
        IOrgTree iorgTree = OrgTreeFactory.getRemoteInstance();
        OrgViewType vt = NewOrgViewHelper.convert((OrgType)OrgType.UnionDebt);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(vt.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate", null, CompareType.NOTEQUALS));
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        sort.add(sortItem);
        sortItem = new SorterItemInfo("startDate");
        sortItem.setSortType(SortType.DESCEND);
        sort.add(sortItem);
        evi.setSorter(sort);
        UnionVersionManager unionVersionManager = UnionVersionManager.getInstance();
        if (unionVersionManager.isStarted()) {
            FilterInfo filterStatus = new FilterInfo();
            filterStatus.getFilterItems().add(new FilterItemInfo("isForBudget", (Object)"1", CompareType.EQUALS));
            filter.mergeFilter(filterStatus, "AND");
        }
        evi.setFilter(filter);
        ocn = iorgTree.getOrgTreeCollection(evi);
        if (ocn != null && !ocn.isEmpty()) {
            IPermission ip = null;
            OrgTreeCollection trees = null;
            ip = PermissionFactory.getRemoteInstance();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            ObjectStringPK pk = new ObjectStringPK(user.getId().toString());
            if (user != null) {
                trees = ip.getAllUnionTrees((IObjectPK)pk);
            }
            if (trees != null && !trees.isEmpty()) {
                for (int i = ocn.size() - 1; i >= 0; --i) {
                    OrgTreeInfo treeInfo = ocn.get(i);
                    if (trees.contains((Object)treeInfo.getId())) continue;
                    ocn.remove(treeInfo);
                }
            } else {
                ocn.clear();
            }
        }
        return ocn;
    }

    public static DefaultKingdeeTreeNode getUnionDebtTree(OrgUnitInfo unitInfo, OrgTreeInfo treeInfo, boolean isOneGrade, boolean onlyGroup) throws EASBizException, BOSException {
        if (treeInfo == null) {
            return null;
        }
        String rootID = null;
        if (unitInfo != null) {
            rootID = unitInfo.getId().toString();
        }
        CtrlUnitInfo ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPK = new ObjectUuidPK(ctrlInfo.getId());
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        TreeModel treeModel = OrgF7InnerUtils.buildUnionTreeModel((IObjectPK)cuPK, (IObjectPK)userPK, (String)treeInfo.getId().toString(), (String)rootID, (boolean)isOneGrade, (boolean)false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        BgEliminationHelper.traceUnionDebtTreeForBudget(root);
        if (onlyGroup) {
            BgEliminationHelper.traceUnionDebtTreeOnlyShowGroup(root);
        }
        List orgIdList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        BgEliminationHelper.traceUnionDebtTreeInOrgRange(userPK, root, orgIdList);
        return root;
    }

    public static DefaultKingdeeTreeNode getUnionDebtTree(Context ctx, OrgUnitInfo unitInfo, OrgTreeInfo treeInfo, boolean isOneGrade, boolean onlyGroup) throws EASBizException, BOSException {
        if (treeInfo == null) {
            return null;
        }
        String rootID = null;
        if (unitInfo != null) {
            rootID = unitInfo.getId().toString();
        }
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        ObjectUuidPK cuPK = new ObjectUuidPK(ctrlInfo.getId());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        TreeModel treeModel = OrgF7InnerUtils.buildUnionTreeModel((IObjectPK)cuPK, (IObjectPK)userPK, (String)treeInfo.getId().toString(), (String)rootID, (boolean)isOneGrade, (boolean)false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        BgEliminationHelper.traceUnionDebtTreeForBudget(root);
        if (onlyGroup) {
            BgEliminationHelper.traceUnionDebtTreeOnlyShowGroup(root);
        }
        List orgIdList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        BgEliminationHelper.traceUnionDebtTreeInOrgRange(userPK, root, orgIdList);
        return root;
    }

    public static void traceUnionDebtTreeInOrgRange(ObjectUuidPK userPK, DefaultKingdeeTreeNode root, List orgIdList) {
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!orgIdList.contains(info.getId().toString())) {
                    if (BgEliminationHelper.checkChildInOrgRange(node, orgIdList)) continue;
                    root.remove(i);
                    continue;
                }
                if (node.isLeaf()) continue;
                BgEliminationHelper.traceUnionDebtTreeInOrgRange(userPK, node, orgIdList);
            }
        }
    }

    private static boolean checkChildInOrgRange(DefaultKingdeeTreeNode root, List orgIdList) {
        boolean isChildInOrgRange = false;
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            oui = (OrgStructureInfo)node.getUserObject();
            info = oui.getUnit();
            if (orgIdList.contains(info.getId().toString())) {
                isChildInOrgRange = true;
                return isChildInOrgRange;
            }
            if (!node.isLeaf()) {
                BgEliminationHelper.checkChildInOrgRange(node, orgIdList);
                continue;
            }
            root.remove(i);
        }
        return isChildInOrgRange;
    }

    public static void traceUnionDebtTreeForBudget(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        int i;
        if (root == null) {
            return;
        }
        HashSet<String> seup = new HashSet<String>();
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (int i2 = root.getChildCount() - 1; i2 >= 0; --i2) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i2);
                if (!node.isLeaf()) {
                    BgEliminationHelper.traceUnionDebtTreeForBudget(node);
                    continue;
                }
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!info.isIsGrouping() && !info.isIsCostOrgUnit()) {
                    root.remove(i2);
                }
                if (!info.isIsCostOrgUnit()) continue;
                seup.add(info.getId().toString());
            }
        }
        if (seup.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", seup, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(1)));
        evi.setFilter(filter);
        CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
        seup.clear();
        if (col != null && !col.isEmpty()) {
            for (i = 0; i < col.size(); ++i) {
                seup.add(col.get(i).getId().toString());
            }
        }
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!node.isLeaf()) {
                    BgEliminationHelper.traceUnionDebtTreeForBudget(node);
                    continue;
                }
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!seup.contains(info.getId().toString())) continue;
                root.remove(i);
            }
        }
    }

    public static void traceUnionDebtTreeOnlyShowGroup(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        if (root == null) {
            return;
        }
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!node.isLeaf() || info.isIsGrouping()) {
                    BgEliminationHelper.traceUnionDebtTreeOnlyShowGroup(node);
                    continue;
                }
                if (info.isIsGrouping()) continue;
                root.remove(i);
            }
        }
    }

    public static IObjectPK getPK(IObjectValue v) {
        if (v != null) {
            String pkField = v.getPKField();
            if (pkField != null && v.get(pkField) != null) {
                return new ObjectStringPK(v.get(pkField).toString());
            }
            return null;
        }
        return null;
    }

    public static Object getValueFromMap(Map map, String id) {
        if (StringUtil.isEmpty((String)id) || map == null || map.isEmpty()) {
            return null;
        }
        CoreBaseInfo cbi2 = null;
        for (CoreBaseInfo cbi2 : map.keySet()) {
            if (cbi2 == null || cbi2.getId() == null || !id.equals(cbi2.getId().toString())) continue;
            return map.get(cbi2);
        }
        return null;
    }
}

