/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslFacadeFactory;
import com.kingdee.eas.ma.bgcsl.BgElimContext;
import com.kingdee.eas.ma.bgcsl.BgElimContextHelper;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.IBgCslFacade;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgConsolidationListUI;
import com.kingdee.eas.ma.bgcsl.client.IBgElimContextUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgCHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgConsolidationListUI
extends AbstractBgConsolidationListUI
implements IBgElimContextUI {
    private static final long serialVersionUID = 8756364090784831184L;
    private static final Logger logger = CoreUIObject.getLogger(BgConsolidationListUI.class);
    protected BgElimContext bgElimContext = BgElimContext.getInstance();
    protected BgSchemeDimensionHelper schemeHelper = null;

    public void onLoad() throws Exception {
        this.setIsNeedDefaultFilter(false);
        if (BgElimContextHelper.isInitialized((CoreUIObject)this, this.getUIContext())) {
            this.initOrgTreeF7();
            super.onLoad();
            this.init();
            BgElimContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
    }

    protected void refreshOrgUnitTree() throws Exception {
        try {
            TreeModel treeModel = this.loadOrgTreeModel();
            this.treeOrgUnit.setModel(treeModel);
            this.locateCurrentOrg();
            this.treeOrgUnit.expandOnLevel(1);
            this.treeOrgUnit.setRootVisible(this.isRootVisible());
            if (treeModel.getRoot() == null || !(treeModel.getRoot() instanceof DefaultKingdeeTreeNode) || ((DefaultKingdeeTreeNode)treeModel.getRoot()).getChildCount() != 0) {
                this.treeOrgUnit.updateUI();
            }
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof AbortException) {
                throw (AbortException)ex.getCause();
            }
            this.handUIExceptionAndAbort(ex);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    protected String getDefaultLocateOrgUnitId() {
        try {
            if (BgElimContextHelper.getBgElimContext() != null && BgElimContextHelper.getBgElimContext().getCurOrgGroup() != null) {
                return BgElimContextHelper.getBgElimContext().getCurOrgGroup().getId().toString();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return super.getDefaultLocateOrgUnitId();
    }

    private void init() throws Exception {
        this.initBgScheme();
        this.refreshOrgUnitTree();
    }

    protected boolean isRootVisible() {
        return true;
    }

    protected void initOrgTreeF7() throws Exception {
        boolean isDiff = BgCslClientHelper.initOrgTreeComboBox(this.combOrgTree);
        if (isDiff) {
            this.combOrgTreeChanged();
        }
    }

    protected void initBgScheme() throws BOSException, EASBizException {
        BgCslClientHelper.setBgSchemeView(this.prmtBgScheme, BgElimContextHelper.getBgElimContext().getCurOrgBound());
        BgCslClientHelper.setCurBgScheme(this.prmtBgScheme, this.bgElimContext);
        this.prmtBgScheme.setEditable(false);
    }

    protected void fillPeriodType(KDTDataRequestEvent e) {
        if (e == null || this.tblMain.getColumn("bgPeriod.number") == null || !this.tblMain.getColumn("bgPeriod.number").getStyleAttributes().isHided()) {
            return;
        }
        IRow row = null;
        String pnumber = null;
        String pname = null;
        int in = e.getLastRow();
        for (int i = e.getFirstRow(); i <= in; ++i) {
            row = this.tblMain.getRow(i);
            pname = (String)row.getCell("bgPeriod.name").getValue();
            pnumber = (String)row.getCell("bgPeriod.number").getValue();
            if (pnumber == null) continue;
            String prefix = pnumber.substring(0, 4);
            pname = pname + "(" + prefix + ")";
            row.getCell("bgPeriod.number").setValue(null);
            row.getCell("bgPeriod.name").setValue((Object)pname);
        }
    }

    protected BgSchemeInfo getSelectBgScheme() {
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            return (BgSchemeInfo)this.prmtBgScheme.getData();
        }
        return null;
    }

    protected OrgTreeInfo getSelectOrgTree() {
        return (OrgTreeInfo)this.combOrgTree.getSelectedItem();
    }

    @Override
    protected void combOrgTree_itemStateChanged(ItemEvent e) throws Exception {
        super.combOrgTree_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            return;
        }
        this.combOrgTreeChanged();
    }

    private void combOrgTreeChanged() throws Exception {
        if (this.combOrgTree.getSelectedItem() instanceof OrgTreeInfo) {
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.combOrgTree.getSelectedItem();
            BgElimContext.getInstance().setCurOrgBound(orgTreeInfo);
            this.prmtBgScheme.setEntityViewInfo(null);
            BgSchemeInfo oldScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
            BgCslClientHelper.setBgSchemeView(this.prmtBgScheme, orgTreeInfo);
            BgSchemeInfo newScheme = (BgSchemeInfo)this.prmtBgScheme.getData();
            if (!BgCommCHelper.isEqualsPK((IObjectValue)oldScheme, (IObjectValue)newScheme)) {
                this.bgSchemeChanged(newScheme);
            }
            this.permissionHelper.loadPermissioniMap();
            this.refreshOrgUnitTree();
        }
        this.tblMain.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
            BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
            try {
                if (newInfo == null && e.getOldValue() != null && this.prmtBgScheme.getUserObject() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
                    this.prmtBgScheme.setDataNoNotify(e.getOldValue());
                } else if (!BgCommCHelper.isEqualsPK((IObjectValue)oldInfo, (IObjectValue)newInfo)) {
                    this.bgSchemeChanged(newInfo);
                }
            }
            finally {
                this.prmtBgScheme.setUserObject(null);
            }
        }
        this.setDefaultPrmt();
        this.refreshList();
    }

    protected void setDefaultPrmt() throws EASBizException, BOSException {
    }

    protected void bgSchemeChanged(BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)this.getSelectBgScheme());
        uiContext.put((Object)"orgTreeInfo", (Object)this.getSelectOrgTree());
    }

    protected TreeModel loadOrgTreeModel() throws Exception {
        DefaultTreeModel treeModel = null;
        OrgTreeInfo treeInfo = this.getSelectOrgTree();
        if (treeInfo == null) {
            treeInfo = this.bgElimContext.getCurOrgBound();
        }
        OrgUnitInfo currCompany = this.bgElimContext.getCurOrgGroup();
        DefaultKingdeeTreeNode rootNode = BgEliminationHelper.getUnionDebtTree(currCompany, treeInfo, false, this.isOnlyShowGroup());
        treeModel = new DefaultTreeModel((TreeNode)rootNode);
        return treeModel;
    }

    protected void checkBgSchemeSelected() {
        this.checkBgSchemeSelected(null);
    }

    protected void checkBgSchemeSelected(SelectorEvent e) {
        if (this.prmtBgScheme.getData() == null) {
            if (e != null) {
                e.setCanceled(true);
            }
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"selectBgScheme"));
            SysUtil.abort();
        }
        BgCslClientHelper.checkHasCslScheme((CoreUI)this, this.getSelectBgScheme().getId().toString(), this.getSelectOrgTree().getId().toString());
    }

    protected void checkFilled() throws EASBizException, BOSException {
        if (this.getSelectBgScheme() != null) {
            BgCslClientHelper.checkFilled(this.getSelectBgScheme().getId().toString());
        }
    }

    protected boolean isOnlyShowGroup() {
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    protected IObjectPK getOrgPK() {
        IObjectPK pk = this.getOrgGroupPk();
        if (pk == null) {
            pk = super.getOrgPK();
        }
        return pk;
    }

    protected IObjectPK getOrgTreePK() throws BOSException {
        OrgTreeInfo orgTree = this.getSelectOrgTree();
        if (orgTree == null) {
            orgTree = BgElimContextHelper.getBgElimContext().getCurOrgBound();
        }
        if (orgTree != null) {
            return new ObjectUuidPK(orgTree.getId());
        }
        return super.getOrgTreePK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = this.getOrgGroupPk();
        if (pk == null) {
            pk = super.getOrgPK(action);
        }
        return pk;
    }

    protected IObjectPK getOrgGroupPk() {
        ObjectUuidPK pk = null;
        try {
            String selectedOrgId = this.getSelectedOrgId();
            if (!StringUtils.isEmpty((String)selectedOrgId)) {
                pk = new ObjectUuidPK(selectedOrgId);
            } else {
                OrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
                if (orgUnitInfo == null) {
                    orgUnitInfo = BgElimContextHelper.getBgElimContext().getCurOrgGroup();
                }
                if (orgUnitInfo != null) {
                    pk = new ObjectUuidPK(orgUnitInfo.getId());
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get orgtree error", (Throwable)e);
        }
        return pk;
    }

    protected OrgType getOrgType() {
        return OrgType.UnionDebt;
    }

    protected void checkOperateByState(ItemAction itemAction, String operateStr, boolean showMsg) {
        List rowIndexes = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblMain);
        if (rowIndexes == null || rowIndexes.isEmpty()) {
            return;
        }
        IRow row = null;
        Iterator iterator = rowIndexes.iterator();
        while (iterator.hasNext()) {
            int _state;
            int rowIndex = (Integer)iterator.next();
            row = this.tblMain.getRow(rowIndex);
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("state").getValue();
            if (state == null || !this.getBtnsByOperate(_state = state.getInt()).contains(itemAction)) continue;
            if (showMsg) {
                MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"operateBgFormByState", (Object[])new String[]{operateStr, state.getAlias()}));
            }
            SysUtil.abort();
        }
    }

    protected void checkOperateByState(ItemAction itemAction, String operateStr) {
        this.checkOperateByState(itemAction, operateStr, true);
    }

    protected Set<ItemAction> getBtnsByOperate(int state) {
        HashSet<ItemAction> itemActionSet = new HashSet<ItemAction>();
        switch (state) {
            case 1: {
                itemActionSet.add(this.actionUnionReport);
                itemActionSet.add(this.actionUnionUnReport);
                break;
            }
            case 2: {
                itemActionSet.add((ItemAction)this.actionEdit);
                itemActionSet.add((ItemAction)this.actionRemove);
                itemActionSet.add(this.actionUnionUnReport);
                break;
            }
            case 50: {
                itemActionSet.add((ItemAction)this.actionEdit);
                itemActionSet.add((ItemAction)this.actionRemove);
                itemActionSet.add(this.actionUnionReport);
                break;
            }
            case 51: {
                itemActionSet.add((ItemAction)this.actionEdit);
                itemActionSet.add((ItemAction)this.actionRemove);
                itemActionSet.add(this.actionUnionReport);
                itemActionSet.add(this.actionUnionUnReport);
                break;
            }
        }
        return itemActionSet;
    }

    protected void showOperateByStateMsg(BizEnumValueInfo state, String operateStr) {
        MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"operateBgFormByState", (Object[])new String[]{operateStr, state.getAlias()}));
        SysUtil.abort();
    }

    protected IBgCslFacade getCslFacade() throws BOSException {
        return BgCslFacadeFactory.getRemoteInstance();
    }

    protected Map<String, String> getAuditParams() {
        BgSchemeInfo schemeInfo = this.getSelectBgScheme();
        OrgTreeInfo union = this.getSelectOrgTree();
        OrgUnitInfo orgUnit = this.getOrgUnitInfo();
        UserInfo user = this.getUserInfo();
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", schemeInfo.getId().toString());
        auditParams.put("AUDIT_UNION_UNIONID", union.getId().toString());
        auditParams.put("AUDIT_ORGUNIT_ID", orgUnit.getId().toString());
        auditParams.put("AUDIT_USER_ID", user.getId().toString());
        return auditParams;
    }

    @Override
    public void actionUnionReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionReport_actionPerformed(e);
        this.checkSelected();
        this.checkFilled();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"askUnionReport"));
        if (re == 1 || re == 2) {
            return;
        }
        int size = 0;
        ArrayList billIds = this.getSelectedIdValues();
        StringBuffer msg = new StringBuffer();
        Map result = this.getCslFacade().report(this.getSelectedIdValues(), this.getAuditParams());
        if (result != null && !result.isEmpty()) {
            Map tempalteSetsMap;
            if (result.containsKey("CHECK_RESULT_STATE")) {
                Map stateMap = (Map)result.get("CHECK_RESULT_STATE");
                size += stateMap.size();
                for (String[] tmpStrs : stateMap.values()) {
                    msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"reportErrorStateMsg", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\n");
                }
            }
            if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET")) {
                tempalteSetsMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
                size += tempalteSetsMap.size();
                for (String[] tmpStrs : tempalteSetsMap.values()) {
                    String otherMsg = tmpStrs[5];
                    if (otherMsg.indexOf("#") > 0) {
                        String[] otherStr = otherMsg.split("#");
                        Object[] msgArr = new String[2 + otherStr.length];
                        msgArr[0] = tmpStrs[4];
                        msgArr[1] = tmpStrs[0];
                        for (int i = 0; i < otherStr.length; ++i) {
                            msgArr[i + 2] = otherStr[i];
                        }
                        msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkBgTemplate_Sequence", (Object[])msgArr) + "\r\n");
                        continue;
                    }
                    msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"unionReportTemplateSet", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\r\n");
                }
            } else if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX")) {
                tempalteSetsMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
                size += tempalteSetsMap.size();
                for (String[] tmpStrs : tempalteSetsMap.values()) {
                    String otherMsg = tmpStrs[5];
                    if (otherMsg.indexOf("#") > 0) {
                        String[] otherStr = otherMsg.split("#");
                        Object[] msgArr = new String[2 + otherStr.length];
                        msgArr[0] = tmpStrs[4];
                        msgArr[1] = tmpStrs[0];
                        for (int i = 0; i < otherStr.length; ++i) {
                            msgArr[i + 2] = otherStr[i];
                        }
                        msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkBgTemplate_Sequence_Ex", (Object[])msgArr) + "\r\n");
                        continue;
                    }
                    msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"unionReportTemplateSet", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\r\n");
                }
            }
        }
        MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)this);
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)(billIds.size() == size ? BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"reportError") : BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"reportPartialError")), (String)msg.toString(), (int)0);
        } else {
            this.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"reportSucceed"));
            this.showMessage();
        }
    }

    @Override
    public void actionUnionUnReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionUnReport_actionPerformed(e);
        this.checkSelected();
        this.checkFilled();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"askUnionUnReport"));
        if (re == 1 || re == 2) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        Map result = this.getCslFacade().unReport(this.getSelectedIdValues(), this.getAuditParams());
        if (result != null && !result.isEmpty() && result.containsKey("CHECK_RESULT_STATE")) {
            Map stateMap = (Map)result.get("CHECK_RESULT_STATE");
            for (String[] tmpStrs : stateMap.values()) {
                msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"unReportErrorStateMsg", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\n");
            }
        }
        MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)this);
        if (msg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unReportError"), (String)msg.toString(), (int)0);
        } else {
            this.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"unReportSucceed"));
            this.showMessage();
        }
    }

    @Override
    public void actionUnionReceive_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnionReceive_actionPerformed(e);
    }

    public BgSchemeDimensionHelper getSchemeHelper(boolean isReload) throws EASBizException, BOSException {
        if (!isReload && this.schemeHelper == null && this.getSelectBgScheme() != null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getSelectBgScheme().getId().toString());
        } else if (isReload) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getSelectBgScheme().getId().toString());
        }
        return this.schemeHelper;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        return this.getSchemeHelper(false);
    }
}

