/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateHistFactory;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslBizCalcHistListUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslBizCalcHistMainUI;
import com.kingdee.eas.ma.biz.utils.RefBgTemplateRender;
import com.kingdee.eas.util.client.ExceptionHandler;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslBizCalcHistListUI
extends AbstractBgCslBizCalcHistListUI {
    protected static final String WORK_TEMPLATE_COL = "workTemplate";
    protected static final String BG_TEMPLATE_ADJ_COL = "bgAdjTemplate";
    private static final Logger logger = CoreUIObject.getLogger(BgCslBizCalcHistListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn(WORK_TEMPLATE_COL).setRenderer((IBasicRender)new RefBgTemplateRender());
        this.tblMain.getColumn(BG_TEMPLATE_ADJ_COL).setRenderer((IBasicRender)new RefBgTemplateRender());
    }

    protected void fillTemplateList(KDTDataRequestEvent e) {
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = firstRow; i <= lastRow; ++i) {
            String id = (String)this.tblMain.getRow(i).getCell(ID).getValue();
            idSet.add(id);
        }
        BgNWorkTemplateCollection workColls = null;
        BgCslTemplateCollection cslColls = null;
        BgCslAdjTemplateCollection cslAdjColls = null;
        if (idSet.size() > 0) {
            Map templateMap = null;
            try {
                templateMap = BizRefCslTemplateHistFactory.getRemoteInstance().getRefTemplates(idSet);
            }
            catch (Exception e1) {
                logger.error((Object)"", (Throwable)e1);
                ExceptionHandler.handle((Throwable)e1);
            }
            for (int i = firstRow; i <= lastRow; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = (String)row.getCell(ID).getValue();
                if (templateMap == null || !templateMap.containsKey(id)) continue;
                if (templateMap.get(id) instanceof Map && ((Map)templateMap.get(id)).containsKey("WORKTEMPLATE_COLLECTION")) {
                    workColls = (BgNWorkTemplateCollection)((Object)((Map)templateMap.get(id)).get("WORKTEMPLATE_COLLECTION"));
                    row.getCell(WORK_TEMPLATE_COL).setValue((Object)Arrays.asList((Object[])workColls.toArray()));
                }
                if (templateMap.get(id) instanceof Map && ((Map)templateMap.get(id)).containsKey("bgtemplate")) {
                    cslColls = (BgCslTemplateCollection)((Object)((Map)templateMap.get(id)).get("bgtemplate"));
                    row.getCell(BGTEMPLATE).setValue((Object)Arrays.asList((Object[])cslColls.toArray()));
                }
                if (!(templateMap.get(id) instanceof Map) || !((Map)templateMap.get(id)).containsKey("bgcsladjtemplate")) continue;
                cslAdjColls = (BgCslAdjTemplateCollection)((Object)((Map)templateMap.get(id)).get("bgcsladjtemplate"));
                row.getCell(BG_TEMPLATE_ADJ_COL).setValue((Object)Arrays.asList((Object[])cslAdjColls.toArray()));
            }
        }
    }

    protected String getHistMainUI() {
        return BgCslBizCalcHistMainUI.class.getName();
    }

    protected void putUIContext(UIContext ctx) {
        ctx.put((Object)"ORGTREE_INFO", this.getUIContext().get("ORGTREE_INFO"));
    }
}

