/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslElimBaseEditUI;
import com.kingdee.eas.ma.bgcsl.client.DimensionMemberDialog;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.common.BgCslElimHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.DimGroupFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslElimBaseEditUI
extends AbstractBgCslElimBaseEditUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = -3102927670523843128L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslElimBaseEditUI.class);
    public static final String TB_summary = "summary";
    public static final String TB_bgAccount = "bgAccount";
    public static final String TB_debitAmount = "debitAmount";
    public static final String TB_creditAmount = "creditAmount";
    public static final String TB_mbgMember = "mbgMember";
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    private OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private BgCslSchemeDimensionHelper schemeHelper = null;

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public BgCslSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null && this.getBgSchemeId() != null) {
            this.schemeHelper = new BgCslSchemeDimensionHelper(this.getBgSchemeId());
        }
        return this.schemeHelper;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO");
        if (bgSchemeInfo != null) {
            return bgSchemeInfo;
        }
        if (this.editData != null) {
            return this.editData.getBgScheme();
        }
        return null;
    }

    protected String getBgSchemeId() {
        return this.getBgSchemeInfo().getId().toString();
    }

    protected String getOrgUnitId() {
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.getDetailTable().checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void loadData() throws Exception {
        if (this.idList != null && this.idList.size() > 0) {
            for (int i = this.idList.size() - 1; i >= 0; --i) {
                if (this.idList.getID(i) != null) continue;
                this.idList.remove(this.idList.getID(i), false);
            }
        }
        super.loadData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setButtonEnable();
    }

    protected void setPrmtEditable(boolean isEditable) {
        this.prmtBgVersion.setEditable(isEditable);
        this.prmtBgScenario.setEditable(isEditable);
        this.prmtBgElement.setEditable(isEditable);
        this.prmtBgPeriod.setEditable(isEditable);
        this.prmtMbgMember.setEditable(isEditable);
    }

    protected void setButtonEnable() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAddLine.setEnabled(false);
            this.menuItemAddLine.setEnabled(false);
            this.btnCopyLine.setEnabled(false);
            this.menuItemCopyLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.menuItemRemoveLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.menuItemInsertLine.setEnabled(false);
        } else {
            this.btnAddLine.setEnabled(true);
            this.menuItemAddLine.setEnabled(true);
            this.btnCopyLine.setEnabled(true);
            this.menuItemCopyLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.menuItemRemoveLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.menuItemInsertLine.setEnabled(true);
        }
    }

    protected void init() throws EASBizException, BOSException {
        this.initBgPeriodInfo();
        this.initCurrencyInfo();
        this.initBgVersionInfo();
        this.initBgElementInfo();
        this.initBgScenarioInfo();
        this.getDetailTable().getColumn(TB_bgAccount).getStyleAttributes().setBackground(BgSpecialBudgetClientHelper.REQUIRED_COLOR);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setDefaultMembers();
        }
    }

    protected void setDefaultMembers() throws EASBizException, BOSException {
        HashMap<String, Object> componentMap = new HashMap<String, Object>();
        componentMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, this.prmtBgScenario);
        componentMap.put(DimensionConstants.DEF_PERIOD_NUMBER, this.prmtBgPeriod);
        componentMap.put(DimensionConstants.DEF_VERSION_NUMBER, this.prmtBgVersion);
        componentMap.put(DimensionConstants.DEF_CURRENCY_NUMBER, this.cboCurrency);
        componentMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, this.prmtBgElement);
        BgSchemeUtils.setDefualtMembers((BgSchemeDimensionHelper)this.getSchemeHelper(), componentMap, (boolean)true, (boolean)false, (boolean)true);
    }

    protected void initBgPeriodInfo() throws EASBizException, BOSException {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        BgSchemeInfo bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK(this.getSchemeHelper().getBgSchemeId()));
        dialog.setBgPeriodBeginDate(bgScheme.getDateFrom());
        dialog.setBgPeriodEndDate(bgScheme.getDateTo());
        dialog.setOnlyLeaf(true);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
    }

    protected void initCurrencyInfo() throws EASBizException, BOSException {
        BgNFCHelper.setCurrency((KDComboBox)this.cboCurrency, (BOSUuid)BOSUuid.read((String)this.getOrgUnitId()), (boolean)false, (Set)this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_CURRENCY_NUMBER, false));
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData.getCurrency() != null) {
            BgNFCHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
        }
    }

    protected void initBgVersionInfo() throws EASBizException, BOSException {
        DimensionMemberSelectHelper.addIdFilter((KDBizPromptBox)this.prmtBgVersion, (String)DimensionConstants.DEF_VERSION_NUMBER, (BgSchemeDimensionHelper)this.getSchemeHelper());
    }

    protected void initBgScenarioInfo() throws EASBizException, BOSException {
        FilterItemCollection filters = new FilterItemCollection();
        DimensionMemberSelectHelper.addIdFilter((KDBizPromptBox)this.prmtBgScenario, (String)DimensionConstants.DEF_SCENARIO_NUMBER, (BgSchemeDimensionHelper)this.getSchemeHelper(), (FilterItemCollection)filters);
    }

    protected void initBgElementInfo() throws EASBizException, BOSException {
        DimensionMemberSelectHelper.addIdFilter((KDBizPromptBox)this.prmtBgElement, (String)DimensionConstants.DEF_ELEMENT_NUMBER, (BgSchemeDimensionHelper)this.getSchemeHelper());
    }

    protected BgVersionInfo getBgVersionInfo() {
        Object obj = this.prmtBgVersion.getData();
        BgVersionInfo info = null;
        if (obj instanceof BgVersionInfo) {
            info = (BgVersionInfo)obj;
        } else if (obj instanceof BgVersionInfo[]) {
            info = ((BgVersionInfo[])obj)[0];
        }
        return info;
    }

    protected BgScenarioInfo getBgScenarioInfo() {
        Object obj = this.prmtBgScenario.getData();
        BgScenarioInfo info = null;
        if (obj instanceof BgScenarioInfo) {
            info = (BgScenarioInfo)obj;
        } else if (obj instanceof BgScenarioInfo[]) {
            info = ((BgScenarioInfo[])obj)[0];
        }
        return info;
    }

    protected BgElementInfo getBgElementInfo() {
        Object obj = this.prmtBgElement.getData();
        BgElementInfo info = null;
        if (obj instanceof BgElementInfo) {
            info = (BgElementInfo)obj;
        } else if (obj instanceof BgElementInfo[]) {
            info = ((BgElementInfo[])obj)[0];
        }
        return info;
    }

    protected BgPeriodInfo getBgPeriodInfo() {
        Object obj = this.prmtBgPeriod.getData();
        BgPeriodInfo info = null;
        if (obj instanceof BgPeriodInfo) {
            info = (BgPeriodInfo)obj;
        } else if (obj instanceof BgPeriodInfo[]) {
            info = ((BgPeriodInfo[])obj)[0];
        }
        return info;
    }

    protected CurrencyInfo getCurrencyInfo() {
        Object obj = this.cboCurrency.getSelectedItem();
        CurrencyInfo info = null;
        if (obj instanceof CurrencyInfo) {
            info = (CurrencyInfo)obj;
        } else if (obj instanceof CurrencyInfo[]) {
            info = ((CurrencyInfo[])obj)[0];
        }
        return info;
    }

    protected NewDimensionMemberSelectDialog initBgAccountDialog(int rowIndex) {
        FullOrgUnitInfo fullOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        NewDimensionMemberSelectDialog dialog = null;
        if (fullOrgUnitInfo == null) {
            return dialog;
        }
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, TB_bgAccount).getEditor();
        if (editor instanceof KDTDefaultCellEditor && editor.getComponent() instanceof KDBizPromptBox && ((KDBizPromptBox)editor.getComponent()).getSelector() instanceof NewDimensionMemberSelectDialog) {
            BgDimensionInfo dimension = new BgDimensionInfo(null);
            dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
            dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), this.getBgSchemeId(), (BgDimensionBaseInfo)dimension, fullOrgUnitInfo.getId().toString(), true, false);
        } else {
            dialog = this.newBgIndexMemberSelectDialog();
            KDBizPromptBox prmtProBox = new KDBizPromptBox();
            prmtProBox.setEditable(false);
            prmtProBox.setSelector((KDPromptSelector)dialog);
            this.getDetailTable().getCell(rowIndex, TB_bgAccount).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProBox));
        }
        this.doBgAccountDataChanged(rowIndex);
        return dialog;
    }

    private void doBgAccountDataChanged(int rowIndex) {
        ICellEditor editor = this.getDetailTable().getCell(rowIndex, TB_bgAccount).getEditor();
        if (editor != null && editor.getComponent() instanceof KDBizPromptBox) {
            KDBizPromptBox box = (KDBizPromptBox)editor.getComponent();
            ViewlistCombinHelper.removeDataChengeListeners((KDBizPromptBox)box);
            box.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    BgCslElimBaseEditUI.this.bgAccount_dataChanged(eventObj);
                }
            });
        }
    }

    private void bgAccount_dataChanged(DataChangeEvent eventObj) {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        IRow row = this.getDetailTable().getRow(rowIndex);
        if (eventObj.getNewValue() != null && !(eventObj.getNewValue() instanceof BgDimensionMember) && eventObj.getNewValue() instanceof List) {
            List lst = (List)eventObj.getNewValue();
            BgDimensionMember member = null;
            ICellEditor editor = null;
            Object box = null;
            for (int index = 0; index < lst.size(); ++index) {
                if (index > 0) {
                    row = this.addLine(rowIndex + index);
                }
                member = (BgDimensionMember)lst.get(index);
                editor = row.getCell(TB_bgAccount).getEditor();
                row.getCell(TB_bgAccount).setValue((Object)member);
                row.getCell(TB_bgAccount).setUserObject((Object)member);
            }
        }
    }

    protected NewDimensionMemberSelectDialog newBgIndexMemberSelectDialog() {
        BgDimensionInfo dimension = new BgDimensionInfo(null);
        dimension.setNumber(DimensionConstants.DEF_INDEX_NUMBER);
        dimension.setType(DimensionConstants.DEF_INDEX_NUMBER);
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog((Component)((Object)this), (BgDimensionBaseInfo)dimension, null, true, false);
        dialog.setOnlyLeaf(true);
        return dialog;
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        if (detailData != null) {
            IRow row = table.addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
            this.afterAddLine(table, detailData);
            this.initEntryBgDimMember(row);
            this.initBgAccountDialog(row.getRowIndex());
        }
    }

    protected IRow addLine(int rowIndex) {
        KDTable table = this.getDetailTable();
        if (table == null) {
            return null;
        }
        IRow row = null;
        IObjectValue detailData = this.createNewDetailData(table);
        if (detailData != null) {
            row = table.addRow(rowIndex);
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
            this.loadLineFields(table, row, detailData);
            this.afterAddLine(table, detailData);
            this.initEntryBgDimMember(row);
            this.initBgAccountDialog(row.getRowIndex());
        }
        return row;
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
        this.initEntryBgDimMember(row);
        this.initBgAccountDialog(row.getRowIndex());
    }

    protected String getMemberNumber(BgDimensionMember member) {
        if (member == null) {
            return null;
        }
        StringBuffer ref = new StringBuffer();
        String[] refItemSrc = member.getSrcNumber().split(",");
        String[] refItem = member.getNumber().split(",");
        if (refItemSrc.length != 0 && refItemSrc.length == refItem.length) {
            for (int index = 0; index < refItemSrc.length; ++index) {
                ref.append(refItemSrc[index]).append(":").append(refItem[index]).append(",");
            }
            ref.deleteCharAt(ref.length() - 1);
        }
        return ref.toString();
    }

    protected void initEntryBgDimMember(IRow row) {
        KDBizPromptBox prmptDimension = new KDBizPromptBox();
        this.formatePrmtDimension(prmptDimension, row.getRowIndex());
        KDTDefaultCellEditor dimEditor = new KDTDefaultCellEditor((IKDEditor)prmptDimension);
        row.getCell(TB_mbgMember).setEditor((ICellEditor)dimEditor);
    }

    private void formatePrmtDimension(final KDBizPromptBox prmptDim, int index) {
        DimensionMemberDialog dialog = this.initEntryDimensionF7(index);
        prmptDim.addDataChangeListener((DataChangeListener)dialog);
        prmptDim.setEditable(false);
        prmptDim.setSelector((KDPromptSelector)dialog);
        prmptDim.setRequestFocusEnabled(true);
        prmptDim.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                Object obj = e.getSource();
                if (obj == null || !(obj instanceof KDBizPromptBox)) {
                    return;
                }
                KDBizPromptBox box = (KDBizPromptBox)obj;
                MbgDimensionMember dimMember = null;
                if (box.getData() instanceof MbgDimensionMember) {
                    dimMember = (MbgDimensionMember)box.getData();
                }
                List<String> headDim = BgCslElimBaseEditUI.this.getHeadDim();
                if (prmptDim.getSelector() instanceof DimensionMemberDialog) {
                    ((DimensionMemberDialog)prmptDim.getSelector()).setHeadDim(headDim);
                    ((DimensionMemberDialog)prmptDim.getSelector()).setDimMember(dimMember);
                }
            }
        });
    }

    protected DimensionMemberDialog initEntryDimensionF7(int index) {
        DimensionMemberDialog dialog = null;
        dialog = new DimensionMemberDialog((CoreUI)this, this.getBgSchemeId(), ((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString());
        dialog.setOrgTreeId(((OrgTreeInfo)this.getUIContext().get("orgTreeInfo")).getId().toString());
        dialog.setBgSchemeId(this.getBgSchemeId());
        return dialog;
    }

    protected void checkOffsetTypeNull() {
        if (null == this.cboOffsetType.getSelectedItem()) {
            this.cboOffsetType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"ElimTypeIsNull"));
            SysUtil.abort();
        }
    }

    protected void checkCurrencyNull() {
        if (null == this.cboCurrency.getSelectedItem()) {
            this.cboCurrency.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"currencyIsNull"));
            SysUtil.abort();
        }
    }

    protected void checkBgVersionNull() {
        if (null == this.prmtBgVersion.getValue()) {
            this.prmtBgVersion.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"bgVersionIsNull"));
            SysUtil.abort();
        }
    }

    protected void checkBgElementNull() {
        if (null == this.prmtBgElement.getValue()) {
            this.prmtBgElement.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"bgElementIsNull"));
            SysUtil.abort();
        }
    }

    protected void checkBgPeriodNull() {
        if (null == this.prmtBgPeriod.getValue()) {
            this.prmtBgPeriod.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"bgPeriodIsNull"));
            SysUtil.abort();
        }
    }

    protected void checkBgScenarioNull() {
        if (null == this.prmtBgScenario.getValue()) {
            this.prmtBgScenario.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"bgScenarioIsNull"));
            SysUtil.abort();
        }
    }

    protected void lockAmount(int rowIndex, int colIndex) {
        KDTable table = this.getDetailTable();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_creditAmount.equalsIgnoreCase(fieldName) && table.getRow(rowIndex).getCell(TB_creditAmount).getValue() != null) {
            if (null != table.getRow(rowIndex).getCell(TB_debitAmount).getValue()) {
                table.getRow(rowIndex).getCell(TB_debitAmount).setValue(null);
            }
        } else if (TB_debitAmount.equalsIgnoreCase(fieldName) && table.getRow(rowIndex).getCell(TB_debitAmount).getValue() != null && null != table.getRow(rowIndex).getCell(TB_creditAmount).getValue()) {
            table.getRow(rowIndex).getCell(TB_creditAmount).setValue(null);
        }
    }

    protected List<String> getHeadDim() {
        ArrayList<String> headDim = new ArrayList<String>();
        if (this.prmtMbgMember.getValue() instanceof MbgDimensionMember) {
            MbgDimensionMember member = (MbgDimensionMember)this.prmtMbgMember.getValue();
            String dimension = member.getNumber();
            if (null != dimension) {
                String[] dim = dimension.split(",");
                for (int i = 0; i < dim.length; ++i) {
                    headDim.add(dim[i]);
                }
            }
        } else if (this.prmtMbgMember.getValue() instanceof String && !StringUtils.isEmpty((String)((String)this.prmtMbgMember.getValue()))) {
            headDim.add((String)this.prmtMbgMember.getValue());
        }
        return headDim;
    }

    protected void checkEntryDimMember(KDTable table, int row) throws EASBizException, BOSException {
        MbgDimensionMember member = (MbgDimensionMember)this.prmtMbgMember.getValue();
        String entryDim = null;
        String dim = null;
        if (null != member) {
            dim = member.getType();
        }
        if (null != table.getCell(row, TB_mbgMember).getValue() && table.getCell(row, TB_mbgMember).getValue() instanceof MbgDimensionMember) {
            MbgDimensionMember entryMember = (MbgDimensionMember)table.getCell(row, TB_mbgMember).getValue();
            entryDim = entryMember.getType();
        }
        String strItemCombi = dim + "," + entryDim;
        try {
            this.getSchemeHelper().checkCombination(strItemCombi, true, false, null);
        }
        catch (BgTemplateException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    protected void checkEntryAccount(KDTable table, int row) {
        StringBuffer m = null;
        StringBuffer n = null;
        for (int j = table.getRowCount() - 1; j > row; --j) {
            BgDimensionMember member;
            m = new StringBuffer();
            n = new StringBuffer();
            if (table.getCell(row, TB_bgAccount).getValue() instanceof BgDimensionMember) {
                member = (BgDimensionMember)table.getCell(row, TB_bgAccount).getValue();
                m.append(member.getName());
            } else {
                m.append(table.getCell(row, TB_bgAccount).getValue().toString());
            }
            if (table.getCell(j, TB_bgAccount).getValue() instanceof BgDimensionMember) {
                member = (BgDimensionMember)table.getCell(j, TB_bgAccount).getValue();
                n.append(member.getName());
            } else if (table.getCell(j, TB_bgAccount).getValue() instanceof List) {
                if (((List)table.getCell(j, TB_bgAccount).getValue()).get(0) instanceof BgDimensionMember) {
                    member = (BgDimensionMember)((List)table.getCell(j, TB_bgAccount).getValue()).get(0);
                    n.append(member.getName());
                }
            } else {
                n.append(table.getCell(j, TB_bgAccount).getValue().toString());
            }
            String[] one = m.toString().split(",");
            String[] two = n.toString().split(",");
            HashSet<String> set = new HashSet<String>(Arrays.asList(one));
            set.retainAll(Arrays.asList(two));
            if (set.size() <= 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"accountRepeat", (Object[])new String[]{String.valueOf(row + 1), set.toString(), String.valueOf(j + 1), set.toString()}));
            SysUtil.abort();
        }
    }

    protected Map<String, Map<String, Set<String>>> getSpecialDimCheckMap() throws EASBizException, BOSException {
        return BgCslElimHelper.getSpecialDimCheckMap(null, this.getSchemeHelper());
    }

    protected void checkEntrySpeicalDim() throws BOSException, EASBizException {
        Map<String, MbgMemberInfo> firstMemberMap = BgCslClientHelper.getFirstLevelMembers(this.getSchemeHelper());
        Map<String, Map<String, Set<String>>> checkMap = this.getSpecialDimCheckMap();
        HashMap<String, Set> leafMemberMap = new HashMap<String, Set>();
        Object obj = null;
        int count = this.getDetailTable().getRowCount();
        BgDimensionMember accountMember = null;
        BgDimensionMember dimMember = null;
        for (int index = 0; index < count; ++index) {
            int i;
            String[] memNumArr;
            String[] dimNumArr;
            HashMap<String, String> dimMemberMap = new HashMap<String, String>();
            obj = this.getDetailTable().getRow(index).getCell(TB_bgAccount).getValue();
            if (obj instanceof BgDimensionMember) {
                accountMember = (BgDimensionMember)obj;
            } else {
                obj = this.getDetailTable().getRow(index).getCell(TB_bgAccount).getUserObject();
                if (obj instanceof BgDimensionMember) {
                    accountMember = (BgDimensionMember)obj;
                }
            }
            obj = this.getDetailTable().getRow(index).getCell(TB_mbgMember).getValue();
            if (obj instanceof BgDimensionMember) {
                dimMember = (BgDimensionMember)obj;
                if (!StringUtils.isEmpty((String)dimMember.getType()) && dimMember.getType().indexOf(",") >= 0) {
                    dimNumArr = dimMember.getType().split(",");
                    memNumArr = dimMember.getNumber().split(",");
                    for (i = 0; i < dimNumArr.length; ++i) {
                        dimMemberMap.put(dimNumArr[i], memNumArr[i]);
                    }
                } else {
                    dimMemberMap.put(dimMember.getType(), dimMember.getNumber());
                }
            } else if (obj instanceof List) {
                List memberLst = (List)obj;
                for (int i2 = 0; i2 < memberLst.size(); ++i2) {
                }
            }
            obj = this.prmtMbgMember.getData();
            if (obj instanceof BgDimensionMember) {
                dimMember = (BgDimensionMember)obj;
                if (!StringUtils.isEmpty((String)dimMember.getType()) && dimMember.getType().indexOf(",") >= 0) {
                    dimNumArr = dimMember.getType().split(",");
                    memNumArr = dimMember.getNumber().split(",");
                    for (i = 0; i < dimNumArr.length; ++i) {
                        dimMemberMap.put(dimNumArr[i], memNumArr[i]);
                    }
                } else {
                    dimMemberMap.put(dimMember.getType(), dimMember.getNumber());
                }
            }
            String accountMemberNumberString = accountMember == null ? null : accountMember.getNumber();
            String accNumber = DimensionBaseConstants.DEF_INDEX_SRCNUMBER + ":" + accountMemberNumberString;
            if (checkMap.containsKey(accNumber)) {
                Map<String, Set<String>> tmpMap = checkMap.get(accNumber);
                if (dimMemberMap == null || dimMemberMap.isEmpty()) continue;
                for (String dimNum : dimMemberMap.keySet()) {
                    String memberNum = (String)dimMemberMap.get(dimNum);
                    if (tmpMap.containsKey(dimNum)) {
                        Set leafNums;
                        if (!tmpMap.get(dimNum).isEmpty()) {
                            if (tmpMap.get(dimNum).contains(memberNum.split(":")[1]) || accountMember == null) continue;
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"checkSpecialDim1", (Object[])new String[]{String.valueOf(index + 1), accountMember.getNumber()}));
                            SysUtil.abort();
                            continue;
                        }
                        if (!leafMemberMap.containsKey(dimNum)) {
                            leafNums = DimGroupFactory.getRemoteInstance().queryLeafMemberNums(this.getSchemeHelper().getBgSchemeId(), dimNum);
                            leafMemberMap.put(dimNum, leafNums);
                        }
                        if (!leafMemberMap.containsKey(dimNum) || (leafNums = (Set)leafMemberMap.get(dimNum)).contains(memberNum.split(":")[1]) || accountMember == null) continue;
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"checkSpecialDim1", (Object[])new String[]{String.valueOf(index + 1), accountMember.getNumber()}));
                        SysUtil.abort();
                        continue;
                    }
                    if (!firstMemberMap.containsKey(dimNum) || memberNum.split(":")[1].equals(firstMemberMap.get(dimNum).getNumber()) || accountMember == null) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"checkSpecialDim1", (Object[])new String[]{String.valueOf(index + 1), accountMember.getNumber()}));
                    SysUtil.abort();
                }
                continue;
            }
            if (dimMemberMap == null || firstMemberMap.isEmpty()) continue;
            for (String dimNum : dimMemberMap.keySet()) {
                String memberNum = (String)dimMemberMap.get(dimNum);
                if (memberNum.split(":")[1].equals(firstMemberMap.get(dimNum).getNumber()) || accountMember == null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"checkSpecialDim1", (Object[])new String[]{String.valueOf(index + 1), accountMember.getNumber()}));
                SysUtil.abort();
            }
        }
    }
}

