/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormExportUI;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgFormExportUtils;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormExportProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslFormCourseExportUI
extends BgCslFormExportUI {
    private static final long serialVersionUID = 6176406859313183942L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormCourseExportUI.class);
    private BgFormCollection bgFormColls = null;
    private BgCslFormCollection bgCslFormColls = null;

    @Override
    protected void queryBgForms() throws BOSException {
        EntityViewInfo evi;
        Set bgFormIds = (Set)this.getUIContext().get("BGFORM_IDS");
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        String formid2 = null;
        HashSet<String> bgFormIdSet = new HashSet<String>();
        HashSet<String> bgCslFormIdSet = new HashSet<String>();
        BOSObjectType bgFromType = new BgFormInfo().getBOSType();
        BOSObjectType bgCslFromType = new BgCslFormInfo().getBOSType();
        for (String formid2 : bgFormIds) {
            if (BOSUuid.getBOSObjectType((String)formid2, (boolean)true).equals((Object)bgFromType)) {
                bgFormIdSet.add(formid2);
                continue;
            }
            if (!BOSUuid.getBOSObjectType((String)formid2, (boolean)true).equals((Object)bgCslFromType)) continue;
            bgCslFormIdSet.add(formid2);
        }
        if (!bgCslFormIdSet.isEmpty()) {
            evi = new EntityViewInfo();
            evi.setSelector(BgCslFormHelper.getSelector());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIds, CompareType.INCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo("number"));
            this.bgCslFormColls = BgCslFormFactory.getRemoteInstance().getBgCslFormCollection(evi);
        }
        if (!bgFormIdSet.isEmpty()) {
            evi = new EntityViewInfo();
            evi.setSelector(BgNFSHelper.getSelectors());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIds, CompareType.INCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo("number"));
            this.bgFormColls = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
        }
    }

    @Override
    protected void setTitle() {
        super.setTitle();
    }

    @Override
    protected void exportExcelFile(Map<String, String> orgDir, String filepath, List exportInfoList) {
        this.exportCslExcelFile(orgDir, filepath, this.bgCslFormColls, exportInfoList);
        this.exportBgExcelFile(orgDir, filepath, this.bgFormColls, exportInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportCslExcelFile(Map<String, String> orgDir, String filepath, BgCslFormCollection bgFormList, List exportInfoList) {
        if (orgDir == null || StringUtils.isEmpty((String)filepath) || bgFormList == null || bgFormList.isEmpty()) {
            return;
        }
        ExportManager em = null;
        KDSBook _kdsBook = null;
        String[] _exportInfo = null;
        BgCslFormInfo _bgFormInfo = null;
        BgCslViewListFormExportProvider viewlistExportProcessor = new BgCslViewListFormExportProvider(bgFormList, this);
        for (int i = 0; i < bgFormList.size(); ++i) {
            _bgFormInfo = bgFormList.get(i);
            try {
                if (this.selectFilterFilter == null || ".xlsx".equals(this.selectFilterFilter)) {
                    Book _book = null;
                    if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgCslTemplate().getFormType().getValue() == 8) {
                        _book = (Book)this.exportFixExcelFile(_bgFormInfo, file2007Format);
                    } else if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 2) {
                        _book = (Book)this.exportViewListExcelFile(_bgFormInfo.getId().toString(), viewlistExportProcessor, file2007Format);
                    }
                    BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                    bookDataWrapper.setExportHideCols(true);
                    bookDataWrapper.setExportHideRows(true);
                    if (this.rbDataANDExpression.isSelected()) {
                        bookDataWrapper.setExportFormula(true);
                        bookDataWrapper.setExportCustomerFomulas(true);
                    } else if (this.rbDataANDExcelExpression.isSelected()) {
                        bookDataWrapper.setExportFormula(true);
                        bookDataWrapper.setExportCustomerFomulas(false);
                    } else if (this.rbData.isSelected()) {
                        bookDataWrapper.setExportFormula(false);
                        bookDataWrapper.setExportCustomerFomulas(false);
                    }
                    SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                    String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2007Format)).replaceAll(" ", "");
                    this.makeDir(fileName);
                    File file = new File(fileName);
                    if (file.exists()) {
                        if (file.delete()) {
                            file = new File(fileName);
                        } else {
                            _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                            exportInfoList.add(_exportInfo);
                            continue;
                        }
                    }
                    booksc.write(fileName);
                } else {
                    if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgCslTemplate().getFormType().getValue() == 8) {
                        _kdsBook = (KDSBook)this.exportFixExcelFile(_bgFormInfo, file2003Format);
                    } else if (_bgFormInfo.getBgCslTemplate().getFormType().getValue() == 2) {
                        _kdsBook = (KDSBook)this.exportViewListExcelFile(_bgFormInfo.getId().toString(), viewlistExportProcessor, file2003Format);
                    }
                    em = new ExportManager();
                    em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                    if (this.rbDataANDExpression.isSelected()) {
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                    } else if (this.rbDataANDExcelExpression.isSelected()) {
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                    } else if (this.rbData.isSelected()) {
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                    }
                    this.exportDirectory(filepath, orgDir.get(_bgFormInfo.getOrgUnit().getNumber()));
                    String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2003Format)).replaceAll(" ", "");
                    File file = new File(fileName);
                    if (file.exists()) {
                        if (file.delete()) {
                            file = new File(fileName);
                        } else {
                            _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                            exportInfoList.add(_exportInfo);
                            continue;
                        }
                    }
                    em.exportToExcel(_kdsBook, fileName);
                }
                _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                exportInfoList.add(_exportInfo);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                if (_bgFormInfo == null) continue;
                _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                exportInfoList.add(_exportInfo);
                continue;
            }
            finally {
                _kdsBook = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportBgExcelFile(Map<String, String> orgDir, String filepath, BgFormCollection bgFormList, List exportInfoList) {
        if (orgDir == null || StringUtils.isEmpty((String)filepath) || bgFormList == null || bgFormList.isEmpty()) {
            return;
        }
        ExportManager em = null;
        KDSBook _kdsBook = null;
        String[] _exportInfo = null;
        LinkedHashMap<String, BgFormInfo> bgFormInfoMap = new LinkedHashMap<String, BgFormInfo>();
        for (int i = 0; i < bgFormList.size(); ++i) {
            bgFormInfoMap.put(bgFormList.get(i).getId().toString(), bgFormList.get(i));
        }
        BgFormInfo _bgFormInfo = null;
        MBGViewListFormExportProvider viewlistExportProcessor = new MBGViewListFormExportProvider(bgFormInfoMap, (CoreUIObject)this);
        MBGFormExportProvider mbgFormExportProvider = new MBGFormExportProvider(bgFormInfoMap, (CoreUIObject)this);
        for (int i = 0; i < bgFormList.size(); ++i) {
            _bgFormInfo = bgFormList.get(i);
            try {
                if (this.selectFilterFilter == null || ".xlsx".equals(this.selectFilterFilter)) {
                    Book _book = null;
                    if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                        _book = (Book)this.exportFixExcelFile_BgForm(_bgFormInfo, file2007Format);
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                        _book = (Book)this.exportViewListExcelFile(_bgFormInfo.getId().toString(), (ViewListProvider)viewlistExportProcessor, file2007Format);
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                        _book = BgFormExportUtils.exportMbgExcelFile2007((BgFormInfo)_bgFormInfo, (MBGFormExportProvider)mbgFormExportProvider);
                    }
                    BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                    bookDataWrapper.setExportHideCols(true);
                    bookDataWrapper.setExportHideRows(true);
                    if (this.rbDataANDExpression.isSelected()) {
                        bookDataWrapper.setExportFormula(true);
                        bookDataWrapper.setExportCustomerFomulas(true);
                    } else if (this.rbDataANDExcelExpression.isSelected()) {
                        bookDataWrapper.setExportFormula(true);
                        bookDataWrapper.setExportCustomerFomulas(false);
                    } else if (this.rbData.isSelected()) {
                        bookDataWrapper.setExportFormula(false);
                        bookDataWrapper.setExportCustomerFomulas(false);
                    }
                    SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                    String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2007Format)).replaceAll(" ", "");
                    this.makeDir(fileName);
                    File file = new File(fileName);
                    if (file.exists()) {
                        if (file.delete()) {
                            file = new File(fileName);
                        } else {
                            _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                            exportInfoList.add(_exportInfo);
                            continue;
                        }
                    }
                    booksc.write(fileName);
                } else {
                    if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 0 || _bgFormInfo.getBgTemplate().getFormType().getValue() == 8) {
                        _kdsBook = (KDSBook)this.exportFixExcelFile_BgForm(_bgFormInfo, file2003Format);
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 2) {
                        _kdsBook = BgFormExportUtils.exportViewListExcelFile((BgFormInfo)_bgFormInfo, (MBGViewListFormExportProvider)viewlistExportProcessor);
                    } else if (_bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                        _kdsBook = BgFormExportUtils.exportMbgExcelFile((BgFormInfo)_bgFormInfo, (MBGFormExportProvider)mbgFormExportProvider);
                    }
                    em = new ExportManager();
                    em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                    if (this.rbDataANDExpression.isSelected()) {
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                    } else if (this.rbDataANDExcelExpression.isSelected()) {
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                    } else if (this.rbData.isSelected()) {
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                    }
                    long ct1 = System.currentTimeMillis();
                    this.exportDirectory(filepath, orgDir.get(_bgFormInfo.getOrgUnit().getNumber()));
                    String fileName = filepath + ("/" + orgDir.get(_bgFormInfo.getOrgUnit().getNumber()) + "/" + this.getFileName((IObjectValue)_bgFormInfo, (OrgUnitInfo)_bgFormInfo.getOrgUnit(), file2003Format)).replaceAll(" ", "");
                    File file = new File(fileName);
                    if (file.exists()) {
                        if (file.delete()) {
                            file = new File(fileName);
                        } else {
                            _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error") + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile")};
                            exportInfoList.add(_exportInfo);
                            continue;
                        }
                    }
                    em.exportToExcel(_kdsBook, fileName);
                    logger.info((Object)("end exportToExcel : " + (System.currentTimeMillis() - ct1) + "ms"));
                }
                _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_succeed")};
                exportInfoList.add(_exportInfo);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                if (_bgFormInfo == null) continue;
                _exportInfo = new String[]{_bgFormInfo.getOrgUnit().getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgIEResource", (String)"export_error")};
                exportInfoList.add(_exportInfo);
                continue;
            }
            finally {
                _kdsBook = null;
            }
        }
    }

    @Override
    protected Book getViewlistBook(String formId, ViewListProvider viewlistExportProcessor) {
        Book _book = null;
        if (viewlistExportProcessor instanceof BgCslViewListFormExportProvider) {
            _book = ((BgCslViewListFormExportProvider)viewlistExportProcessor).getBook(formId);
        } else if (viewlistExportProcessor instanceof MBGViewListFormExportProvider) {
            _book = ((MBGViewListFormExportProvider)viewlistExportProcessor).getBook(formId);
        }
        return _book;
    }

    protected Object exportFixExcelFile_BgForm(BgFormInfo _bgFormInfo, String fileFormat) throws Exception {
        Book book = null;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        BigDecimal _coefficient = null;
        BigDecimal bigDecimal = _coefficient = _bgFormInfo.getMeasureUnit() != null ? _bgFormInfo.getMeasureUnit().getCoefficient() : null;
        if (_bgFormInfo.getBgMeasureUnit() != null) {
            BgMeasureUnitInfo _muInfo2 = null;
            for (BgMeasureUnitInfo _muInfo2 : _bgFormInfo.getBgMeasureUnit()) {
                _muMap.put(_muInfo2.getBgElement().getNumber(), _muInfo2.getMeasureUnit().getCoefficient());
            }
        }
        Map _dataMap = BgFormFactory.getRemoteInstance().getBgDataInfo(_bgFormInfo, null);
        book = _bgFormInfo.getBook();
        book.getProtection().deleteOperations();
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        this.refillFixBook_BgFrom(book, _dataMap, _bgFormInfo);
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", book);
        _tmpMap.put("EXPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgFormInfo.getBgTemplate().getFormType())) {
            if (_bgFormInfo.getBgSpecialItems().isEmpty()) {
                _bgFormInfo.getBgSpecialItems().add(BgSpecialBudgetClientHelper.getBgSpecialItemByForm((BgFormInfo)_bgFormInfo));
            }
            _tmpMap.put("bgSpecialItems", _bgFormInfo.getBgSpecialItems());
        }
        if (fileFormat.equals(file2007Format)) {
            return BgNFCHelper.exportExcel2007(_tmpMap);
        }
        if (fileFormat.equals(file2003Format)) {
            return BgNFCHelper.exportExcel(_tmpMap);
        }
        return BgNFCHelper.exportExcel(_tmpMap);
    }

    protected void refillFixBook_BgFrom(Book book, Map dataMap, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        Sheet _sheet = null;
        Cell _cell = null;
        String formula = null;
        BgNDataInfo bgData = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (StringUtils.isEmpty((String)formula) || (bgData = (BgNDataInfo)dataMap.get(formula + "_" + bgFormInfo.getBgVersion().getNumber())) == null) continue;
                    if (this.cacheHelper.getBudgetScens().contains(bgData.getBgScenario())) {
                        if (bgData.getAdjustValue() != null) {
                            BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getAdjustValue());
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBudgetValue());
                        continue;
                    }
                    BgNFSHelper.setValue((Cell)_cell, (Object)bgData.getBizActual());
                }
            }
        }
    }

    @Override
    protected String getFileName(IObjectValue _bgFormInfo, OrgUnitInfo orgUnitInfo, String fileFormat) {
        StringBuffer filename = new StringBuffer();
        filename = new StringBuffer();
        if (_bgFormInfo instanceof BgCslFormInfo) {
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgScheme().getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgCslTemplate().getName().trim().replace("\\", "-"));
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgPeriod().getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getCurrency().getName().trim());
            filename.append("_");
            filename.append(((BgCslFormInfo)_bgFormInfo).getBgVersion().getName().trim());
            filename.append(fileFormat);
        } else if (_bgFormInfo instanceof BgFormInfo) {
            filename.append(((BgFormInfo)_bgFormInfo).getBgScheme().getName().trim());
            filename.append("_");
            filename.append(((BgFormInfo)_bgFormInfo).getBgTemplate().getName().trim().replace("\\", "-"));
            filename.append("_");
            filename.append(((BgFormInfo)_bgFormInfo).getBgPeriod().getName().trim());
            filename.append("_");
            filename.append(((BgFormInfo)_bgFormInfo).getCurrency().getName().trim());
            filename.append("_");
            filename.append(((BgFormInfo)_bgFormInfo).getBgVersion().getName().trim());
            filename.append(fileFormat);
        }
        return filename.toString();
    }
}

