/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.mbg.DimGroupFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.client.NewDimensionMemberF7UI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgCslMbgDimensionMemberF7UI
extends NewDimensionMemberF7UI {
    private static final String RS = "com.kingdee.eas.ma.bgcsl.client.BgCslDimGroupResource";
    public static final String ACC_MEMBERS = "accMembers";
    private Object oldData = null;

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.checkMemberChange();
        super.btnOk_actionPerformed(e);
    }

    protected void checkInput() {
        if (this.tblRight.getRowCount() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
                IRow row = this.tblRight.getRow(i);
                numbers.add(NumberExpandHelper.getNumber((IRow)row));
            }
            BgDimensionBaseInfo dimension = DimensionClientHelper.getSelectDimension((KDComboBox)this.cbxDimension);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("longNumber");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)dimension.getViewId(), CompareType.EQUALS));
            MbgMemberCollection col = null;
            try {
                col = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(evi);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            numbers.clear();
            for (int i = 0; i < col.size(); ++i) {
                numbers.add(col.get(i).getLongNumber());
            }
            for (String number : numbers) {
                HashSet<String> parents = new HashSet<String>();
                String[] part = number.split("!");
                if (part.length > 1) {
                    for (int i = part.length - 1; i > 0; --i) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < i; ++j) {
                            stringBuffer.append(part[j]).append("!");
                        }
                        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                        parents.add(stringBuffer.toString());
                    }
                }
                for (String string : parents) {
                    if (!numbers.contains(string)) continue;
                    MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"noContainsParent"));
                    SysUtil.abort();
                }
            }
        }
    }

    protected void checkMemberChange() throws EASBizException, BOSException {
        block8: {
            BgDimensionMember hasDataAcc;
            Set mbgMembers;
            Iterator iterator;
            Iterator iterator2;
            Map hasDataMap;
            BgSchemeDimensionHelper helper = this.getSelectHelper().getSchemeHelper();
            BgDimensionBaseInfo dimenison = (BgDimensionBaseInfo)this.getUIContext().get("dimension");
            String refField = helper.getRefField(dimenison.getNumber());
            HashSet<String> oldMemberSet = new HashSet<String>();
            HashSet<String> newMemberSet = new HashSet<String>();
            Set<BgDimensionMember> oldMember = new HashSet();
            HashSet<BgDimensionMember> newMember = new HashSet<BgDimensionMember>();
            if (this.oldData != null) {
                for (BgDimensionMember member : (List)this.oldData) {
                    oldMemberSet.add(helper.getSrcNumber(member.getType()) + ":" + member.getNumber() + "_" + member.getName());
                    oldMember.add(member);
                }
            }
            if (oldMember.size() == 0) {
                oldMember = DimGroupFactory.getRemoteInstance().queryMbgLeafMember(helper.getBgSchemeId(), dimenison.getNumber());
            }
            if (this.tblRight.getRowCount() > 0) {
                for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
                    String srcNum = helper.getSrcNumber(((SourceDisplayInfo)this.tblRight.getRow(i).getCell("dimension").getValue()).getDimension().getType());
                    String number = (String)this.tblRight.getRow(i).getCell("number").getValue();
                    String name = (String)this.tblRight.getRow(i).getCell("name").getValue();
                    newMemberSet.add(srcNum + ":" + (String)number + "_" + name);
                    BgDimensionMember member = new BgDimensionMember(dimenison.getNumber(), helper.getRefField(dimenison.getNumber()), name, number);
                    member.setSrcNumber(srcNum);
                    newMember.add(member);
                }
            }
            oldMemberSet.removeAll(newMemberSet);
            oldMember.removeAll(newMember);
            if (oldMember == null || oldMember.size() <= 0) break block8;
            List accMember = (List)this.getUIContext().get(ACC_MEMBERS);
            HashSet<String> accMemberSet = new HashSet<String>();
            if (accMember != null) {
                for (BgDimensionMember member : accMember) {
                    accMemberSet.add(helper.getSrcNumber(member.getType()) + ":" + member.getNumber() + "_" + member.getName());
                }
            }
            if ((hasDataMap = DimGroupFactory.getRemoteInstance().checkHasBgCslData(refField, new HashSet(accMember), oldMember, helper.getBgSchemeId())) != null && hasDataMap.size() > 0 && (iterator2 = hasDataMap.keySet().iterator()).hasNext() && (iterator = (mbgMembers = (Set)hasDataMap.get(hasDataAcc = (BgDimensionMember)iterator2.next())).iterator()).hasNext()) {
                BgDimensionMember mbgMember = (BgDimensionMember)iterator.next();
                MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"canNotRmMbgMem", (Object[])new Object[]{"[" + hasDataAcc.getNumber() + "]" + hasDataAcc.getName(), "[" + mbgMember.getNumber() + "]" + mbgMember.getName()}));
                SysUtil.abort();
            }
        }
    }

    protected void addOneRow(BgDimensionBaseInfo dimension, int rowIndex, int type) {
        IRow row = this.tblLeft.getRow(rowIndex);
        if (row == null) {
            return;
        }
        if (!this.isMultiSelect() && this.tblRight.getRowCount() >= 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"singleSelect"));
            return;
        }
        String compareValue = NumberExpandHelper.getNumber((IRow)row);
        if (!row.getStyleAttributes().isHided()) {
            IRow newRow = this.tblRight.addRow();
            newRow.getCell("dimension").setValue((Object)new SourceDisplayInfo(dimension));
            newRow.getCell("number").setValue((Object)compareValue);
            newRow.getCell("name").setValue(row.getCell("name").getValue());
            newRow.getCell("fillType").setValue((Object)DimensionMemberTypeEnum.getEnum((int)type));
            newRow.getCell("number").setUserObject(row.getCell("number").getValue());
        }
    }

    public void dataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != this.getData()) {
            this.oldData = eventObj.getNewValue();
        }
        super.dataChanged(eventObj);
    }
}

