/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgCslOrgSelectF7UI;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslOrgSelectF7UI
extends AbstractBgCslOrgSelectF7UI
implements ISimpleQuickQueryHandler {
    private static final long serialVersionUID = -8634948371918109198L;
    private static final Logger logger = CoreUIObject.getLogger(BgCslOrgSelectF7UI.class);
    public static final String COL_ID = "id";
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_LEVEL = "level";
    public static final String COL_LONGNUMBER = "longNumber";
    public static final String COL_ISLEAF = "isLeaf";
    protected boolean isShowBtn4Order = true;
    protected boolean isReturnOrgEntity = false;
    protected boolean isCanceled = true;
    private NumberExpandHelper leftNumberHelper = null;
    private String orgTreeID = null;
    private String orgGroupID = null;
    private String editFormat = "name";
    private Object data;
    protected SimpleQuickQueryHandler quickQuery = null;
    protected IObjectPK[] orgPks = null;
    protected Object returnData;
    protected Set<String> AddIDSet = new HashSet<String>();

    public boolean isShowBtn4Order() {
        return this.isShowBtn4Order;
    }

    public void setShowBtn4Order(boolean isShowBtn4Order) {
        this.isShowBtn4Order = isShowBtn4Order;
    }

    public boolean isReturnOrgEntity() {
        return this.isReturnOrgEntity;
    }

    public void setReturnOrgEntity(boolean isReturnOrgEntity) {
        this.isReturnOrgEntity = isReturnOrgEntity;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setEditFormat(String editFormat) {
        this.editFormat = editFormat;
    }

    public void setData(Object data) {
        if (this.isReturnOrgEntity()) {
            if (data instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo org = (FullOrgUnitInfo)data;
                BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, org.getId().toString(), org.getName(), org.getNumber());
                member.setFillType(0);
                member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                ArrayList<BgDimensionMember> list = new ArrayList<BgDimensionMember>();
                list.add(member);
                MbgViewListResultData resultData = new MbgViewListResultData();
                resultData.setMemberType(BgMemberSelectTypeEnum.Member);
                resultData.setMembers(list);
                data = resultData;
            } else if (data instanceof FullOrgUnitInfo[]) {
                FullOrgUnitInfo[] arr = (FullOrgUnitInfo[])data;
                ArrayList<BgDimensionMember> list = new ArrayList<BgDimensionMember>();
                for (int i = 0; i < arr.length; ++i) {
                    FullOrgUnitInfo org = arr[i];
                    BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, org.getId().toString(), org.getName(), org.getNumber());
                    member.setFillType(0);
                    member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                    list.add(member);
                }
                MbgViewListResultData resultData = new MbgViewListResultData();
                resultData.setMemberType(BgMemberSelectTypeEnum.Member);
                resultData.setMembers(list);
                data = resultData;
            }
        }
        this.data = data;
    }

    public Object getData() {
        MbgViewListResultData returnData;
        List members;
        if (this.isReturnOrgEntity() && this.data instanceof MbgViewListResultData && (members = (returnData = (MbgViewListResultData)this.data).getMembers()) != null && !members.isEmpty()) {
            FullOrgUnitInfo[] orgArr = new FullOrgUnitInfo[members.size()];
            for (int i = 0; i < members.size(); ++i) {
                Object object = members.get(i);
                if (!(object instanceof BgDimensionMember)) continue;
                BgDimensionMember member = (BgDimensionMember)object;
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)member.getAttribute()));
                org.setName(member.getName());
                org.setNumber(member.getNumber());
                orgArr[i] = org;
            }
            return orgArr;
        }
        return this.data;
    }

    private NumberExpandHelper getLeftExpandHelper() {
        if (this.leftNumberHelper == null) {
            this.leftNumberHelper = new NumberExpandHelper((CoreUI)this, this.tblLeft);
        }
        return this.leftNumberHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getLeftExpandHelper();
        if (this.getUIContext().get("ORGTREE_ID") instanceof String) {
            this.orgTreeID = (String)this.getUIContext().get("ORGTREE_ID");
        }
        if (this.getUIContext().get("ORGGROUP_ID") instanceof String) {
            this.orgGroupID = (String)this.getUIContext().get("ORGGROUP_ID");
        }
        if (this.getUIContext().get("editFormat") != null) {
            this.editFormat = (String)this.getUIContext().get("editFormat");
        }
        this.init();
        this.quickQuery = new SimpleQuickQueryHandler(this.txtQuickQueryInput, (ISimpleQuickQueryHandler)this, "");
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnUp.setEnabled(this.isShowBtn4Order);
        this.btnBottom.setEnabled(this.isShowBtn4Order);
        this.btnDown.setEnabled(this.isShowBtn4Order);
        this.btnTop.setEnabled(this.isShowBtn4Order);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblLeft.checkParsed();
        this.tblRight.checkParsed();
    }

    protected void init() throws Exception {
        if (this.orgTreeID != null) {
            this.doQuery(this.orgTreeID, this.orgGroupID, this.tblLeft, null);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft);
        if (rows != null && !rows.isEmpty()) {
            this.actionAddRows(rows);
        }
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddAll_actionPerformed(e);
        List rows = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblLeft);
        if (rows != null && !rows.isEmpty()) {
            this.actionAddRows(rows);
        }
    }

    @Override
    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        List rows;
        super.tblLeft_tableClicked(e);
        if (e.getClickCount() == 2 && (rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft)) != null && !rows.isEmpty()) {
            this.actionAddRows(rows);
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        BgCommCHelper.removeRows((KDTable)this.tblRight);
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveAll_actionPerformed(e);
        this.tblRight.removeRows();
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        BgCommCHelper.moveUp((KDTable)this.tblRight);
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnTop_actionPerformed(e);
        BgCommCHelper.moveTop((KDTable)this.tblRight);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        BgCommCHelper.moveDown((KDTable)this.tblRight);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottom_actionPerformed(e);
        BgCommCHelper.moveBottom((KDTable)this.tblRight);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.isCanceled = false;
        MbgViewListResultData resultData = null;
        if (this.tblRight.getRowCount() > 0) {
            ArrayList<BgDimensionMember> memberLst = new ArrayList<BgDimensionMember>();
            for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
                IRow row = this.tblRight.getRow(i);
                BgDimensionMember member = this.getMemberOfRow(row);
                memberLst.add(member);
            }
            resultData = new MbgViewListResultData();
            resultData.setMembers(memberLst);
            resultData.setEditFormat(this.editFormat);
            resultData.setMemberType(BgMemberSelectTypeEnum.Member);
        }
        this.data = resultData;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void quickQueryButton_actionPerformed(ActionEvent e) throws Exception {
        super.quickQueryButton_actionPerformed(e);
        this.doQuickQuery();
    }

    @Override
    protected void txtQuickQueryInput_focusLost(FocusEvent e) throws Exception {
    }

    @Override
    protected void txtQuickQueryInput_focusGained(FocusEvent e) throws Exception {
    }

    public void doQuickQuery() {
        if (!StringUtils.isEmpty((String)this.orgTreeID)) {
            try {
                this.doQuery(this.orgTreeID, this.orgGroupID, this.tblLeft, this.txtQuickQueryInput.getText());
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    protected void actionAddRows(List<Integer> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        String number = null;
        boolean tag = false;
        HashSet<String> selectedNumbers = new HashSet<String>();
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            number = NumberExpandHelper.getNumber((IRow)this.tblRight.getRow(i));
            selectedNumbers.add(number);
        }
        boolean hasNoLeaf = false;
        boolean isOnlyLeaf = Boolean.TRUE.equals(this.getUIContext().get("isOnlyLeaf"));
        for (int i = 0; i < rows.size(); ++i) {
            int rowIndex = rows.get(i);
            IRow row = this.tblLeft.getRow(rowIndex);
            if (row.getStyleAttributes().isHided()) continue;
            if (isOnlyLeaf && row.getCell(COL_NUMBER).getValue() instanceof NumberExpandInfo && !((NumberExpandInfo)row.getCell(COL_NUMBER).getValue()).isLeaf()) {
                hasNoLeaf = true;
                continue;
            }
            number = NumberExpandHelper.getNumber((IRow)row);
            Object value = row.getCell(COL_ID).getValue();
            if (value instanceof String && !this.AddIDSet.contains((String)value) || selectedNumbers.contains(number)) continue;
            if (!BgNumberHelper.checkNumber((String)number)) {
                tag = true;
                continue;
            }
            String compareValue = NumberExpandHelper.getNumber((IRow)row);
            if (row.getStyleAttributes().isHided()) continue;
            IRow newRow = this.tblRight.addRow();
            newRow.getCell(COL_NUMBER).setValue((Object)compareValue);
            newRow.getCell(COL_NAME).setValue(row.getCell(COL_NAME).getValue());
            newRow.getCell(COL_ID).setValue(row.getCell(COL_ID).getValue());
        }
        if (tag) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgTemplateResource", (String)"checkMemberNumber"));
        } else if (hasNoLeaf) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"selectLeafMember"));
        }
    }

    protected BgDimensionMember getMemberOfRow(IRow row) throws EASBizException, BOSException {
        String number = NumberExpandHelper.getNumber((IRow)row);
        String name = (String)row.getCell(COL_NAME).getValue();
        BgDimensionMember member = (BgDimensionMember)row.getUserObject();
        if (member == null) {
            member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, row.getCell(COL_ID).getValue() != null ? String.valueOf(row.getCell(COL_ID).getValue()) : DimensionConstants.DEF_ORGUNIT_FIELD, name, number);
        }
        member.setFillType(0);
        member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        return member;
    }

    protected KDTable getTableForCommon() {
        return this.tblLeft;
    }

    public void doQuery(final String orgTreeId, String orgGroupId, final KDTable tblLeft, final String quickText) throws BOSException {
        if (orgTreeId == null) {
            return;
        }
        final HashSet<String> unitIds = new HashSet<String>();
        try {
            INewOrgViewFacade iNewOrgView = NewOrgViewFacadeFactory.getRemoteInstance();
            IRowSet rows = iNewOrgView.buildUnionRows(orgGroupId, orgTreeId);
            OrgStructureCollection orgStructureCol = iNewOrgView.createStructureCol(rows, false);
            for (int i = 0; i < orgStructureCol.size(); ++i) {
                unitIds.add(orgStructureCol.get(i).getUnit().getId().toString());
            }
        }
        catch (EASBizException e2) {
            throw new BOSException((Throwable)e2);
        }
        tblLeft.getDataRequestManager().putBindContents(COL_ID, "mainQuery", "unit.id");
        tblLeft.getDataRequestManager().putBindContents(COL_NUMBER, "mainQuery", "unit.number");
        tblLeft.getDataRequestManager().putBindContents(COL_NAME, "mainQuery", "unit.name");
        tblLeft.getDataRequestManager().putBindContents(COL_LONGNUMBER, "mainQuery", COL_LONGNUMBER);
        tblLeft.getDataRequestManager().putBindContents(COL_LEVEL, "mainQuery", COL_LEVEL);
        tblLeft.getDataRequestManager().putBindContents(COL_ISLEAF, "mainQuery", COL_ISLEAF);
        tblLeft.getDataRequestManager().setDataRequestMode(1);
        BgViewMemberSelectHelper.removeRequestDataListener((KDTable)tblLeft);
        tblLeft.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    OrgStructureCollection colls;
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("unit.id");
                    viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                    FilterInfo filter = new FilterInfo();
                    viewInfo.setFilter(filter);
                    filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
                    filter.getFilterItems().add(new FilterItemInfo("unit.isgrouping", (Object)Boolean.TRUE));
                    HashSet<String> ids = new HashSet<String>();
                    if (!unitIds.isEmpty()) {
                        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitIds, CompareType.INCLUDE));
                    }
                    if ((colls = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo)) != null && !colls.isEmpty()) {
                        for (int index = 0; index < colls.size(); ++index) {
                            ids.add(colls.get(index).getUnit().getId().toString());
                        }
                    }
                    viewInfo = new EntityViewInfo();
                    sic = new SelectorItemCollection();
                    sic.add(BgCslOrgSelectF7UI.COL_ID);
                    sic.add("unit.id");
                    sic.add("unit.number");
                    sic.add("unit.name");
                    sic.add(BgCslOrgSelectF7UI.COL_LONGNUMBER);
                    sic.add(BgCslOrgSelectF7UI.COL_LEVEL);
                    sic.add(BgCslOrgSelectF7UI.COL_ISLEAF);
                    viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("unit.id", ids, CompareType.INCLUDE));
                    String maskString = "#0 ";
                    if (!StringUtils.isEmpty((String)quickText)) {
                        filter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)("%" + quickText + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("unit.name", (Object)("%" + quickText + "%"), CompareType.LIKE));
                        maskString = maskString + "and ( #1 or #2)";
                    }
                    filter.setMaskString(maskString);
                    viewInfo.setFilter(filter);
                    viewInfo.setSorter(new SorterItemCollection());
                    SorterItemInfo sortInfo = new SorterItemInfo(BgCslOrgSelectF7UI.COL_LONGNUMBER);
                    sortInfo.setSortType(SortType.ASCEND);
                    viewInfo.getSorter().add(sortInfo);
                    EntityObjectInfo entity = BgEntityUtil.getEntity((BOSObjectType)new OrgStructureInfo().getBOSType());
                    IDataProvider mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
                    mainExec.setObjectView(viewInfo);
                    Uuid queryId = mainExec.openQuery();
                    List allIdList = mainExec.getQueryKeys(queryId);
                    mainExec.option().isAutoTranslateEnum = true;
                    mainExec.option().pageCount = tblLeft.getDataRequestManager().getPageRowCount();
                    int start = (Integer)e.getParam1();
                    int length = (Integer)e.getParam2() - start + 1;
                    IRowSet res = mainExec.executeQuery(queryId, start, length);
                    ArrayList<ObjectUuidPK> list = new ArrayList<ObjectUuidPK>();
                    while (res.next()) {
                        String id = res.getString("unit.id");
                        ObjectUuidPK pk = new ObjectUuidPK(id);
                        list.add(pk);
                    }
                    if (!list.isEmpty()) {
                        BgCslOrgSelectF7UI.this.orgPks = list.toArray(new IObjectPK[list.size()]);
                        if (BgCslOrgSelectF7UI.this.orgPks != null) {
                            String addNewPermission = "csl_mbgform02_addNew";
                            BgCslOrgSelectF7UI.this.AddIDSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), BgCslOrgSelectF7UI.this.orgPks, addNewPermission);
                        }
                    }
                    e.setRowSet(res);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        });
        tblLeft.checkParsed();
        tblLeft.removeRows();
        for (int i = 0; i < tblLeft.getRowCount(); ++i) {
            this.disableColorExistMember(tblLeft.getRow(i));
        }
    }

    public void dataChanged(DataChangeEvent eventObj) {
        this.returnData = eventObj.getNewValue();
        if (this.isReturnOrgEntity() && this.returnData instanceof FullOrgUnitInfo[]) {
            FullOrgUnitInfo[] arr = (FullOrgUnitInfo[])this.returnData;
            ArrayList<BgDimensionMember> list = new ArrayList<BgDimensionMember>();
            for (int i = 0; i < arr.length; ++i) {
                FullOrgUnitInfo org = arr[i];
                BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, org.getId().toString(), org.getName(), org.getNumber());
                member.setFillType(0);
                member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                list.add(member);
            }
            MbgViewListResultData data = new MbgViewListResultData();
            data.setMemberType(BgMemberSelectTypeEnum.Member);
            data.setMembers(list);
            this.returnData = data;
        }
        if (this.returnData instanceof MbgViewListResultData) {
            this.reFillData((MbgViewListResultData)this.returnData);
        } else {
            this.tblRight.removeRows(false);
        }
    }

    protected void reFillData(MbgViewListResultData newData) {
        List members = newData.getMembers();
        if (members != null && !members.isEmpty()) {
            this.tblRight.removeRows();
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgDimensionMember)) continue;
                BgDimensionMember member = (BgDimensionMember)members.get(i);
                member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                IRow row = this.tblRight.addRow();
                row.setUserObject((Object)member);
                row.getCell(COL_NUMBER).setValue((Object)member.getNumber());
                row.getCell(COL_NAME).setValue((Object)member.getName());
            }
        }
    }

    private void disableColorExistMember(IRow row) {
        if (row == null) {
            return;
        }
        Color disableColor = new Color(230, 230, 230);
        Object value = row.getCell(COL_ID).getValue();
        if (value instanceof String && !this.AddIDSet.contains((String)value)) {
            row.getStyleAttributes().setBackground(disableColor);
        }
    }
}

