/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.bgcsl.BgElimContext;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.client.BgElimContextUI;
import com.kingdee.eas.ma.bgcsl.client.IBgElimContextUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Observable;

public class BgElimContextManager
extends Observable
implements PropertyChangeListener {
    private static BgElimContextManager manager = new BgElimContextManager();
    public static final String PARENT_METADATAPK = "PARENT_METADATAPK";

    private BgElimContextManager() {
    }

    public static BgElimContextManager getInstance() {
        return manager;
    }

    public boolean isInitialized() {
        return BgElimContext.getInstance().isInitialized();
    }

    public boolean isInitialized(Map uiContext) {
        if (!this.isElimContextSetted() && !this.showContextUI(uiContext)) {
            return false;
        }
        return BgElimContext.getInstance().isInitialized();
    }

    public void registUIObject(IBgElimContextUI uiObject) {
        manager.addObserver(uiObject);
    }

    public void unRegistUIObject(IBgElimContextUI uiObject) {
        manager.deleteObserver(uiObject);
    }

    public boolean showContextUI(Map uiContext) {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgElimContextUI.class.getName(), uiContext, null);
            uiWindow.show();
            return !((BgElimContextUI)uiWindow.getUIObject()).isCancel();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public void closeBgElimUI(CoreUI ui) {
        boolean close;
        if (ui != null && ui.getUIWindow() != null && !(close = ui.getUIWindow().close())) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"Report_NotSave"));
            if (result == 0) {
                this.closeBgElimUI(ui);
            } else if (result == 2) {
                this.closeBgElimUI(ui);
            } else if (result == 1) {
                this.closeBgElimUI(ui);
            }
        }
    }

    public void notifyCTXChanged() {
        this.setChanged();
        this.notifyObservers(BgElimContext.getInstance());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ReLogin")) {
            BgElimContext.getInstance().destroyContext();
        }
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    public boolean isElimContextSetted() {
        Map<String, Object> bgElimOperationMap = null;
        try {
            bgElimOperationMap = BgCslClientHelper.getBgElimOperationMap();
            if (!bgElimOperationMap.isEmpty()) {
                OrgTreeCollection ocn;
                OrgTreeInfo orgTreeInfo = (OrgTreeInfo)bgElimOperationMap.get("orgTree");
                OrgUnitInfo companyInfo = (OrgUnitInfo)bgElimOperationMap.get("f7Company");
                BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)bgElimOperationMap.get("bgScheme");
                BgElimContext.getInstance().setCurOrgBound(orgTreeInfo);
                BgElimContext.getInstance().setCurOrgGroup(companyInfo);
                if (bgSchemeInfo != null) {
                    FilterInfo filter = BgCslClientHelper.getBgSchemeView(orgTreeInfo).getFilter();
                    BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("id", (Object)bgSchemeInfo.getId().toString()));
                    if (BgSchemeFactory.getRemoteInstance().exists(filter)) {
                        BgElimContext.getInstance().setCurBgScheme(bgSchemeInfo);
                    } else {
                        BgElimContext.getInstance().setCurBgScheme(null);
                    }
                }
                return (ocn = BgEliminationHelper.getOrgTreeCollection()).contains(orgTreeInfo) && companyInfo != null;
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)e.getMessage());
            return false;
        }
        return false;
    }
}

