/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgUserOperationCollection;
import com.kingdee.eas.ma.base.BgUserOperationFactory;
import com.kingdee.eas.ma.base.BgUserOperationInfo;
import com.kingdee.eas.ma.base.BgUserOperationType;
import com.kingdee.eas.ma.bgcsl.BgElimContext;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.client.AbstractBgElimContextUI;
import com.kingdee.eas.ma.bgcsl.client.BgElimContextManager;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElimContextUI
extends AbstractBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgElimContextUI.class);
    public static final String RES_PATH = "com.kingdee.eas.ma.bgcsl.client.BgEliminationResource";
    public static final String ORG_TREE = "orgTree";
    public static final String F7_COMPANY = "f7Company";
    public static final String BG_SCHEME = "bgScheme";
    private BgElimContext ctx = BgElimContext.getInstance();
    private BgElimContextManager manager = BgElimContextManager.getInstance();
    private Map<String, String> dataMap = null;
    private BgUserOperationInfo userOperationInfo = null;
    boolean isCancel = true;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.ctx.isInitialized()) {
            MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)this.manager);
        }
        this.refresh();
        this.bgElimContextToUI(this.ctx.isInitialized());
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        if (this.getUIContext().get("PARENT_METADATAPK") != null) {
            return (IMetaDataPK)this.getUIContext().get("PARENT_METADATAPK");
        }
        return super.getMetaDataPK();
    }

    protected String getOnloadPermItemName() {
        return "csl_bgElimContextUI001_Edit";
    }

    private void refresh() throws EASBizException, BOSException {
        this.refreshOrgBound();
        this.refreshCompany();
        this.refreshBgScheme();
    }

    private void loadData() throws EASBizException, BOSException {
        Map userOperationMap = BgUserOperationFactory.getRemoteInstance().getEliminationInfo(this.dataMap);
        if (this.dataMap != null) {
            HashMap<String, BgSchemeInfo> resultMap = new HashMap<String, BgSchemeInfo>();
            Iterator<Map.Entry<String, String>> it = this.dataMap.entrySet().iterator();
            Map.Entry<String, String> entry = null;
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getKey().equals(BG_SCHEME)) continue;
                BgSchemeInfo bgSchemeInfo = null;
                if (entry.getValue() != null) {
                    String bgSchemeId = entry.getValue().toString();
                    bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK(bgSchemeId));
                }
                resultMap.put(BG_SCHEME, bgSchemeInfo);
            }
            userOperationMap.putAll(resultMap);
        }
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)userOperationMap.get(ORG_TREE);
        this.listOrgBound.setSelectedItem((Object)orgTreeInfo);
        OrgUnitInfo companyInfo = (OrgUnitInfo)userOperationMap.get(F7_COMPANY);
        this.F7Company.setData((Object)companyInfo);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)userOperationMap.get(BG_SCHEME);
        this.prmptBgScheme.setData((Object)bgSchemeInfo);
    }

    private boolean isChanged() throws EASBizException, BOSException {
        if (!this.ctx.isInitialized()) {
            return true;
        }
        BgElimContext c = null;
        try {
            c = (BgElimContext)this.ctx.clone();
        }
        catch (CloneNotSupportedException e) {
            super.handUIException((Throwable)e);
        }
        this.setContext(c);
        return !this.ctx.equals(c);
    }

    private void refreshOrgBound() throws EASBizException, BOSException {
        OrgTreeCollection ocn = BgEliminationHelper.getOrgTreeCollection();
        this.listOrgBound.removeAllItems();
        if (ocn != null) {
            this.listOrgBound.addItems(ocn.toArray());
        }
    }

    private void refreshCompany() {
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
        BgCslClientHelper.refreshCompany((CoreUIObject)this, this.F7Company, orgTreeInfo);
    }

    private void refreshBgScheme() throws EASBizException, BOSException {
        OrgTreeInfo orgTreeInfo;
        if (this.listOrgBound.getSelectedItem() != null && (orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem()) != null && orgTreeInfo.getId() != null) {
            BgCslClientHelper.setBgSchemeView(this.prmptBgScheme, orgTreeInfo);
        }
        this.prmptBgScheme.setData(null);
        this.prmptBgScheme.setEditable(false);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.check()) {
            this.closeBgElimUIs();
            this.isCancel = false;
            this.saveDataMap();
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    private void saveDataMap() throws EASBizException, BOSException {
        this.dataMap = new HashMap<String, String>();
        String orgTreeId = ((OrgTreeInfo)this.listOrgBound.getSelectedItem()).getId().toString();
        this.dataMap.put(ORG_TREE, orgTreeId);
        this.dataMap.put(F7_COMPANY, OrgClientUtils.getPromptValue((KDBizPromptBox)this.F7Company).getId().toString());
        if (this.prmptBgScheme.getData() != null) {
            this.dataMap.put(BG_SCHEME, ((BgSchemeInfo)this.prmptBgScheme.getData()).getId().toString());
        } else {
            this.dataMap.put(BG_SCHEME, null);
        }
        this.userOperationInfo = new BgUserOperationInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.userOperationInfo.setUser(userInfo);
        this.userOperationInfo.setData(BgAnalyseHelper.getBytes(this.dataMap));
        this.userOperationInfo.setType(BgUserOperationType.BGELIMINATION);
        BgUserOperationFactory.getRemoteInstance().submit((CoreBaseInfo)this.userOperationInfo);
    }

    private boolean check() {
        if (this.listOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"Msg_NoFindOrgBound"));
            return false;
        }
        if (this.F7Company.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"Msg_NoFindOrgGroup"));
            return false;
        }
        return true;
    }

    public void setLogDatas(HashMap logDatas) throws BOSException {
        logDatas.put("FItemName", "ma_budget_BgElimContext_Change");
        logDatas.put("FID", this.getID());
        logDatas.put("FUserID", this.getUserId());
        logDatas.put("FUserName", this.getUserName());
        logDatas.put("FClientIP", this.getClientIp());
        logDatas.put("FClientName", this.getClientName());
        logDatas.put("FOccurTime", new Timestamp(System.currentTimeMillis()));
        logDatas.put("FEntityAlias_L2", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"392_CSLSysContextUI"));
        logDatas.put("FEntityAlias_L3", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"393_CSLSysContextUI"));
        logDatas.put("FInstanceNo", this.getInstanceNO());
        logDatas.put("FCompanyName_L2", this.getCurrOrgUnit());
        logDatas.put("FCompanyName_L3", this.getCurrOrgUnit());
        AppLogFactory.getRemoteInstance().writeLog(logDatas);
    }

    private String getID() {
        AppLogInfo appLogInfo = new AppLogInfo();
        String id = BOSUuid.create((BOSObjectType)appLogInfo.getBOSType()).toString();
        return id;
    }

    private String getUserId() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getId().toString();
    }

    private String getUserName() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo == null ? "" : userInfo.getNumber();
    }

    private String getClientIp() {
        String obj = SysContext.getSysContext().getClientIP();
        return obj == null ? "" : obj.toString();
    }

    private String getClientName() {
        String obj = SysContext.getSysContext().getClientName();
        return obj == null ? "" : obj.toString();
    }

    public String getInstanceNO() throws BOSException {
        String CurOrgBound = null;
        if (this.ctx != null && this.ctx.getCurOrgBound() != null) {
            CurOrgBound = this.ctx.getCurOrgBound().getName();
        }
        String retValue = CurOrgBound;
        return retValue;
    }

    private String getCurrOrgUnit() {
        String obj = SysContext.getSysContext().getCurrentOrgUnit().getName();
        return obj == null ? "" : obj.toString();
    }

    private boolean closeBgElimUIs() throws BOSException, EASBizException {
        this.setContext(this.ctx);
        this.manager.notifyCTXChanged();
        return false;
    }

    private void setContext(BgElimContext c) throws EASBizException, BOSException {
        if (this.listOrgBound.getSelectedItem() == null || this.F7Company.getValue() == null) {
            return;
        }
        c.setCurOrgBound((OrgTreeInfo)this.listOrgBound.getSelectedItem());
        c.setCurOrgGroup(OrgClientUtils.getPromptValue((KDBizPromptBox)this.F7Company));
        c.setCurBgScheme((BgSchemeInfo)this.prmptBgScheme.getData());
    }

    @Override
    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        super.listOrgBound_actionPerformed(e);
        this.refreshCompany();
        this.refreshBgScheme();
    }

    @Override
    protected void F7Company_willShow(SelectorEvent e) throws Exception {
        super.F7Company_willShow(e);
        if (this.listOrgBound.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"Msg_NoFindOrgBound"));
            return;
        }
    }

    @Override
    protected void F7Company_dataChanged(DataChangeEvent e) throws Exception {
        super.F7Company_dataChanged(e);
    }

    @Override
    protected void prmptBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmptBgScheme_willShow(e);
    }

    private void bgElimContextToUI(boolean isInitialized) {
        try {
            if (isInitialized) {
                this.listOrgBound.setSelectedItem((Object)this.ctx.getCurOrgBound());
                this.F7Company.setData((Object)this.ctx.getCurOrgGroup());
                this.prmptBgScheme.setData((Object)this.ctx.getCurBgScheme());
            } else {
                BgUserOperationInfo info = null;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.getUserId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
                BgUserOperationCollection col = BgUserOperationFactory.getRemoteInstance().getBgUserOperationCollection(view);
                if (col != null && !col.isEmpty()) {
                    info = col.get(0);
                    this.dataMap = (Map)BgAnalyseHelper.getObject((byte[])info.getData());
                    this.loadData();
                }
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

