/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.client.AbstractDimGroupEditUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslDimensionMemberDialog;
import com.kingdee.eas.ma.bgcsl.client.utils.DimGroupHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionDisplayInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgMergeSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class DimGroupEditUI
extends AbstractDimGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DimGroupEditUI.class);
    private static final String RS = "com.kingdee.eas.ma.bgcsl.client.BgCslDimGroupResource";
    public static final String DIM_GROUP = "dimGroup";
    public static final String SCHEME_HELPER = "schemeHelper";
    public static final String OPRT_STATE = "oprtState";
    private final String COL_ACC_MEMBER = "accMember";
    private final String COL_MBG_DIM = "mbgDim";
    private final String COL_DIM_MEMBER = "dimMember";
    private BgSchemeInfo bgSchemeInfo = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private String orgUnitId = null;
    private BgDimensionInfo accDimension = null;
    private Object[] allMbgDim = null;
    private List<List<Object>> dimGroup = new ArrayList<List<Object>>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initDataFromUIContext();
        this.initTable();
    }

    protected void initWorkButton() {
        if (this.getUIContext().get(OPRT_STATE).equals(OprtState.VIEW)) {
            this.btnAddRow.setEnabled(false);
            this.btnInsertRow.setEnabled(false);
            this.btnRemoveRow.setEnabled(false);
            this.btnOK.setEnabled(false);
        }
    }

    protected void initTable() throws Exception {
        this.tblMain.checkParsed();
        this.initTableData();
        StringBuffer desc = new StringBuffer();
        desc.append(EASResource.getString((String)RS, (String)"dimGroupDesc1")).append("\r\n").append(EASResource.getString((String)RS, (String)"dimGroupDesc2")).append("\r\n").append(EASResource.getString((String)RS, (String)"dimGroupDesc3")).append("\r\n").append(EASResource.getString((String)RS, (String)"dimGroupDesc4")).append("\r\n").append(EASResource.getString((String)RS, (String)"dimGroupDesc5")).append("\r\n").append(EASResource.getString((String)RS, (String)"dimGroupDesc6"));
        this.txtDesc.setEditable(false);
        this.txtDesc.setText(desc.toString());
    }

    protected void initTableData() throws Exception {
        BgMergeSchemeHelper.initDimGroupList((String)this.getSchemeHelper().getBgSchemeId(), this.dimGroup, (BgSchemeDimensionHelper)this.getSchemeHelper());
        if (this.dimGroup.size() > 0) {
            for (List<Object> obj : this.dimGroup) {
                List accMembers = (List)obj.get(0);
                BgDimensionDisplayInfo mbgDim = (BgDimensionDisplayInfo)obj.get(1);
                List mbgMember = null;
                if (obj.size() > 2 && ((List)obj.get(2)).size() != 0) {
                    mbgMember = (List)obj.get(2);
                }
                IRow row = this.addRow();
                ((KDBizPromptBox)row.getCell("accMember").getEditor().getComponent()).setData((Object)accMembers);
                row.getCell("accMember").setValue((Object)accMembers);
                int index = 0;
                Object[] mbgDims = this.getMbgDimensions();
                for (int i = 0; i < mbgDims.length; ++i) {
                    if (!((BgDimensionDisplayInfo)mbgDims[i]).getBgDimensionInfo().getNumber().equals(mbgDim.getBgDimensionInfo().getNumber())) continue;
                    index = i;
                    break;
                }
                ((KDComboBox)row.getCell("mbgDim").getEditor().getComponent()).setSelectedIndex(index);
                row.getCell("mbgDim").setValue((Object)mbgDim);
                BgCslDimensionMemberDialog dialog = new BgCslDimensionMemberDialog(this.getOwner(), mbgDim.getBgDimensionInfo(), this.orgUnitId, true);
                dialog.setCanFillType(false);
                dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
                dialog.setMemberType("mbgMember");
                dialog.setAccMembers((List)row.getCell("accMember").getValue());
                KDBizPromptBox prmtMbgMember = new KDBizPromptBox();
                prmtMbgMember.setSelector((KDPromptSelector)dialog);
                prmtMbgMember.setEditable(false);
                prmtMbgMember.addDataChangeListener((DataChangeListener)new MemberDataChangeListener(dialog));
                row.getCell("dimMember").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMbgMember));
                row.getCell("dimMember").setValue((Object)mbgMember);
            }
        }
        if (this.tblMain.getRowCount() == 0) {
            this.addRow();
        }
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        return this.schemeHelper;
    }

    private void initDataFromUIContext() {
        this.orgUnitId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.accDimension = new BgDimensionInfo(null);
        this.accDimension.setType(DimensionConstants.DEF_ACCOUNT_NUMBER);
        this.accDimension.setNumber(DimensionConstants.DEF_ACCOUNT_NUMBER);
        this.accDimension.setName(DimensionConstants.DEF_ACCOUNT_MAME);
        this.accDimension.setAlias(DimensionConstants.DEF_ACCOUNT_MAME);
        this.bgSchemeInfo = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get(SCHEME_HELPER);
    }

    private void initCbxMbgDim(IRow row) throws Exception {
        KDComboBox cbxMbgDim = new KDComboBox();
        cbxMbgDim.addItems(this.getMbgDimensions());
        cbxMbgDim.setUserObject((Object)row);
        row.getCell("mbgDim").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxMbgDim));
        cbxMbgDim.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object obj = e.getItem();
                    if (obj != null && obj instanceof BgDimensionDisplayInfo) {
                        BgCslDimensionMemberDialog dialog = new BgCslDimensionMemberDialog(DimGroupEditUI.this.getOwner(), ((BgDimensionDisplayInfo)obj).getBgDimensionInfo(), DimGroupEditUI.this.orgUnitId, true);
                        dialog.setCanFillType(false);
                        dialog.setMemberType("mbgMember");
                        IRow row = (IRow)((KDComboBox)e.getSource()).getUserObject();
                        dialog.setAccMembers((List)row.getCell("accMember").getValue());
                        try {
                            dialog.setBgSchemeID(DimGroupEditUI.this.getSchemeHelper().getBgSchemeId());
                            KDBizPromptBox prmtMbgMember = new KDBizPromptBox();
                            prmtMbgMember.setSelector((KDPromptSelector)dialog);
                            prmtMbgMember.setEditable(false);
                            prmtMbgMember.addDataChangeListener((DataChangeListener)new MemberDataChangeListener(dialog));
                            DimGroupEditUI.this.getTable().getRow(DimGroupEditUI.this.getTable().getSelectManager().getActiveRowIndex()).getCell("dimMember").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMbgMember));
                            DimGroupEditUI.this.getTable().getRow(DimGroupEditUI.this.getTable().getSelectManager().getActiveRowIndex()).getCell("dimMember").setValue(null);
                        }
                        catch (Exception ex) {
                            logger.error((Object)"", (Throwable)ex);
                        }
                    }
                } else {
                    IRow row = (IRow)((KDComboBox)e.getSource()).getUserObject();
                    if (row.getCell("accMember").getValue() == null) {
                        MsgBox.showWarning((String)EASResource.getString((String)DimGroupEditUI.RS, (String)"emptyAcc"));
                        SysUtil.abort();
                    }
                }
            }
        });
    }

    private KDBizPromptBox getAccountMemberF7() throws Exception {
        BgCslDimensionMemberDialog dialog = new BgCslDimensionMemberDialog(this, this.accDimension, this.orgUnitId, true);
        dialog.setCanFillType(false);
        dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        dialog.setMemberType("accMember");
        KDBizPromptBox prmtAccount = new KDBizPromptBox();
        prmtAccount.setSelector((KDPromptSelector)dialog);
        prmtAccount.setEditable(false);
        prmtAccount.addDataChangeListener((DataChangeListener)new MemberDataChangeListener(dialog));
        return prmtAccount;
    }

    private Object[] getMbgDimensions() throws Exception {
        if (this.allMbgDim == null) {
            ArrayList<BgDimensionDisplayInfo> mbgDims = new ArrayList<BgDimensionDisplayInfo>();
            List allDims = this.getSchemeHelper().getAllDimensions();
            List mbgDimNumbers = this.getSchemeHelper().getAccAndOtherDim(true);
            for (BgDimensionInfo dimension : allDims) {
                if (!mbgDimNumbers.contains(dimension.getNumber()) || dimension.getNumber().equals(DimensionConstants.DEF_CSL_NUMBER)) continue;
                mbgDims.add(new BgDimensionDisplayInfo(dimension));
            }
            this.allMbgDim = new Object[mbgDims.size()];
            this.allMbgDim = mbgDims.toArray(this.allMbgDim);
        }
        return this.allMbgDim;
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow();
    }

    protected IRow addRow() throws Exception {
        return this.addRow(this.getTable().getRowCount());
    }

    protected IRow addRow(int index) throws Exception {
        IRow row = this.getTable().addRow(index);
        row.getCell("accMember").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getAccountMemberF7()));
        this.initCbxMbgDim(row);
        return row;
    }

    @Override
    protected void btnInsertRow_actionPerformed(ActionEvent e) throws Exception {
        int activeRowIndex = this.getTable().getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = this.getTable().getRowCount();
        }
        this.addRow(activeRowIndex);
    }

    @Override
    protected void btnRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable().getSelectManager().getActiveRowIndex() < 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"selectRow"));
        }
        BgCommCHelper.removeRows((KDTable)this.getTable(), (List)BgCommCHelper.getSelectRowIndexes((KDTable)this.getTable()));
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.checkRepeat();
        this.checkAccMbgDimChange();
        this.dimGroup.clear();
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            IRow row = this.getTable().getRow(i);
            if (this.isEmptyRow(row)) continue;
            ArrayList<Object> dimGroupItem = new ArrayList<Object>();
            dimGroupItem.add(row.getCell("accMember").getValue());
            dimGroupItem.add(row.getCell("mbgDim").getValue());
            dimGroupItem.add(row.getCell("dimMember").getValue());
            this.dimGroup.add(dimGroupItem);
        }
        BgMergeSchemeHelper.saveDimGroup((BgSchemeInfo)this.bgSchemeInfo, this.dimGroup, null);
        MsgBox.showInfo((String)EASResource.getString((String)RS, (String)"saveSuccess"));
        this.getUIWindow().close();
    }

    protected void checkInput() {
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            boolean isMbgMemberEmpty;
            IRow row = this.getTable().getRow(i);
            boolean isAccMemberEmpty = row.getCell("accMember").getValue() == null;
            boolean isMbgDimEmpty = row.getCell("mbgDim").getValue() == null;
            boolean bl = isMbgMemberEmpty = row.getCell("dimMember").getValue() == null;
            if (isAccMemberEmpty && isMbgDimEmpty && isMbgMemberEmpty) continue;
            if (isAccMemberEmpty) {
                MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"accMemberIsEmpty", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
                continue;
            }
            if (!isMbgDimEmpty) continue;
            MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"mbgDimIsEmpty", (Object[])new Object[]{i + 1}));
            SysUtil.abort();
        }
    }

    protected void checkRepeat() {
        HashMap dimAccMap = new HashMap();
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            IRow row = this.getTable().getRow(i);
            if (this.isEmptyRow(row)) continue;
            List accMembers = (List)row.getCell("accMember").getValue();
            BgDimensionDisplayInfo mbgDim = (BgDimensionDisplayInfo)row.getCell("mbgDim").getValue();
            HashSet<String> accNumbers = (HashSet<String>)dimAccMap.get(mbgDim.getBgDimensionInfo().getNumber());
            if (accNumbers == null) {
                accNumbers = new HashSet<String>();
                dimAccMap.put(mbgDim.getBgDimensionInfo().getNumber(), accNumbers);
            }
            for (BgDimensionMember accMem : accMembers) {
                if (accNumbers.contains(accMem.getNumber())) {
                    MsgBox.showWarning((String)EASResource.getString((String)RS, (String)"accMemberRepeat", (Object[])new Object[]{"[" + accMem.getNumber() + "]" + accMem.getName(), mbgDim.getBgDimensionInfo().getName()}));
                    SysUtil.abort();
                    continue;
                }
                accNumbers.add(accMem.getNumber());
            }
        }
    }

    protected void checkAccMbgDimChange() throws EASBizException, BOSException {
        Set<BgDimensionDisplayInfo> mbgDims;
        BgDimensionDisplayInfo mbgDim;
        List accMembers;
        HashMap<BgDimensionMember, Set<BgDimensionDisplayInfo>> oldDataMap = new HashMap<BgDimensionMember, Set<BgDimensionDisplayInfo>>();
        HashMap<BgDimensionMember, Set<BgDimensionDisplayInfo>> newDataMap = new HashMap<BgDimensionMember, Set<BgDimensionDisplayInfo>>();
        if (this.dimGroup.size() > 0) {
            for (List<Object> obj : this.dimGroup) {
                accMembers = (List)obj.get(0);
                mbgDim = (BgDimensionDisplayInfo)obj.get(1);
                for (BgDimensionMember accMember : accMembers) {
                    mbgDims = (HashSet<BgDimensionDisplayInfo>)oldDataMap.get(accMember);
                    if (mbgDims == null) {
                        mbgDims = new HashSet<BgDimensionDisplayInfo>();
                        oldDataMap.put(accMember, mbgDims);
                    }
                    mbgDims.add(mbgDim);
                }
            }
        }
        for (int i = 0; i < this.getTable().getRowCount(); ++i) {
            IRow row = this.getTable().getRow(i);
            if (this.isEmptyRow(row)) continue;
            accMembers = (List)row.getCell("accMember").getValue();
            mbgDim = (BgDimensionDisplayInfo)row.getCell("mbgDim").getValue();
            for (BgDimensionMember accMember : accMembers) {
                mbgDims = (Set)newDataMap.get(accMember);
                if (mbgDims == null) {
                    mbgDims = new HashSet();
                    newDataMap.put(accMember, mbgDims);
                }
                mbgDims.add(mbgDim);
            }
        }
        DimGroupHelper.checkAccMbgDimChange(oldDataMap, newDataMap, this.bgSchemeInfo);
    }

    protected boolean isEmptyRow(IRow row) {
        boolean isAccMemberEmpty = row.getCell("accMember").getValue() == null;
        boolean isMbgDimEmpty = row.getCell("mbgDim").getValue() == null;
        boolean isMbgMemberEmpty = row.getCell("dimMember").getValue() == null;
        return isAccMemberEmpty && isMbgDimEmpty && isMbgMemberEmpty;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected CoreUI getOwner() {
        return this;
    }

    class MemberDataChangeListener
    implements DataChangeListener {
        NewDimensionMemberDialog dialog = null;

        MemberDataChangeListener(NewDimensionMemberDialog dialog) {
            this.dialog = dialog;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            this.dialog.dataChanged(eventObj);
        }
    }
}

