/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.IMbgDim;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslElimDimensionHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgCslElimDimensionHelper.class);
    private static String bgSchemeID = null;
    protected static BgCslSchemeDimensionHelper schemeHelper = null;

    public BgCslElimDimensionHelper() {
    }

    public BgCslElimDimensionHelper(BgCslSchemeDimensionHelper schemeHelper) {
        if (schemeHelper != null) {
            BgCslElimDimensionHelper.schemeHelper = schemeHelper;
        }
    }

    public static BgCslSchemeDimensionHelper getSchemeHelper() {
        if (schemeHelper == null) {
            try {
                schemeHelper = new BgCslSchemeDimensionHelper(bgSchemeID);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return schemeHelper;
    }

    protected void checkBgScheme(String bgSchemeId) {
        if (!bgSchemeId.equals(bgSchemeID)) {
            try {
                schemeHelper = new BgCslSchemeDimensionHelper(bgSchemeId);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        bgSchemeID = bgSchemeId;
    }

    public BgDimensionMember assembleBgAccountMember(String number, String name, String bgSchemeId) {
        this.checkBgScheme(bgSchemeId);
        if (!StringUtils.isEmpty((String)number) && number.indexOf(DimensionConstants.DEF_INDEX_SRCNUMBER) >= 0) {
            String[] arr = number.split(":");
            number = arr[1];
        }
        BgDimensionMember mbgDimensionMember = new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, name, number);
        mbgDimensionMember.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
        return mbgDimensionMember;
    }

    public MbgDimensionMember assembleMbgDimensionMember(String number, String name, String attribute, String bgSchemeID) {
        this.checkBgScheme(bgSchemeID);
        Map dimSrcMap = BgCslElimDimensionHelper.getSchemeHelper().getDimensionBySrcNumber();
        StringBuffer types = new StringBuffer();
        StringBuffer names = new StringBuffer();
        StringBuffer numbers = new StringBuffer();
        StringBuffer SrcNames = new StringBuffer();
        StringBuffer srcNumbers = new StringBuffer();
        String[] dimMember = number.split(",");
        for (int i = 0; i < dimMember.length; ++i) {
            String[] single = dimMember[i].split(":");
            String src = single[0];
            String member = single[1];
            if (!dimSrcMap.containsKey(src)) {
                return null;
            }
            String dimension = ((BgDimensionInfo)dimSrcMap.get(src)).getNumber();
            if (srcNumbers.length() == 0) {
                srcNumbers.append(src);
            } else {
                srcNumbers.append("," + src);
            }
            if (types.length() == 0) {
                types.append(dimension);
            } else {
                types.append("," + dimension);
            }
            if (0 == numbers.length()) {
                numbers.append(member);
            } else {
                numbers.append("," + member);
            }
            MbgDimInfo dimInfo = this.getMbgDimInfoByNumber(dimension);
            if (0 == SrcNames.length()) {
                SrcNames.append(dimInfo.getName());
            } else {
                SrcNames.append("," + dimInfo.getName());
            }
            MbgMemberInfo memberInfo = BgCslElimDimensionHelper.getMbgMemberInfoByNumber(member, dimension);
            if (0 == names.length()) {
                names.append(memberInfo.getName());
                continue;
            }
            names.append("," + memberInfo.getName());
        }
        MbgDimensionMember mbgDimensionMember = new MbgDimensionMember(types.toString(), attribute, names.toString(), numbers.toString(), SrcNames.toString());
        mbgDimensionMember.setSrcNumber(srcNumbers.toString());
        return mbgDimensionMember;
    }

    private MbgDimInfo getMbgDimInfoByNumber(String number) {
        MbgDimInfo mbgDimInfo = new MbgDimInfo();
        try {
            IMbgDim imbgDim = MbgDimFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            view.setFilter(filter);
            MbgDimCollection mbgDimCol = imbgDim.getMbgDimCollection(view);
            if (mbgDimCol.size() == 1) {
                mbgDimInfo = mbgDimCol.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return mbgDimInfo;
    }

    private static MbgMemberInfo getMbgMemberInfoByNumber(String number, String srcNumber) {
        String viewId = null;
        if (!DimensionConstants.DEF_ACCOUNT_NUMBER.equals(srcNumber)) {
            viewId = BgCslElimDimensionHelper.getSchemeHelper().getDimension(srcNumber).getViewId();
        }
        MbgMemberInfo mbgMemberInfo = new MbgMemberInfo();
        try {
            IMbgMember imbgMember = MbgMemberFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            if (!StringUtils.isEmpty((String)viewId)) {
                filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)viewId, CompareType.EQUALS));
            }
            view.setFilter(filter);
            MbgMemberCollection mbgMemberCol = imbgMember.getMbgMemberCollection(view);
            if (mbgMemberCol.size() == 1) {
                mbgMemberInfo = mbgMemberCol.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return mbgMemberInfo;
    }

    public String[] getMemberName(MbgDimensionMember dimMember) {
        String[] nameArray = dimMember.getName().split(",");
        return nameArray;
    }

    public String[] getDimName(MbgDimensionMember dimMember) {
        String[] dimArray = dimMember.getSrcName().split(",");
        return dimArray;
    }

    public MbgDimensionMember assembleDefaultMbgDimMember(String bgSchemeID) throws EASBizException, BOSException {
        this.checkBgScheme(bgSchemeID);
        List dims = BgCslElimDimensionHelper.getSchemeHelper().getAllDimensions();
        Map srcNumMap = BgCslElimDimensionHelper.getSchemeHelper().getSrcNumberMap();
        Map<String, MbgMemberInfo> memberMap = BgCslClientHelper.getFirstLevelMembers(BgCslElimDimensionHelper.getSchemeHelper());
        if (memberMap.isEmpty()) {
            return null;
        }
        int length = memberMap.size();
        int count = 0;
        Object[] numbers = new String[length];
        Object[] srcNumbers = new String[length];
        Object[] srcNames = new String[length];
        Object[] names = new String[length];
        Object[] types = new String[length];
        Object[] attributes = new String[length];
        BgDimensionInfo info = null;
        for (int index = 0; index < dims.size(); ++index) {
            info = (BgDimensionInfo)dims.get(index);
            if (!memberMap.containsKey(info.getNumber())) continue;
            numbers[count] = memberMap.get(info.getNumber()).getNumber();
            names[count] = memberMap.get(info.getNumber()).getName();
            srcNumbers[count] = (String)srcNumMap.get(info.getNumber());
            srcNames[count] = info.getName();
            types[count] = info.getType();
            attributes[count] = info.getAttribute();
            ++count;
        }
        String number = BgNFSHelper.arrayToString((Object[])numbers, (String)DimensionConstants.COMMA_SEPARATOR);
        String srcNumber = BgNFSHelper.arrayToString((Object[])srcNumbers, (String)DimensionConstants.COMMA_SEPARATOR);
        String srcName = BgNFSHelper.arrayToString((Object[])srcNames, (String)DimensionConstants.COMMA_SEPARATOR);
        String name = BgNFSHelper.arrayToString((Object[])names, (String)DimensionConstants.COMMA_SEPARATOR);
        String type = BgNFSHelper.arrayToString((Object[])types, (String)DimensionConstants.COMMA_SEPARATOR);
        String attribute = BgNFSHelper.arrayToString((Object[])attributes, (String)DimensionConstants.COMMA_SEPARATOR);
        MbgDimensionMember member = new MbgDimensionMember(type, attribute, name, number, srcName);
        member.setSrcNumber(srcNumber);
        return member;
    }
}

