/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslDisplayValueProvider;
import com.kingdee.eas.ma.bgcsl.client.utils.IBgCslViewListDisplayHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.StyleAttributes;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class BgCslViewListDispalyValueProvider
extends BgCslDisplayValueProvider {
    private static final Logger logger = Logger.getLogger(BgCslViewListDispalyValueProvider.class);
    private Map formulaMap = new WeakHashMap();
    private Map bgAccountDataMap = null;
    private TemplateStyleInfo templateStyle = null;

    public BgCslViewListDispalyValueProvider(IBgCslViewListDisplayHelper ownerUI) {
        super(ownerUI);
        if (ownerUI != null && ownerUI.getFormulaMap() != null) {
            this.formulaMap = ownerUI.getFormulaMap();
        }
    }

    @Override
    public IBgCslViewListDisplayHelper getOwnerUI() {
        return (IBgCslViewListDisplayHelper)super.getOwnerUI();
    }

    public Map getAccountDataTypeMap() {
        if (this.bgAccountDataMap != null) {
            return this.bgAccountDataMap;
        }
        this.bgAccountDataMap = this.getOwnerUI().getAccountDataTypeMap();
        if (this.bgAccountDataMap == null) {
            this.bgAccountDataMap = new HashMap();
        }
        return this.bgAccountDataMap;
    }

    public TemplateStyleInfo getTemplateStyle() {
        if (this.templateStyle == null) {
            this.templateStyle = this.getOwnerUI().getTemplateStyle();
        }
        return this.templateStyle;
    }

    @Override
    public Object getDisplayValue(Cell cell, int viewMode) {
        String _text = cell.getText();
        if (!StringUtils.isEmpty((String)_text)) {
            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
            if (obj instanceof ReportCalculateErrorProvider) {
                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                if ("#DIV/0!".equals(_text)) {
                    return rcep.getZeroDivDisplayAs();
                }
            } else if ("#DIV/0!".equals(_text)) {
                return "";
            }
            if (ViewListHelper.getCalculatorDataStyle((Cell)cell) != null) {
                return this.getCalcDisplayValue(cell, viewMode);
            }
            return super.getDisplayValue(cell, viewMode);
        }
        return super.getDisplayValue(cell, viewMode);
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision, String numberFormat) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        boolean hasBracket = false;
        try {
            precision = this.checkHasPercent(precision, numberFormat);
            _value = this.dealValueWithDispalyMode(obj, coefficient, precision);
            if (numberFormat != null) {
                _decFormat = new DecimalFormat(numberFormat);
                if (_value.compareTo(BigDecimal.ZERO) < 0 && !numberFormat.contains(";-") && !numberFormat.contains(";(")) {
                    _value = _value.multiply(new BigDecimal(-1));
                }
            } else {
                _decFormat = precision != 0 ? (_value.compareTo(BigDecimal.ZERO) < 0 ? new DecimalFormat(numberFormat) : new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)precision))) : new DecimalFormat("#,##0");
            }
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return this.dealUnitWithDispalyMode(_text);
    }

    private boolean checkHasBracket(String text) {
        return text.indexOf("(") != -1;
    }

    private String getDataNumberFormate(Integer accountType, boolean isRateElement, String eleNumber) {
        String numberFormat = ViewListStyleHelper.convertStyle((StyleAttributes)this.getTemplateStyle().getDataStyleAttributes()).getNumberFormat();
        if (this.templateStyle.isDataTYpe()) {
            if (accountType == 10) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getCurrencyNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getCurrencyDecNums(), this.templateStyle.isCurrencyHasGroupSep(), isRateElement ? this.templateStyle.isCurrencyShowPercent() : false);
            } else if (accountType == 20) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getNoCurrencyNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getNoCurrencyDecNums(), this.templateStyle.isNoCurrencyGroupSep(), isRateElement ? this.templateStyle.isNoCurrencyShowPercent() : false);
            } else if (accountType == 30) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getRateNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getRateDecNums(), this.templateStyle.isRateHasGroupSep(), this.templateStyle.isRateShowPercent());
            }
        } else if (eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
            Object[] object = (Object[])this.templateStyle.getEleMap().get(eleNumber);
            this.templateStyle.setDataNegativeIndex(((Integer)object[2]).intValue());
            numberFormat = this.templateStyle.toNumberPatternNoColor(((Integer)object[0]).intValue(), ((Boolean)object[1]).booleanValue(), ((Boolean)object[4]).booleanValue());
        }
        return numberFormat;
    }

    @Override
    public Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic((Cell)cell)) != null) {
            return showStr;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        String _bgAccountNumber = null;
        String numberFormat = null;
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)formulaStr);
        if (cell != null && cell.getUserObject("BGACCOUNT_NUMBER") != null && cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
            _bgAccountNumber = String.valueOf(cell.getUserObject("BGACCOUNT_NUMBER").getValue());
            if (_bgAccountNumber != null) {
                String eleNumber = MBGViewListFormClientHelper.getCellElement((Cell)cell, this.getElementObjMap(), (Map)this.formulaMap);
                if (this.getTemplateStyle().isDataTYpe()) {
                    if (!MBGViewListFormClientHelper.checkElementRateOrPrice((Cell)cell, this.getElementObjMap(), (Map)this.formulaMap)) {
                        _coefficient = this.getCoefficent(this.getCoef(_bgAccountNumber, null));
                    }
                } else {
                    _coefficient = this.getCoefficent(this.getCoef(_bgAccountNumber, eleNumber));
                }
                Boolean isRateElement = MBGViewListFormClientHelper.checkRateElement((Cell)cell, this.getElementObjMap(), (Map)this.getFormulaMap());
                if (this.getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
                    numberFormat = this.getDataNumberFormate((Integer)this.getAccountDataTypeMap().get(_bgAccountNumber), isRateElement, eleNumber);
                    if (!this.getTemplateStyle().isDataTYpe() && eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
                        Object[] object = (Object[])this.templateStyle.getEleMap().get(eleNumber);
                        this.templateStyle.setDataNegativeIndex(((Integer)object[2]).intValue());
                        String nFormat = this.templateStyle.toNumberPattern(((Integer)object[0]).intValue(), ((Boolean)object[1]).booleanValue(), ((Boolean)object[4]).booleanValue());
                        StyleAttributes style = this.templateStyle.getDataStyleAttributes();
                        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes newStyle = ViewListStyleHelper.convertStyle((StyleAttributes)style);
                        newStyle.setNumberFormat(nFormat);
                        newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        Range range = cell.getSheet().getRange(cell);
                        MBgTemplateHelper.setRangeStyle((Range)range, (com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes)newStyle, null);
                    }
                }
            }
            if (_parameter.length == 6) {
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
        return this.getDisplayValue(obj, _coefficient, _precision, numberFormat);
    }

    @Override
    public Object getMeasureUnitDisplayValue(ICell cell, String formulaStr, Object obj, boolean useMeasureUnit, String bgAccountNumber) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr) || obj == null) {
            return null;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        String _numberFormat = null;
        _parameter = BgNFSHelper.parseFormulaPara((String)formulaStr);
        if (_parameter == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)bgAccountNumber)) {
            String eleNumber = MBGViewListFormClientHelper.getCellElement((String)formulaStr, this.getElementObjMap(), (Map)this.getFormulaMap());
            if (this.getTemplateStyle().isDataTYpe()) {
                if (!MBGViewListFormClientHelper.checkElementRateOrPrice((String)formulaStr, this.getElementObjMap(), (Map)this.getFormulaMap())) {
                    _coefficient = this.getCoefficent(this.getCoef(bgAccountNumber, null));
                }
            } else {
                _coefficient = this.getCoefficent(this.getCoef(bgAccountNumber, eleNumber));
            }
            Boolean isRateElement = MBGViewListFormClientHelper.checkRateElement((String)formulaStr, this.getElementObjMap(), (Map)this.getFormulaMap());
            if (this.getAccountDataTypeMap().containsKey(bgAccountNumber)) {
                _numberFormat = this.getDataNumberFormate((Integer)this.getAccountDataTypeMap().get(bgAccountNumber), isRateElement, eleNumber);
            }
        }
        if (_parameter.length == 6) {
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
            _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
            _precision = _currencyInfo.getPrecision();
        }
        return this.getDisplayValue(obj, _coefficient, _precision, _numberFormat);
    }

    protected int checkHasPercent(int precision, String numberFormat) {
        if (!StringUtils.isEmpty((String)numberFormat) && numberFormat.endsWith("%")) {
            precision += 2;
        }
        return precision;
    }

    protected BigDecimal getCoefficent(Object measureUnit) {
        if (measureUnit instanceof BigDecimal) {
            return (BigDecimal)measureUnit;
        }
        if (measureUnit instanceof MeasureUnitInfo) {
            return ((MeasureUnitInfo)measureUnit).getCoefficient();
        }
        return BgNConstants.ONE;
    }

    protected BigDecimal getCoef(String _bgAccountNumber, String eleNumber) {
        BigDecimal defaultValue = new BigDecimal((Integer)this.getMeasureUnitMap().get("currency"));
        if (this.getAccountDataTypeMap() == null || !this.getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
            return defaultValue;
        }
        if (this.getTemplateStyle().isDataTYpe()) {
            if (this.getAccountDataTypeMap().get(_bgAccountNumber) != null && this.getAccountDataTypeMap().get(_bgAccountNumber) instanceof Integer) {
                if (10 == (Integer)this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getMeasureUnitMap().get("currency"));
                }
                if (20 == (Integer)this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getMeasureUnitMap().get("noCurrency"));
                }
                if (30 == (Integer)this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getMeasureUnitMap().get("rate"));
                }
            }
        } else if (eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
            Object[] object = (Object[])this.templateStyle.getEleMap().get(eleNumber);
            if ((Integer)object[3] == 0) {
                return this.templateStyle.getCof();
            }
            return new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit((int)((Integer)object[3] - 1)));
        }
        return defaultValue;
    }

    protected Object getCalcDisplayValue(Cell cell, int viewMode) {
        ViewListCalculatorDataStyleInfo calcDataStyle = ViewListHelper.getCalculatorDataStyle((Cell)cell);
        Object obj = cell.getValue().getValue();
        int _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)this.getPrecision());
        BigDecimal _coefficient = new BigDecimal(MBGViewListFormClientHelper.transMeasureUnit((int)calcDataStyle.getMeasureUnit()));
        String numberFormat = this.getCalcNumberFormate(calcDataStyle);
        return this.getDisplayValue(obj, _coefficient, _precision, numberFormat);
    }

    private String getCalcNumberFormate(ViewListCalculatorDataStyleInfo calcDataStyle) {
        if (calcDataStyle != null) {
            this.getTemplateStyle().setDataNegativeIndex(calcDataStyle.getNegativeIndex());
        }
        String numberFormat = this.getTemplateStyle().toNumberPatternNoColor(calcDataStyle.getDecNums(), calcDataStyle.isHasGroupSep(), calcDataStyle.isShowPercent());
        return numberFormat;
    }
}

