/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BgSpecialCommonHelper {
    public static boolean isInSpecialItem(String dimNumber, IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) {
        List<BgDimensionInfo> bgDimensions = BgSpecialCommonHelper.getBgDimensions(bgSpecialInfo, schemeHelper);
        HashSet<String> specialDims = new HashSet<String>();
        if (bgDimensions != null) {
            for (BgDimensionInfo dim : bgDimensions) {
                specialDims.add(dim.getNumber());
            }
        }
        return specialDims.contains(dimNumber);
    }

    public static List<BgDimensionInfo> getBgDimensions(IBgCslSpecialInfo bgSpecialInfo, BgSchemeDimensionHelper schemeHelper) {
        if (bgSpecialInfo.getBgSpecialItems() != null && !bgSpecialInfo.getBgSpecialItems().isEmpty()) {
            BgCslSpecialItemsInfo BgCslSpecialItemsInfo2 = bgSpecialInfo.getBgSpecialItems().get(0);
            return BgSpecialCommonHelper.getBgDimensionsBySpecialItems(BgCslSpecialItemsInfo2, schemeHelper);
        }
        return new ArrayList<BgDimensionInfo>();
    }

    public static List<BgDimensionInfo> getBgDimensionsBySpecialItems(BgCslSpecialItemsInfo BgCslSpecialItemsInfo2, BgSchemeDimensionHelper schemeHelper) {
        ArrayList<BgDimensionInfo> bgDimensions = new ArrayList<BgDimensionInfo>();
        if (BgCslSpecialItemsInfo2 == null || schemeHelper == null || StringUtils.isEmpty((String)BgCslSpecialItemsInfo2.getDimensionNumber())) {
            return bgDimensions;
        }
        String dimensionNumber = BgCslSpecialItemsInfo2.getDimensionNumber();
        String memberName = BgCslSpecialItemsInfo2.getMemberName();
        String hide = BgCslSpecialItemsInfo2.getHide();
        Map srcNumAndDimensonMap = schemeHelper.getDimensionBySrcNumber();
        String[] numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
        String[] names = BgSpecialCommonHelper.splitName(memberName, DimensionConstants.TICK_SEPARATOR);
        String[] hides = BgSpecialCommonHelper.splitName(hide, DimensionConstants.COMMA_SEPARATOR);
        if (hides == null) {
            hides = new String[numbers.length];
            for (int i = 0; i < hides.length; ++i) {
                hides[i] = String.valueOf(false);
            }
        }
        BgDimensionInfo bgDimensionInfo = null;
        BgDimensionMember bgDimensionMember = null;
        String mNumber = null;
        String meName = null;
        String srcNum = null;
        String isHide = null;
        int length = numbers.length;
        for (int index = 0; index < length; ++index) {
            srcNum = numbers[index].split(":")[0];
            mNumber = numbers[index].split(":")[1];
            meName = names[index];
            isHide = hides[index];
            if (!srcNumAndDimensonMap.containsKey(srcNum)) continue;
            bgDimensionInfo = ((BgDimensionInfo)srcNumAndDimensonMap.get(srcNum)).clone();
            bgDimensionInfo.getMember().clear();
            if ("#".equals(mNumber)) {
                bgDimensionMember = null;
            } else {
                bgDimensionMember = new BgDimensionMember(bgDimensionInfo.getNumber(), bgDimensionInfo.getRefField(), meName, mNumber);
                bgDimensionMember.setSrcNumber(srcNum);
                bgDimensionInfo.getMember().add(bgDimensionMember);
            }
            bgDimensionInfo.setShow(Boolean.valueOf(isHide) == false);
            bgDimensions.add(bgDimensionInfo);
        }
        return bgDimensions;
    }

    public static String[] splitName(String name, String split) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)split)) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        int start = 0;
        int pos = 0;
        while (start < name.length()) {
            pos = name.indexOf(split, start);
            if (start == pos) {
                resultList.add("");
            } else if (pos > 0) {
                resultList.add(name.substring(start, pos));
            } else {
                pos = name.length();
                resultList.add(name.substring(start, pos));
            }
            start = pos + 1;
        }
        if (name.endsWith(split)) {
            resultList.add("");
        }
        return resultList.toArray(new String[0]);
    }
}

